

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetServiceCommcellPropertiesSubscription.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetServiceCommcellPropertiesSubscription.sp,v $ $Id: AppGetServiceCommcellPropertiesSubscription.sp,v 1.1.2.1 2020/12/23 17:43:22 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppGetServiceCommcellPropertiesSubscription()
--  |
--  | Description:  SP for getting MQ servers to write the ServiceCommcellProperties.
--  |
--  |       Input:  GetServiceCommcellPropertiesSubscriptionReq xml
--  |
--  |      Output:  GetServiceCommcellPropertiesSubscriptionResponse xml
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	SP for getting MQ servers to write the ServiceCommcellProperties.
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetServiceCommcellPropertiesSubscription')
BEGIN
	print '>>> Drop Stored Procedure: AppGetServiceCommcellPropertiesSubscription <<<'
	drop procedure AppGetServiceCommcellPropertiesSubscription
END
IF EXISTS (select * from GxQscripts where name='AppGetServiceCommcellPropertiesSubscription')
	delete from GxQscripts where name = 'AppGetServiceCommcellPropertiesSubscription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetServiceCommcellPropertiesSubscription')
	delete from GXDBVersions where aliasname = 'AppGetServiceCommcellPropertiesSubscription'
GO
print '... Creating Procedure: AppGetServiceCommcellPropertiesSubscription'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetServiceCommcellPropertiesSubscription
  @i_xml XML	
AS
SET NOCOUNT ON
DECLARE @errorCode int = 0
DECLARE @errorMsg NVARCHAR(510)
BEGIN TRY
	DECLARE @qClients XML
	DECLARE @webconsolePackageWindows varchar(50)
	DECLARE @webconsolePackageUnix varchar(50)
	DECLARE @webserverClientIdParam varchar(50)
	-- webconsoles
	IF OBJECT_ID('tempdb.dbo.#webConsoleTbl') is not null
		DROP TABLE #webConsoleTbl
	CREATE TABLE #webConsoleTbl (clientId int, dynamicAppEnabled INT DEFAULT(0))
	-- webconsole package and webserverclientId attribute
    	IF OBJECT_ID('tempdb.dbo.#clientPropTbl') is not null
     	   DROP TABLE #clientPropTbl
    	CREATE TABLE #clientPropTbl (id int,componentNameId int, attrName nvarchar(2048), attrVal nvarchar(2048))
	    -- available webservers
    	IF OBJECT_ID('tempdb.dbo.#webserverTbl') is not null
    	    DROP TABLE #webserverTbl
   	 CREATE TABLE #webserverTbl (clientId int PRIMARY KEY)
	 SET @webconsolePackageWindows = 'PackageStateForId 726'
	 SET @webconsolePackageUnix = 'PackageStateForId 1135'
     SET @webserverClientIdParam = 'WebServerClientId'
	-- Get webservers
    INSERT INTO #webserverTbl(clientId)
    SELECT cl.id
    FROM APP_Client AS CL WITH(NOLOCK)
        INNER JOIN SimInstalledpackages SIM WITH(NOLOCK) ON SIM.ClientId = CL.id AND sim.simPackageID IN (252,1174)
    --Get client props
    INSERT INTO #clientPropTbl(id ,componentNameId , attrName , attrVal )
    SELECT
    (CASE
        WHEN attrName=@webserverClientIdParam THEN 1
        WHEN attrName=@webconsolePackageWindows OR attrName = @webconsolePackageUnix THEN 2
    END) as id,
    componentNameId, attrName, attrval
    FROM APP_ClientProp WITH(NOLOCK) WHERE attrName in (@webserverClientIdParam, @webconsolePackageWindows,@webconsolePackageUnix)
	AND modified = 0
	-- #1 webconsole should have attrName 'WebServerClientId' with attrVal as WebserverID
    -- #2 webconsole should have attrName 'PackageStateForId 726' with attrVal=1
    INSERT INTO #webConsoleTbl(clientId)
    SELECT distinct cpTbl2.componentNameId
        FROM #clientPropTbl cpTbl1
        INNER JOIN #webserverTbl wsTbl ON cpTbl1.attrVal = CAST(wsTbl.clientId AS NVARCHAR(12))
        INNER JOIN #clientPropTbl cpTbl2 ON cpTbl2.componentNameId = cpTbl1.componentNameId
        WHERE cpTbl1.id = 1 --@webserverClientId
        AND cpTbl2.id = 2 /**@webServerAttribute**/ AND cpTbl2.attrVal = N'1'
		UPDATE WC SET dynamicAppEnabled = 1
		FROM #webConsoleTbl WC
		INNER JOIN APP_ClientProp CP
		ON WC.clientId = CP.componentNameId AND
		CP.attrName = N'Side by Side Loading of Multiple SP Instance Enabled' AND CP.attrVal = N'1'  AND CP.modified = 0
		WHERE WC.clientId iS NOT NULL
	-- get default webconsole
	DECLARE @webConsoleURL NVARCHAR(MAX) = ''
	DECLARE @defaultWebconsoleHostname nvarchar(510);
	DECLARE @defaultWebconsoleClientId INT
	SELECT @webConsoleURL = value FROM GXGlobalParam(nolock) WHERE name = N'WebConsoleURL' AND modified = 0
	IF @webConsoleURL IS NOT NULL AND LTRIM(RTRIM(@webConsoleURL)) <> ''
	BEGIN
		SET @defaultWebconsoleHostname = DBO.GetHostnameFromUrl(@webConsoleURL)
		SELECT @defaultWebconsoleClientId = id
		FROM
		APP_Client CL (NOLOCK)
		INNER JOIN #webConsoleTbl WC ON CL.ID = WC.clientId
		WHERE (CL.net_hostname = @defaultWebconsoleHostname OR CL.name = @defaultWebconsoleHostname)
	END
	--
--
	 -- ServiceCommcellPropertiesSubscribers
    IF OBJECT_ID('tempdb.dbo.#ServiceCommcellPropertiesSubscribersTbl') is not null
        DROP TABLE #ServiceCommcellPropertiesSubscribersTbl
   	CREATE TABLE #ServiceCommcellPropertiesSubscribersTbl (webserverClientId int PRIMARY KEY, mqClientId int default(NULL))
	--Get distinct webservers associated to webconsoles supporting dynamic app
	INSERT INTO #ServiceCommcellPropertiesSubscribersTbl(webserverClientId)
	SELECT DISTINCT CAST(attrval AS INT)
	FROM #webConsoleTbl WC
	INNER JOIN APP_ClientProp CL(NOLOCK) ON CL.componentNameId = WC.clientId AND CL.attrName = 'WebServerClientId' AND CL.modified = 0
	--Get MQ servers for the webservers
	DECLARE @webserverClientId INT = 0
	DECLARE GetMQClients CURSOR LOCAL FORWARD_ONLY READ_ONLY
	FOR SELECT webserverClientId FROM #ServiceCommcellPropertiesSubscribersTbl
	OPEN GetMQClients
    FETCH GetMQClients INTO @webserverClientId
	WHILE @@FETCH_STATUS = 0
    BEGIN
		DECLARE @mqConnectionInfo xml
		EXEC CT_appGetMQConnectionString  @webserverClientId,@mqConnectionInfo OUTPUT,@generateOutput=0
		UPDATE 	#ServiceCommcellPropertiesSubscribersTbl SET mqClientId =
		(SELECT  ref.value('(clientEntity/@clientId)[1]', 'int') FROM  @mqConnectionInfo.nodes('Api_MQConnectionInfo') R ( ref ))
		FETCH GetMQClients INTO @webserverClientId
    END
    CLOSE GetMQClients
    DEALLOCATE GetMQClients
	SET @qClients = (SELECT mqClientId as '@val' FROM #ServiceCommcellPropertiesSubscribersTbl FOR XML PATH('qClientIdList'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
		--Close cursor
		IF ( CURSOR_STATUS('local', 'GetMQClients') >= 0 )
			CLOSE GetMQClients
		IF ( CURSOR_STATUS('local','GetMQClients') = -1 )
			DEALLOCATE GetMQClients
END  CATCH
SELECT
	@qClients,
	(SELECT  @errorCode as '@errorCode',
        @errorMsg as  '@errorMessage'
	FOR  XML PATH('error'),TYPE)
	FOR  XML PATH('Api_GetServiceCommcellPropertiesSubscriptionResponse'),TYPE
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetServiceCommcellPropertiesSubscription')
	delete from GxQscripts where name = 'AppGetServiceCommcellPropertiesSubscription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetServiceCommcellPropertiesSubscription')
	delete from GXDBVersions where aliasname = 'AppGetServiceCommcellPropertiesSubscription'
GO

insert into GXDBVersions values(2, 'AppGetServiceCommcellPropertiesSubscription',  '00010001000200010000', 'AppGetServiceCommcellPropertiesSubscription', '00010001000200010000')
GO

