

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSenderForRecipients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSenderForRecipients.sp,v $ $Id: AppGetSenderForRecipients.sp,v 1.1.2.7 2018/10/26 15:47:26 dtrivedi Exp $";
--	+===================================================================+
--	| AppGetSenderForRecipients - Get from address for recipients based on organization prop if applicable	|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSenderForRecipients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSenderForRecipients <<<'
	drop procedure AppGetSenderForRecipients
END
IF EXISTS (select * from GxQscripts where name='AppGetSenderForRecipients')
	delete from GxQscripts where name = 'AppGetSenderForRecipients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSenderForRecipients')
	delete from GXDBVersions where aliasname = 'AppGetSenderForRecipients'
GO
print '... Creating Procedure: AppGetSenderForRecipients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSenderForRecipients
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @reqXml xml
-----------------------------------------------------------
AS
  DECLARE @respXml XML
DECLARE   @senderEmail  nvarchar(max)
DECLARE   @displayName nvarchar(max)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
----------------------------------------------------------
----------------------------------------------------------
--- HERE IS WHERE WE WILL EXTRACT THE XML TO:          ---
----------------------------------------------------------
declare  @emailString nvarchar(max)
SELECT	@emailString = ISNULL((ref.value('@recipientEmailAddresses', 'nvarchar(max)')), '')
FROM @reqXml.nodes('/App_GetSenderForRecipientsReq') R(ref)
if @emailString is null OR len(@emailString)=0
begin
	select '<App_Email />'
	return
end
if object_id('tempdb.dbo.#RecipientTmp') is not null
BEGIN
	DROP TABLE #RecipientTmp
END
CREATE TABLE #RecipientTmp (userEmail nvarchar(max), userId int,organizationId int)
insert into #RecipientTmp(userEmail,userId,organizationId)
select data,0,0
from dbo.SplitString(@emailString, ',')
-- Update userId for all recipients based on email.
Update RecipientTmp
set userId=UMusers.id
from #RecipientTmp RecipientTmp
inner join UMusers
on RecipientTmp.userEmail=UMusers.email
-- In case there is a email which doesnt have user, then return empty.
if exists(select 1 from #RecipientTmp where userId=0)
begin
	select '<App_Email />'
	drop table #RecipientTmp
	return
end
Update #RecipientTmp
set organizationId = dbo.AppGetOrganizationForUser(userId)
declare @countOrganizations int = 0
-- If there is only one organization other than 0, then we send modified sender. Else we send null
select @countOrganizations = count(distinct organizationId) from #RecipientTmp
if (@countOrganizations<>1)
begin
	select '<App_Email />'
	drop table #RecipientTmp
	return
end
declare @organizationId int = 0
select @organizationId = organizationId from #RecipientTmp
-- Now retrieve email sender property for that organization
SELECT top 1 @senderEmail = attrval
from App_CompanyProp with (READUNCOMMITTED)
WHERE componentNameId=@organizationId and attrName='Notification Email'
and modified=0
--if display name property isnt filled, fill it with email. 'Notification Sender Name'
SELECT top 1 @displayName = attrval
from App_CompanyProp with (READUNCOMMITTED)
WHERE componentNameId=@organizationId
and attrName='Notification Sender Name'
and modified=0
if @displayName is null or len(@displayName)=0
begin
	set @displayName = @senderEmail
end
drop table #RecipientTmp
set @respXml = (SELECT @senderEmail AS '@emailAddress', @displayName AS '@displayName'
	FOR XML PATH('App_Email'));
select @respXml as respXml;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSenderForRecipients')
	delete from GxQscripts where name = 'AppGetSenderForRecipients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSenderForRecipients')
	delete from GXDBVersions where aliasname = 'AppGetSenderForRecipients'
GO

insert into GXDBVersions values(2, 'AppGetSenderForRecipients',  '00010001000200070000', 'AppGetSenderForRecipients', '00010001000200070000')
GO

