

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSenderEmailForSendingShareEmails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppGetSenderEmailForSendingShareEmails					|
--	|  Procedure to get the sender email address to use for	sending			|
--	|					share related emails								|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSenderEmailForSendingShareEmails <<<'

IF EXISTS (select * from sysobjects where name='AppGetSenderEmailForSendingShareEmails')
	drop procedure AppGetSenderEmailForSendingShareEmails
IF EXISTS (select * from GxQscripts where name='AppGetSenderEmailForSendingShareEmails')
	delete from GxQscripts where name = 'AppGetSenderEmailForSendingShareEmails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSenderEmailForSendingShareEmails')
	delete from GXDBVersions where aliasname = 'AppGetSenderEmailForSendingShareEmails'
GO
print '... Creating Procedure: AppGetSenderEmailForSendingShareEmails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSenderEmailForSendingShareEmails
----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_userId INT,
  @i_localeId INT
-----------------------------------------------------------
AS
  DECLARE @o_emailAddress NVARCHAR(100)
BEGIN
	DECLARE @userEmail	NVARCHAR(100)
	DECLARE @domain	NVARCHAR(100) = ''
	DECLARE @providerId	INT
	DECLARE @posIdx	INT = 0
	-- GET SHARE OWNER'S EMAIL
	SELECT @userEmail = ISNULL(email, ''), @providerId = umdsproviderid FROM Umusers WITH(NOLOCK) WHERE id = @i_userId
	-- GET COMMCELL NAME AS DOMAIN IF PROVIDERID IS ZERO
	IF @providerId = 0
	BEGIN
		SELECT @domain = aliasname FROM APP_CommCell WITH(NOLOCK) WHERE id = 2 /*CommCell*/
		SET @domain = @domain + '.com'
	END
	ELSE
	BEGIN
		SET @posIdx = PATINDEX('%@%', @userEmail)
		IF @posIdx = 0
		BEGIN
			-- GET ANY OTHER USER'S EMAIL ADDRESS FROM THE SAME DOMAIN
			SELECT TOP 1 @userEmail = email FROM Umusers WITH(NOLOCK) WHERE umdsproviderid = @providerId AND email IS NOT NULL AND email <> '' AND enabled = 1
			SET @posIdx = PATINDEX('%@%', @userEmail)
		END
		SET @domain = SUBSTRING(@userEmail, @posIdx + 1, LEN(@userEmail) - @posIdx)
	END
	SET @o_emailAddress = 'no-reply@' + @domain
	SELECT @o_emailAddress
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppGetSenderEmailForSendingShareEmails')
	delete from GxQscripts where name = 'AppGetSenderEmailForSendingShareEmails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSenderEmailForSendingShareEmails')
	delete from GXDBVersions where aliasname = 'AppGetSenderEmailForSendingShareEmails'
GO

insert into GXDBVersions values(2, 'AppGetSenderEmailForSendingShareEmails',  '00000000000000000000', 'AppGetSenderEmailForSendingShareEmails', '00000000000000000000')
GO

