

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSecureLoginDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSecureLoginDetails.sp,v $ $Id: AppGetSecureLoginDetails.sp,v 1.1.2.1.52.1 2021/03/24 18:35:07 nshah Exp $";
--
--  +========================================================================+
--  | Stored Precedure: AppGetSecureLoginDetails()
--  |
--  |   Revisions   Author          Description
--  |   ---------   ----------      ----------------------------------------
--  |   1.0 Logesh G AppGetSecureLoginDetails to give details required for secure login layer
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetSecureLoginDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSecureLoginDetails <<<'
	drop procedure AppGetSecureLoginDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetSecureLoginDetails')
	delete from GxQscripts where name = 'AppGetSecureLoginDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSecureLoginDetails')
	delete from GXDBVersions where aliasname = 'AppGetSecureLoginDetails'
GO
print '... Creating Procedure: AppGetSecureLoginDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetSecureLoginDetails
AS
DECLARE @packageTbl TABLE(packageId INT)
INSERT INTO @packageTbl VALUES(726),(1135)
DECLARE @clientInfo TABLE(clientId INT , clientName NVARCHAR(255),clientGuid NVARCHAR(MAX),networkPassword NVARCHAR(255))
INSERT INTO @clientInfo
SELECT DISTINCT client.id,
				client.name,
				client.GUID,
				client.client_password
FROM simInstalledPackages simInstalledPackage WITH(NOLOCK)
INNER JOIN @packageTbl package
ON simInstalledPackage.simPackageID = package.packageId
INNER JOIN APP_Client client WITH(NOLOCK)
ON simInstalledPackage.ClientId = client.id
DECLARE @output XML =
	ISNULL(
		(SELECT	networkPassword AS '@networkPassword',
					clientId AS 'client/@clientId',
					clientName AS 'client/@clientName',
					clientguid as 'client/@clientGUID',
					(
						SELECT installedPackage.simPackageID AS '@packageId'
						FROM simInstalledPackages installedPackage WITH(NOLOCK)
						INNER JOIN @packageTbl package
						ON installedPackage.simPackageID = package.packageId
						WHERE installedPackage.ClientId = client.clientId
						FOR XML PATH('packageList'),TYPE
					)
			FROM @clientInfo client
			FOR XML PATH('clientPackageList') , ROOT('App_SecureLoginDetailsResp')
		)
		,
		'<App_SecureLoginDetailsResp></App_SecureLoginDetailsResp>'
		)
SELECT @output as outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSecureLoginDetails')
	delete from GxQscripts where name = 'AppGetSecureLoginDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSecureLoginDetails')
	delete from GXDBVersions where aliasname = 'AppGetSecureLoginDetails'
GO

insert into GXDBVersions values(2, 'AppGetSecureLoginDetails',  'v1.1.2.1.52.1', 'AppGetSecureLoginDetails', 'v1.1.2.1.52.1')
GO

