

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSearchServerList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   12/05/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSearchServerList.sp,v $ $Id: AppGetSearchServerList.sp,v 1.1.2.2 2020/12/02 16:48:21 sgolla Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetSearchServerList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSearchServerList <<<'
	drop procedure AppGetSearchServerList
END
IF EXISTS (select * from GxQscripts where name='AppGetSearchServerList')
	delete from GxQscripts where name = 'AppGetSearchServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSearchServerList')
	delete from GXDBVersions where aliasname = 'AppGetSearchServerList'
GO
print '... Creating Procedure: AppGetSearchServerList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetSearchServerList
  @i_exchangeIndex integer = 0,
  @i_userGUID varchar(100) = ''
AS
  DECLARE @o_serverName NVARCHAR(255)
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(255)
  DECLARE @o_cloudId INT
  DECLARE @o_fastHostName NVARCHAR(255)
  DECLARE @o_fastBasePort INT
  DECLARE @o_version VARCHAR(1024)
  DECLARE @o_engineName VARCHAR(1024)
  DECLARE @o_serverType INT
BEGIN
	SET NOCOUNT ON
	DECLARE @FastServers TABLE (	  serverName	NVARCHAR(MAX)
								, clientId		INT
								, clientName	NVARCHAR(MAX)
								, cloudId		INT
								, hostName	NVARCHAR(MAX)
								, baseport	INT
								, version		VARCHAR(1024)
								, engineName	VARCHAR(1024)
								, serverType	INT DEFAULT 3 --App::CloudServerType_SearchEngine
							  )
	INSERT INTO @FastServers
	EXEC AppGetFastServerList @i_exchangeIndex
	IF @i_exchangeIndex = 1
	begin
	--MR 255161: option to hide Journal/ Mailbox index/Virtual Cloud
		IF EXISTS (SELECT 1 FROM GXGlobalParam (NOLOCK) WHERE name = N'HideMailboxIndex' AND value = 'true' AND modified = 0)
DELETE F FROM @FastServers F JOIN DM2Cloud C (NOLOCK)  ON  F.cloudId = C.cloudId   WHERE C.flags & 4 > 0
		IF EXISTS (SELECT 1 FROM GXGlobalParam (NOLOCK) WHERE name = N'HideJournalIndex' AND value = 'true' AND modified = 0)
DELETE F FROM @FastServers F JOIN DM2Cloud C (NOLOCK)  ON  F.cloudId = C.cloudId   WHERE C.flags & 2 > 0
	end
	DECLARE @hideSEOfVirtualCloud INT = 0
	IF EXISTS (SELECT 1 FROM GXGlobalParam (NOLOCK) WHERE name = N'HideSearchEnginesPartOfVirtualCloud' AND value = 'true' AND modified = 0)
		SET @hideSEOfVirtualCloud = 1
	IF @hideSEOfVirtualCloud = 1
	BEGIN
		--get all VIRTUAL CLOUDIds
		DECLARE @virtualCLouds TABLE (t_vitrualCloudId int)
		INSERT INTO @virtualCLouds
		SELECT componentid
		FROM APP_ComponentProp WITH (NOLOCK)
WHERE propertytypeid = 1001 AND componentType =2 AND stringval = 'virtual'
		--returns list of all nodes of virtual clouds
		IF EXISTS (SELECT 1 FROM @virtualCLouds)
		BEGIN
			DECLARE @virtualToPhysicalCloud TABLE (t_vitrualCloudId int, t_CloudId int)
			INSERT INTO @virtualToPhysicalCloud
			SELECT t_vitrualCloudId, longval
			FROM APP_ComponentProp WITH (NOLOCK)
				JOIN @virtualCLouds ON componentid = t_vitrualCloudId
WHERE propertytypeid = 1010 AND componentType =2
			--Hide Search Engines which are already part of Virtual Cloud
			DELETE F
			FROM @FastServers F
			JOIN @virtualToPhysicalCloud V ON F.cloudId = V.t_CloudId
		END
	END
--
DECLARE @metallic INT = 0
DECLARE @companyId INT = 0
DECLARE @oemTbl table (oemid int)
	IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL
		DROP TABLE #getPlans
	CREATE TABLE #getPlans
	(
		planId INT
	)
	IF OBJECT_ID('tempdb.dbo.#FinalTbl') IS NOT NULL
				DROP TABLE #FinalTbl
	CREATE TABLE #FinalTbl
	(
		   planId INT,
		   planName NVARCHAR(1024),
		   planType INT,
		   planSubType INT,
		   storagePolicyId INT
	)
--
INSERT INTO @oemTbl
EXEC GetOEMId
--
-- special logic needed for metallic
--
IF EXISTS (SELECT 1 FROM GXGlobalParam (NOLOCK) WHERE name = 'METALLIC_THEME' and value = 'True')
	OR EXISTS (SELECT 1 FROM @oemTbl WHERE oemid = 119) -- Metallic
BEGIN
	SET @metallic = 1
	DECLARE @userId INT = 0
	SELECT @userId = id FROM umusers (NOLOCK) where userGuid = @i_userGUID AND enabled = 1
	SET @companyId = ISNULL(dbo.AppGetCompanyForUserOrUserGroup(@userId, 1), 0)
	-- Get All Company Plans
	DECLARE @tenantAdminGroupId INT
	SELECT @tenantAdminGroupId=UG.id FROM UMGroups UG (NOLOCK) where UG.groupFlags&65536 <> 0 and UG.umdsProviderId=@companyId
	DECLARE @tenantAdminId int = ISNULL((select top 1 userId From UMUserGroup (NOLOCK) where groupId=@tenantAdminGroupId),0)
	IF(@tenantAdminId > 0)
	BEGIN
		-- This procedure will raise an error if the userId was 0.
		EXEC sec_getNonIdaObjectsForThisUser @tenantAdminId, 158,159,'#getPlans' -- PLAN_ENTITY, CAT_PLAN_ASSOCIATIONS_ADD_REMOVE
		INSERT INTO #FinalTbl
		SELECT AP.id, AP.name, AP.type, AP.subType, dbo.AppPlanGetEntityValueV2(AP.id,'Storage Policy', default) FROM #getPlans GP
		INNER JOIN App_Plan AP (NOLOCK)
		ON AP.id = GP.planId
	END
END
	SELECT  serverName
		, clientId
		, clientName
		, cloudId
		, hostName
		, baseport
		, version
		, engineName
		, serverType
	FROM @FastServers T
	WHERE @metallic = 0
	OR
(@metallic = 1 and serverType <> 3 OR (serverType = 3 AND
	((@companyid > 0 AND EXISTS (SELECT 1 FROM archContentIndexingRules B (NOLOCK) JOIN #FinalTbl F ON B.archGroupId = F.storagePolicyId WHERE T.cloudId = B.cloudId AND enabled = 1)) OR @companyId = 0))
	)
	ORDER BY engineName, serverName DESC
	IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL
		DROP TABLE #getPlans
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppGetSearchServerList')
	delete from GxQscripts where name = 'AppGetSearchServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSearchServerList')
	delete from GXDBVersions where aliasname = 'AppGetSearchServerList'
GO

insert into GXDBVersions values(2, 'AppGetSearchServerList',  '00010001000200020000', 'AppGetSearchServerList', '00010001000200020000')
GO

