

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSalesforceProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppGetSalesforceProperties							|
--	|		 Procedure to get salesforce organization properties		|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetSalesforceProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSalesforceProperties <<<'
	drop procedure AppGetSalesforceProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetSalesforceProperties')
	delete from GxQscripts where name = 'AppGetSalesforceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSalesforceProperties')
	delete from GXDBVersions where aliasname = 'AppGetSalesforceProperties'
GO
print '... Creating Procedure: AppGetSalesforceProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetSalesforceProperties
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inXml XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE @outputXml XML = '<App_GetSalesforcePropertiesResponse />'
BEGIN TRY
	DECLARE @userId INT
	DECLARE @clientId INT
	DECLARE @commcellId INT
	DECLARE @instanceId INT
	DECLARE @backupsetId INT
	DECLARE @subclientId INT
	DECLARE @clientName NVARCHAR(256) = NULL
	SET @clientId = ISNULL(@inXml.value('(/App_GetSalesforcePropertiesRequest/entity/@clientId)[1]', 'INT'), 0)
	IF @clientId <> 0
	BEGIN
		SELECT @commcellId = cl.origCCId, @clientName = cl.displayName FROM APP_Client cl WITH (NOLOCK) WHERE id = @clientId
	END
	IF @clientName IS NULL
	BEGIN
		SET @outputXml = '<App_GenericResp errorCode="-1" errorMessage="Invalid clientId."></App_GenericResp>'
		GOTO PROC_EXIT
	END
	SET @userId = ISNULL(@inXml.value('(/App_GetSalesforcePropertiesRequest/processinginstructioninfo/user/@userId)[1]', 'INT'), 0)
	SET @instanceId = ISNULL(@inXml.value('(/App_GetSalesforcePropertiesRequest/entity/@instanceId)[1]', 'INT'), 0)
	SET @backupsetId = ISNULL(@inXml.value('(/App_GetSalesforcePropertiesRequest/entity/@backupsetId)[1]', 'INT'), 0)
	SET @subclientId = ISNULL(@inXml.value('(/App_GetSalesforcePropertiesRequest/entity/@subclientId)[1]', 'INT'), 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
				DROP TABLE #getIdaObjects
		CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
		-- fetch the list of accessible entities for this user
EXEC dbo.sec_getIdaObjectsForUser @userId, 7, 0, 1, '#getIdaObjects' -- SUBCLIENT_ENTITY = 7
		IF EXISTS (SELECT TOP 1 1 FROM #getIdaObjects WHERE clientId = @clientId)
		BEGIN
			DECLARE @orgProps TABLE(
						clientId INT,
						organizationName NVARCHAR(256),
						connectedAppCredentialId INT,
						connectedAppCredentialName NVARCHAR(256),
						consumerId NVARCHAR(256),
						environmentType INT,
						userName NVARCHAR(256),
						syncDatabase XML,
						planId INT,
						planName NVARCHAR(256),
						downloadCachePath NVARCHAR(256),
						filesPerBackup INT,
						lastBackupTime BIGINT,
						lastBackupSize BIGINT,
						noOfBackupStreams INT,
						backupArchivedandDeletedRecs INT,
						backupObjs XML,
						ignoreObjs XML,
						backupSfObjects INT,
						backupFileObjects INT,
						backupSFMetadata INT,
						accessNodes XML,
						endpoint NVARCHAR(256),
						authType INT)
			SELECT TOP 1 @instanceId=app.instance, @backupsetId=app.backupSet, @subclientId=app.id
			FROM APP_Application app WITH (NOLOCK)
			INNER JOIN APP_BackupSetName bp WITH (NOLOCK) ON app.backupSet = bp.id
			WHERE (@instanceId = 0 OR app.instance = @instanceId)
			AND (@backupsetId = 0 OR app.backupSet = @backupsetId)
			AND (@subclientId = 0 OR app.id = @subclientId)
			AND app.clientId = @clientId
			AND (@subclientId <> 0 OR app.subclientStatus & 8 = 8) -- pick default subclient only when subclientId is not provided
			AND (@backupsetId <> 0 OR bp.status & 8 = 8) -- pick default backupset only when backupsetId is not provided
			ORDER BY app.refTime ASC
			-- insert props
			INSERT INTO @orgProps(clientId, organizationName, planId, environmentType, connectedAppCredentialId, consumerId, userName,
				downloadCachePath, syncDatabase, filesPerBackup, lastBackupTime,
				noOfBackupStreams, backupArchivedandDeletedRecs, backupObjs, ignoreObjs,
				backupSfObjects, backupFileObjects, backupSFMetadata, accessNodes, endpoint, authType)
			SELECT @clientId AS clientId,
				@clientName as organizationName,
				ISNULL([Associated Plan], 0) AS planId,
				ISNULL([Salesforce Organization Type], '') AS environmentType,
				ISNULL([Salesforce Connected App Credential Id], 0) AS connectedAppCredentialId,
				ISNULL([Salesforce consumer ID], '') AS consumerId,
				ISNULL([Salesforce username], '') AS userName,
				ISNULL([Salesforce Download Cache Path], '') AS downloadCachePath,
				ISNULL([Salesforce Sync Database], '<App_SalesforceSyncDatabase />') AS syncDatabase,
				ISNULL([Salesforce files per backup], 50) AS filesPerBackup,
				ISNULL([Last Data Protected Time], 0) AS lastBackupTime,
				ISNULL([sys:nStreams], 2) AS noOfBackupStreams,
				ISNULL([Salesforce Backup Archived and Deleted Records], 0) AS backupArchivedandDeletedRecs,
				ISNULL([Salesforce Backup Objects], '<App_SalesforceSubClient />') AS backupObjs,
				ISNULL([Salesforce Exclude Objects], '<App_SalesforceSubClient />') AS ignoreObjs,
				ISNULL([Salesforce Backup Salesforce Objects], 0) AS backupSfObjects,
				ISNULL([Salesforce Backup File Objects], 0) AS backupFileObjects,
				ISNULL([Salesforce Backup Metadata], 0) AS backupSFMetadata,
				[Vs Member Servers] AS accessNodes,
				ISNULL([Salesforce endpoint], '') AS endpoint,
				ISNULL([Salesforce authentication type], 2) AS authType -- default to password based auth
			FROM (
				(SELECT attrName, attrVal FROM APP_InstanceProp WITH (NOLOCK)
					WHERE componentNameId = @instanceId AND modified = 0 AND attrName IN
					('Salesforce consumer ID', 'Salesforce Organization Type', 'Salesforce files per backup', 'Vs Member Servers', 'Salesforce endpoint'))
				UNION
				(SELECT attrName, attrVal FROM APP_BackupSetProp WITH (NOLOCK)
					WHERE componentNameId = @backupsetId AND modified = 0 AND attrName IN
					('Salesforce username', 'Salesforce Download Cache Path', 'Salesforce Sync Database', 'Salesforce Connected App Credential Id', 'Salesforce authentication type'))
				UNION
				(SELECT attrName, attrVal FROM APP_SubClientProp WITH (NOLOCK)
					WHERE componentNameId = @subclientId AND modified = 0 AND attrName IN
					('Associated Plan',
					'Last Data Protected Time',
					'sys:nStreams',
					'Salesforce Backup Archived and Deleted Records',
					'Salesforce Backup Objects',
					'Salesforce Exclude Objects',
					'Salesforce Backup Salesforce Objects',
					'Salesforce Backup File Objects',
					'Salesforce Backup Metadata'
					)
					AND cs_attrName IN
					(
						CHECKSUM(N'Associated Plan'),
						CHECKSUM(N'Last Data Protected Time'),
						CHECKSUM(N'sys:nStreams'),
						CHECKSUM(N'Salesforce Backup Archived and Deleted Records'),
						CHECKSUM(N'Salesforce Backup Objects'),
						CHECKSUM(N'Salesforce Exclude Objects'),
						CHECKSUM(N'Salesforce Backup Salesforce Objects'),
						CHECKSUM(N'Salesforce Backup File Objects'),
						CHECKSUM(N'Salesforce Backup Metadata')
					))
			) AS T
			PIVOT (
				MAX(attrVal)
				FOR attrName IN (
					[Salesforce consumer ID],
					[Salesforce Organization Type],
					[Salesforce Connected App Credential Id],
					[Salesforce files per backup],
					[Vs Member Servers],
					[Salesforce endpoint],
					[Salesforce authentication type],
					[Salesforce username],
					[Salesforce Download Cache Path],
					[Salesforce Sync Database],
					[Associated Plan],
					[Last Data Protected Time],
					[sys:nStreams],
					[Salesforce Backup Archived and Deleted Records],
					[Salesforce Backup Objects],
					[Salesforce Exclude Objects],
					[Salesforce Backup Salesforce Objects],
					[Salesforce Backup File Objects],
					[Salesforce Backup Metadata]
				)
			) AS p
			-- update plan name
			UPDATE op
			SET op.planName = ap.name
			FROM @orgProps op
			INNER JOIN App_Plan ap WITH (NOLOCK) ON ap.id = op.planId
			WHERE ap.modified = 0
AND ((ap.flag & 0x00004) = 0) -- 0x00004
AND ((ap.flag & 0x40000000) = 0) -- 0x40000000
			-- update last backup size
			UPDATE op
			SET op.lastBackupSize = bs.totalUncompBytes
			FROM @orgProps op
			INNER JOIN JMBkpStats bs WITH (NOLOCK) ON bs.commCellId = @commcellId
			INNER JOIN (
				SELECT MAX(jobId) AS jobId, appId, commCellId FROM JMBkpStats WITH (NOLOCK)
				WHERE appId = @subclientId AND status IN (1, 3, 14)
				GROUP BY appId, commCellId
			) T ON T.jobId = bs.jobId AND T.commCellId = bs.commCellId
			-- update Credential entity name
			UPDATE op
			SET op.connectedAppCredentialName = cred.credentialName
			FROM @orgProps op
			INNER JOIN APP_Credentials cred WITH (NOLOCK) ON op.connectedAppCredentialId = cred.credentialId
			UPDATE op
			SET op.accessNodes = (SELECT CL.id AS 'client/@clientId', Cl.displayName AS 'client/@clientName', 3 AS 'client/@_type_'
									FROM APP_InstanceProp IP WITH (NOLOCK)
									INNER JOIN APP_Client CL WITH (NOLOCK) ON IP.attrVal = CL.id
									WHERE IP.componentNameId = @instanceId AND IP.attrName = 'Salesforce backup client' AND IP.modified = 0
									FOR XML PATH('memberServers'), ROOT('App_MemberServers'))
			FROM @orgProps op WHERE op.accessNodes IS NULL
			-- set consumer secret to null when authentication type is oauth
			UPDATE op
			SET op.consumerId = NULL
			FROM @orgProps op
			WHERE op.authType = 1 -- OAUTH
			SET @outputXml = (
			SELECT organizationName AS '@organizationName',
				downloadCachePath AS '@downloadCachePath',
				filesPerBackup AS '@filesPerBackup',
				lastBackupTime AS '@lastBackupTime',
				lastBackupSize AS '@lastBackupSize',
				noOfBackupStreams AS '@noOfBackupStreams',
				backupArchivedandDeletedRecs AS '@backupArchivedandDeletedRecs',
				backupSfObjects AS '@backupSfObjects',
				backupFileObjects AS '@backupFileObjects',
				backupSFMetadata AS '@backupSFMetadata',
				(SELECT planId AS '@planId',
					ISNULL(planName, '') AS '@planName'
					FOR XML PATH('plan'), TYPE),
				(SELECT consumerId AS '@consumerId',
					environmentType AS '@environmentType',
					endpoint AS '@endpoint',
					authType AS '@authenticationType',
					(SELECT
						userName AS '@userName'
						FOR XML PATH('userCredentials'), TYPE),
					(SELECT
						connectedAppCredentialId as '@credentialId',
						connectedAppCredentialName as '@credentialName'
						FOR XML PATH('connectedAppCredentials'), TYPE)
				FOR XML PATH('salesforceAccount'), TYPE),
				(SELECT ISNULL(n.v.value('@dbEnabled', 'INT'), 0) AS '@dbEnabled',
						ISNULL(n.v.value('@dbHost', 'NVARCHAR(256)'), '') AS '@dbHost',
						ISNULL(n.v.value('@dbName', 'NVARCHAR(256)'), '') AS '@dbName',
						ISNULL(n.v.value('@dbPort', 'INT'), 0) AS '@dbPort',
						ISNULL(n.v.value('@dbType', 'INT'), 0) AS '@dbType',
						ISNULL(n.v.value('@dbInstance', 'NVARCHAR(256)'), '') AS '@dbInstance',
						(SELECT ISNULL(n.v.value('dbUserPassword[1]/@userName', 'NVARCHAR(256)'), '') AS '@userName'
							FOR XML PATH('dbUserPassword'), TYPE)
					FROM syncDatabase.nodes('App_SalesforceSyncDatabase') n(v)
					FOR XML PATH('syncDatabase'), TYPE),
				(SELECT backupObjs.query('/App_SalesforceSubClient/*')),
				(SELECT ignoreObjs.query('/App_SalesforceSubClient/*')),
				(SELECT n.i.query('./*') FROM accessNodes.nodes('App_MemberServers/memberServers') n(i)
					FOR XML PATH('accessNodes'), TYPE),
				(SELECT DISTINCT I.id AS '@instanceId', I.name AS '@instanceName', I.GUID AS '@instanceGUID',
					ida.type AS '@applicationId', ida.displayName AS '@appName', app.clientId AS '@clientId', organizationName AS '@clientName',
					organizationName AS '@displayName', app.backupSet AS '@backupsetId', app.id AS '@subclientId'
					FROM APP_InstanceName I WITH (NOLOCK)
					INNER JOIN APP_Application app WITH (NOLOCK) ON app.instance = I.id
					INNER JOIN APP_iDAType ida WITH (NOLOCK) ON app.appTypeId = ida.type
					WHERE I.id = @instanceId AND app.backupSet = @backupsetId AND app.id = @subclientId
					FOR XML PATH('entity'), TYPE)
			FROM @orgProps
			FOR XML PATH('App_GetSalesforcePropertiesResponse'))
		END
		ELSE
			SET @outputXml = '<App_GenericResp errorCode="-2" errorMessage="User doesn''t have required privileges."></App_GenericResp>'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @outputXml = (
		SELECT ERROR_NUMBER() AS '@errorCode', ERROR_MESSAGE() AS '@errorMessage'
		FOR XML PATH('App_GenericResp')
	)
END CATCH
PROC_EXIT:
SELECT @outputXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSalesforceProperties')
	delete from GxQscripts where name = 'AppGetSalesforceProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSalesforceProperties')
	delete from GXDBVersions where aliasname = 'AppGetSalesforceProperties'
GO

insert into GXDBVersions values(2, 'AppGetSalesforceProperties',  '00000000000000000000', 'AppGetSalesforceProperties', '00000000000000000000')
GO

