

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSalesforceOrgs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSalesforceOrgs.sp,v $ $Id: AppGetSalesforceOrgs.sp,v 1.1.2.5 2019/08/27 21:17:10 stelagamsetti Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSalesforceOrgs')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSalesforceOrgs <<<'
	drop procedure AppGetSalesforceOrgs
END
IF EXISTS (select * from GxQscripts where name='AppGetSalesforceOrgs')
	delete from GxQscripts where name = 'AppGetSalesforceOrgs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSalesforceOrgs')
	delete from GXDBVersions where aliasname = 'AppGetSalesforceOrgs'
GO
print '... Creating Procedure: AppGetSalesforceOrgs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSalesforceOrgs
  @i_xmlString XML
AS
  DECLARE @o_xmlString XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	IF OBJECT_ID('tempdb.dbo.#SalesforceOrgs') IS NOT NULL
		DROP TABLE #SalesforceOrgs
	IF OBJECT_ID('tempdb.dbo.#SalesforceOrgDetails') IS NOT NULL
		DROP TABLE #SalesforceOrgDetails
	IF OBJECT_ID('tempdb.dbo.#SalesforceSyncDbDetails') IS NOT NULL
		DROP TABLE #SalesforceSyncDbDetails
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	CREATE INDEX getIdaObjects_instanceID_Idx ON #getIdaObjects(instanceID)
	CREATE TABLE #SalesforceOrgs
	(
		[SubclientID] INT,
		[SubclientName] NVARCHAR(1024),
		[BackupsetID] INT,
		[BackupsetName] NVARCHAR(1024),
		[InstanceId] INT,
		[InstanceName] NVARCHAR(255),
		[ClientId] INT,
		[ClientName] NVARCHAR(255),
		[LastBackupTime] INT DEFAULT 0,
		[Size] BIGINT DEFAULT 0,
		[SLA] INT DEFAULT 1,
		[Status] INT DEFAULT 0,
		[SalesforceOrgType] INT,
		[PlanId] INT DEFAULT '0',
		[PlanName] NVARCHAR(256) DEFAULT ''
		PRIMARY KEY([SubclientID], [BackupsetID], [InstanceId], [ClientId])
	)
	CREATE TABLE #SalesforceOrgDetails
	(
		[InstanceId] INT,
		[endpoint] NVARCHAR(256),
		[SfOrgId] NVARCHAR(256),
		[SfOrgType] INT,
		[filesPerBackup] INT
	)
	CREATE TABLE #SalesforceSyncDbDetails
	(
		[BackupsetID] INT,
		[SyncDatabase] XML
		PRIMARY KEY([BackupsetID])
	)
	DECLARE @localeId INT = ISNULL((select ref.value('@localeId','INT') FROM @i_xmlString.nodes('/Api_SalesforceOrgsReq/processinginstructioninfo/locale')  R(ref)), 0)
	DECLARE @userId INT = ISNULL((select ref.value('@userId','INT') FROM @i_xmlString.nodes('/Api_SalesforceOrgsReq/processinginstructioninfo/user')  R(ref)), 0)
	--Get list of instances user has visibility to
	EXEC dbo.sec_getIdaObjectsForUser @userid, 7, 0, 1, '#getIdaObjects' -- 7 = SUBCLIENT_ENTITY from CvEntities.x
	DELETE	#getIdaObjects
WHERE	apptypeId != 134
	INSERT	INTO #SalesforceOrgs (SubclientID, SubclientName, BackupsetID, BackupsetName, InstanceId, InstanceName, ClientId, ClientName, Status)
	SELECT	DISTINCT A.id, A.subclientName, B.id, B.name, I.id, I.name, C.id, C.name, A.subclientStatus
	FROM	#getIdaObjects sec
		INNER JOIN APP_Application A
			ON sec.instanceID = A.instance
		INNER JOIN APP_Client C
			ON A.clientId = C.id
		INNER JOIN APP_InstanceName I
			ON I.id = A.instance
		INNER JOIN APP_BackupsetName B
			ON A.backupset = B.id AND (B.name <> 'defaultBackupset' OR (B.status & 8) = 0)
		INNER JOIN APP_InstanceProp IP
			ON IP.componentNameId = I.id AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal = '3'
	WHERE	(A.subclientStatus&4) = 0
		AND (A.subclientStatus&16) = 0
		AND (A.subclientStatus & 32) = 0
			--#define CV_STATUS_DELETED           0x00004
			--#define CV_STATUS_DUMMY			  0x00010
			--#define CV_STATUS_HIDDEN            0x00020
	INSERT INTO #SalesforceOrgDetails
	SELECT	DISTINCT componentNameId,
			ISNULL([Salesforce endpoint], ''),
			ISNULL([Salesforce Organization ID], ''),
			ISNULL([Salesforce Organization Type], 2), --Send unknown if org type is not set (SalesforceOrganizationType_UNKNOWN)
			ISNULL([Salesforce files per backup], 50)
    FROM
    (
        SELECT  componentNameId, attrName, attrVal
		FROM APP_InstanceProp prop
			INNER JOIN #SalesforceOrgs S
				ON S.InstanceId = prop.componentNameId
        WHERE prop.modified = 0
    ) AS backupSetProp
    PIVOT
    (
        MAX(attrVal) FOR attrName IN ([Salesforce endpoint], [Salesforce Organization ID],
                                        [Salesforce Organization Type], [Salesforce files per backup])
    ) AS P
	INSERT INTO #SalesforceSyncDbDetails
	SELECT	DISTINCT S.BackupsetID, ISNULL(BP.attrVal, '<App_SalesforceSyncDatabase dbEnabled="0"/>')
	FROM	#SalesforceOrgs S
		LEFT OUTER JOIN APP_BackupSetProp BP
			ON S.BackupsetID = BP.componentNameId AND BP.attrName = 'Salesforce Sync Database' AND BP.modified = 0
	--Update plan info
	UPDATE	#SalesforceOrgs
	SET		PlanId = AP.id,
			PlanName = AP.name
	FROM	#SalesforceOrgs I
		INNER JOIN APP_InstanceProp IP
ON IP.componentNameId = I.InstanceId  AND IP.attrName = 'Associated Plan' AND IP.modified=0
		LEFT OUTER JOIN App_Plan AP WITH(NOLOCK)
ON CAST(AP.id AS NVARCHAR(32)) = IP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
	--Update SLA status
	UPDATE	S
	SET		S.SLA = (CASE WHEN R.status = 1 THEN 1 WHEN (R.status = 2 OR R.status IS NULL) THEN 2 ELSE 3 END)
	FROM	#SalesforceOrgs S
		LEFT OUTER JOIN RptSLASubclient R
			ON R.appId = S.subclientID AND R.fullJobsOnly = 0
	IF OBJECT_ID('tempdb.dbo.#lastSuccBackupJob') IS NOT NULL DROP TABLE dbo.#lastSuccBackupJob
	CREATE TABLE #lastSuccBackupJob (subclientId INT, instanceId INT, backupJobId INT, commCellId INT, servEndDate INT, size BIGINT)
	INSERT INTO #lastSuccBackupJob
	SELECT subclientId, InstanceId, jobId, commCellID, servEndDate, totalUnCompBytes
	FROM
	(
		SELECT	A.id AS 'subclientId', A.instance AS 'InstanceId', B.jobId, B.commCellID, B.servEndDate, B.totalUnCompBytes, ROW_NUMBER() OVER (PARTITION BY A.id ORDER BY B.servEndDate DESC) AS rowId
		FROM	#SalesforceOrgs I
			INNER JOIN APP_Application A
				ON I.subclientId = A.id
			INNER JOIN APP_IdaType IDA
				ON A.appTypeId = IDA.type
			INNER JOIN JMBkpStats B
				ON A.id = B.appId AND (B.status IN (1, 14) OR (B.status = 3 AND IDA.isCWEJobValid = 1))
	) S
	WHERE S.rowId = 1
	--Update size and last backup time
	UPDATE	I
	SET		I.LastBackupTime = (CASE WHEN I.LastBackupTime > 0 THEN I.LastBackupTime ELSE J.servEndDate END),
			I.Size = (CASE WHEN I.Size > 0 THEN I.Size ELSE J.size END)
	FROM	#SalesforceOrgs I
		INNER JOIN #lastSuccBackupJob J
			ON I.InstanceId = J.instanceId
	WHERE	(I.LastBackupTime = 0 OR I.Size = 0)
	IF OBJECT_ID('tempdb.dbo.#lastSuccBackupJob') IS NOT NULL DROP TABLE dbo.#lastSuccBackupJob
	SET @o_xmlString =
	(
		SELECT
		(	SELECT	0 AS '@errorCode',
					N'' AS '@errorMessage'
			FOR XML PATH('error'), TYPE),
		(	SELECT	D.LastBackupTime AS '@backupTime',
					D.Size AS '@backupSize',
					D.SLA AS '@slaStatus',
					D.Status AS '@status',
					(SELECT SO.endpoint FROM #SalesforceOrgDetails AS SO WHERE SO.instanceId = D.instanceId) AS '@endPoint',
					(SELECT SO.SfOrgId FROM #SalesforceOrgDetails AS SO WHERE SO.instanceId = D.instanceId) AS '@sfOrgId',
					(SELECT SO.SfOrgType FROM #SalesforceOrgDetails AS SO WHERE SO.instanceId = D.instanceId) AS '@sfOrgType',
					(SELECT SO.filesPerBackup FROM #SalesforceOrgDetails AS SO WHERE SO.instanceId = D.instanceId) AS '@filesPerBackup',
					D.subclientId AS 'sfSubclient/@subclientId',
					D.subclientName AS 'sfSubclient/@subclientName',
					D.BackupsetID AS 'sfSubclient/@backupsetId',
					D.BackupsetName AS 'sfSubclient/@backupsetName',
					D.InstanceId AS 'sfSubclient/@instanceId',
					D.InstanceName AS 'sfSubclient/@instanceName',
134 AS 'sfSubclient/@applicationId',
					D.ClientId AS 'sfSubclient/@clientId',
					D.ClientName AS 'sfSubclient/@clientName',
					D.PlanId AS 'plan/@planId',
					D.PlanName AS 'plan/@planName',
					(SELECT DB.SyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbEnabled)', 'integer') AS '@dbEnabled',
                            DB.SyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbHost)', 'NVARCHAR(MAX)') AS '@dbHost',
                            DB.SyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbInstance)', 'NVARCHAR(MAX)') AS '@dbInstance',
                            DB.SyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbName)', 'NVARCHAR(MAX)') AS '@dbName',
                            DB.SyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbPort)', 'integer') AS '@dbPort',
                            DB.SyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbType)', 'integer') AS '@dbType'
					FROM	#SalesforceSyncDbDetails DB
					WHERE	DB.BackupsetID = D.BackupsetID
                    FOR XML PATH('syncDB'), TYPE)
			FROM #SalesforceOrgs AS D for XML PATH('orgs'), TYPE)
		FOR XML PATH(''), ROOT('Api_SalesforceOrgsResp')
	)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @o_xmlString = (SELECT @@ERROR AS '@errorCode', 'Failed to get database details.' AS '@errorMessage'
			FOR XML PATH ('response'), root(N'Api_SalesforceOrgsResp'))
END CATCH
IF @o_xmlString IS NULL
	SET @o_xmlString = '<Api_SalesforceOrgsResp/>'
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
IF OBJECT_ID('tempdb.dbo.#SalesforceOrgs') IS NOT NULL
	DROP TABLE #SalesforceOrgs
IF OBJECT_ID('tempdb.dbo.#SalesforceOrgDetails') IS NOT NULL
	DROP TABLE #SalesforceOrgDetails
IF OBJECT_ID('tempdb.dbo.#SalesforceSyncDbDetails') IS NOT NULL
	DROP TABLE #SalesforceSyncDbDetails
SELECT @o_xmlString AS o_xmlString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSalesforceOrgs')
	delete from GxQscripts where name = 'AppGetSalesforceOrgs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSalesforceOrgs')
	delete from GXDBVersions where aliasname = 'AppGetSalesforceOrgs'
GO

insert into GXDBVersions values(2, 'AppGetSalesforceOrgs',  '00010001000200050000', 'AppGetSalesforceOrgs', '00010001000200050000')
GO

