

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSQLPossibleAssociatedAppIDs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSQLPossibleAssociatedAppIDs')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSQLPossibleAssociatedAppIDs <<<'
	drop procedure AppGetSQLPossibleAssociatedAppIDs
END
IF EXISTS (select * from GxQscripts where name='AppGetSQLPossibleAssociatedAppIDs')
	delete from GxQscripts where name = 'AppGetSQLPossibleAssociatedAppIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLPossibleAssociatedAppIDs')
	delete from GXDBVersions where aliasname = 'AppGetSQLPossibleAssociatedAppIDs'
GO
print '... Creating Procedure: AppGetSQLPossibleAssociatedAppIDs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSQLPossibleAssociatedAppIDs
  @XmlInputOutput XML OUTPUT
AS
  DECLARE @o_xml XML
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @instanceId INT = ISNULL((SELECT @XmlInputOutput.value('(/Api_SQLDatabaseBackupReq/@instanceId)[1]','INT')), 0)
	DECLARE @allDBs INT = ISNULL((SELECT @XmlInputOutput.value('(/Api_SQLDatabaseBackupReq/@allDBs)[1]','INT')), 0)
	IF OBJECT_ID('tempdb.dbo.#SqlDatabasAppId') IS NOT NULL
		DROP TABLE #SqlDatabasAppId
	CREATE TABLE #SqlDatabasAppId(dbId INT, dbName NVARCHAR(1024), subClientId INT, subclientName NVARCHAR(1024))
	IF @allDBs = 1
	BEGIN
		INSERT INTO #SqlDatabasAppId
			SELECT
				0, N'', AP.id,
				AP.subclientName
			FROM APP_Application AP
			WHERE AP.appTypeId = 81
					AND AP.instance = @instanceId
					AND AP.subclientStatus & (2|4) = 0
					AND AP.subclientStatus & 32 <> 32 -- Avoid the DNB subclient.
	END
	ELSE
	BEGIN
		INSERT INTO #SqlDatabasAppId
			SELECT
				ISNULL(Tbl.Col.value('@val', 'int'), 0),
				N'', 0, N''
			FROM @XmlInputOutput.nodes('/Api_SQLDatabaseBackupReq/database') as Tbl(Col)
		-- Update database name from database ID.
		UPDATE SA SET
			SA.dbName = SN2.name
		FROM #SqlDatabasAppId SA
			JOIN sqlNames SN
				ON SN.id = SA.dbId
					AND SN.type = 1
			JOIN sqlNames2 SN2
				ON SN2.id = SN.sqlId
					AND SN2.type = 1
		-- Update last associated SQL subclient.
		UPDATE SA SET
			SA.subClientId = SP.componentNameId,
			SA.subclientName = AP.subclientName
		FROM #SqlDatabasAppId SA
			JOIN APP_Application AP
				ON Ap.instance = @instanceId
					AND AP.appTypeId = 81
					AND AP.subclientStatus & (2|4) = 0
			JOIN APP_SubClientProp SP
				ON SP.componentNameId = AP.id
					AND SP.attrType = 118
					AND SP.modified =  0
		WHERE SA.dbName <> N''
			AND SA.dbName = SP.attrName
			AND SA.subClientId = 0
		-- Update the default as the last option.
		UPDATE SA SET
			SA.subClientId = CASE WHEN SP.attrVal IS NULL OR SP.attrVal = N'0' THEN AP.id END,
			SA.subclientName = AP.subclientName
		FROM #SqlDatabasAppId SA
			JOIN APP_Application AP
				ON AP.instance = @instanceId
					AND AP.appTypeId = 81
					AND AP.subclientStatus & (2|4) = 0
					AND AP.subclientStatus & 8 = 8
			LEFT JOIN APP_SubClientProp SP
				ON SP.componentNameId = AP.id
					AND SP.attrName = N'MSSQL Disable AutoDiscovery'
					AND SP.cs_attrName = CHECKSUM(N'MSSQL Disable AutoDiscovery')
					AND SP.modified = 0
		WHERE SA.dbName <> N''
			AND SA.subClientId = 0
		-- Update the FULL discovery subclient.
		UPDATE SA SET
			SA.subClientId = CASE WHEN SP.attrVal IS NULL OR SP.attrVal = N'0' THEN AP.id END,
			SA.subclientName = AP.subclientName
		FROM #SqlDatabasAppId SA
			JOIN APP_Application AP
				ON AP.instance = @instanceId
					AND AP.appTypeId = 81
					AND AP.subclientStatus & (2|4) = 0
			JOIN APP_SubClientProp SP
				ON SP.componentNameId = AP.id
					AND SP.attrName = N'MSSQL Disable AutoDiscovery'
					AND SP.cs_attrName = CHECKSUM(N'MSSQL Disable AutoDiscovery')
					AND SP.modified = 0
			JOIN APP_SubClientProp SPS
				ON SPS.componentNameId = AP.id
					AND SPS.attrName = N'SQL Special Subclient Type'
					AND SPS.cs_attrName = CHECKSUM(N'SQL Special Subclient Type')
					AND SPS.modified = 0
					AND SPS.attrVal = N'3' -- FULL recovery.
		WHERE SA.dbName <> N''
			AND SA.subClientId = 0
	END
	SET @XmlInputOutput =
				(SELECT
					(SELECT
						AP.subClientId AS '@subclientId',
						AP.subclientName AS '@subclientName'
					FOR XML PATH('subClientEntity'), TYPE),
					(SELECT
						SP.dbName AS '@databaseName',
						SP.dbId AS '@databaseId'
					FROM #SqlDatabasAppId SP
					WHERE AP.subClientId = SP.subClientId
					FOR XML PATH('sqlDatabaseInfo'), TYPE)
				FROM
					(SELECT P.subclientId, P.subclientName
						FROM #SqlDatabasAppId P
						WHERE P.subClientId <> 0
						GROUP BY P.subclientId, P.subclientName) AP
				FOR XML PATH('sqlSubclientContent'),
					ROOT('App_GetSQLDatabaseConfigurationResponse'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @XmlInputOutput = (SELECT ERROR_NUMBER() AS '@errorCode', 'Failed to get database details. ' + ERROR_MESSAGE() AS '@errorMessage'
			FOR XML PATH ('genericerror'), root(N'App_GetSQLDatabaseConfigurationResponse'))
END CATCH
SELECT @XmlInputOutput
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSQLPossibleAssociatedAppIDs')
	delete from GxQscripts where name = 'AppGetSQLPossibleAssociatedAppIDs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLPossibleAssociatedAppIDs')
	delete from GXDBVersions where aliasname = 'AppGetSQLPossibleAssociatedAppIDs'
GO

insert into GXDBVersions values(2, 'AppGetSQLPossibleAssociatedAppIDs',  '00000000000000000000', 'AppGetSQLPossibleAssociatedAppIDs', '00000000000000000000')
GO

