

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSQLJobHistoryInCommcell.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSQLJobHistoryInCommcell')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSQLJobHistoryInCommcell <<<'
	drop procedure AppGetSQLJobHistoryInCommcell
END
IF EXISTS (select * from GxQscripts where name='AppGetSQLJobHistoryInCommcell')
	delete from GxQscripts where name = 'AppGetSQLJobHistoryInCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLJobHistoryInCommcell')
	delete from GXDBVersions where aliasname = 'AppGetSQLJobHistoryInCommcell'
GO
print '... Creating Procedure: AppGetSQLJobHistoryInCommcell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSQLJobHistoryInCommcell
  @XmlInputOutput XML
AS
  DECLARE @o_xml XML
-- This indicates that no more data is available.
DECLARE @endData INT = 1
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
DECLARE @errorMessage NVARCHAR(256) = N''
BEGIN TRY
	DECLARE @userId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLJobHistoryRequest/@userId)[1]','INT')), 0)
	DECLARE @instanceId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLJobHistoryRequest/@instanceId)[1]','INT')), 0)
	DECLARE @databaseId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLJobHistoryRequest/@databaseId)[1]','INT')), 0)
	DECLARE @jobType INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLJobHistoryRequest/@jobType)[1]','INT')), 0)
	DECLARE @jobId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLJobHistoryRequest/@jobId)[1]','INT')), 0)
	DECLARE @fromTime INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLJobHistoryRequest/@fromTime)[1]','INT')), 0)
	DECLARE @toTime INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLJobHistoryRequest/@toTime)[1]','INT')), 0)
	DECLARE @propertyLevel INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLJobHistoryRequest/@propertyLevel)[1]','INT')), 10)
	DECLARE @debug INT = 0
	IF @jobId = 0
		--If jobId is not passed assign starting date to ending date of the current month
		SELECT @fromTime = dbo.GetUnixTime(CAST(DATEADD(DAY, -DAY(GETDATE()) + 1, CAST(GETDATE() AS DATE)) AS DATETIME)) WHERE @fromTime = 0
		SELECT @toTime = dbo.GetUnixTime(DATEADD(s,-1, DATEADD(mm, DATEDIFF(m, 0, CAST(GETDATE() AS DATE)) + 1, 0))) WHERE @toTime = 0
	IF ((@fromTime > 0) AND (@toTime > 0)) AND @fromTime >= @toTime
	BEGIN
		SET @errorCode  = 5
		SET @errorMessage = N'Invalid time information provided for the operation.'
		-- RETURN
		RAISERROR(@errorMessage, 25, -1)
	END
	IF @instanceId = 0
	BEGIN
		SET @errorCode  = 6
		SET @errorMessage = N'Invalid instance information provided.'
		-- RETURN
		RAISERROR(@errorMessage, 25, -1)
	END
	-- User permission to view jobs.
	IF OBJECT_ID('tempdb.dbo.#SqlClients') IS NOT NULL
		DROP TABLE #SqlClients
	CREATE TABLE #SqlClients( appId INT, clientID INT, instanceId INT, PRIMARY KEY(appId, instanceId))
	INSERT INTO #SqlClients
		SELECT DISTINCT AP.id, AP.clientId, AP.instance
			FROM sqlDbBackupInfo  SDB
				JOIN APP_Application AP ON SDB.appId = AP.id
			WHERE SDB.instanceId = @instanceId
		UNION
		SELECT DISTINCT AP.id, AP.clientId, AP.instance
			FROM sqlAnalysisDbBackupInfo  SDB
				JOIN APP_Application AP ON SDB.appId = AP.id
			WHERE SDB.instanceId = @instanceId
	-- User Permission Check Code Starts
	IF OBJECT_ID('tempdb.dbo.#tt_getAllIdaObjects') IS NOT NULL DROP TABLE #tt_getAllIdaObjects
	CREATE TABLE #tt_getAllIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	EXEC sec_getIdaObjectsForUser @userId, 2 /*CLIENT_ENTITY*/, 0 /* Any Permission */, 1 /* Inherit from child */, N'#tt_getAllIdaObjects'
	-- Based on operation, remove those clients for which current user does not have any permissions.
	DELETE FROM #SqlClients where clientId not in (select clientID from #tt_getAllIdaObjects)
	IF NOT EXISTS(SELECT * FROM #SqlClients WHERE instanceId = @InstanceId)
	BEGIN
		SET @errorCode  = 7
		SET @errorMessage = N'User doesn''t have permission on the instance.'
		-- RETURN
		RAISERROR(@errorMessage, 25, -1)
	END
	-- If JobId is not passed get the list of jobs for the given instance.
	IF OBJECT_ID('tempdb.dbo.#SqlJobs') IS NOT NULL DROP TABLE #SqlJobs
	CREATE TABLE #SqlJobs(jobId INT, appId INT, instanceId INT, jobType INT, endUTCTime INT, status INT,
			backupSize INT, commcellId INT, initFrom INT, noDBs INT
				PRIMARY KEY(jobId, appId, instanceId))
	INSERT INTO #SqlJobs
		SELECT jobId, jbs.appId, @InstanceId,  bkpLevel, servEndDate, status, totalBackupSize, commCellId, initFrom, 0
		FROM JMBkpStats jbs
			JOIN #SqlClients sc ON jbs.appId = sc.appId
			JOIN APP_iDAType ait ON jbs.appType = ait.type AND jbs.appType <> 106
		WHERE (jbs.status IN (1, 14) OR jbs.status = 3 AND ait.isCWEjobValid = 1) AND (jbs.opType NOT IN (59, 65) OR jbs.jobIdActedOn = jbs.jobId)
			AND (@jobId = 0 OR @jobId = jbs.jobId)
			AND (servStartDate >=
			(CASE @fromtime
				WHEN 0 THEN 0
				ELSE @fromtime
			END)
			OR
			servEndDate <=
			(CASE @toTime
				WHEN 0 THEN 0
				ELSE @toTime
			END))
	UPDATE SJ SET SJ.noDBs = SDJ.DBCount
		FROM #SqlJobs SJ
			JOIN (SELECT sdb.jobId, count(sdb.sqlNameId) DBCount
					FROM sqlDbBackupInfo sdb
						JOIN #SqlJobs sj
							ON sdb.jobId = sj.jobId
								AND sdb.appId = sj.appId
					WHERE (@databaseId = 0 OR @databaseId = sdb.sqlNameId)
				GROUP BY sdb.jobId) SDJ
		ON SDJ.jobId = SJ.jobId
	UPDATE SJ SET SJ.noDBs = SDJ.DBCount
		FROM #SqlJobs SJ
			JOIN (SELECT sdb.jobId, COUNT(DISTINCT sdb.dbId) DBCount
					FROM sqlAnalysisDbBackupInfo sdb
						JOIN #SqlJobs sj
							ON sdb.jobId = sj.jobId
								AND sdb.appId = sj.appId
					WHERE (@databaseId = 0 OR @databaseId = sdb.dbId)
				GROUP BY sdb.jobId) SDJ
		ON SDJ.jobId = SJ.jobId
	IF @databaseId <> 0 OR @propertyLevel > 10
	BEGIN
		-- Get the list of jobs for the given instance.
		IF OBJECT_ID('tempdb.dbo.#SqlDbJobs') IS NOT NULL DROP TABLE #SqlDbJobs
		CREATE TABLE #SqlDbJobs(instanceId INT, SqlDbId INT, backupSet INT, jobId INT, mVersion INT, mnVersion INT, bkpDate INT, type INT,
						bkpMethod INT, backupSize INT, firstLSN NVARCHAR(32), lastLSN NVARCHAR(32), ckptLSN NVARCHAR(32), fBkpLSN NVARCHAR(32)
					PRIMARY KEY(instanceId, SqlDbId, jobId))
		INSERT INTO #SqlDbJobs
			SELECT sdb.instanceId, sdb.sqlNameId, sdb.id, sdb.jobId, sdb.majorVersion, sdb.minorVersion, sdb.backup_finish_Date,
				CASE sdb.type	WHEN 'D' THEN 1		WHEN 'L' THEN 2		WHEN 'I' THEN 3 END,
				sdb.backupmethod, sdb.backup_size, sdb.first_lsn, sdb.last_lsn, sdb.checkpoint_lsn, sdb.full_bkup_lsn
			FROM sqlDbBackupInfo sdb WHERE @instanceId = sdb.instanceId AND (@databaseId = 0 OR @databaseId = SDB.sqlNameId)
				AND (@jobId = 0 OR @jobId = sdb.jobId)
				AND (backup_start_Date >=
				(CASE @fromtime
					WHEN 0 THEN 0
					ELSE @fromtime
				END)
				OR
				backup_finish_Date <=
				(CASE @toTime
					WHEN 0 THEN 0
					ELSE @toTime
				END))
		INSERT INTO #SqlDbJobs
			SELECT sdb.instanceId,
				sdb.dbId,
				sdb.id,
				sdb.jobId,
				sdb.instanceVersion,
				0, sdb.backup_finish_Date,
				1, 0,
				sdb.backup_size, 0, 0, 0, 0
			FROM sqlAnalysisDbBackupInfo sdb
			WHERE @instanceId = sdb.instanceId
				AND (@databaseId = 0
						OR @databaseId = SDB.dbId)
				AND (@jobId = 0
						OR @jobId = sdb.jobId)
				AND (backup_start_Date >=
						(CASE @fromtime
							WHEN 0 THEN 0
							ELSE @fromtime
						END)
					OR
					backup_finish_Date <=
						(CASE @toTime
							WHEN 0 THEN 0
							ELSE @toTime
						END))
		set @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage' FOR XML PATH('response'), type),
					(SELECT sd.instanceId as "@insId", sd.sqlDbId as "@dbId", sd.backupSet as "@bkpId", sd.jobId as "@jobId",
					sd.mVersion as "@mVersion", sd.mnVersion as "@minVersion", sd.bkpDate as "@bkpDate",
					sd.type as "@type", sd.bkpMethod as "@bkpMethod", sd.backupSize as "@bkpSize", sd.firstLSN as "@firstLSN",
					sd.lastLSN as "@lastLSN", sd.ckptLSN as "@ckptLSN",sd.fBkpLSN as "@fBkpLSN"
				FROM #SqlDbJobs sd FOR XML PATH('dbBackups'), type)
					FOR XML PATH(''), ROOT('App_GetSQLJobHistoryResponse')), N'<App_GetSQLJobHistoryResponse />')
	END
	ELSE
	BEGIN
		set @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage' FOR XML PATH('response'), type),
					(SELECT sd.instanceId as "@insId", sd.appId as "@appId", sd.jobType as "@jType", sd.jobId as "@jobId",
						sd.endUTCTime as "@endTime", sd.status as "@status", sd.backupSize as "@bkpSize", sd.commcellId as "@ccId",
						sd.initFrom as "@initFrom", sd.noDBs as "@noDBs"
					FROM #SqlJobs sd FOR XML PATH('jobs'), type)
						FOR XML PATH(''), ROOT('App_GetSQLJobHistoryResponse')), N'<App_GetSQLJobHistoryResponse />')
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @@ERROR <> 0
		SET  @XmlInputOutput = (SELECT @@ERROR AS '@errorCode', 'Failed to get database details.' AS '@errorMessage'
			FOR XML PATH ('response'), root(N'App_GetSQLDatabasesResponse'))
	ELSE
		SET  @XmlInputOutput = (SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage'
			FOR XML PATH ('response'), root(N'App_GetSQLDatabasesResponse'))
END CATCH
SELECT @XmlInputOutput
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSQLJobHistoryInCommcell')
	delete from GxQscripts where name = 'AppGetSQLJobHistoryInCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLJobHistoryInCommcell')
	delete from GXDBVersions where aliasname = 'AppGetSQLJobHistoryInCommcell'
GO

insert into GXDBVersions values(2, 'AppGetSQLJobHistoryInCommcell',  '00000000000000000000', 'AppGetSQLJobHistoryInCommcell', '00000000000000000000')
GO

