

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSQLInstancesInACommcell.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSQLInstancesInACommcell')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSQLInstancesInACommcell <<<'
	drop procedure AppGetSQLInstancesInACommcell
END
IF EXISTS (select * from GxQscripts where name='AppGetSQLInstancesInACommcell')
	delete from GxQscripts where name = 'AppGetSQLInstancesInACommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLInstancesInACommcell')
	delete from GXDBVersions where aliasname = 'AppGetSQLInstancesInACommcell'
GO
print '... Creating Procedure: AppGetSQLInstancesInACommcell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSQLInstancesInACommcell
  @XmlInputOutput XML OUTPUT
AS
  DECLARE @o_xml XML
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- This indicates that no more data is available.
DECLARE @endData INT = 1
BEGIN TRY
	-- Basic Info
	DECLARE @userId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/@userId)[1]','INT')), 0)
	DECLARE @InstanceId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/@instanceId)[1]','INT')), 0)
	DECLARE @CalcSLAOnly INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/@slaOnly)[1]','INT')), 0)
	DECLARE @propertyLevel INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/@propertyLevel)[1]','INT')), 10)
	-- Paging Values
	DECLARE @noPaging INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/paging/@noPaging)[1]','INT')), 1)
	-- Default will be 0th page (which is first 50 instances).
	DECLARE @startIndex INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/paging/@startIndex)[1]','INT')), 0)
	-- First 50 instances will be considered.
	DECLARE @maxSize INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/paging/@maxSize)[1]','INT')), 50)
	DECLARE @startOffset INT = @startIndex * @maxSize
	DECLARE @endOffset INT = @startOffset + @maxSize
	-- SORT VALUES
	DECLARE @sort INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/@sortIndex)[1]','INT')), 1)
	DECLARE @order INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/@sortOrder)[1]','INT')), 0)
	-- Search option
	DECLARE @search_term NVARCHAR(1024) = N'%' + ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/search/@searchKey)[1]','NVARCHAR(256)')), N'') + N'%'
	-- Filter option for database name.
	DECLARE @instance_name_key NVARCHAR(1024) = N'%' + ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/search/@instanceNameKey)[1]','NVARCHAR(256)')), N'') + N'%'
	-- Filter option for database name.
	DECLARE @client_name_key NVARCHAR(1024) = N'%' + ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLInstancesRequest/search/@clientNameKey)[1]','NVARCHAR(256)')), N'') + N'%'
	DECLARE @debug INT = 0
	-- User Permission Check Code Starts
	IF OBJECT_ID('tempdb.dbo.#tt_getAllIdaObjects') IS NOT NULL
		DROP TABLE #tt_getAllIdaObjects
	CREATE TABLE #tt_getAllIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	-- Get all IDA objects on which current USER have permissions.
EXEC sec_getIdaObjectsForUser @userId,  3, 0 /* Any Permission */, 1 /* Inherit from child */, N'#tt_getAllIdaObjects'
	-- Table: to store authentication details
	IF OBJECT_ID('tempdb..#SQLAuthDetails') IS NOT NULL DROP TABLE #SQLAuthDetails
	CREATE TABLE #SQLAuthDetails (instanceId int, authType int,
			userName nvarchar(1024), userPassword nvarchar(1024), level int)
	-- Base information is stored in this table.
	IF OBJECT_ID('tempdb.dbo.#SqlInstanceDetails') IS NOT NULL DROP TABLE #SqlInstanceDetails
	CREATE TABLE #SqlInstanceDetails (instance int, instanceName nvarchar(1024), clientId int, clientname nvarchar(1024),
		version nvarchar(256), status int, lastBackupTime int, serverType nvarchar(256), primary key(instance, clientId))
	INSERT INTO #SqlInstanceDetails
		SELECT DISTINCT SC.instance, ai.name, SC.clientId, ac.displayName, aip.attrVal,
			CASE WHEN AC.status & 2 = 2 THEN 0 ELSE 1 END, maxDate.finDate, Px.attrVal
			FROM APP_Application SC
				JOIN APP_Client AC ON SC.clientId = AC.id AND SC.appTypeId = 81 /* CV_APPTYPE_MSSQL */
				JOIN APP_InstanceName AI ON SC.instance = AI.id
				LEFT JOIN APP_InstanceProp aip ON SC.instance = aip.componentNameId AND
					aip.attrName = N'MSSQL Version' AND aip.modified = 0
				LEFT JOIN APP_InstanceProp Px ON SC.instance = Px.componentNameId AND
					Px.attrName = N'MSSQL Server Type' AND Px.modified = 0
				LEFT JOIN (SELECT SDB.instanceId, MAX(SDB.backup_finish_Date) AS finDate
					FROM sqlDbBackupInfo SDB GROUP BY sdb.instanceId) maxDate
					ON maxDate.instanceId = SC.instance
			WHERE (@InstanceId = 0 OR @InstanceId = SC.instance)
				AND SC.clientId in (select clientID from #tt_getAllIdaObjects)
				-- Removed the filter for analysis databases.
				-- Apply search term.
				AND (AI.name LIKE @search_term OR AC.name LIKE @search_term)
				-- Apply filters.
				AND (AC.name LIKE @client_name_key)
				AND (AI.name LIKE @instance_name_key)
	-- Get plan details added
	IF OBJECT_ID('tempdb.dbo.#SqlInstancePlanDetails') IS NOT NULL DROP TABLE #SqlInstancePlanDetails
	CREATE TABLE #SqlInstancePlanDetails (instance int, planId int, planName NVARCHAR(255), PRIMARY KEY(instance))
	INSERT INTO #SqlInstancePlanDetails
		SELECT TH.instance, TH.planId, TH.planName
		FROM (
			SELECT ROW_NUMBER() OVER(PARTITION BY SD.instance ORDER BY SC.id ASC) rn, SD.instance, SC.id as appId,
				CASE
					WHEN APY.id IS NOT NULL THEN APY.id
					WHEN APX.id IS NOT NULL THEN APX.id
					WHEN AP.id IS NOT NULL THEN AP.id
					ELSE 0
				END as planId,
				CASE
					WHEN APY.id IS NOT NULL THEN APY.name
					WHEN APX.id IS NOT NULL THEN APX.name
					WHEN AP.id IS NOT NULL THEN AP.name
					ELSE N''
				END as planName
			FROM #SqlInstanceDetails SD
				JOIN APP_Application SC
					ON SD.instance = SC.instance
						AND SD.clientId = SC.clientId
						AND SC.appTypeId = 81
						AND (SC.subclientStatus & (2|4)) = 0
						-- Only default subclient is considered for plan details.
						AND SC.subclientStatus & 8 = 8
				LEFT JOIN App_ClientProp ACP ON ACP.componentNameId = SD.clientId AND ACP.attrName = 'Associated Plan' AND ACP.modified = 0
				LEFT JOIN App_Plan ap ON ACP.attrVal = CAST(AP.id AS NVARCHAR(12))
				LEFT JOIN APP_BackupSetProp ABP ON ABP.componentNameId = SC.backupSet AND ABP.attrName = 'Associated Plan' AND ABP.modified = 0
				LEFT JOIN App_Plan APX ON ABP.attrVal = CAST(APX.id AS NVARCHAR(12))
				LEFT JOIN APP_SubClientProp ASP ON ASP.componentNameId = SC.id AND ASP.attrName = 'Associated Plan' AND ASP.modified = 0
				LEFT JOIN App_Plan APY ON ASP.attrVal = CAST(APY.id AS NVARCHAR(12))
			WHERE AP.id IS NOT NULL OR APX.id IS NOT NULL OR APY.id IS NOT NULL
		) TH WHERE TH.rn = 1
	-- Number of databases calculation
	IF OBJECT_ID('tempdb.dbo.#tt_SqlInstanceDbDetails') IS NOT NULL DROP TABLE #tt_SqlInstanceDbDetails
	CREATE TABLE #tt_SqlInstanceDbDetails (instanceId int, SLA int, unprotected int, protected int, attempted int, total int, sysDBs int
		PRIMARY KEY(instanceId))
	-- Get SLA days for each subclient.
	BEGIN
		-- SLA calcualtion for each database happens here.
		IF OBJECT_ID('tempdb.dbo.#SLA_Subclient') IS NOT NULL DROP TABLE tempdb.dbo.#SLA_Subclient
		CREATE TABLE #SLA_Subclient (clientId INT, appId INT, slaDays INT)
		INSERT INTO #SLA_Subclient
			SELECT DISTINCT SI.clientId, SI.id, 0
				FROM APP_Application SI WHERE SI.appTypeId = 81
		-- SLA days and time
		IF OBJECT_ID('tempdb.dbo.#ClientSLADays') IS NOT NULL DROP TABLE tempdb.dbo.#ClientSLADays
		CREATE TABLE #ClientSLADays (clientId INT, clientGroupId INT, slaDays INT)
		DECLARE	@ClientGroupSLADays TABLE (clientGroupId INT, slaDays INT)
		DECLARE @CS_SLADays			INT = 0
		SELECT	@CS_SLADays = longVal
			FROM	APP_ComponentProp WITH (NOLOCK)
			WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3300 AND modified = 0
		IF ISNULL(@CS_SLADays, 0) <= 0 SET @CS_SLADays = 30
		UPDATE	#SLA_Subclient SET slaDays = @CS_SLADays
		INSERT	INTO @ClientGroupSLADays
			SELECT	componentId, longVal
			FROM	APP_ComponentProp WITH (NOLOCK)
			WHERE	componentType = 8 AND propertyTypeId = 3300 AND modified = 0
		IF EXISTS (SELECT * FROM @ClientGroupSLADays)
		BEGIN
			INSERT INTO #ClientSLADays
			SELECT	T.clientId, T.clientGroupId, T.slaDays
			FROM	(SELECT CG.slaDays, CGA.clientId, CGA.clientGroupId, ROW_NUMBER() OVER (PARTITION BY CGA.clientId ORDER BY CG.slaDays) AS rowId
					FROM	@ClientGroupSLADays CG INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CG.clientGroupId = CGA.clientGroupId) T
			WHERE	T.rowId = 1
			UPDATE	S SET slaDays = CG.slaDays
			FROM	#SLA_Subclient S
					INNER JOIN #ClientSLADays CG ON S.clientId = CG.clientId
		END
	END
	-- Following databases should be removed from count.
	DECLARE @tblException TABLE (name NVARCHAR(255))
	INSERT INTO @tblException VALUES(N'master')
	INSERT INTO @tblException VALUES(N'msdb')
	INSERT INTO @tblException VALUES(N'model')
	-- Last valid backups
	IF OBJECT_ID('tempdb.dbo.#ValidBackups') IS NOT NULL DROP TABLE #ValidBackups
	CREATE TABLE #ValidBackups (instanceId int, dbId INT, lastBkpId INT,  primary key (instanceId, dbId))
	INSERT INTO #ValidBackups
		SELECT SDB.instanceId, SDB.sqlNameId, MAX(id) FROM sqlDbBackupInfo SDB
					GROUP BY SDB.instanceId, SDB.sqlNameId
		UNION
		SELECT SDB.instanceId, SDB.dbId, MAX(id) FROM sqlAnalysisDbBackupInfo SDB
					GROUP BY SDB.instanceId, SDB.dbId
	-- Get contents that are active for backups.
	IF OBJECT_ID('tempdb.dbo.#SqlActiveDbContents') IS NOT NULL DROP TABLE #SqlActiveDbContents
	CREATE TABLE #SqlActiveDbContents (databaseName NVARCHAR(1024), modified INT, instanceId INT, appId INT)
	INSERT INTO #SqlActiveDbContents
		SELECT ASP.attrName, ASP.modified, AP.instance, AP.id FROM APP_SubClientProp ASP
			-- Only active sub-client is considered.
			JOIN APP_Application AP ON ASP.componentNameId = AP.id AND AP.appTypeId = 81 AND (AP.subclientStatus & (2|4)) = 0
				AND ASP.attrType = 118 AND ASP.modified = 0
			JOIN #tt_getAllIdaObjects IA ON IA.clientId = AP.clientId
	-- Do not consider SQL archive and FFG subclients.
	-- Added the separate delete. Reason: There can be cases with no type set (for upgraded setups) and defaulted to consider as DATABASE type.
	DELETE SAC FROM #SqlActiveDbContents SAC
		JOIN App_SubclientProp ASP ON SAC.appId = ASP.componentNameId AND ASP.attrName = N'mssql subclient type'
			AND ASP.modified = 0 and ASP.cs_attrName = CHECKSUM(N'mssql subclient type') AND ASP.attrVal IN (2, 3)
	-- Temp table for database job status.
	IF OBJECT_ID('tempdb.dbo.#JobDatabaseInfo') IS NOT NULL DROP TABLE #JobDatabaseInfo
	CREATE TABLE #JobDatabaseInfo (instanceId int, sqlNameId INT, dbName NVARCHAR(128), status INT, bkpTime int, SLA int, PRIMARY KEY(instanceId, sqlNameId, dbName))
	INSERT INTO #JobDatabaseInfo
		SELECT SDI.instanceId, SDI.databaseId, SDI.DatabaseName,
			CASE
				WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus = 1 THEN 1	 /* PROTECTED */
					WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus IN (3, 6) THEN 1	 /* LAST JOB SKIPPED BUT HAVE VALID BACKUP */
					WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus IN (2, 7) THEN 2	 /* ATTEMPTED, FAILED BUT HAVE VALID BKP */
					WHEN SDI.LastBackupSetId  = 0 THEN 3  /* UNPROTECTED TILL DATE */
			END AS database_state, SDI.LastOkBackupTime,
			CASE WHEN csd.modified = 0 THEN
				CASE WHEN DATEDIFF(DAY, dbo.getdatetime(SDI.LastOkBackupTime), GETUTCDATE()) <= SLA.slaDays
					THEN 1 ELSE 0 END
				-- Mark it met.
				ELSE 1 END
		FROM SqlDatabaseInfo SDI
			JOIN APP_InstanceProp PX ON PX.componentNameId = SDI.instanceId AND PX.modified = 0
				AND PX.attrName = N'MSSQL Server Type'
				AND PX.attrVal NOT IN (N'Aws DataBase Engine', N'Azure DataBase Engine', N'Azure Managed DataBase Engine')
			-- Cross verify the details here.
			JOIN #ValidBackups TH ON TH.instanceId = SDI.instanceId
				AND TH.dbId = SDI.databaseId AND SDI.LastBackupSetId = TH.lastBkpId
			JOIN #SLA_Subclient SLA ON SLA.appId = SDI.appId
			LEFT JOIN #SqlActiveDbContents csd ON SDI.instanceId = csd.instanceId AND SDI.DatabaseName = csd.databaseName
	-- Table: Latest databases details
	IF OBJECT_ID('tempdb..#SqlDatabaseLatest') IS NOT NULL DROP TABLE #SqlDatabaseLatest
	CREATE TABLE #SqlDatabaseLatest (instance int, sqlDbId int, PRIMARY KEY(instance, sqlDbId))
	INSERT INTO #SqlDatabaseLatest
		SELECT DISTINCT SB.instanceId, SB.sqlNameId FROM sqlDbBackupInfo SB
		EXCEPT
		SELECT SD.instanceId, SD.sqlNameId FROM #JobDatabaseInfo SD
	;WITH SqlDatabaseLatestDetails (sqlNameId, backup_finish_date, id, instanceid, appId, dbName, rn)  AS
		(select SDB.sqlNameId, SDB.backup_finish_date, SDB.id, SDB.instanceId, SDB.appId, SN2.name,
			ROW_NUMBER() OVER (PARTITION BY  SDB.sqlNameId, SDB.instanceId ORDER BY SDB.backup_finish_date DESC) rn
			 FROM  sqlDbBackupInfo SDB
				JOIN #SqlDatabaseLatest SD ON SD.instance = SDB.instanceId AND SD.sqlDbId = SDB.sqlNameId
				JOIN sqlNames SN ON SN.id = SDB.sqlNameId AND SN.type = 1
				JOIN sqlNames2 SN2 ON SN2.id = SN.sqlId AND SN2.type = 1)
		INSERT INTO #JobDatabaseInfo
			SELECT
				SDI.instanceId,
				SDI.sqlNameId,
				SDI.dbName,
				1,
				SDI.backup_finish_date,
				CASE
					WHEN csd.modified = 0 THEN
						CASE
							WHEN DATEDIFF(DAY, dbo.getdatetime(SDI.backup_finish_date), GETUTCDATE()) <= SLA.slaDays
					THEN 1 ELSE 0 END
				-- Mark it met.
				ELSE 1 END
			FROM SqlDatabaseLatestDetails SDI
				JOIN #SLA_Subclient SLA ON SLA.appId = SDI.appId
				LEFT JOIN #SqlActiveDbContents csd ON SDI.instanceId = csd.instanceId AND SDI.dbName = csd.databaseName
			WHERE SDI.rn = 1
	-- Database details are added here.
	IF @CalcSLAOnly = 0
	BEGIN
		-- Update the readiness for instances based on the status flag.
		DECLARE @EnableInstanceStatusCheck INT = 1
		SELECT @EnableInstanceStatusCheck = CAST(value AS INT) FROM GXGlobalParam WHERE name = 'EnableInstanceStatusCheck' AND modified = 0
		IF @EnableInstanceStatusCheck = 1
		BEGIN
			UPDATE	I SET
				I.[Status] = 0
			FROM #SqlInstanceDetails I
				LEFT JOIN APP_InstanceProp AIP
					ON I.instance = AIP.componentNameId
						AND AIP.modified = 0
						AND AIP.attrName = N'Instance Status'
						AND AIP.attrVal <> N'0'
			WHERE I.status = 1
				AND AIP.attrVal IS NOT NULL
		END
		-- SQL Auth Details.
		IF OBJECT_ID('tempdb..#temp_instances') IS NOT NULL DROP TABLE #temp_instances
		CREATE TABLE #temp_instances (instance int)
		INSERT INTO #temp_instances select distinct instance from #SqlInstanceDetails
		EXEC AppGetSqlAuth 0, 0, 0, 0
		-- IF version >= 11, AuthType = 1 (LS Account), no backup ran, status is 'not ready'
		UPDATE SI SET
			SI.status = 0
		FROM #SqlInstanceDetails SI
				LEFT JOIN #SQLAuthDetails SD ON SD.instanceId = SI.instance
		WHERE ((SI.status & 2) = 2) OR
			(((LEN(ISNULL(SI.version, N'')) = 0 ) OR (LEN(ISNULL(SI.version, N'')) > 0 AND CAST(SUBSTRING(SI.version, 1, CHARINDEX('.', SI.version) -1) AS INT) > 10
			AND ISNULL(SD.authType, 0) = 1))
			AND SI.instance NOT IN (SELECT DISTINCT instanceId FROM sqlDbBackupInfo))
		-- Instance not ready when no valid plan or SP assigned.
		UPDATE	I SET
			I.[Status] = 0
		FROM #SqlInstanceDetails I
			INNER JOIN APP_Application A
				ON I.instance = A.instance
					AND A.subclientStatus & 8 <> 0
			LEFT OUTER JOIN APP_InstanceProp IP
				ON IP.componentNameId = I.instance
					AND IP.attrName = 'Associated Plan'
					AND IP.modified=0
			LEFT OUTER JOIN App_Plan AP WITH (NOLOCK)
				ON CAST(AP.id AS NVARCHAR(32)) = IP.attrVal
			WHERE A.dataArchGrpId <= 1
				AND	(AP.id IS NULL
OR ((AP.flag & 0x00004) <> 0)
OR ((AP.flag & 0x40000000) <> 0))
				AND I.status = 1
		-- Instance not ready when client is deconfigured.
		UPDATE I SET
			I.[Status] = 0
		FROM	#SqlInstanceDetails I
			INNER JOIN APP_Client C
ON I.ClientId= C.id AND C.status & 0x00002 = 0x00002
			WHERE I.status = 1
		-- Instance not ready when instance is deconfigured.
		UPDATE I SET
			I.[Status] = 0
		FROM	#SqlInstanceDetails I
			INNER JOIN APP_InstanceName II
ON II.id = I.instance AND II.status & 0x00002 = 0x00002
			WHERE I.status = 1
		-- Instance not ready when last backup failed.
		IF OBJECT_ID('tempdb.dbo.#lastBackupJob') IS NOT NULL DROP TABLE dbo.#lastBackupJob
		CREATE TABLE #lastBackupJob (instanceId INT, backupJobId INT, commCellId INT, status INT)
		IF OBJECT_ID('tempdb.dbo.#SubclientLastBkpDetails') IS NOT NULL DROP TABLE dbo.#SubclientLastBkpDetails
		CREATE TABLE #SubclientLastBkpDetails (instanceId INT, appId INT, lastBkpDetails XML, PRIMARY KEY(instanceId, appId))
		INSERT INTO #SubclientLastBkpDetails
			SELECT
				AP.instance,
				Ap.id,
				CAST(ASP.attrVal AS XML) as lastBkpInfo
			FROM APP_SubClientProp ASP
				JOIN APP_Application AP
					ON AP.id = ASP.componentNameId
						AND AP.subclientStatus & (2|4) = 0
				JOIN #SqlInstanceDetails I
					ON I.instance = AP.instance
						AND I.ClientId = AP.clientId
			WHERE ASP.attrName = N'Last Backup Job Info'
				AND ASP.modified = 0
				AND ASP.cs_attrName = CHECKSUM(N'Last Backup Job Info')
		INSERT INTO #lastBackupJob
		SELECT
			Y.instanceId,
			Y.jobId,
			Y.commCellID,
			Y.status
		FROM
		-- Multiple subclients with last backup information will be found for SQL agents.
		-- So added the row number here to select the top MAX one.
			(SELECT
				ROW_NUMBER() OVER (PARTITION BY X.instanceId ORDER BY ISNULL(X.lastBkpDetails.value('(/lastBackupJobInfo/@jobID)[1]', 'INT'), 0) DESC) rn,
				X.instanceId,
				ISNULL(X.lastBkpDetails.value('(/lastBackupJobInfo/@jobID)[1]', 'INT'), 0) AS jobId,
				ISNULL(X.lastBkpDetails.value('(/lastBackupJobInfo/@commCellID)[1]', 'INT'), 0) AS commCellID,
				ISNULL(X.lastBkpDetails.value('(/lastBackupJobInfo/@status)[1]', 'INT'), 0) AS status
			FROM #SubclientLastBkpDetails X) Y
		WHERE Y.rn = 1
		UPDATE I SET
				I.Status = 0
			FROM	#SqlInstanceDetails I
			INNER JOIN APP_IdaType IDA
				ON 81 = IDA.type
			INNER JOIN #lastBackupJob J
				ON I.instance = J.instanceId
			WHERE J.status NOT IN (1, 3, 14)
				AND I.status = 1
		IF OBJECT_ID('tempdb.dbo.#lastBackupJob') IS NOT NULL DROP TABLE dbo.#lastBackupJob
	END
	-- Update database counts.
	INSERT INTO #tt_SqlInstanceDbDetails
		SELECT DISTINCT
			SD.instance,
			ISNULL(TX.SLA, 0),
			ISNULL(X.unprotected, 0),
			ISNULL(X.Protected, 0),
			ISNULL(X.Attempted, 0),
			ISNULL(X.unprotected, 0) + ISNULL(X.Protected, 0) + ISNULL(X.Attempted, 0),
			ISNULL(SC.SysCount, 0)
		FROM #SqlInstanceDetails SD
			-- Only SLA 0, 1 are considered for SLA calc.
			LEFT JOIN
				(SELECT T.instanceId, AVG(T.SLA) SLA
					FROM #JobDatabaseInfo T GROUP BY T.instanceId) TX
				ON TX.instanceId = SD.instance
			-- Do not consider system-DBs for DB counts.
			LEFT JOIN
				(SELECT instanceId, ISNULL(piv.[1], 0) as Protected, ISNULL(piv.[2], 0) as Unprotected,
							ISNULL(piv.[3], 0) as Attempted
					FROM (SELECT T.instanceId, status, count(1) dbCount
							FROM #JobDatabaseInfo T
							GROUP BY T.instanceId, T.status) T
						PIVOT(MAX(dbCount) FOR
								status IN ([1], [2], [3])) piv) X
				ON SD.instance = X.instanceId
			LEFT JOIN
				(SELECT T.instanceId, COUNT(T.sqlNameId) SysCount
					FROM #JobDatabaseInfo T
						JOIN @tblException TE ON T.dbName = TE.name
					GROUP BY T.instanceId) SC
				ON SC.instanceId = SD.instance
	-- Final table containing all inforamtion.
	IF OBJECT_ID('tempdb.dbo.#SqlInstances') IS NOT NULL DROP TABLE #SqlInstances
		CREATE TABLE #SqlInstances (rn int identity, instance int, instanceName nvarchar(1024), clientId int, clientname nvarchar(1024), version nvarchar(256),
						status int, planId int, planName nvarchar(1024), numberDatabases int, SLA int, lastBackupTime int, protected int, unprotected int,
						attempted int, serverType nvarchar(256), noSysDBs INT
						primary key(rn, clientId, instance))
	-- Sort and order the data.
	IF @order = 1
	BEGIN
		INSERT INTO #SqlInstances
			SELECT
				SVI.instance,
				SVI.instanceName,
				SVI.clientId,
				SVI.clientname,
				SVI.version,
				SVI.status,
				ISNULL(SPI.planId, 0),
				ISNULL(SPI.planName, N''),
				DI.total,
				DI.SLA,
				0,
				DI.protected,
				DI.unprotected,
				DI.attempted,
				SVI.serverType,
				DI.sysDBs
			FROM #SqlInstanceDetails SVI
				LEFT JOIN #SqlInstancePlanDetails SPI ON SVI.instance = SPI.instance
				LEFT JOIN #tt_SqlInstanceDbDetails DI ON DI.instanceId = SVI.instance
			ORDER BY (CASE @sort WHEN 1 THEN SVI.instanceName WHEN 2 THEN SVI.version
								WHEN 3 THEN SVI.clientname WHEN 5 THEN SPI.planName
								ELSE NULL END) DESC,
					(CASE @sort WHEN 4 THEN DI.total ELSE NULL END) DESC,
					(CASE WHEN @sort > 5 AND @sort < 1 THEN DI.total ELSE NULL END) DESC
	END
	ELSE
	BEGIN
		INSERT INTO #SqlInstances
			SELECT SVI.instance, SVI.instanceName, SVI.clientId, SVI.clientname, SVI.version, SVI.status,
				ISNULL(SPI.planId, 0), ISNULL(SPI.planName, N''), DI.total, DI.SLA, 0, DI.protected, DI.unprotected,
				DI.attempted, SVI.serverType, DI.sysDBs
			FROM #SqlInstanceDetails SVI
				LEFT JOIN #SqlInstancePlanDetails SPI ON SVI.instance = SPI.instance
				LEFT JOIN #tt_SqlInstanceDbDetails DI ON DI.instanceId = SVI.instance
			ORDER BY (CASE @sort WHEN 1 THEN SVI.instanceName WHEN 2 THEN SVI.version
								WHEN 3 THEN SVI.clientname WHEN 5 THEN SPI.planName
								ELSE NULL END) ASC,
					(CASE @sort WHEN 4 THEN DI.total ELSE NULL END) ASC,
					(CASE WHEN @sort > 5 AND @sort < 1 THEN DI.total ELSE NULL END) ASC
	END
	-- Paging.
	IF @CalcSLAOnly = 0
	BEGIN
		DECLARE @total INT = 0
		SELECT @total = count(*) FROM #SqlInstances
		-- Paging is applicable only for instance details.
		SELECT @endData = 0 FROM #SqlInstances WHERE rn > @endOffset AND @noPaging = 0
		DELETE FROM #SqlInstances WHERE rn > @endOffset AND @noPaging = 0
		DELETE FROM #SqlInstances WHERE rn <= @startOffset AND @noPaging = 0
		IF @propertyLevel > 10
		BEGIN
			SET @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage', @endData as '@end', @total as '@total' FOR XML PATH('response'), type),
					(SELECT sd.instance as "@insId", sd.clientId as "@cId", sd.clientName as "@cName",
					sd.instanceName as "@insName", sd.version as "@version", sd.status as "@status", sd.numberDatabases as "@noDBs" , sd.SLA as "@sla",
					sd.planId as "@planId", sd.planName as "@planName", sd.protected as "@protect", sd.unprotected as "@unprot",
					sd.attempted as "@attempt", sd.serverType as "@serverType", sd.noSysDBs AS "@noSysDBs",
					(SELECT CASE WHEN SA.authType = 1 THEN 1 ELSE 0 END as "@UseLSA", CASE WHEN SA.level = 4 THEN 0 ELSE 1 END as "@Override",
						(SELECT SA.userName as "@userName", SA.userPassword as "@password" FOR XML PATH('credential'), TYPE)
						FROM #SQLAuthDetails SA WHERE SA.instanceId = sd.instance
							FOR XML PATH('auth'), TYPE)
				FROM #SqlInstances as sd for XML PATH('SqlInstance'), type)
					FOR XML PATH(''), root('App_GetSQLInstancesResponse')), N'<App_GetSQLInstancesResponse />')
		END
		ELSE
		BEGIN
		SET @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage', @endData as '@end', @total as '@total' FOR XML PATH('response'), type),
			(SELECT sd.instance as "@insId", sd.clientId as "@cId", sd.clientName as "@cName",
				sd.instanceName as "@insName", sd.version as "@version", sd.status as "@status", sd.numberDatabases as "@noDBs" , sd.SLA as "@sla",
				sd.planId as "@planId", sd.planName as "@planName", sd.protected as "@protect", sd.unprotected as "@unprot",
				sd.attempted as "@attempt", sd.serverType as "@serverType", sd.noSysDBs AS "@noSysDBs"
				FROM #SqlInstances as sd for XML PATH('SqlInstance'), type)
			FOR XML PATH(''), root('App_GetSQLInstancesResponse')), N'<App_GetSQLInstancesResponse />')
		END
	END
	ELSE
	BEGIN
		DECLARE @metSLA INT = 0
		DECLARE @missedSLA INT = 0
		SELECT @metSLA = count(*) FROM #SqlInstances SD WHERE SD.SLA = 1
		SELECT @missedSLA = count(*) FROM #SqlInstances SD WHERE SD.SLA = 0
		SET @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage', @endData as '@end' FOR XML PATH('response'), type),
			(SELECT @metSLA as "@metSLACount", @missedSLA as "@missedSLACount" FOR XML PATH('SlaDetails'), type)
			FOR XML PATH(''), root('App_GetSQLInstancesResponse')), N'<App_GetSQLInstancesResponse />')
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @XmlInputOutput = (SELECT ERROR_NUMBER() AS '@errorCode', 'Failed to get instance details. ' + ERROR_MESSAGE() AS '@errorMessage', @endData as '@end'
			FOR XML PATH ('response'), root(N'App_GetSQLInstancesResponse'))
END CATCH
SELECT @XmlInputOutput
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSQLInstancesInACommcell')
	delete from GxQscripts where name = 'AppGetSQLInstancesInACommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLInstancesInACommcell')
	delete from GXDBVersions where aliasname = 'AppGetSQLInstancesInACommcell'
GO

insert into GXDBVersions values(2, 'AppGetSQLInstancesInACommcell',  '00000000000000000000', 'AppGetSQLInstancesInACommcell', '00000000000000000000')
GO

