

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSQLDatabasesInACommcell.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSQLDatabasesInACommcell')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSQLDatabasesInACommcell <<<'
	drop procedure AppGetSQLDatabasesInACommcell
END
IF EXISTS (select * from GxQscripts where name='AppGetSQLDatabasesInACommcell')
	delete from GxQscripts where name = 'AppGetSQLDatabasesInACommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLDatabasesInACommcell')
	delete from GXDBVersions where aliasname = 'AppGetSQLDatabasesInACommcell'
GO
print '... Creating Procedure: AppGetSQLDatabasesInACommcell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSQLDatabasesInACommcell
  @XmlInputOutput XML OUTPUT
AS
  DECLARE @o_xml XML
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/* This indicates that no more data is available. */
DECLARE @endData INT = 1
BEGIN TRY
	-- Required Values
	DECLARE @userId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@userId)[1]','INT')), 0)
	DECLARE @InstanceId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@instanceId)[1]','INT')), 0)
	DECLARE @SqlDbId INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@databaseId)[1]','INT')), 0)
	-- Flag to indicate only SLA calculation.
	DECLARE @CalcSla INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@slaOnly)[1]','INT')), 0)
	-- Flag to include replication details with the response
	DECLARE @showReplicationInfo INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@showReplicationInfo)[1]','INT')), 0)
	-- Sort values
	DECLARE @sort INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@sortIndex)[1]','INT')), 0)
	DECLARE @order INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@sortOrder)[1]','INT')), 0)
	-- Property filter
	DECLARE @propertyLevel INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@propertyLevel)[1]','INT')), 10)
	-- paging filter
	DECLARE @noPaging INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/paging/@noPaging)[1]','INT')), 1)
	/* Default will be 0th page (which is first 50 instances). */
	DECLARE @startIndex INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/paging/@startIndex)[1]','INT')), 0)
	-- First 50 instances will be considered.
	DECLARE @maxSize INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/paging/@maxSize)[1]','INT')), 50)
	DECLARE @startOffset INT = @startIndex * @maxSize
	DECLARE @endOffset INT = @startOffset + @maxSize
	-- Fetch only specified type.
	-- 0: ALL, 1:PROTECTED, 2:UNPROTECTED, 3:ATTEMPTED
	DECLARE @fetch INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@status)[1]','INT')), 0)
	-- Browse time sent.
	DECLARE @toTime INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@toTime)[1]','INT')), 0)
	-- Include System DBs in response.
	DECLARE @showSystemDBs INT = ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/@showSystemDB)[1]','INT')), 0)
	-- Search option
	DECLARE @search_term NVARCHAR(1024) = N'%' + ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/search/@searchKey)[1]','NVARCHAR(256)')), N'') + N'%'
	-- Filter option for database name.
	DECLARE @db_name_key NVARCHAR(1024) = N'%' + ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/search/@databaseNamekey)[1]','NVARCHAR(256)')), N'') + N'%'
	-- Filter option for database name.
	DECLARE @instance_name_key NVARCHAR(1024) = N'%' + ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/search/@instanceNameKey)[1]','NVARCHAR(256)')), N'') + N'%'
	-- Filter option for database name.
	DECLARE @client_name_key NVARCHAR(1024) = N'%' + ISNULL((SELECT @XmlInputOutput.value('(/App_GetSQLDatabasesRequest/search/@clientNameKey)[1]','NVARCHAR(256)')), N'') + N'%'
	-- Debug
	DECLARE @debug INT = 0
	-- User Permission Check Code Starts
	IF OBJECT_ID('tempdb..#tt_getAllIdaObjects') IS NOT NULL
		DROP TABLE #tt_getAllIdaObjects
	CREATE TABLE #tt_getAllIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	IF @toTime <> 0
		-- Browse permission check.
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/, 13 /* BROWSE */, 1 /* Inherit from child */, N'#tt_getAllIdaObjects'
	ELSE
		-- Check for any capability here.
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/, 0 /* Any Permission */, 1 /* Inherit from child */, N'#tt_getAllIdaObjects'
	-- Table: Database status (protected or unprotected or failed in last attempt).
	IF OBJECT_ID('tempdb.dbo.#JobDatabaseState') IS NOT NULL DROP TABLE #JobDatabaseState
	CREATE TABLE #JobDatabaseState (instanceId int, dbName NVARCHAR(1024), status INT, primary key (instanceId, dbName))
	-- Following databases should be removed from count.
	DECLARE @tblException TABLE (name NVARCHAR(255))
	INSERT INTO @tblException VALUES(N'master')
	INSERT INTO @tblException VALUES(N'msdb')
	INSERT INTO @tblException VALUES(N'model')
	-- Last valid backups
	IF OBJECT_ID('tempdb.dbo.#ValidBackups') IS NOT NULL DROP TABLE #ValidBackups
	CREATE TABLE #ValidBackups (instanceId int, dbId INT, lastBkpId INT,  primary key (instanceId, dbId))
	INSERT INTO #ValidBackups
		SELECT SDB.instanceId, SDB.sqlNameId, MAX(id) FROM sqlDbBackupInfo SDB
					GROUP BY SDB.sqlNameId, SDB.instanceId
	-- SQL Analysis Service
	INSERT INTO #ValidBackups
		SELECT SABI.instanceId, SABI.dbId, MAX(id) FROM sqlAnalysisDbBackupInfo SABI
					GROUP BY SABI.dbId, SABI.instanceId
	-- Table: Basic database information.
	IF OBJECT_ID('tempdb..#SqlDbBasicInfo') IS NOT NULL DROP TABLE #SqlDbBasicInfo
	CREATE TABLE #SqlDbBasicInfo (instance int, sqlDbId int,
		DbName NVARCHAR(128), instanceName nvarchar(1024), clientname nvarchar(1024),  clientId int, RecoveryModel nvarchar(256), databaseLastBackupTime int,
		lastBkpSetId INT, lastBkpJob int, version nvarchar(256), subclientId int, lastBkpType int, databaseCreationDate int, lastBkpSize bigint,
		fullBkpMethod INT, SLA INT, status INT, PRIMARY KEY(instance, sqlDbId, clientId))
	INSERT INTO #SqlDbBasicInfo
		SELECT
			SDI.instanceId,
			SDI.databaseId,
			SDI.DatabaseName,
			AI.name,
			AC.displayName,
			AC.id,
			CASE SDI.RecoveryModel
				WHEN 1 THEN N'FULL'
				WHEN 2 THEN N'BULK LOGGED'
				WHEN 3 THEN N'SIMPLE' END,
			SDI.LastOkBackupTime,
			SDI.LastBackupSetId,
			ISNULL(SBI.jobId, 0),
			CONCAT(CONVERT(VARCHAR(5), ISNULL(SBI.majorVersion, 0)), '.', CONVERT(VARCHAR(5), ISNULL(SBI.minorVersion, 0)), '.',
					CONVERT(VARCHAR(5), ISNULL(SBI.buildVersion, 0))),
			ISNULL(SBI.appId, 0),
			CASE ISNULL(SBI.type, N'')
					WHEN 'D' THEN 1
					WHEN 'I' THEN 2
					WHEN 'L' THEN 3
					WHEN 'P' THEN 1
					WHEN 'Q' THEN 2
					ELSE 0
			END,
			ISNULL(SBI.database_creation_date, 0), 0, 0, 0,
			CASE
					WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus = 1 THEN 1	 /* PROTECTED */
					WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus IN (3, 6) THEN 1	 /* LAST JOB SKIPPED BUT HAVE VALID BACKUP */
					WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus IN (2, 7) THEN 2	 /* ATTEMPTED, FAILED BUT HAVE VALID BKP */
					WHEN SDI.LastBackupSetId  = 0 THEN 3  /* UNPROTECTED TILL DATE */
			END AS database_state
		FROM SqlDatabaseInfo SDI
			JOIN APP_Application SC ON SC.id = SDI.appId AND SC.appTypeId = 81
			JOIN APP_InstanceName AI ON AI.id = SDI.instanceId
			JOIN App_Client AC ON AC.id = SC.clientId
			LEFT JOIN APP_InstanceProp PX ON PX.componentNameId = AI.id AND PX.modified = 0
				AND PX.attrName = N'MSSQL Server Type'
				AND PX.attrVal NOT IN (N'Aws DataBase Engine', N'Azure DataBase Engine', N'Azure Managed DataBase Engine', N'Analysis Services')
			-- Cross verify the details here.
			JOIN #ValidBackups TH ON TH.instanceId = SDI.instanceId
				AND TH.dbId = SDI.databaseId AND SDI.LastBackupSetId = TH.lastBkpId
			LEFT JOIN sqlDbBackupInfo SBI ON SDI.LastBackupSetId = SBI.id
		WHERE (@InstanceId = 0 OR SDI.instanceId = @InstanceId)
				AND (@SqlDbId = 0 OR SDI.databaseId = @SqlDbId)
				AND SC.clientId IN (SELECT DISTINCT clientId FROM #tt_getAllIdaObjects)
				AND ((@toTime = 0 OR @toTime >= SBI.backup_finish_Date))
				-- Apply search term.
				AND (SDI.DatabaseName LIKE @search_term OR AI.name LIKE @search_term OR AC.name like @search_term)
				-- Apply filters.
				AND (SDI.DatabaseName LIKE @db_name_key)
				AND (AC.name LIKE @client_name_key)
				AND (AI.name LIKE @instance_name_key)
				AND PX.attrVal <> N'Analysis Services'
	UNION
	-- SQL Analysis Service
	SELECT SDI.instanceId, SDI.databaseId, SDI.DatabaseName, AI.name, AC.displayName, AC.id,
		CASE SDI.RecoveryModel WHEN 1 THEN N'FULL' END,
		SDI.LastOkBackupTime, SDI.LastBackupSetId, ISNULL(SABI.jobId, 0),
		CONCAT(CONVERT(VARCHAR(5), ISNULL(SABI.instanceVersion, 0)), '.', 0, '.', 0),
		ISNULL(SABI.appId, 0),
		CASE ISNULL(SABI.type, N'')
				WHEN 'D' THEN 1
				ELSE 0
		END,
		ISNULL(SABI.database_creation_date, 0), 0, 0, 0,
		CASE
				WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus = 1 THEN 1	 /* PROTECTED */
				WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus IN (3, 6) THEN 1	 /* LAST JOB SKIPPED BUT HAVE VALID BACKUP */
				WHEN SDI.LastBackupSetId  <> 0 AND LastBkpStatus IN (2, 7) THEN 2	 /* ATTEMPTED, FAILED BUT HAVE VALID BKP */
				WHEN SDI.LastBackupSetId  = 0 THEN 3  /* UNPROTECTED TILL DATE */
		END AS database_state
	FROM SqlDatabaseInfo SDI
		JOIN APP_Application SC ON SC.id = SDI.appId AND SC.appTypeId = 81
		JOIN APP_InstanceName AI ON AI.id = SDI.instanceId
		JOIN App_Client AC ON AC.id = SC.clientId
		JOIN APP_InstanceProp PX ON PX.componentNameId = AI.id AND PX.modified = 0
			AND PX.attrName = N'MSSQL Server Type'
			AND PX.attrVal = N'Analysis Services'
		-- Cross verify the details here.
		JOIN #ValidBackups TH ON TH.instanceId = SDI.instanceId
			AND TH.dbId = SDI.databaseId AND SDI.LastBackupSetId = TH.lastBkpId
		LEFT JOIN sqlAnalysisDbBackupInfo SABI ON SDI.LastBackupSetId = SABI.id
	WHERE (@InstanceId = 0 OR SDI.instanceId = @InstanceId)
			AND (@SqlDbId = 0 OR SDI.databaseId = @SqlDbId)
			AND SC.clientId IN (SELECT DISTINCT clientId FROM #tt_getAllIdaObjects)
			AND ((@toTime = 0 OR @toTime >= SABI.backup_finish_Date))
			-- Apply search term.
			AND (SDI.DatabaseName LIKE @search_term OR AI.name LIKE @search_term OR AC.name like @search_term)
			-- Apply filters.
			AND (SDI.DatabaseName LIKE @db_name_key)
			AND (AC.name LIKE @client_name_key)
			AND (AI.name LIKE @instance_name_key)
	-- Table: Latest databases.
	IF OBJECT_ID('tempdb..#SqlLeftOverDatabases') IS NOT NULL DROP TABLE #SqlLeftOverDatabases
	CREATE TABLE #SqlLeftOverDatabases (instance int, sqlDbId int, PRIMARY KEY(instance, sqlDbId))
	INSERT INTO #SqlLeftOverDatabases
		SELECT DISTINCT SB.instanceId, SB.sqlNameId FROM sqlDbBackupInfo SB
		EXCEPT
		SELECT SD.instance, SD.sqlDbId FROM #SqlDbBasicInfo SD
	-- SQL Analysis Service
	INSERT INTO #SqlLeftOverDatabases
		SELECT DISTINCT SABI.instanceId, SABI.dbId FROM sqlAnalysisDbBackupInfo SABI
		EXCEPT
		SELECT SD.instance, SD.sqlDbId FROM #SqlDbBasicInfo SD
	IF OBJECT_ID('tempdb..#SqlDatabaseLatestDetails') IS NOT NULL DROP TABLE #SqlDatabaseLatestDetails
	CREATE TABLE #SqlDatabaseLatestDetails (sqlNameId INT, backup_finish_date INT, backup_size BIGINT, id INT, database_creation_date INT,
		instanceid INT, bkpMethod INT, appId INT, type CHAR, majorVersion INT, minorVersion INT, buildVersion INT, jobId INT PRIMARY KEY(sqlNameId, instanceid))
	IF @toTime = 0
	BEGIN
		INSERT INTO #SqlDatabaseLatestDetails
			SELECT
				SDB.sqlNameId,
				SDB.backup_finish_date,
				SDB.backup_size,
				SDB.id,
				SDB.database_creation_date,
				SDB.instanceId,
				SDB.backupmethod,
				SDB.appId,
				SDB.type,
				SDB.majorVersion,
				SDB.minorVersion,
				SDB.buildVersion,
				SDB.jobId
			 FROM
				sqlDbBackupInfo SDB
				JOIN (SELECT MAX(SDB.id) as bkpId, SDB.instanceId, SDB.sqlNameId
						 FROM
							sqlDbBackupInfo SDB
							JOIN #SqlLeftOverDatabases SD
								ON SD.instance = SDB.instanceId
									AND SD.sqlDbId = SDB.sqlNameId
						GROUP BY SDB.instanceId, SDB.sqlNameId) T
					ON T.bkpId = SDB.id
			-- Analysis Service
			UNION
			SELECT
				SABI.dbId,
				SABI.backup_finish_date,
				SABI.backup_size,
				SABI.id,
				SABI.database_creation_date,
				SABI.instanceId, -1 /*SDB.backupmethod*/,
				SABI.appId, SABI.type,
				SABI.instanceVersion,
				0 /*SDB.minorVersion*/,
				0 /*SDB.buildVersion*/,
				SABI.jobId
			FROM  sqlAnalysisDbBackupInfo SABI
				JOIN (SELECT MAX(SDB.id) as bkpId, SDB.instanceId, SDB.dbId
						 FROM
							sqlAnalysisDbBackupInfo SDB
							JOIN #SqlLeftOverDatabases SD
								ON SD.instance = SDB.instanceId
									AND SD.sqlDbId = SDB.dbId
						GROUP BY SDB.instanceId, SDB.dbId) T
					ON T.bkpId = SABI.id
	END
	ELSE
	BEGIN
		-- Latest backup details are fetched here.
		INSERT INTO #SqlDatabaseLatestDetails
			SELECT
				SDB.sqlNameId,
				SDB.backup_finish_date,
				SDB.backup_size, SDB.id,
				SDB.database_creation_date,
				SDB.instanceId,
				SDB.backupmethod,
				SDB.appId,
				SDB.type,
				SDB.majorVersion,
				SDB.minorVersion,
				SDB.buildVersion,
				SDB.jobId
			FROM
			sqlDbBackupInfo SDB
				JOIN (SELECT
						T.instanceId, T.sqlNameId, MAX(T.bkpID) bkpId
						FROM
						(SELECT
							SD.instanceId, SD.sqlNameId, MAX(SD.id) bkpID
							FROM sqlDbBackupInfo SD JOIN #SqlLeftOverDatabases SL ON SD.instanceId = SL.instance
									AND SD.sqlNameId = SL.sqlDbId AND @toTime >= SD.backup_finish_Date
							GROUP BY SD.instanceId, SD.sqlNameId
							UNION ALL
							SELECT
								SDB.instanceId, SDB.sqlNameId, MAX(SDB.id) bkpID
							FROM  sqlDbBackupInfo SDB JOIN #SqlLeftOverDatabases SD ON SD.instance = SDB.instanceId
									AND SD.sqlDbId = SDB.sqlNameId AND SDB.type = 'L' AND SDB.begins_log_chain = 'Y'
											AND @toTime > SDB.backup_start_Date AND @toTime <= SDB.backup_finish_Date
							GROUP BY SDB.instanceId, SDB.sqlNameId) T
						GROUP BY T.instanceId, T.sqlNameId
					)TX
				ON SDB.id = TX.bkpId
			-- Analysis Service
			UNION
			SELECT
				SABI.dbId,
				SABI.backup_finish_date,
				SABI.backup_size,
				SABI.id,
				SABI.database_creation_date,
				SABI.instanceId,
				-1 /*SDB.backupmethod*/,
				SABI.appId,
				SABI.type,
				SABI.instanceVersion,
				0 /*SDB.minorVersion*/,
				0 /*SDB.buildVersion*/,
				SABI.jobId
			FROM  sqlAnalysisDbBackupInfo SABI
				JOIN (SELECT MAX(SDB.id) as bkpId, SDB.instanceId, SDB.dbId
						 FROM
							sqlAnalysisDbBackupInfo SDB
							JOIN #SqlLeftOverDatabases SD
								ON SD.instance = SDB.instanceId
									AND SD.sqlDbId = SDB.dbId
						WHERE @toTime >= SDB.backup_finish_Date
						GROUP BY SDB.instanceId, SDB.dbId) T
					ON T.bkpId = SABI.id
	END
	INSERT INTO #SqlDbBasicInfo
		SELECT SDI.instanceid, SDI.sqlNameId, SN2.name, AI.name, AC.displayName, AC.id,
			CASE ISNULL(SDI.type, N'') WHEN 'L' THEN N'FULL' ELSE N'SIMPLE' END,
			SDI.backup_finish_date, SDI.id, SDI.jobId,
			CONCAT(CONVERT(VARCHAR(5), ISNULL(SDI.majorVersion, 0)), '.', CONVERT(VARCHAR(5), ISNULL(SDI.minorVersion, 0)), '.',
			CONVERT(VARCHAR(5), ISNULL(SDI.buildVersion, 0))), SDI.appId,
			CASE ISNULL(SDI.type, N'')
					WHEN 'D' THEN 1
					WHEN 'I' THEN 2
					WHEN 'L' THEN 3
					WHEN 'P' THEN 1
					WHEN 'Q' THEN 2
					ELSE 0
			END,
			ISNULL(SDI.database_creation_date, 0), 0, 0, 0, 1
		FROM #SqlDatabaseLatestDetails SDI
			JOIN sqlNames SN ON SN.id = SDI.sqlNameId AND SN.type = 1
			JOIN sqlNames2 SN2 ON SN2.id = SN.sqlId AND SN2.type = 1
			JOIN APP_Application SC ON SC.id = SDI.appId AND SC.appTypeId = 81
			JOIN APP_InstanceName AI ON AI.id = SDI.instanceId
			JOIN App_Client AC ON AC.id = SC.clientId
		WHERE (@InstanceId = 0 OR SDI.instanceId = @InstanceId)
				AND (@SqlDbId = 0 OR SDI.sqlNameId = @SqlDbId)
				AND SC.clientId IN (SELECT DISTINCT clientId FROM #tt_getAllIdaObjects)
				-- No more time filter needed here for latest backups.
				-- Apply search term.
				AND (SN2.name LIKE @search_term OR AI.name LIKE @search_term OR AC.name like @search_term)
				-- Apply filters.
				AND (SN2.name LIKE @db_name_key)
				AND (AC.name LIKE @client_name_key)
				AND (AI.name LIKE @instance_name_key)
	-- Table: Last database information.
	IF OBJECT_ID('tempdb..#SqlDbPlanDetails') IS NOT NULL DROP TABLE #SqlDbPlanDetails
	CREATE TABLE #SqlDbPlanDetails (dbName NVARCHAR(256), subclientId int, instance int, planId int, planName nvarchar(1024),
		primary key (instance, dbName))
	INSERT INTO #SqlDbPlanDetails
		SELECT ASPX.attrName as DBName, ASPX.componentNameId as subclientId, AC.instance,
			CASE
				WHEN APY.id IS NOT NULL THEN APY.id
				WHEN APX.id IS NOT NULL THEN APX.id
				WHEN AP.id IS NOT NULL THEN AP.id
				ELSE 0
			END as planId,
			CASE
				WHEN APY.id IS NOT NULL THEN APY.name
				WHEN APX.id IS NOT NULL THEN APX.name
				WHEN AP.id IS NOT NULL THEN AP.name
				ELSE N''
			END as planName
		FROM APP_SubClientProp ASPX
		-- Consider the plan details for the databases that are being actively backed-up.
		-- Do not consider plan for databases thate removed from subclient content or from non-active/deleted subclient.
		JOIN APP_Application AC ON AC.id = ASPX.componentNameId AND ASPX.attrType = 118 AND ASPX.modified = 0 AND (AC.subclientStatus & (2|4)) = 0
		-- Distinct subclient which is of type 1.
		JOIN (SELECT componentNameId FROM APP_SubclientProp ASX WHERE ASX.attrName = 'mssql subclient type' AND ASX.modified = 0
				AND ASX.attrVal = N'1' GROUP BY componentNameId) OMS
			ON OMS.componentNameId = AC.id
		LEFT JOIN App_ClientProp ACP ON ACP.componentNameId = AC.clientId AND ACP.attrName = 'Associated Plan' AND ACP.modified = 0
		LEFT JOIN App_Plan ap ON ACP.attrVal = CAST(AP.id AS NVARCHAR(12))
		LEFT JOIN APP_BackupSetProp ABP ON ABP.componentNameId = AC.backupSet AND ABP.attrName = 'Associated Plan' AND ABP.modified = 0
		LEFT JOIN App_Plan APX ON ABP.attrVal = CAST(APX.id AS NVARCHAR(12))
		LEFT JOIN APP_SubClientProp ASP ON ASP.componentNameId = AC.id AND ASP.attrName = 'Associated Plan' AND ASP.modified = 0
		LEFT JOIN App_Plan APY ON ASP.attrVal = CAST(APY.id AS NVARCHAR(12))
		WHERE AP.id IS NOT NULL OR APX.id IS NOT NULL OR APY.id IS NOT NULL
	-- Update latest FULL backup details.
	;WITH SqlFullBkp (sqlNameId, backup_finish_date, backup_size, id, instanceid, bkpMethod, rn )  AS
		(select SDB.sqlNameId, SDB.backup_finish_date, SDB.backup_size, SDB.id, SDB.instanceId, SDB.backupmethod,
		ROW_NUMBER() OVER (PARTITION BY  SDB.sqlNameId, SDB.instanceId ORDER BY SDB.backup_finish_date DESC) rn
		 FROM  sqlDbBackupInfo SDB JOIN #SqlDbBasicInfo SD ON SD.instance = SDB.instanceId
			AND SD.sqlDbId = SDB.sqlNameId and SDB.type = 'D' AND (@toTime = 0 OR @toTime >= sdb.backup_finish_Date))
		UPDATE SD SET
			SD.lastBkpSize = SDB.size,
			SD.fullBkpMethod = SDB.bkpMethod
			FROM  #SqlDbBasicInfo SD
				JOIN (SELECT SB.instanceId,
							SB.sqlNameId,
							SB.bkpMethod,
							SUM(SF.pageSize) size
						FROM SqlFullBkp SB
							JOIN sqlFileBackupInfo SF
								ON SF.sqlDbBackupInfoId = SB.id AND SB.rn = 1
						GROUP BY SB.instanceId, SB.sqlNameId, SB.bkpMethod) SDB
					ON SD.instance = SDB.instanceId
						AND SD.sqlDbId = SDB.sqlNameId
	-- SQL Analysis Service
	;WITH SqlFullBkp (sqlNameId, backup_finish_date, backup_size, id, instanceid, bkpMethod, rn )  AS
	(select SABI.dbId, SABI.backup_finish_date, SABI.backup_size, SABI.id, SABI.instanceId, -1 /*SDB.backupmethod*/,
	ROW_NUMBER() OVER (PARTITION BY  SABI.dbId, SABI.instanceId ORDER BY SABI.backup_finish_date DESC) rn
		FROM  sqlAnalysisDbBackupInfo SABI JOIN #SqlDbBasicInfo SD ON SD.instance = SABI.instanceId
		AND SD.sqlDbId = SABI.dbId and SABI.type = 'D' AND (@toTime = 0 OR @toTime >= SABI.backup_finish_Date))
	UPDATE SD SET SD.lastBkpSize = SDB.backup_size, SD.fullBkpMethod = SDB.bkpMethod
		FROM  #SqlDbBasicInfo SD JOIN SqlFullBkp SDB
			ON SD.instance = SDB.instanceId and SD.sqlDbId = SDB.sqlNameId AND SDB.rn = 1
	BEGIN
		-- Get contents that are active for backups.
		IF OBJECT_ID('tempdb.dbo.#SqlActiveDbContents') IS NOT NULL DROP TABLE #SqlActiveDbContents
		CREATE TABLE #SqlActiveDbContents (databaseName NVARCHAR(1024), modified INT, instanceId INT, appId INT)
		INSERT INTO #SqlActiveDbContents
			SELECT ASP.attrName, ASP.modified, AP.instance, AP.id FROM APP_SubClientProp ASP
				-- Only active sub-client is considered.
				JOIN APP_Application AP ON ASP.componentNameId = AP.id AND AP.appTypeId = 81 AND (AP.subclientStatus & (2|4)) = 0
					AND ASP.attrType = 118 AND ASP.modified = 0
				JOIN #tt_getAllIdaObjects IA ON IA.clientId = AP.clientId
		-- Do not consider SQL archive and FFG subclients.
		-- Added the separate delete. Reason: There can be cases with no type set (for upgraded setups) and defaulted to consider as DATABASE type.
		DELETE SAC FROM #SqlActiveDbContents SAC
			JOIN App_SubclientProp ASP ON SAC.appId = ASP.componentNameId AND ASP.attrName = N'mssql subclient type'
				AND ASP.modified = 0 and ASP.cs_attrName = CHECKSUM(N'mssql subclient type') AND ASP.attrVal IN (2, 3)
		UPDATE SD SET SD.SLA = CASE WHEN csd.modified IS NULL THEN 1 ELSE 0 END
			FROM #SqlDbBasicInfo SD LEFT JOIN #SqlActiveDbContents csd ON SD.instance = csd.instanceId AND SD.DbName = csd.databaseName
		-- SLA calcualtion for each database happens here.
		IF OBJECT_ID('tempdb.dbo.#SLA_Subclient') IS NOT NULL DROP TABLE tempdb.dbo.#SLA_Subclient
		CREATE TABLE #SLA_Subclient (clientId INT, appTypeId INT, appId INT, status INT, category INT, slaDays INT)
		INSERT INTO #SLA_Subclient SELECT DISTINCT SI.clientId, 81, SI.subclientId, 0, 0, 0 FROM #SqlDbBasicInfo SI
		-- SLA days and time
		IF OBJECT_ID('tempdb.dbo.#ClientSLADays') IS NOT NULL DROP TABLE tempdb.dbo.#ClientSLADays
		CREATE TABLE #ClientSLADays (clientId INT, clientGroupId INT, slaDays INT)
		DECLARE	@ClientGroupSLADays TABLE (clientGroupId INT, slaDays INT)
		DECLARE @CS_SLADays			INT = 0
		SELECT	@CS_SLADays = longVal
			FROM	APP_ComponentProp WITH (NOLOCK)
			WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3300 AND modified = 0
		IF ISNULL(@CS_SLADays, 0) <= 0 SET @CS_SLADays = 30
		UPDATE	#SLA_Subclient SET slaDays = @CS_SLADays
		INSERT	INTO @ClientGroupSLADays
			SELECT	componentId, longVal
			FROM	APP_ComponentProp WITH (NOLOCK)
			WHERE	componentType = 8 AND propertyTypeId = 3300 AND modified = 0
		IF EXISTS (SELECT * FROM @ClientGroupSLADays)
		BEGIN
			INSERT INTO #ClientSLADays
			SELECT	T.clientId, T.clientGroupId, T.slaDays
			FROM	(SELECT CG.slaDays, CGA.clientId, CGA.clientGroupId, ROW_NUMBER() OVER (PARTITION BY CGA.clientId ORDER BY CG.slaDays) AS rowId
					FROM	@ClientGroupSLADays CG INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON CG.clientGroupId = CGA.clientGroupId) T
			WHERE	T.rowId = 1
			UPDATE	S SET slaDays = CG.slaDays
			FROM	#SLA_Subclient S
					INNER JOIN #ClientSLADays CG ON S.clientId = CG.clientId
		END
		UPDATE SD SET SD.SLA = CASE WHEN DATEDIFF(DAY, dbo.getdatetime(SD.databaseLastBackupTime), GETUTCDATE()) <= CSD.slaDays
					THEN 1 ELSE 0 END
		FROM #SqlDbBasicInfo SD JOIN #SLA_Subclient csd ON SD.subclientId = csd.appId AND SD.SLA <> 1
	END
	-- SORT AND ORDER
	IF OBJECT_ID('tempdb..#sqlInstanceDb') IS NOT NULL DROP TABLE #sqlInstanceDb
	CREATE TABLE #sqlInstanceDb (rn int IDENTITY, instance int, sqlDbId int,
		DbName nvarchar(1024), instanceName nvarchar(1024), clientname nvarchar(1024), RecoveryModel nvarchar(256), databaseLastBackupTime int,
		lastBkpSize bigint, planId int, planName nvarchar(1024), SLA int,
		-- Advanced Information.
		lastBkpSetId int, lastBkpJob int, version nvarchar(256), lastBkpType int, subclientId int, clientId int, firstBkpSetId int, firstBkpJob int,
		databaseCreationDate int, databaseFirstBackupTime int, status int, fullBkpMethod int, replicationInfo xml, serverType nvarchar(256),
		primary key(rn, clientId, instance, sqlDbId))
	IF @order = 0
	BEGIN
		INSERT INTO #sqlInstanceDb
			SELECT SDI.instance, SDI.sqlDbId, SDI.DbName, SDI.instanceName, SDI.clientname, SDI.RecoveryModel,
				SDI.databaseLastBackupTime, SDI.lastBkpSize, ISNULL(SPI.planId, 0), ISNULL(SPI.planName, N''),
				SDI.SLA, SDI.lastBkpSetId, SDI.lastBkpJob, SDI.version, SDI.lastBkpType,
				SDI.subclientId, SDI.clientId, 0, 0, SDI.databaseCreationDate, 0,
				SDI.status, SDI.fullBkpMethod, NULL, ISNULL(IP.attrVal, 'DataBase Engine')
			FROM #SqlDbBasicInfo SDI
				LEFT JOIN #SqlDbPlanDetails SPI ON SPI.instance = SDI.instance AND SPI.dbName = SDI.DbName
				LEFT JOIN APP_InstanceProp IP ON IP.componentNameId = SDI.instance AND IP.attrName = 'MSSQL Server Type'
				ORDER BY (CASE @sort WHEN 1 THEN SDI.DbName WHEN 2 THEN SDI.instanceName
									WHEN 3 THEN SDI.clientname WHEN 4 THEN SDI.RecoveryModel
									WHEN 6 THEN SPI.planName ELSE NULL END) ASC,
						(CASE @sort WHEN 5 THEN SDI.lastBkpSize ELSE NULL END) ASC,
						(CASE WHEN @sort > 6 OR @sort < 1 THEN SDI.DbName ELSE NULL END) ASC
	END
	ELSE
	BEGIN
		INSERT INTO #sqlInstanceDb
			SELECT SDI.instance, SDI.sqlDbId, SDI.DbName, SDI.instanceName, SDI.clientname, SDI.RecoveryModel,
				SDI.databaseLastBackupTime, SDI.lastBkpSize, ISNULL(SPI.planId, 0), ISNULL(SPI.planName, N''),
				SDI.SLA, SDI.lastBkpSetId, SDI.lastBkpJob, SDI.version, SDI.lastBkpType,
				SDI.subclientId, SDI.clientId, 0, 0, SDI.databaseCreationDate, 0,
				SDI.status, SDI.fullBkpMethod, NULL, ISNULL(IP.attrVal, 'DataBase Engine')
				FROM #SqlDbBasicInfo SDI
					LEFT JOIN #SqlDbPlanDetails SPI ON SPI.instance = SDI.instance AND SPI.dbName = SDI.DbName
					LEFT JOIN APP_InstanceProp IP ON IP.componentNameId = SDI.instance AND IP.attrName = 'MSSQL Server Type'
				ORDER BY (CASE @sort WHEN 1 THEN SDI.DbName WHEN 2 THEN SDI.instanceName
									WHEN 3 THEN SDI.clientname WHEN 4 THEN SDI.RecoveryModel
									WHEN 6 THEN SPI.planName ELSE NULL END) DESC,
						(CASE @sort WHEN 5 THEN SDI.lastBkpSize ELSE NULL END) DESC,
						(CASE WHEN @sort > 6 OR @sort < 1 THEN SDI.DbName ELSE NULL END) DESC
	END
	-- Apply PAGING
	DECLARE @total INT = 0
	SELECT @total = count(*) FROM #sqlInstanceDb
	IF @CalcSla = 0
	BEGIN
		SELECT @endData = 0 FROM #sqlInstanceDb WHERE rn > @endOffset AND @noPaging = 0
		DELETE FROM #sqlInstanceDb WHERE rn > @endOffset AND @noPaging = 0
		DELETE FROM #sqlInstanceDb WHERE rn <= @startOffset AND @noPaging = 0
	END
	IF @showReplicationInfo > 0
	BEGIN
	   IF OBJECT_ID('tempdb.dbo.#replicationInfoOut') IS NOT NULL DROP TABLE #replicationInfoOut
	   CREATE TABLE #replicationInfoOut(repInfo XML)
DECLARE @applicationId INT = 81
	   DECLARE @replicationInfoReq XML
	   DECLARE @replicationInfoResp XML
	   SET @replicationInfoReq = (
			SELECT (
				SELECT @applicationId AS "source/@applicationId", @instanceId AS "source/@instanceId" FOR XML PATH('siteInfo'), TYPE
			) FOR XML PATH('App_LiveSyncReplicationReq')
	   )
	   EXEC [dbo].[AppLiveSyncReplicationsGetInfo] @replicationInfoReq
	   SELECT @replicationInfoResp = repInfo FROM #replicationInfoOut
	   UPDATE sqlIns
	   SET replicationInfo = (SELECT i.query('.') FROM @replicationInfoResp.nodes('App_LiveSyncReplicationResp/siteInfo') R(i) WHERE i.value('@restoreSource', 'VARCHAR(MAX)') = sqlIns.DbName AND i.value('source[1]/@instanceId', 'INT')  = sqlIns.instance FOR XML PATH('replicationInfo'))
	   FROM #sqlInstanceDb sqlIns
	   DROP TABLE #replicationInfoOut
	END
	-- Send additional information for the database.
	IF @CalcSla = 0 AND @propertyLevel > 10
	BEGIN
		-- Update information for first backup.
		;WITH SqlFirstDbChain(sqlNameId, instanceId, backup_finish_Date, id, jobId, rn) AS
		(SELECT SDB.sqlNameId, SDB.instanceId, SDB.backup_finish_Date, SDB.id, SDB.jobId,
			ROW_NUMBER() OVER (PARTITION BY  SDB.sqlNameId, SDB.instanceId ORDER BY SDB.backup_finish_date ASC) rn
					FROM  sqlDbBackupInfo SDB JOIN #sqlInstanceDb SD ON SDB.sqlNameId = SD.sqlDbId
						AND SDB.instanceId = SD.instance AND (@toTime = 0 OR @toTime >= sdb.backup_finish_Date))
			UPDATE SD SET
				SD.databaseFirstBackupTime = SDB.backup_finish_Date, SD.firstBkpJob = SDB.jobId, SD.firstBkpSetId = SDB.id
			FROM  #sqlInstanceDb SD JOIN  SqlFirstDbChain SDB
				ON SD.instance = SDB.instanceId and SD.sqlDbId = SDB.sqlNameId AND SDB.rn = 1
		;WITH SqlFirstAnalysisDbChain(sqlNameId, instanceId, backup_finish_Date, id, jobId, rn) AS
		(SELECT SDB.dbId, SDB.instanceId, SDB.backup_finish_Date, SDB.id, SDB.jobId,
			ROW_NUMBER() OVER (PARTITION BY  SDB.dbId, SDB.instanceId ORDER BY SDB.backup_finish_date ASC) rn
					FROM  sqlAnalysisDbBackupInfo SDB JOIN #sqlInstanceDb SD ON SDB.dbId = SD.sqlDbId
						AND SDB.instanceId = SD.instance AND (@toTime = 0 OR @toTime >= sdb.backup_finish_Date))
			UPDATE SD SET
				SD.databaseFirstBackupTime = SDB.backup_finish_Date, SD.firstBkpJob = SDB.jobId, SD.firstBkpSetId = SDB.id
			FROM  #sqlInstanceDb SD JOIN  SqlFirstAnalysisDbChain SDB
				ON SD.instance = SDB.instanceId and SD.sqlDbId = SDB.sqlNameId AND SDB.rn = 1
	END
	-- XML response: App_GetSQLDatabasesResponse
	IF @CalcSla = 0 AND @propertyLevel > 10
	BEGIN
		SET @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage', @endData as '@end', @total as '@total' FOR XML PATH('response'), type),
			(SELECT sd.instance as "@insId", sd.sqlDbId as "@dbId", sd.clientId as "@cId", sd.clientName as "@cName",
			sd.instanceName as "@insName", sd.DbName as "@dbName", sd.subclientId as "@appId",
			sd.lastBkpSetId as "@lastBkpId", sd.lastBkpJob as "@jobId", sd.databaseLastBackupTime as "@bkpTime",
			sd.version as "@version", sd.lastBkptype as "@bkpType", sd.lastBkpSize as "@bkpSize", sd.DatabaseCreationDate as "@dbCreateDate",
			sd.databaseFirstBackupTime as "@fBkpTime", sd.firstBkpJob as "@fBkpJob",sd.planId as "@planId", sd.planName as "@planName",
					sd.RecoveryModel as "@rModel", sd.SLA as "@sla", SD.fullBkpMethod as "@fBkpMethod", sd.serverType as "@serverType", sd.replicationInfo.query('replicationInfo/siteInfo')
			FROM #sqlInstanceDb as sd
					LEFT JOIN @tblException TL ON TL.name = SD.DbName
				WHERE TL.name IS NULL OR @showSystemDBs = 1
			FOR XML PATH('SqlDatabase'), type)
			FOR XML PATH(''), root('App_GetSQLDatabasesResponse')), N'<App_GetSQLDatabasesResponse />')
	END
	ELSE IF @CalcSla > 0
	BEGIN
		set @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage', @endData as '@end', @total as '@total' FOR XML PATH('response'), type),
			(SELECT X.protected as "@protect", X.unprotected as "@unprotect", X.attempted as "@attempt",
				X.SlaMet as "@metSLACount", X.SlaMissed as "@missedSLACount"
				FROM (SELECT ISNULL(piv1.[1], 0) AS SlaMet, ISNULL(piv1.[0], 0) AS SlaMissed,
							ISNULL(piv.[1], 0) as protected, ISNULL(piv.[2], 0) as attempted,
							ISNULL(piv.[3], 0) as unprotected
						FROM (select SLA, COUNT(1) as SLACount from #sqlInstanceDb group by SLA) T
								pivot (max(SLACount) for SLA in ([1], [0]) ) piv1,
							(select status, COUNT(1) as sCount from #sqlInstanceDb group by status) T1
								pivot (max(sCount) for status in ([1], [2], [3]) ) piv) X
				FOR XML PATH('SlaDetails'), type)
			FOR XML PATH(''), root('App_GetSQLDatabasesResponse')), N'<App_GetSQLDatabasesResponse />')
	END
	ELSE
	BEGIN
		SET @XmlInputOutput = ISNULL((SELECT (SELECT 0 AS '@errorCode', N'' AS '@errorMessage', @endData as '@end', @total as '@total' FOR XML PATH('response'), type),
				(SELECT sd.instance AS "@insId", sd.sqlDbId as "@dbId", sd.clientId as "@cId", sd.clientName as "@cName",
				sd.instanceName AS "@insName", sd.DbName as "@dbName", sd.subclientId as "@appId", sd.lastBkpJob as "@jobId",
				sd.databaseLastBackupTime AS "@bkpTime", sd.lastBkpSize as "@bkpSize", sd.planId as "@planId", sd.planName as "@planName",
				sd.RecoveryModel AS "@rModel", sd.SLA as "@sla", SD.fullBkpMethod as "@fBkpMethod", sd.serverType as "@serverType", sd.replicationInfo.query('replicationInfo/siteInfo')
			FROM #sqlInstanceDb AS sd
					LEFT JOIN @tblException TL ON TL.name = SD.DbName
				WHERE TL.name IS NULL OR @showSystemDBs = 1
				FOR XML PATH('SqlDatabase'), type)
				FOR XML PATH(''), root('App_GetSQLDatabasesResponse')), N'<App_GetSQLDatabasesResponse />')
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @XmlInputOutput = (SELECT ERROR_NUMBER() AS '@errorCode', 'Failed to get database details. ' + ERROR_MESSAGE() AS '@errorMessage', @endData as '@end'
			FOR XML PATH ('response'), root(N'App_GetSQLDatabasesResponse'))
END CATCH
SELECT @XmlInputOutput
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSQLDatabasesInACommcell')
	delete from GxQscripts where name = 'AppGetSQLDatabasesInACommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLDatabasesInACommcell')
	delete from GXDBVersions where aliasname = 'AppGetSQLDatabasesInACommcell'
GO

insert into GXDBVersions values(2, 'AppGetSQLDatabasesInACommcell',  '00000000000000000000', 'AppGetSQLDatabasesInACommcell', '00000000000000000000')
GO

