

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSQLDatabaseAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: AppGetSQLDatabaseAssociation
--  |
--  | Description:
--  |  To get Contents associated with subClients
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		To get Contents associated with subClients
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSQLDatabaseAssociation <<<'

IF EXISTS (select * from sysobjects where name='AppGetSQLDatabaseAssociation')
	drop procedure AppGetSQLDatabaseAssociation
IF EXISTS (select * from GxQscripts where name='AppGetSQLDatabaseAssociation')
	delete from GxQscripts where name = 'AppGetSQLDatabaseAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLDatabaseAssociation')
	delete from GXDBVersions where aliasname = 'AppGetSQLDatabaseAssociation'
GO
print '... Creating Procedure: AppGetSQLDatabaseAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSQLDatabaseAssociation
  @xmlText XML,
  @databaseAssociation XML
AS
--This will turn off message: "xxx rows affected".
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @mode		INT = 0
DECLARE @clientId	INT
DECLARE @instanceId INT
IF @xmlText.exist('/Api_GetSQLDatabaseListRequest') = 1
	BEGIN
		DECLARE @dbAssociation TABLE(databaseId INT, databaseName NVARCHAR(MAX), createdTime INT, recoveryModelType INT, subClientId INT, subClientName NVARCHAR(MAX), discoverType INT)
		SET @mode = ISNULL((SELECT  ref.value('@mode', 'int') AS client
								  FROM    @xmlText.nodes('Api_GetSQLDatabaseListRequest') R ( ref )),0)
		SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'int') AS client
								  FROM    @xmlText.nodes('Api_GetSQLDatabaseListRequest/instance') R ( ref )),0)
		SET @instanceId = ISNULL((SELECT  ref.value('@instanceId', 'int') AS client
								  FROM    @xmlText.nodes('Api_GetSQLDatabaseListRequest/instance') R ( ref )),0)
		INSERT INTO @dbAssociation(databaseId, databaseName, createdTime, recoveryModelType)
		SELECT
		N.association.value('@databaseId','INT') AS databaseId,
		N.association.value('@databaseName','NVARCHAR(MAX)') AS databaseName,
		N.association.value('@createdTime','INT') AS createdTime,
		N.association.value('@recoveryModelType','INT') AS recoveryModelType
		FROM   @databaseAssociation.nodes('/Api_GetSQLDatabaseListResponse/databaseAssociation') AS N(association)
		UPDATE Assoc SET Assoc.subClientId = APP.id, Assoc.subClientName = APP.subclientName,
			Assoc.discoverType = (SELECT Data FROM SplitString(ASP1.attrVal, ' ') WHERE Id = 2)
				FROM APP_Application APP
					INNER JOIN APP_SubClientProp ASP1
						ON APP.id = ASP1.componentNameId
					INNER JOIN APP_SubClientProp ASP2
						ON APP.id = ASP2.componentNameId
					INNER JOIN @dbAssociation Assoc
						ON ASP1.attrName = Assoc.databaseName
						AND APP.clientId = @clientId
						AND APP.instance = @instanceId
						AND APP.appTypeId = 81
						AND APP.subclientStatus <> 4
						AND ASP1.attrType = 118
						AND ASP1.modified = 0
						AND ASP2.attrName = N'mssql subclient type'
						AND ASP2.attrVal = N'1'
						AND ASP2.modified = 0
		IF @mode = 0 -- Configured
		BEGIN
			DELETE FROM @dbAssociation WHERE subClientId IS NULL
		END
		ELSE IF @mode = 1 --Unconfigured
		BEGIN
			DELETE FROM @dbAssociation WHERE subClientId IS NOT NULL
		END
		SET @databaseAssociation = (SELECT
							databaseId AS '@databaseId',
							databaseName AS '@databaseName',
							createdTime AS '@createdTime',
							recoveryModelType AS '@recoveryModelType',
							discoverType AS '@discoverType',
							CASE subClientId WHEN NULL
							THEN NULL
							ELSE (SELECT
								subClientId AS '@subclientId',
								subClientName AS '@subclientName'
								FOR XML PATH('associatedSubclient'),TYPE)
							END
							FROM @dbAssociation
							FOR XML PATH('databaseAssociation'),
							ROOT('Api_GetSQLDatabaseListResponse'))
		IF @databaseAssociation IS NULL -- In case of no association, sending empty XML.
			SET @databaseAssociation = N'<Api_GetSQLDatabaseListResponse/>'
	END
	ELSE IF @xmlText.exist('Api_GetSQLFFGListRequest') = 1
	BEGIN
		DECLARE @ffgAssociation TABLE(fileGroupId INT, groupName  NVARCHAR(MAX), fileId INT, fileName NVARCHAR(MAX), fileSize INT,
			fileMaxSize INT,systemDbFlags INT, logicalFileName NVARCHAR(MAX), displayName NVARCHAR(MAX), subClientId INT, subClientName NVARCHAR(MAX))
		SET @mode = ISNULL((SELECT  ref.value('@mode', 'int') AS client
								  FROM    @xmlText.nodes('Api_GetSQLFFGListRequest') R ( ref )),0)
		SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'int') AS client
								  FROM    @xmlText.nodes('Api_GetSQLFFGListRequest/instance') R ( ref )),0)
		SET @instanceId = ISNULL((SELECT  ref.value('@instanceId', 'int') AS client
								  FROM    @xmlText.nodes('Api_GetSQLFFGListRequest/instance') R ( ref )),0)
		DECLARE @databaseId INT = ISNULL((SELECT  ref.value('@id', 'int') AS client
								  FROM    @xmlText.nodes('Api_GetSQLFFGListRequest/database') R ( ref )),0)
		DECLARE @databaseName NVARCHAR(MAX) = ISNULL((SELECT  ref.value('@name', 'NVARCHAR(MAX)') AS client
								  FROM    @xmlText.nodes('Api_GetSQLFFGListRequest/database') R ( ref )),0)
		--Inserting File Group Info from XML.
		INSERT INTO @ffgAssociation(fileGroupId, groupName, displayName)
		SELECT
		N.association.value('@fileGroupId','INT') AS fileGroupId,
		N.association.value('@groupName','NVARCHAR(MAX)') AS groupName,
		N.association.value('@groupName','NVARCHAR(MAX)') AS displayName
		FROM   @databaseAssociation.nodes('/Api_GetSQLFFGListResponse/sqlFileGroupInfo') AS N(association)
		--Inserting File INfo from XML.
		INSERT INTO @ffgAssociation(fileGroupId, groupName, fileId, fileName, fileSize, fileMaxSize, systemDbFlags, logicalFileName, displayName)
		SELECT
		N.association.value('../@fileGroupId','INT') AS fileGroupId,
		N.association.value('../@groupName','NVARCHAR(MAX)') AS groupName,
		N.association.value(('@fileId'),'INT') AS fileId,
		N.association.value('@fileName','NVARCHAR(MAX)') AS fileName,
		N.association.value('@fileSize','INT') AS fileSize,
		N.association.value('@fileMaxSize','INT') AS fileMaxSize,
		N.association.value('@systemDbFlags','INT') AS systemDbFlags,
		N.association.value('@logicalFileName','NVARCHAR(MAX)') AS logicalFileName,
		N.association.value('../@groupName','NVARCHAR(MAX)') + ':' + N.association.value('@logicalFileName','NVARCHAR(MAX)') AS displayName
		FROM   @databaseAssociation.nodes('/Api_GetSQLFFGListResponse/sqlFileGroupInfo/sqlFileInfo') AS N(association)
		UPDATE Assoc SET Assoc.subClientId = APP.id, Assoc.subClientName = APP.subclientName
				FROM APP_Application APP
					INNER JOIN APP_SubClientProp ASP1
						ON App.id = ASP1.componentNameId
					INNER JOIN APP_SubClientProp ASP2
						ON APP.id = ASP2.componentNameId
					INNER JOIN APP_SubClientProp ASP3
						ON APP.id = ASP3.componentNameId
					INNER JOIN @ffgAssociation Assoc
						ON ASP3.attrName = Assoc.displayName
						AND ASP3.attrType = 119
						AND ASP3.modified = 0
						AND APP.clientId = @clientId
						AND APP.instance = @instanceId
						AND APP.appTypeId = 81 --MSSQL
						AND APP.subclientStatus <> 4
						AND ASP1.attrName = @databaseName
						AND ASP1.attrType = 118
						AND ASP1.modified = 0
						AND ASP2.attrName = N'mssql subclient type'
						AND ASP2.attrVal = N'2'
						AND ASP2.modified = 0
		-- Adding association at file level if filegroup level is associated.
		UPDATE  FASSOC SET subClientId = FGASSOC.subClientId, subClientName = FGASSOC.subClientName
		FROM @ffgAssociation FGASSOC
			INNER JOIN @ffgAssociation FASSOC
				ON FGASSOC.fileGroupId = FASSOC.fileGroupId
				AND FGASSOC.fileName IS NULL
				AND FASSOC.fileName IS NOT NULL
				AND FGASSOC.subClientId IS NOT NULL
		IF @mode = 0 -- ConfiguredOnly
		BEGIN
			DELETE FROM @ffgAssociation WHERE fileId IS NOT NULL AND  subClientId IS NULL -- Removing entries for files.
			DELETE FROM @ffgAssociation WHERE fileId IS NULL AND  subClientId IS NULL AND fileGroupId IN ( -- Removing filegroup also if no files are present
				SELECT fileGroupId FROM @ffgAssociation GROUP BY fileGroupId HAVING ( COUNT(fileGroupId) = 1 ))
		END
		ELSE IF @mode = 1 --UnconfiguredOnly
		BEGIN
			DELETE FROM @ffgAssociation WHERE fileId IS NOT NULL AND subClientId IS NOT NULL -- Removing entries for files.
			DELETE FROM @ffgAssociation WHERE fileId IS NULL AND  subClientId IS NOT NULL AND fileGroupId IN ( -- Removing filegroup also if no files are present
				SELECT fileGroupId FROM @ffgAssociation GROUP BY fileGroupId HAVING ( COUNT(fileGroupId) = 1 ))
		END
		SET @databaseAssociation = (SELECT
								FileGroup.fileGroupId AS '@fileGroupId',
								FileGroup.groupName AS '@groupName',
								FileGroup.subClientId AS '@associatedSubclientId',
								FileGroup.subClientName AS '@subclientName',
								(SELECT
								files.fileId AS '@fileId',
								files.logicalFileName AS '@logicalFileName',
								files.fileSize AS '@fileSize',
								files.fileMaxSize AS '@fileMaxSize',
								files.systemDbFlags AS '@systemDbFlags',
								files.fileName AS '@fileName',
								files.subClientId AS '@associatedSubclientId',
								files.subClientName AS '@subclientName'
								FROM @ffgAssociation Files WHERE Files.fileGroupId = FileGroup.fileGroupId AND fileId IS NOT NULL
								FOR XML PATH('sqlFileInfo'),TYPE)
							FROM @ffgAssociation FileGroup WHERE fileId IS NULL
							For XML PATH('sqlFileGroupInfo'),
							ROOT('Api_GetSQLFFGListResponse'))
		IF @databaseAssociation IS NULL
			SET @databaseAssociation = N'<Api_GetSQLFFGListResponse/>'
	END
	SELECT @databaseAssociation AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSQLDatabaseAssociation')
	delete from GxQscripts where name = 'AppGetSQLDatabaseAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLDatabaseAssociation')
	delete from GXDBVersions where aliasname = 'AppGetSQLDatabaseAssociation'
GO

insert into GXDBVersions values(2, 'AppGetSQLDatabaseAssociation',  '00000000000000000000', 'AppGetSQLDatabaseAssociation', '00000000000000000000')
GO

