

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSQLBrowseData.sp] ---------- 

--  +-----------------------------------------------------------------------+
--  |           Procedure : "AppGetSQLBrowseData"
--  |   This procedure will browse the backed up SQL data
--	|
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
--Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSQLBrowseData <<<'

IF EXISTS (select * from sysobjects where name='AppGetSQLBrowseData')
	drop procedure AppGetSQLBrowseData
IF EXISTS (select * from GxQscripts where name='AppGetSQLBrowseData')
	delete from GxQscripts where name = 'AppGetSQLBrowseData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLBrowseData')
	delete from GXDBVersions where aliasname = 'AppGetSQLBrowseData'
GO
print '... Creating Procedure: AppGetSQLBrowseData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSQLBrowseData
--Input Arguments
  @xmlText XML
AS
  DECLARE @outXml XML
DECLARE @clientname AS NVARCHAR(MAX)
DECLARE @instancename AS NVARCHAR(MAX)
DECLARE @clientId AS INT
DECLARE @instanceId AS INT
DECLARE @starttime AS NVARCHAR(MAX)
DECLARE @endtime AS NVARCHAR(MAX)
DECLARE @databasename AS NVARCHAR(MAX)
DECLARE @jobId AS INT
DECLARE @backupsetid AS INT
DECLARE @isDetails AS INT
DECLARE @userId AS INT
DECLARE @errorCode AS INT
DECLARE @errorString AS NVARCHAR(MAX)
SET @errorCode = 0
SET @errorString = 'Successful'
DECLARE @temptable TABLE
(
	userid int,
	nodecaps bigint,
	childcaps bigint
)
DECLARE @outputTable TABLE
(
	jobid int,
    backup_set_id int,
    DatabaseName NVarchar(max),
    type CHAR(1),
    backup_size bigint,
    backup_start_date int,
    backup_finish_date int,
    backupmethod varchar(16)
)
SET @clientname = ISNULL((SELECT ref.value ('@clientName','nvarchar(MAX)') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData/entity') R (ref)),'')
SET @clientId = ISNULL((SELECT ref.value ('@clientId','int') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData/entity') R (ref)),0)
SET @instancename = ISNULL((SELECT ref.value ('@instanceName','nvarchar(MAX)') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData/entity') R (ref)),'')
SET @instanceid = ISNULL((SELECT ref.value ('@instanceId','int') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData/entity') R (ref)),0)
SET @starttime = ISNULL((SELECT ref.value ('@startTime','nvarchar(MAX)') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData') R (ref)),'0')
SET @endtime = ISNULL((SELECT ref.value ('@endTime','nvarchar(MAX)') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData') R (ref)),'0')
SET @databasename = ISNULL((SELECT ref.value ('@databaseName','nvarchar(MAX)') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData') R (ref)),'')
SET @jobid = ISNULL((SELECT ref.value ('@jobId','int') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData') R (ref)),0)
SET @backupsetid = ISNULL((SELECT ref.value ('@backupsetid','int') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData') R (ref)),0)
SET @isdetails = ISNULL((SELECT ref.value ('@details','int') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData') R (ref)),0)
SET @userId = ISNULL((SELECT ref.value ('@userId','int') AS client
				   FROM @xmltext.nodes('App_GetSQLBrowseData/processinginstructioninfo/user') R (ref)),0)
--SELECT @clientname, @instancename, @clientid, @instanceid, @starttime, @endtime, @databasename, @jobId, @backupsetid, @isDetails, @userId
IF ((@clientId = 0) OR (@instanceId = 0))
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid input passed'
	GOTO ERR_EXIT
END
INSERT @temptable
EXEC sec_iDaNodeAccess @userid, 2, @clientid, 81, @instanceid, 0, 0
IF ((SELECT TOP 1 nodecaps FROM @temptable ) & (POWER(2,12)) = 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'User does not have browse capability on this instance to do this operation'
	GOTO ERR_EXIT
END
INSERT INTO @outputTable
EXEC QS_GetSQLJobList @clientname, @instancename, @starttime, @endtime, @databasename, @jobid, @backupsetid, 0
IF ((SELECT COUNT(*) FROM @outputTable) = 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'No data to browse'
END
ERR_EXIT:
SET @outXML = ISNULL((SELECT(SELECT jobid as '@jobId',
		backup_set_id as '@backup_set_id',
		DatabaseName as '@dataBaseName',
		type as '@type',
		backup_size as '@backup_size',
		backup_start_date as '@backup_start_date',
		backup_finish_date as '@backup_finish_date',
		backupmethod as '@backupmethod'
	   FROM @outputTable
	   FOR XML PATH ('browsedSQLData'),TYPE),
	   (SELECT @errorCode AS '@errorCode',
			  @errorString AS '@errorString'
		FOR XML PATH ('errorResponse'),TYPE)
	   FOR XML PATH(''), ROOT('App_GetSQLBrowseResponse')),'<App_GetSQLBrowseResponse/>')
SELECT @outXML

IF EXISTS (select * from GxQscripts where name = 'AppGetSQLBrowseData')
	delete from GxQscripts where name = 'AppGetSQLBrowseData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSQLBrowseData')
	delete from GXDBVersions where aliasname = 'AppGetSQLBrowseData'
GO

insert into GXDBVersions values(2, 'AppGetSQLBrowseData',  '00000000000000000000', 'AppGetSQLBrowseData', '00000000000000000000')
GO

