

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSECloudMapping.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSECloudMapping.sp,v $ $Id: AppGetSECloudMapping.sp,v 1.3.42.1 2018/03/27 09:02:29 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppGetSECloudMapping   - Get cloudid to preview cloud id details
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSECloudMapping <<<'

IF EXISTS (select * from sysobjects where name='AppGetSECloudMapping')
	drop procedure AppGetSECloudMapping
IF EXISTS (select * from GxQscripts where name='AppGetSECloudMapping')
	delete from GxQscripts where name = 'AppGetSECloudMapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSECloudMapping')
	delete from GXDBVersions where aliasname = 'AppGetSECloudMapping'
GO
print '... Creating Procedure: AppGetSECloudMapping'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSECloudMapping
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_srcCloudId integer
AS
  DECLARE @o_previewCloudId INT
  DECLARE @o_clientId INT
  DECLARE @o_hostName varchar(1024)
  DECLARE @o_basePort INT
  DECLARE @o_enabled INT
  DECLARE @o_coreRoles INT
  DECLARE @o_URL varchar(1024)
  DECLARE @o_creationTime DATETIME
  DECLARE @o_modifiedTime DATETIME
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
-- GET SEARCH ENGINE NODE DETAILS FOR DESTCLOUDiD
DECLARE @previewNodesTbl TABLE (t_previewCloudId INT, t_clientId INT, t_hostName  varchar(1024), t_basePort INT, t_enabled INT, t_coreRoles INT, t_url varchar(1024), t_created DATETIME, t_modified DATETIME)
INSERT INTO @previewNodesTbl (t_previewCloudId, t_clientId, t_hostName , t_basePort , t_enabled , t_coreRoles , t_url, t_created, t_modified )
SELECT DISTINCT C.DestCloudId, S.ClientId, '', 0 , S.enabled, S.CoreRoles, S.ServiceLink, C.CreationTime, ( CASE WHEN C.flags = 0 THEN 0 ELSE C.ModifiedTime END)
FROM DM2SearchServerCoreInfo S WITH (NOLOCK)
	INNER JOIN DM2SearchEngineCloudMapping C WITH (NOLOCK) ON S.CloudId = C.DestCloudId
WHERE srcCloudId = @i_srcCloudId AND flags <> 2 AND SharingType =1
UPDATE 	@previewNodesTbl
SET t_hostName = CP.attrVal
FROM @previewNodesTbl T INNER JOIN APP_clientProp CP WITH (NOLOCK) ON T.t_clientId = CP.componentNameId AND Modified = 0
WHERE CP.attrName IN ('FAST_hostname')
UPDATE 	@previewNodesTbl
SET t_basePort = CP.attrVal
FROM @previewNodesTbl T INNER JOIN APP_clientProp CP WITH (NOLOCK) ON T.t_clientId = CP.componentNameId AND Modified = 0
WHERE CP.attrName IN ('FAST_baseport')
  --------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
ERROR_EXIT:
SELECT * FROM @previewNodesTbl
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSECloudMapping')
	delete from GxQscripts where name = 'AppGetSECloudMapping'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSECloudMapping')
	delete from GXDBVersions where aliasname = 'AppGetSECloudMapping'
GO

insert into GXDBVersions values(2, 'AppGetSECloudMapping',  '00010003004200010000', 'AppGetSECloudMapping', '00010003004200010000')
GO

