

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSCPForEdgeDriveUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetSCPForEdgeDriveUser.sp,v $ $Id: AppGetSCPForEdgeDriveUser.sp,v 1.22.2.26 2019/12/18 22:54:52 nramalingam Exp $";
--
--  +====================================================================================================================================+
--  |   Procedure:  AppGetSCPForEdgeDriveUser()
--  |
--  | Description:  SP for retrieving all edge drive associations(clientId, subclient , subclient Policy) for an edge drive user
--  |
--  |       Input:  XML containing Entity Information (user or subclient)
--  |      Output:  XML containing association information
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  riyer    For retrieving all edge drive associations for an edge drive entity(User or Subclient)
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSCPForEdgeDriveUser')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSCPForEdgeDriveUser <<<'
	drop procedure AppGetSCPForEdgeDriveUser
END
IF EXISTS (select * from GxQscripts where name='AppGetSCPForEdgeDriveUser')
	delete from GxQscripts where name = 'AppGetSCPForEdgeDriveUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSCPForEdgeDriveUser')
	delete from GXDBVersions where aliasname = 'AppGetSCPForEdgeDriveUser'
GO
print '... Creating Procedure: AppGetSCPForEdgeDriveUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSCPForEdgeDriveUser
  @i_xml XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @entityType INT
DECLARE @userId  INT
DECLARE @userLoginName NVARCHAR(MAX)
DECLARE @clientId  INT
DECLARE @storagePolicyId INT
DECLARE @scpId 	INT
DECLARE @subclientId INT
DECLARE @appId INT
DECLARE @nowTime  INT
DECLARE @defaultsubclientId  INT
DECLARE @userBackupsetId  INT
DECLARE @userBackupsetName  NVARCHAR(MAX)
DECLARE @inputEntity XML
DECLARE @r_entity XML
DECLARE @r_errors XML
DECLARE @out_xml XML
DECLARE @warningCode INT
DECLARE @errorCode INT
DECLARE @errorString VARCHAR(256)
DECLARE @contentStoreType NVARCHAR(MAX)
DECLARE @isContentStore INT
DECLARE @r_edgeDriveInfo XML
DECLARE @outCloudId INT
DECLARE @outCapabilities BIGINT
DECLARE @contentIndexingEnabled  int
DECLARE @dirDelim				 nvarchar(16)
DECLARE @appTypeId				 int
DECLARE @clientToUse			 int
DECLARE @contentStoreClientType	 int
DECLARE @hasEdgeDriveEnabledLaptop int
DECLARE @hasSyncBlackListedLaptop int
DECLARE @capUpload bigint= (POWER(2.0, 5 -1))
BEGIN TRY
SET @clientId  = 0
SET @scpId     = 0
SET @errorCode = 0
SET @warningCode = 0
SET @errorString = ''
SET @entityType = ISNULL((SELECT  ref.value('@_type_', 'int') AS Agent
                         FROM    @i_xml.nodes('App_EdgeDriveAssocCheckReq/entity') R ( ref )),0)
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_EdgeDriveAssocCheckReq/entity') R ( ref )),0)
SET @subclientId = ISNULL((SELECT  ref.value('@subclientId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_EdgeDriveAssocCheckReq/entity') R ( ref )),0)
SET @contentStoreType = ISNULL((SELECT  ref.value('@contentStoreType', 'nvarchar(max)') AS Agent
                         FROM    @i_xml.nodes('App_EdgeDriveAssocCheckReq') R ( ref )), '')
SET @clientToUse = ISNULL((SELECT  ref.value('@clientId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_EdgeDriveAssocCheckReq/clientToUse') R ( ref )), 0)
DECLARE @syncFolderInfo TABLE
	(
	        syncFolderId INT,
	        syncFolderName NVARCHAR(MAX)
	)
IF @entityType <> 7 AND @entityType <> 13
BEGIN
	SET @errorCode = -1
	SET @errorString = 'Invalid entity type.'
END
SET @inputEntity =(	SELECT @userId AS '@userId',
						   @subclientId AS '@subclientId',
						   @entityType as '@_type_'
					FOR XML PATH('entity'))
---------------------CASE :SUBCLIENT-----------------------------
---This case , we need an indication if this is an Edge Drive Subclient and if so, the Edge Drive User for which the subclient got created
IF @entityType = 7
BEGIN
IF(  EXISTS(SELECT 1 FROM App_Application WITH(nolock) WHERE id = @subclientId))
	BEGIN
	SET @userId = ISNULL((SELECT attrVal FROM APP_BackupSetProp ABP INNER JOIN App_Application AAP ON ABP.componentNameId = AAP.backupset WHERE AAP.id = @subclientId AND ABP.attrName = 'Edge Drive User Id' ) ,0)
		IF NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @userId)
	BEGIN
		SET @errorCode = 2;
		SET @errorString = 'Unknown User'
		GOTO GENERATE_OUTPUT
	END
END
	ELSE
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Invlid Entity Info. Entity Type : Subclient. SubclientId : ['+ CAST(@subclientId AS NVARCHAR(100))+']'
		GOTO GENERATE_OUTPUT
	END
END
------------------END CASE : SUBCLIENT-----------------------------
---------------------CASE :USER------------------------------------
IF @entityType = 13
BEGIN
IF (EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @userId))
	BEGIN
		SET @subclientId = ISNULL(( SELECT TOP 1 AAP.id
									FROM APP_BackupSetProp ABP
									INNER JOIN App_Application AAP ON ABP.componentNameId = AAP.backupset
									WHERE ABP.attrName = 'Edge Drive User Id' AND
									ABP.attrVal = CAST(@userId AS NVARCHAR(256)) AND ABP.modified =0
									AND (@clientToUse = 0 OR AAP.clientId = @clientToUse)
								   ) ,0)
		SET @userLoginName = (SELECT login FROM UMUsers WITH(nolock) WHERE id = @userId)
	END
	ELSE
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Invlid Entity Info. Entity Type : User. UserId : ['+ CAST(@userId AS NVARCHAR(100))+']'
		GOTO GENERATE_OUTPUT
END
END
------------------END CASE : USER-----------------------------
	DECLARE @edgeClientsWithCapabilities TABLE
	(clientId INT, clientStatus INT, capabilities BIGINT,userAssociationType INT)
	INSERT INTO @edgeClientsWithCapabilities
	EXEC AppGetEdgeCapabilties @userId, NULL
	SET @clientId = ISNULL((SELECT TOP 1 EC.clientId
							FROM @edgeClientsWithCapabilities  EC
							INNER JOIN App_EdgeDriveAssociation EDA ON EDA.clientId = EC.clientId AND EDA.entityType = 3 AND EDA.entityId > 1
							WHERE capabilities & 4112 = 4112 -- Client with upload and browse capability
							AND (@clientToUse = 0 OR EC.clientId = @clientToUse)
ORDER BY (EC.clientStatus & 0x40000000) DESC, EC.userAssociationType DESC), 0)
SET @isContentStore = ISNULL((SELECT 1 FROM APP_client WITH(NOLOCK) WHERE id = @clientId AND status & 0x40000000 <> 0), 0)
	SET @scpId  = ISNULL( (SELECT  entityId
							FROM   App_EdgeDriveAssociation WITH(nolock)
							WHERE  entityType = 65 AND clientId = @clientId), 0)
	IF @contentStoreType <> '' AND @isContentStore = 0
	BEGIN
		SET @errorCode = 1;
		SET @errorString = 'Unable to create content store drive as Content Store Client not found for UserId : ['+ CAST(@userId AS NVARCHAR(100))+'].'
		GOTO GENERATE_OUTPUT
	END
	IF @isContentStore = 1
	BEGIN
		SET @contentStoreClientType =	ISNULL((SELECT CAST(attrVal AS INT)
												FROM App_ClientProp
												WHERE componentNameId = @clientId AND modified = 0 AND attrName = 'System Drive Type'), 0)
	END
	IF ( EXISTS(SELECT 1 FROM App_Client WITH(nolock) WHERE id = @clientId) AND
		 EXISTS(SELECT 1 FROM App_BackupsetName WITH(nolock) WHERE id = @scpId))
	BEGIN
		IF @subclientId = 0   --if User does not have an Edge Drive Subclient, we need to create one.
		BEGIN
			SET @userBackupsetName = @userLoginName
			-- If it is outlook addin content store, multiple subclients are allowed.
			IF @contentStoreClientType NOT IN(2, 7) -- OUTLOOK_ADDIN_STORE, FILESTORE in App.x
			BEGIN
				--final check if the backupset already exists
				IF (EXISTS(SELECT 1 FROM App_BackupsetName WITH(nolock) WHERE name = @userLoginName) OR
					EXISTS(SELECT 1 FROM App_BackupsetProp WITH(nolock) WHERE attrName = 'Edge Drive User Id' AND attrVal = CAST(@userId AS NVARCHAR(100) )))
				BEGIN
					SET @errorCode = 1;
					SET @errorString = 'Cannot have 2 subclients under single User specific Backup Set.UserId : ['+ CAST(@userId AS NVARCHAR(100))+']'
					GOTO GENERATE_OUTPUT
				END
			END
			ELSE IF @contentStoreClientType = 7 -- FILESTORE
			BEGIN
				SET @userBackupsetName = 'FileStore'
			END
			SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
			INSERT INTO APP_BackupSetName
			VALUES(@userBackupsetName, @nowTime, @nowTime, 0, 0, 0, 2, NEWID())
			SET @userBackupsetId = SCOPE_IDENTITY()
			INSERT INTO APP_BackupSetProp
			VALUES	(@userBackupsetId, 'Use Change Journal', 2, '1', @nowTime, 0, 0),
					(@userBackupsetId, 'Pre 7.0 System State Archive Files Exist', 2, '0', @nowTime, 0, 0),
					(@userBackupsetId, 'NAS Turbo Backupset', 7, '2', @nowTime, 0, 0),
					(@userBackupsetId, 'Edge Drive User Id', 7, CAST(@userId AS NVARCHAR(10)), @nowTime, 0, 0),
					(@userBackupsetId, 'Associated subclient Policy', 7, CAST(@scpId AS NVARCHAR(10)), @nowTime, 0, 0)
			SET @storagePolicyId = (SELECT TOP 1 dataArchGrpID FROM APP_Application WITH(nolock) WHERE backupset = @scpId)
DECLARE @applicationTypeId INT = ISNULL((SELECT 29 WHERE EXISTS(
SELECT 1 FROM APP_BackupSetprop where componentNameId=@scpId and attrname='Associated subclient Policy Ida Type' and attrVal='3')),33)
			--SCP_UNIX-3  	CV_APPTYPE_LINUX_FS-29| CV_APPTYPE_WINDOWS_FILESYSTEM-33
			INSERT INTO APP_Application
			VALUES( @clientId , @applicationTypeId, 1, @userBackupsetId, 0, @storagePolicyId, @storagePolicyId, @nowTime, @nowTime, @userBackupsetName, 131080, 0, 0, 2, NEWID())
			SET @defaultsubclientId = SCOPE_IDENTITY()
			SET @appId = (SELECT TOP 1 id FROM APP_Application WITH(nolock) WHERE backupset = @scpId AND (subclientStatus & 8) = 8)
			INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			VALUES	(@defaultsubclientId, 'Associated subclient Policy', 10 , CAST(@appId AS NVARCHAR(10)), @nowTime, 0,0),
					(@defaultsubclientId, 'Single Instancing Option', 7, '1', @nowTime, 0,0),
					(@defaultsubclientId, 'Encrypt: encryption', 10, '2', @nowTime, 0,0),
					(@defaultsubclientId, 'Keep items past their expiration', 2, '1', @nowTime, 0,0),
					(@defaultsubclientId, 'Archived expiration days', 7, '-1', @nowTime, 0,0),
					(@defaultsubclientId, 'Decouple SCP Content', 1, '0', @nowTime, 0,0),
					(@defaultsubclientId, 'System State', 2, '0', @nowTime, 0,0),
					(@defaultsubclientId, 'System State on Full Backup Only', 2, '0', @nowTime, 0,0),
					(@defaultsubclientId, 'sys:nStreams', 7, '2', @nowTime, 0,0),
					(@defaultsubclientId, 'use global filters', 2, '0', @nowTime, 0,0),
					(@defaultsubclientId, 'Use VSS Enabled', 2, '0', @nowTime, 0,0),
					(@defaultsubclientId, 'Use VSS Options', 7, '0', @nowTime, 0,0),
					(@defaultsubclientId, 'Days to keep items past their expiration', 7, '0', @nowTime, 0,0),
					(@defaultsubclientId, 'use cs setting for global filters', 2, '0', @nowTime, 0,0),
					(@defaultsubclientId, 'Edge Drive User Id', 7, CAST(@userId AS NVARCHAR(10)), @nowTime, 0, 0)
			-- Insert content store type
			IF @isContentStore = 1
			BEGIN
				IF @contentStoreType <> ''
					INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					VALUES(@defaultsubclientId, 'Edge Content Store Type', 1, @contentStoreType, @nowTime, 0, 0)
			END
			--Insert NFS Share Enabled info for NFS_OBJECT_STORE
			If @contentStoreClientType = 4 --NFS_OBJECT_STORE in App.x
			BEGIN
				INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES	(@defaultsubclientId, '3dfs Is NFS Share Enabled', 2, '1', @nowTime, 0, 0),
						(@defaultsubclientId, '3dfs config operation in process', 2, '1', @nowTime, 0, 0) -- Adding this flag to not allow creation of PIT views till share export completes
			END
			--Insert into APP_ScFilterFile
			INSERT INTO APP_ScFilterFile (componentNameId, type, fileName, created, modified, ccpId)
VALUES( @defaultsubclientId, 1 , 'EDGEDRIVE' ,@nowTime, 0, 0)
			-- Insert archpipeconfig
			INSERT INTO archPipeConfig(appNumber, compressWhere, numNWAgents, NWWriteSpeed)
			SELECT @defaultsubclientId, compressWhere, numNWAgents, NWWriteSpeed
			FROM archPipeConfig
			WHERE appNumber = @appId
DECLARE @adminUser INT = (SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE flags & 0x040 <> 0)
			DECLARE @allEdgeCapabilities TABLE
			(capabilityId INT, capabilityValue BIGINT)
			INSERT INTO @allEdgeCapabilities
			SELECT id, CAST(POWER(2.0, id - 1) AS BIGINT)
			FROM UMCapability
			WHERE name in ('Upload', 'Download', 'Browse', 'In Place Recover', 'Out of Place Recover', 'Sharing')
			IF @contentStoreClientType = 3 -- RECORDS_MANAGER in App.x
			BEGIN
				-- Dont allow edit operations from webconsole
				DELETE AE
				FROM @allEdgeCapabilities AE
				INNER JOIN UMCapability U ON AE.capabilityId = U.id
				WHERE U.name = 'Upload'
			END
			-- Add security entries
			INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId)
			SELECT 0, EAC.capabilityId, @userId, 1, 1, 1, 0, 0, 0, 3, APP.clientId, 4, APP.appTypeId, 5, APP.instance, 6, APP.backupSet, 7, APP.id, 0, 0, @adminUser
			FROM @edgeClientsWithCapabilities EC
			INNER JOIN App_Application APP ON APP.clientId = EC.clientId
			INNER JOIN @allEdgeCapabilities EAC ON EC.capabilities & EAC.capabilityValue <> 0
			WHERE APP.id = @defaultsubclientId
			-- This is needed to populate correct security entries
			exec sec_updateUserCredentials @userId, 1
			SET @subclientId = @defaultsubclientId
		END
	END
	ELSE
	SET @warningCode = 2
IF @subclientId > 0
	BEGIN
		select @clientId = APP.ClientId, @userBackupsetId = APP.backupSet from APP_Application APP where App.Id = @subclientId
		IF(EXISTS(select 1 from App_EdgeDriveAssociation where clientId = @clientId and entitytype = 3))
			BEGIN
				DECLARE @indexServerRoleName NVARCHAR(MAX) = ISNULL((SELECT CAST('NFS Index' AS NVARCHAR(20)) FROM APP_ClientProp CP
																		WHERE CP.componentNameId = @clientId AND CP.attrName = 'System Drive Type' AND attrval='4' ),
															'EDGE Drive')
				set @outCloudId = (SELECT 	TOP 1 DM.CloudId
								   FROM 	DM2SearchServerCoreInfo DM 	INNER JOIN DM2Cloud C ON DM.CloudId = C.cloudId
																	INNER JOIN DM2CloudCoreRole R ON DM.CloudId = R.CloudId
																	INNER JOIN DM2CloudRoleMaster RM ON RM.roleType = R.roleId AND RM.roleTypeName = @indexServerRoleName
								   WHERE 	C.pseudoClientId IN (SELECT entityId
														 FROM 	App_EdgeDriveAssociation AE
														 WHERE 	AE.clientId = @clientId AND AE.entityType = 3))
				--
				IF OBJECT_ID(N'tempdb.dbo.#UMUserCredentialCache') IS NOT NULL DROP TABLE #UMUserCredentialCache
				--
create table  #UMUserCredentialCache ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
				--
				exec sec_getUserObjects @userId,2013,0,'#UMUserCredentialCache'
				--
				--Commcell Capability
				DECLARE @CCLevelSec BIGINT = 0
				SELECT @CCLevelSec = userCredential.capabilities FROM #UMUserCredentialCache AS userCredential
WHERE userCredential.commCellId=2 AND userCredential.clientGroupId=0 AND userCredential.clientId=0 AND userCredential.appTypeId=0 AND userCredential.instanceId=0 AND userCredential.backupsetId=0 AND userCredential.subClientId=0 AND userCredential.mediaAgentId=0 AND userCredential.libraryId=0 AND userCredential.archGroupId=0 AND userCredential.vtContainerId=0 AND userCredential.vtPolicyId=0 AND userCredential.vtShelfId=0 AND userCredential.reviewSetId=0 AND userCredential.querySetId=0 AND userCredential.downloadSetId=0 AND userCredential.ermId=0 AND userCredential.legalHoldId=0 AND userCredential.tagId=0 AND userCredential.cdPolicyId=0 AND userCredential.complianceReportId=0 AND userCredential.taskId=0 AND userCredential.workflowId=0 AND userCredential.logMonitoringPolicyId=0 AND userCredential.arrayId=0 AND userCredential.cloudId=0 AND userCredential.userGroupId=0 AND userCredential.providerId=0 AND userCredential.entityId1=0 AND userCredential.entityId2=0 AND userCredential.entityId3=0 AND userCredential.entityId4=0 AND userCredential.entityId5=0									AND userCredential.entityId6=0 AND userCredential.entityId7=0 AND userCredential.entityId8=0 AND userCredential.entityId9=0
				--Edge Subclient capability
				DECLARE @subClientLevelSec BIGINT = 0
				SELECT @subClientLevelSec = userCredential.capabilities FROM #UMUserCredentialCache AS userCredential
				WHERE userCredential.subClientId = @subclientId
				--
				SET @outCapabilities = ISNULL(@CCLevelSec,0) | ISNULL(@subClientLevelSec,0)
				-- if the client is not licensed remove upload capability
IF EXISTS (SELECT 1 FROM App_Client CL WITH (NOLOCK) WHERE id = @clientId AND (CL.Status & 0x00002 = 0x00002))
					SET @outCapabilities  = @outCapabilities & ~@capUpload
				--
				SET @contentIndexingEnabled = ISNULL((	select top 1 CAST(attrVal AS INT)
														From APP_ClientProp
														where attrName = 'Content Indexing Enabled' and modified = 0 and componentNameId = @clientId),0)
			  SET @appTypeId = (select appTypeId from APP_Application where id = @subclientId)
			  SET @dirDelim = (select dirDelim  from APP_iDAType idatType where type =  @appTypeId)
			END
		ELSE
			BEGIN
				SET @errorCode = 10005; --Error code for missing index server as defined in EvSvr2Static.h
				SET @errorString = 'No Index server is configured for client : ['+ CAST(@clientId AS NVARCHAR(100))+']'
				GOTO GENERATE_OUTPUT
			END
	END
	INSERT INTO @syncFolderInfo
	SELECT syncWebFolderId, syncWebFolderName
	FROM App_SyncCloudFolder
WHERE ownerId = @userId AND flag & 0x10 <> 0
	IF EXISTS(
	                        SELECT 1 FROM App_SyncCloudConfig CF
	                        JOIN @syncFolderInfo SF ON SF.syncFolderId = CF.syncWebFolderId
	                                AND CF.syncType & 3 = 3
	                        JOIN APP_Client C ON C.id = CF.clientId AND C.releaseId >= 16
	                        WHERE CF.syncWebFolderId = SF.syncFolderId
	                        AND
	                        EXISTS(SELECT 1 FROM simInstalledPackages P WHERE P.ClientId = C.id AND C.releaseId > 16 OR (C.releaseId = 16 AND P.HighestSP >= 4))    --ALL CLIENTS ARE AT 11.0 SP5 OR LARGER
	                )
	        SET @hasEdgeDriveEnabledLaptop = 1
	IF EXISTS(
					SELECT 1 FROM App_SyncCloudConfig CF
	                INNER JOIN @syncFolderInfo SF ON SF.syncFolderId = CF.syncWebFolderId
AND CF.syncType & 3 = 3 AND CF.FLAG & 0x20 = 0x20
	         )
		BEGIN
			SET @hasSyncBlackListedLaptop = 1
		END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing Stored Procedure. Error Message [' + ERROR_MESSAGE() + '].'
	GOTO GENERATE_OUTPUT
END CATCH
GENERATE_OUTPUT:
SET @r_errors = ( SELECT @warningCode 		AS '@warningCode',
							@errorCode 		AS '@errorCode',
							@errorString 	AS '@errorString',
							@inputEntity
					FOR xml PATH('error'))
SET @r_entity = ( SELECT @userId 				AS '@userId',
						 @clientId 				AS  '@clientId',
						 CL.name				AS '@clientName',
						 @userBackupsetId 		AS '@backupsetId',
						 BS.name				AS '@backupsetName',
						 @subclientId 			AS '@subclientId',
						 APP.subclientName		AS '@subclientName',
						 @scpId 				AS '@subclientPolicyId',
						 APP.appTypeId			AS '@applicationId',
						 APP.instance			AS '@instanceId',
						 INS.name				AS '@instanceName'
				  FROM 	APP_Application APP WITH(NOLOCK)
				  INNER JOIN APP_Client CL WITH (NOLOCK) ON APP.clientId = CL.id
				  INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON APP.backupSet = BS.id
				  INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON APP.instance= INS.id
				  WHERE APP.id = @subclientId
					FOR xml PATH('edgeDriveAssociations'))
SET @r_edgeDriveInfo = ( SELECT @outCloudId 		AS '@cloudId',
								@outCapabilities 	AS '@capabilities',
								NULL 				AS '@rootGUID',
								@contentIndexingEnabled AS '@contentIndexingEnabled',
								@hasEdgeDriveEnabledLaptop AS '@hasEdgeDriveEnabledLaptop',
								@dirDelim 			AS '@dirDelim',
								@contentStoreClientType AS '@driveType'
				FOR xml PATH('edgeDriveInfo'))
SET @out_xml = ( SELECT @r_errors,@r_entity,@r_edgeDriveInfo  FOR XML PATH(''),ROOT('App_EdgeDriveAssocCheckResp'))
SELECT @out_xml o_xmlText
--
IF OBJECT_ID(N'tempdb.dbo.#UMUserCredentialCache') IS NOT NULL DROP TABLE #UMUserCredentialCache
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSCPForEdgeDriveUser')
	delete from GxQscripts where name = 'AppGetSCPForEdgeDriveUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSCPForEdgeDriveUser')
	delete from GXDBVersions where aliasname = 'AppGetSCPForEdgeDriveUser'
GO

insert into GXDBVersions values(2, 'AppGetSCPForEdgeDriveUser',  '00010022000200260000', 'AppGetSCPForEdgeDriveUser', '00010022000200260000')
GO

