

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSCGAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =================================================================
-- Author:			Mohammad Dilshad
-- Create date: 	06/15/2015
-- Description:		get the SmartClientGroupAssociation for audit
-- 10/21/2016 - AEB Performance Tuned
-- =================================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetSCGAssociation <<<'

IF EXISTS (select * from sysobjects where name='AppGetSCGAssociation')
	drop procedure AppGetSCGAssociation
IF EXISTS (select * from GxQscripts where name='AppGetSCGAssociation')
	delete from GxQscripts where name = 'AppGetSCGAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSCGAssociation')
	delete from GXDBVersions where aliasname = 'AppGetSCGAssociation'
GO
print '... Creating Procedure: AppGetSCGAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSCGAssociation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXml XML,
  @flag int
AS
  DECLARE @r_xmlText XML;
BEGIN
	DECLARE @xmlText XML
	----------------------------
	----FETCH THE GROUPS-------
	----------------------------
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF object_id('tempdb.dbo.#smartClientGroupAssoc') IS NOT NULL
		DROP TABLE #smartClientGroupAssoc
	CREATE TABLE #smartClientGroupAssoc (
		[clientGroupId] INT NOT NULL,
		[clientId] INT NOT NULL,
		[status] INT DEFAULT 1,
		PRIMARY KEY ([clientGroupId], [clientId])
	)
	INSERT INTO #smartClientGroupAssoc (clientGroupId, clientId)
		SELECT DISTINCT
			[clientGroupId] = CLA.[clientGroupId],
			[clientId] = CLA.[clientId]
		FROM [APP_ClientGroup] AS CLG
		INNER JOIN [APP_ClientGroupAssoc] AS CLA WITH (NOLOCK) ON (
				STATUS & 2 <> 2
				AND (CLG.flag & 0x1000) <> 0
				)
			AND CLA.[clientGroupId] = CLG.[id]
	----------------------------
	--CONSTRUCT THE XML---------
	----------------------------
	IF @flag = 0
	BEGIN
		SET @xmlText = (
				SELECT --CLIENTGROUP
					CLG.[clientGroupId] AS '@clientGroupId',
					CLG.[clientId] AS '@clientId'
				FROM #smartClientGroupAssoc AS CLG
				FOR XML PATH('association'),
					ROOT('Api_ClientGroupAssociationList'), TYPE
				)
	END
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#smartClientGroupAssocOld') IS NOT NULL
			DROP TABLE #smartClientGroupAssocOld
		CREATE TABLE #smartClientGroupAssocOld (
			[clientGroupId] INT NOT NULL,
			[clientId] INT NOT NULL,
			[status] INT,
			PRIMARY KEY ([clientGroupId], [clientId])
		)
		-- Reading Old Assoc from XML.
		INSERT INTO #smartClientGroupAssocOld
			SELECT
				t.clientGroupId,
				t.clientId,
				1 [status]
			FROM (
					SELECT
						Tbl.Col.value('@clientGroupId', 'int') clientGroupId,
						Tbl.Col.value('@clientId', 'int') clientId
					FROM @inXml.nodes('Api_ClientGroupAssociationList/association') Tbl(Col)
				) t
			WHERE
				-- remove bad rows
				t.clientGroupId IS NOT NULL
				AND t.clientId IS NOT NULL
		-- Marking All newly associated Clients
		UPDATE SCG
			SET status = 0
		FROM #smartClientGroupAssoc SCG
			INNER JOIN #smartClientGroupAssocOld AS SCGO ON
				SCG.clientGroupId = SCGO.clientGroupId
				AND SCG.clientId = SCGO.clientId
		-- Marking All newly De-associated Clients
		UPDATE SCGO
			SET status = 0
		FROM #smartClientGroupAssocOld SCGO
			INNER JOIN #smartClientGroupAssoc SCG ON
				SCG.clientGroupId = SCGO.clientGroupId
				AND SCG.clientId = SCGO.clientId
		SET @xmlText = (
				SELECT --CLIENTGROUP
					CLG.[id] AS '@clientGroupId',
					CLG.[name] AS '@clientGroupName',
					(
						SELECT CL.[name] + ','
						FROM #smartClientGroupAssoc AS ACL
							INNER JOIN [APP_Client] AS CL WITH (NOLOCK) ON
								CGA.[clientGroupId] = ACL.[clientGroupId]
								AND CL.[id] = ACL.[clientId]
								AND ACL.[status] = 1
						FOR XML path('')
						) AS '@addedClientNames',
					(
						SELECT CL.[name] + ','
						FROM #smartClientGroupAssocOld AS DCL
							INNER JOIN [APP_Client] AS CL WITH (NOLOCK) ON
								CGA.[clientGroupId] = DCL.[clientGroupId]
								AND CL.[id] = DCL.[clientId]
								AND DCL.[status] = 1
						FOR XML path('')
						) AS '@deletedClientNames'
				FROM (
						SELECT
							clientGroupId
						FROM #smartClientGroupAssoc
						WHERE [status] = 1
						UNION
						SELECT
							clientGroupId
						FROM #smartClientGroupAssocOld
						WHERE [status] = 1
					) AS CGA
					INNER JOIN [APP_ClientGroup] AS CLG WITH (NOLOCK) ON
						CGA.[clientGroupId] = CLG.[id]
				FOR XML PATH('clientGroups'),
					ROOT('Api_SmartClientGroupList')
				);
		IF object_id('tempdb.dbo.#smartClientGroupAssocOld') IS NOT NULL
			DROP TABLE #smartClientGroupAssocOld
	END
	IF object_id('tempdb.dbo.#smartClientGroupAssoc') IS NOT NULL
		DROP TABLE #smartClientGroupAssoc
	SELECT @xmlText r_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSCGAssociation')
	delete from GxQscripts where name = 'AppGetSCGAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSCGAssociation')
	delete from GXDBVersions where aliasname = 'AppGetSCGAssociation'
GO

insert into GXDBVersions values(2, 'AppGetSCGAssociation',  '00000000000000000000', 'AppGetSCGAssociation', '00000000000000000000')
GO

