

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetSAPHANAEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetSAPHANAEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppGetSAPHANAEntities <<<'
	drop procedure AppGetSAPHANAEntities
END
IF EXISTS (select * from GxQscripts where name='AppGetSAPHANAEntities')
	delete from GxQscripts where name = 'AppGetSAPHANAEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSAPHANAEntities')
	delete from GXDBVersions where aliasname = 'AppGetSAPHANAEntities'
GO
print '... Creating Procedure: AppGetSAPHANAEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetSAPHANAEntities
  @inXML xml
AS
  DECLARE @outXML xml
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	--Debug
	--SET @inXML = '<App_GetSAPHANAClientAndInstanceIdsReq hanaInstanceName="MTN" hanaTenantDbName="SYSTEMDB"><hanaMemberClient clientId="3045" /></App_GetSAPHANAClientAndInstanceIdsReq>'
	DECLARE @inClientId				INT
	DECLARE @inHanaInstanceName		NVARCHAR(1024)
	DECLARE @inHanaTenantDB			NVARCHAR(1024)
	DECLARE @inHanaClientFlag		INT
	SET @inClientId				= ISNULL (( SELECT ref.value('@clientId', 'INTEGER')FROM @inXMl.nodes('App_GetSAPHANAClientAndInstanceIdsReq/hanaMemberClient') R(ref)), 0)
	SET @inHanaInstanceName		= ISNULL (( SELECT ref.value('@hanaInstanceName', 'NVARCHAR(1024)')FROM @inXMl.nodes('App_GetSAPHANAClientAndInstanceIdsReq') R(ref)), 0)
	SET @inHanaTenantDB			= ISNULL (( SELECT ref.value('@hanaTenantDbName', 'NVARCHAR(1024)')FROM @inXMl.nodes('App_GetSAPHANAClientAndInstanceIdsReq') R(ref)), 0)
	SET @inHanaClientFlag		= ISNULL (( SELECT ref.value('@hanaClientType', 'INT')FROM @inXMl.nodes('App_GetSAPHANAClientAndInstanceIdsReq') R(ref)), 0)
	DECLARE @includeDeconfigured INT = (@inHanaClientFlag & 1)
	DECLARE @clientId				INT
	DECLARE @instanceId				INT
	DECLARE @backupsetId			INT
	DECLARE @defaultSubclient		INT
	DECLARE @cmdLineSubclient		INT
	DECLARE @logCmdlineSubclient	INT
	IF @inClientId <> 0 /*ClientId*/
	BEGIN
		SET @backupsetId = (
		SELECT	TOP 1 A.backupSet
		FROM	APP_Application A
			INNER JOIN APP_InstanceName I
ON A.instance = I.id AND I.name = @inHanaInstanceName AND (@includeDeconfigured = 1 OR ((I.status & 0x00002) = 0 AND (I.status & 0x00004) = 0))
			INNER JOIN APP_InstanceProp IP
				ON I.id = IP.componentNameId
			INNER JOIN APP_BackupSetName B
ON A.backupSet = B.id AND (@inHanaTenantDB = '' OR B.name = @inHanaTenantDB) AND (@includeDeconfigured = 1 OR ((B.status & 0x00002) = 0 AND (B.status & 0x00004) = 0))
			CROSS APPLY dbo.SplitString(IP.attrVal, '+') S
		WHERE A.appTypeId = 135 AND IP.attrName = 'Database Clients' AND IP.modified = 0
		AND S.Data = @inClientId
		)
		SELECT @clientId = clientId from APP_Application WHERE backupSet = @backupsetId
		SELECT @instanceId = instance from APP_Application WHERE backupSet = @backupsetId
		SELECT @defaultSubclient = id from APP_Application where backupSet = @backupsetId and (subclientStatus & 8) <> 0
		SELECT @cmdLineSubclient = id from APP_Application where backupSet = @backupsetId and (subclientStatus & 64) <> 0
		SELECT @logCmdlineSubclient = id from APP_Application where backupSet = @backupsetId and (subclientStatus & 4096) <> 0
		SET @outXML =	(
							SELECT	@clientId AS 'defaultSubclient/@clientId',
									@backupsetId AS 'defaultSubclient/@backupsetId',
									@instanceId AS 'defaultSubclient/@instanceId',
									@defaultSubclient AS 'defaultSubclient/@subclientId',
									@cmdLineSubclient AS 'cmdlineSubclient/@subclientId',
									@logCmdlineSubclient AS 'logCmdlineSubclient/@subclientId'
							FOR XML PATH('App_GetSAPHANAClientAndInstanceIdsResp'), TYPE
						)
	END
	IF @outXML IS NULL
		SET @outXML = '<App_GetSAPHANAClientAndInstanceIdsResp/>'
	SELECT @outXML
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- return error response
	SET @outXML = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE)
	SELECT @outXML;
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetSAPHANAEntities')
	delete from GxQscripts where name = 'AppGetSAPHANAEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetSAPHANAEntities')
	delete from GXDBVersions where aliasname = 'AppGetSAPHANAEntities'
GO

insert into GXDBVersions values(2, 'AppGetSAPHANAEntities',  '00000000000000000000', 'AppGetSAPHANAEntities', '00000000000000000000')
GO

