

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRunningSyncJobs.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2016  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetRunningSyncJobs.sp,v $ $Id: AppGetRunningSyncJobs.sp,v 1.1.2.2 2018/01/12 16:01:34 ssanur Exp $";
-- =========================================================
-- Author: Sarath Joseph
-- Description: Get running live sync jobs
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRunningSyncJobs <<<'

IF EXISTS (select * from sysobjects where name='AppGetRunningSyncJobs')
	drop procedure AppGetRunningSyncJobs
IF EXISTS (select * from GxQscripts where name='AppGetRunningSyncJobs')
	delete from GxQscripts where name = 'AppGetRunningSyncJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRunningSyncJobs')
	delete from GXDBVersions where aliasname = 'AppGetRunningSyncJobs'
GO
print '... Creating Procedure: AppGetRunningSyncJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRunningSyncJobs
  @xmlText XML
AS
SET NOCOUNT ON;
		Declare @taskId INT = @xmlText.value('(JobManager_GetRunningSyncJobsReq/task)[1]/@taskId', 'int')
		SET @xmlText = (
		select
		(
		  select I.jobId as '@jobID'
		  from JMJobInfo I WITH(NOLOCK) JOIN TM_Jobs J WITH(NOLOCK) ON J.jobId = I.jobId
		  JOIN TM_JobRequest R WITH(NOLOCK) ON R.jobRequestId = J.jobRequestId
		  JOIN TM_SubTask S WITH(NOLOCK)ON S.subTaskId = R.subTaskId
		  where S.taskId = @taskId
		for xml path ('job'),TYPE
		)
		for xml path ('JobManager_GetRunningSyncJobsResp'),TYPE)
		select isnull(@xmlText, '<JobManager_GetRunningSyncJobsResp/>')
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRunningSyncJobs')
	delete from GxQscripts where name = 'AppGetRunningSyncJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRunningSyncJobs')
	delete from GXDBVersions where aliasname = 'AppGetRunningSyncJobs'
GO

insert into GXDBVersions values(2, 'AppGetRunningSyncJobs',  '00010001000200020000', 'AppGetRunningSyncJobs', '00010001000200020000')
GO

