

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRunningJobsOnExchClient.sp] ---------- 

--  +===================================================================================+
--  | Name        :  AppGetRunningJobsOnExchClient()                                |
--  | Description :  Gets the running job ids given an exchange client id           |
--  +===================================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRunningJobsOnExchClient <<<'

IF EXISTS (select * from sysobjects where name='AppGetRunningJobsOnExchClient')
	drop procedure AppGetRunningJobsOnExchClient
IF EXISTS (select * from GxQscripts where name='AppGetRunningJobsOnExchClient')
	delete from GxQscripts where name = 'AppGetRunningJobsOnExchClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRunningJobsOnExchClient')
	delete from GXDBVersions where aliasname = 'AppGetRunningJobsOnExchClient'
GO
print '... Creating Procedure: AppGetRunningJobsOnExchClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRunningJobsOnExchClient
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @i_clientId 	INT
	SET     @o_ErrorCode  = 0
	SET     @o_xmlText    = '<App_GetRunningJobsOnExchClientResp />'
	SET     @i_clientId   = ISNULL((SELECT ref.value('@clientId','int') FROM @i_xmlText.nodes('App_GetRunningJobsOnExchClientReq') R ( ref )), 0)
	IF @i_clientId = 0
	BEGIN
		SET @o_ErrorCode   = 1
		SET @o_ErrorString = 'Client ID not found. Invalid client.'
		GOTO EXIT_PROC
	END
	SET @o_xmlText =
	(
		SELECT
			(SELECT j.jobid '@val'
				FROM JMJobInfo j JOIN JMBkpJobInfo b
				ON j.jobId = b.jobId
				JOIN APP_Application a
				ON b.applicationId = a.id WHERE a.clientId = @i_clientId AND a.appTypeId = 137
				FOR XML PATH('jobIds'), TYPE
			),
			(SELECT j.jobid '@val'
				FROM JMJobInfo j JOIN JMRstJobInfo r
				ON j.jobId = r.jobId WHERE r.srcClientId = @i_clientId AND r.appType = 137
				FOR XML PATH('jobIds'), TYPE
			),
			(SELECT j.jobid '@val'
				FROM JMJobInfo j JOIN JMAdminJobInfoTable ad
				ON j.jobId = ad.jobId
				JOIN APP_Application a
				ON ad.appID = a.id WHERE a.clientId = @i_clientId AND a.appTypeId = 137
				FOR XML PATH('jobIds'), TYPE
			)
			FOR XML PATH(''), ROOT('App_GetRunningJobsOnExchClientResp'), TYPE
	)
	EXIT_PROC:
    IF @o_ErrorCode > 0
    BEGIN
        SET @o_xmlText =
        (
            SELECT @o_ErrorCode '@errorCode',
                    @o_ErrorString '@errorMessage'
            FOR XML PATH ('error'), ROOT('App_GetRunningJobsOnClientResp')
        )
    END
    SELECT @o_xmlText
END
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRunningJobsOnExchClient')
	delete from GxQscripts where name = 'AppGetRunningJobsOnExchClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRunningJobsOnExchClient')
	delete from GXDBVersions where aliasname = 'AppGetRunningJobsOnExchClient'
GO

insert into GXDBVersions values(2, 'AppGetRunningJobsOnExchClient',  '00000000000000000000', 'AppGetRunningJobsOnExchClient', '00000000000000000000')
GO

