

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRightsOnCMCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  			 	 AppGetRightsOnCMCredentials						|
--	|			Return Permission on credential entity					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRightsOnCMCredentials <<<'

IF EXISTS (select * from sysobjects where name='AppGetRightsOnCMCredentials')
	drop procedure AppGetRightsOnCMCredentials
IF EXISTS (select * from GxQscripts where name='AppGetRightsOnCMCredentials')
	delete from GxQscripts where name = 'AppGetRightsOnCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRightsOnCMCredentials')
	delete from GXDBVersions where aliasname = 'AppGetRightsOnCMCredentials'
GO
print '... Creating Procedure: AppGetRightsOnCMCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRightsOnCMCredentials
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_userId integer,
  @i_credentialId integer
-----------------------------------------------------------
AS
  DECLARE @hasRights integer;
  DECLARE @o_ErrorCode integer;
  DECLARE @o_ErrorString nvarchar(max);
SET NOCOUNT ON
BEGIN TRY
	SET @hasRights = 0
EXEC sec_checkPermissionOnEntity @i_userId,218,@hasRights OUTPUT,174,@i_credentialId
	IF @hasRights = 0
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL DROP TABLE dbo.#getMemberUserGroupsHelperOutputTbl
		create table #getMemberUserGroupsHelperOutputTbl
		(
			isUser int,
			userOrGroupId int
		);
		EXEC sec_getMemberUserGroupsHelper @i_userId
		IF EXISTS(SELECT 1 FROM UMSecurityAssociations Sec INNER JOIN #getMemberUserGroupsHelperOutputTbl Tbl ON Sec.isUser = Tbl.isUSer AND Sec.userOrGroupId = Tbl.userOrGroupId
WHERE entityType1 = 174	AND isCreator = 1 AND entityId1=@i_credentialId)
			SET @hasRights = 1
		IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') is not null drop table dbo.#getMemberUserGroupsHelperOutputTbl
	END
	SET @o_ErrorCode = @@ERROR
    IF @hasRights = 0
        SET @o_ErrorString = 'User does not have required capability on Credential Entity'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_ErrorCode = ERROR_NUMBER()
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2722 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = 0)
	SET @hasRights = 0
END CATCH
SELECT @hasRights, @o_ErrorCode, @o_ErrorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRightsOnCMCredentials')
	delete from GxQscripts where name = 'AppGetRightsOnCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRightsOnCMCredentials')
	delete from GXDBVersions where aliasname = 'AppGetRightsOnCMCredentials'
GO

insert into GXDBVersions values(2, 'AppGetRightsOnCMCredentials',  '00000000000000000000', 'AppGetRightsOnCMCredentials', '00000000000000000000')
GO

