

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRestoreClients.sp] ---------- 

--  +=============================================================================================+
--  |						Name: AppGetRestoreClients()
--  | Description: Fetches restore client entities based on filters
--  |
--  |       Input: XML
--  |      Output: XML containing list of restore client entities
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetRestoreClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetRestoreClients <<<'
	drop procedure AppGetRestoreClients
END
IF EXISTS (select * from GxQscripts where name='AppGetRestoreClients')
	delete from GxQscripts where name = 'AppGetRestoreClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRestoreClients')
	delete from GXDBVersions where aliasname = 'AppGetRestoreClients'
GO
print '... Creating Procedure: AppGetRestoreClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetRestoreClients
  @i_flag INT,
  @i_xmlText XML OUTPUT
AS
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(max)
DECLARE @userId INT = 0
DECLARE @localeId INT = 0
DECLARE @appTypeId INT = 0
DECLARE @clientId INT = 0
DECLARE @flag INT = 0
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @errorCode = 0
	SET @errorString = ''
	SET @localeId = ISNULL(@i_xmlText.value('(//App_GetRestoreClientsReq/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
							FROM @i_xmlText.nodes ('App_GetRestoreClientsReq/processinginstructioninfo/user') R(ref)), 0)
	SET @clientId = ISNULL(@i_xmlText.value('(//App_GetRestoreClientsReq/client/@clientId)[1]', 'int') , 0)
	SET @appTypeId = ISNULL(@i_xmlText.value('(//App_GetRestoreClientsReq/agentType/@appTypeId)[1]', 'int') , 0)
	IF (@clientId = 0 AND @appTypeId = 0)
	BEGIN
SET @errorCode = (1771 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (1771 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		SET @i_xmlText = (SELECT (SELECT @errorCode as '@errorCode',@errorString as '@errorMessage' FOR XML PATH('error'), TYPE) FOR XML PATH('App_GetRestoreClientsResp'),TYPE)
		GOTO SCRIPT_EXIT
	END
	IF @i_flag <> 0
	BEGIN
		SET @flag = @i_flag
	END
	ELSE
	BEGIN
		SET @flag = (SELECT
(ISNULL(f.value('@filterByAppType', 'tinyint'),0) * 0x8)
|  (ISNULL(f.value('@filterByCDRCopyBack', 'tinyint'),0) * 0x20)
|  (ISNULL(f.value('@filterByWBARestore', 'tinyint'),0) * 0x40)
|  (ISNULL(f.value('@filterByVSARestore', 'tinyint'),0) * 0x80)
|  (ISNULL(f.value('@filterByClone', 'tinyint'),0) * 0x200)
|  (ISNULL(f.value('@filterByRestoreOnly', 'tinyint'),0) * 0x800)
|  (ISNULL(f.value('@filterByVSARestoreFBR', 'tinyint'),0) * 0x400)
|  (ISNULL(f.value('@filterBySybaseCluster', 'tinyint'),0) * 0x2000)
					FROM @i_xmlText.nodes('/App_GetRestoreClientsReq/restoreClientFlags') t(f))
IF @flag & 0x80 = 0x80
		BEGIN
IF EXISTS(SELECT 1 FROM App_Client WITH(NOLOCK) WHERE id = @clientId AND releaseId > 14) AND @appTypeId = 106
			BEGIN
SET @flag = @flag | 0x400
			END
		END
	END
IF (((@flag & 0x8) | (@flag & 0x20) | (@flag & 0x40) | (@flag & 0x80)) > 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#restoreClientList')                    IS NOT NULL DROP TABLE #restoreClientList
		CREATE TABLE #restoreClientList (clientId integer, clientName nvarchar(max), appTypeId integer, displayname nvarchar(max))
		INSERT INTO #restoreClientList
			EXEC AppGetClientListByAppType @userId, @appTypeId, @clientId, @flag
		SET @i_xmlText = (SELECT(SELECT (SELECT clientid AS '@clientId', clientName AS '@clientName' for XML PATH('client'),TYPE),
											(SELECT appTypeId AS '@appTypeId' FOR XML PATH('agentType'),TYPE)
											 FROM #restoreClientList for XML PATH('restoreClients'),TYPE ),
								(SELECT @errorCode as '@errorCode' FOR XML PATH('error'), TYPE) FOR XML PATH('App_GetRestoreClientsResp'),TYPE)
		IF OBJECT_ID('tempdb.dbo.#restoreClientList')                    IS NOT NULL DROP TABLE #restoreClientList
	END
	ELSE
	BEGIN
		SET @i_xmlText = (SELECT (SELECT @errorCode as '@errorCode',@errorString as '@errorMessage' FOR XML PATH('error'), TYPE) FOR XML PATH('App_GetRestoreClientsResp'),TYPE)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
	SET @i_xmlText = (SELECT (SELECT @errorCode as '@errorCode',@errorString as '@errorMessage' FOR XML PATH('error'), TYPE) FOR XML PATH('App_GetRestoreClientsResp'),TYPE)
END CATCH
SCRIPT_EXIT:
	SELECT @i_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRestoreClients')
	delete from GxQscripts where name = 'AppGetRestoreClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRestoreClients')
	delete from GXDBVersions where aliasname = 'AppGetRestoreClients'
GO

insert into GXDBVersions values(2, 'AppGetRestoreClients',  '00000000000000000000', 'AppGetRestoreClients', '00000000000000000000')
GO

