

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetReportListing.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetReportListing.sp,v $ $Id: AppGetReportListing.sp,v 1.1.2.3 2020/12/15 18:27:25 csunderland Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetReportListing')
BEGIN
	print '>>> Drop Stored Procedure: AppGetReportListing <<<'
	drop procedure AppGetReportListing
END
IF EXISTS (select * from GxQscripts where name='AppGetReportListing')
	delete from GxQscripts where name = 'AppGetReportListing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetReportListing')
	delete from GXDBVersions where aliasname = 'AppGetReportListing'
GO
print '... Creating Procedure: AppGetReportListing'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetReportListing
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId NVARCHAR(100),
  @i_manage INTEGER=0,
  @i_offlineOnly INTEGER=0,
  @i_tags XML=null,
  @i_reportType INTEGER=0,
  @i_tileType INTEGER=0,
  @i_showHidden INTEGER=0,
  @i_tenantAdmin INTEGER=0,
  @i_includeMetrics INTEGER=0
AS
  DECLARE @reportId int 
  DECLARE @name NVARCHAR(510)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
-- Prepare tags information to be displayed in the report manager
DECLARE @outtbl table
(
tagXML xml
)
DECLARE @inputxml xml = '<WebReport_TagViewEditReq userId="' + Cast(@i_userId As varchar) + '"/>'
INSERT INTO @outtbl
EXEC WebReportsTagOperations  @inputxml
DECLARE @reportTags table
(
   reportId int,
   tagName nvarchar(max)
   )
INSERT INTO @reportTags
   SELECT tag.value('@reportId', 'int') as reportId,
					ISNULL(tag.value('@tagName', 'nvarchar(max)'),'Untagged') as 'Tag Name'
FROM @outtbl O
CROSS APPLY O.tagXML.nodes('/WebReport_TagViewEditResp/tagInfoList')  tag(tag)
WHERE tag.value('@reportType', 'varchar(256)') ='custom'
DECLARE @tagTbl TABLE (tag nvarchar(255))
IF (@i_tags IS NOT NULL)
BEGIN
	INSERT INTO @tagTbl
	SELECT t.p.query('.').value('.', 'nvarchar(255)') AS tag
	FROM @i_tags.nodes('/root/tag') t(p)
END
-- end of temp table with tags to report id information
DECLARE @isViewAllCap INT = 0
exec sec_checkPermissionOnEntity @i_userId, '1', @isViewAllCap OUTPUT, 1, 2
IF object_id('tempdb.dbo.#AppGetReportListing_Reports') is not null DROP TABLE #AppGetReportListing_Reports
CREATE TABLE #AppGetReportListing_Reports (reportId INT, CONSTRAINT PK_AppGetReportListing_Reports_reportId PRIMARY KEY CLUSTERED (reportId))
IF (@isViewAllCap = 1)
BEGIN
	INSERT INTO #AppGetReportListing_Reports SELECT reportId FROM APP_Reports
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NOT NULL
		DROP TABLE #getNonIdaObjects_InputPermissionsTbl
	CREATE TABLE #getNonIdaObjects_InputPermissionsTbl
	(
		permissionId INT
	)
Insert Into #getNonIdaObjects_InputPermissionsTbl Values (130)
Insert Into #getNonIdaObjects_InputPermissionsTbl Values (131)
	IF @i_manage = 0
Insert Into #getNonIdaObjects_InputPermissionsTbl Values (132)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 131, -1, '#AppGetReportListing_Reports'
END
IF object_id('tempdb.dbo.#AppGetReportListing_translations') is not null DROP TABLE #AppGetReportListing_translations
CREATE TABLE #AppGetReportListing_translations (reportId INT, reportTitle NVARCHAR(MAX), reportdescription NVARCHAR(MAX))
INSERT INTO #AppGetReportListing_translations EXEC AppGetTranslations 131, -1, @i_localeId, '''RPT_TITLE'', ''RPT_DESCRIPTION'''
IF object_id('tempdb.dbo.#AppGetReportListing_report_translations') is not null DROP TABLE #AppGetReportListing_report_translations
CREATE TABLE #AppGetReportListing_report_translations (
	reportId INT,
	reportTitle NVARCHAR(MAX),
	reportdescription NVARCHAR(MAX),
	CONSTRAINT PK_AppGetReportListing_report_translations_reportId PRIMARY KEY CLUSTERED (reportId)
)
INSERT INTO #AppGetReportListing_report_translations(reportId, reportTitle, reportdescription)
(
	SELECT reportId, [RPT_TITLE], [RPT_DESCRIPTION]
	FROM
	(
		SELECT reportId, reportTitle, reportdescription FROM #AppGetReportListing_translations
	) as translations
	PIVOT
	(
		MAX(reportdescription)
		FOR reportTitle IN ([RPT_TITLE], [RPT_DESCRIPTION])
	) as pvt
)
--DECLARE @tileFlag INT = 0
--IF @i_tileReports = 1
--	SET @tileFlag = 8
Declare @roleId int
Declare @providerId int
Declare @errCode int
Declare @errString nvarchar(1024)
EXEC AppGetUserRoleType @i_userId, @roleId OUTPUT, @providerId OUTPUT, @errCode OUTPUT, @errString OUTPUT
DECLARE @filterTable TABLE (reportId int, [type] nvarchar(255))
IF EXISTS (SELECT * FROM @tagTbl)
BEGIN
	INSERT INTO @filterTable
	SELECT r.reportId, ISNULL(o.[type], 'Online')
	FROM APP_Reports r
	LEFT OUTER JOIN
	(
		Select reportId, Case When Sum(Offline) > 0 THEN 'Offline' ELSE 'Online' END As [type]
		From APP_DataSet
		Group By reportId
	) o ON r.reportId = o.reportId
	INNER JOIN APP_ReportTags t ON r.reportId = t.reportId AND t.[type] = 0
	--WHERE r.flags & 1 = 0 --skip hidden reports --need to show hidden reports when filtering by tags
	--AND r.flags & 8 = @tileFlag --tile reports
	WHERE r.[type] = @i_reportType
	AND (@i_tileType = 0 OR r.tileType = @i_tileType) --tile offline or online
	AND (@i_includeMetrics = 1 OR r.flags & 512 = 0) --metrics reports
	AND (
		r.reportId IN (SELECT reportId FROM #AppGetReportListing_Reports) OR
		(@i_manage = 0 AND r.flags & 2 > 0) OR
(@roleId = 0 AND r.flags & 64 > 0) OR
(@roleId = 1 AND r.flags & 16 > 0) OR
(@roleId = 2 AND r.flags & 32 > 0)
		)
	AND t.tag IN (SELECT tag FROM @tagTbl)
END
ELSE
BEGIN
	INSERT INTO @filterTable
	SELECT r.reportId, ISNULL(o.[type], 'Online')
	FROM APP_Reports r
	LEFT OUTER JOIN
	(
		Select reportId, Case When Sum(Offline) > 0 THEN 'Offline' ELSE 'Online' END As [type]
		From APP_DataSet
		Group By reportId
	) o ON r.reportId = o.reportId
	WHERE (@i_showHidden = 1 OR r.flags & 1 = 0) --skip hidden reports
	--AND r.flags & 8 = @tileFlag --tile reports
	AND r.[type] = @i_reportType
	AND (@i_tileType = 0 OR r.tileType = @i_tileType) --tile offline or online
	AND (@i_includeMetrics = 1 OR r.flags & 512 = 0) --metrics reports
	AND (
		r.reportId IN (SELECT reportId FROM #AppGetReportListing_Reports) OR
		(@i_manage = 0 AND r.flags & 2 > 0) OR
(@roleId = 0 AND r.flags & 64 > 0) OR
(@roleId = 1 AND r.flags & 16 > 0) OR
(@roleId = 2 AND r.flags & 32 > 0)
		)
END
SELECT 	r.reportId,
		r.userReportId,
		ISNULL(t.reportTitle, r.name) AS name,
		ISNULL(t.reportdescription, r.description) AS description,
		'' As 'definition',
		r.[version],
		r.[deployedVersion],
		r.[createTime],
		r.[modifiedTime],
		r.[userId],
		r.guid,
		r.[revision],
		r.flags,
		r.[engineVersion],
		r.[referenceId],
		r.[icon],
		r.[source],
	    ISNULL(( stuff( ( select ',' + tagName from @reportTags rt	 where rt.reportId = r.reportId for xml path('')),1,1,'')),'') as 'Tags',
		ISNULL(DCCache.remoteRevision, '') AS 'RemoteRevision',
		ISNULL(DCCache.whatsNew, '') AS 'WhatsNew',
		DCCache.packageId AS 'packageId',
		DCCache.platformId AS 'platformId',
		f.[type] As 'type',
		r.tileProperties,
		r.minCommCellVersion,
		r.maxCommCellVersion,
		CASE
			WHEN r.tileType = 1 THEN 'Online'
			WHEN r.tileType = 2 THEN 'Offline'
			ELSE null END AS tileType,
		r.CategoryId,
		c.CategoryName,
		r.customIcon
FROM APP_Reports r
INNER JOIN @filterTable f ON r.reportId = f.reportId
LEFT OUTER JOIN #AppGetReportListing_report_translations t ON r.reportId = t.reportId
LEFT OUTER JOIN DCStoreItemCache DCCache ON r.guid = DCCache.guid
LEFT OUTER JOIN RptTileCategories c ON r.CategoryId = c.CategoryId
WHERE (@i_offlineOnly = 0 OR f.[type] = 'Offline')
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetReportListing')
	delete from GxQscripts where name = 'AppGetReportListing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetReportListing')
	delete from GXDBVersions where aliasname = 'AppGetReportListing'
GO

insert into GXDBVersions values(2, 'AppGetReportListing',  '00010001000200030000', 'AppGetReportListing', '00010001000200030000')
GO

