

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetReportDetails.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetReportDetails <<<'

IF EXISTS (select * from sysobjects where name='AppGetReportDetails')
	drop procedure AppGetReportDetails
IF EXISTS (select * from GxQscripts where name='AppGetReportDetails')
	delete from GxQscripts where name = 'AppGetReportDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetReportDetails')
	delete from GXDBVersions where aliasname = 'AppGetReportDetails'
GO
print '... Creating Procedure: AppGetReportDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetReportDetails
  @xmlText XML
AS
DECLARE @outXml XML
DECLARE @reportId INT = @xmlText.value('(/App_GetReportDetailsReq/@reportId)[1]', 'INT')
DECLARE @name NVARCHAR(max) = @xmlText.value('(/App_GetReportDetailsReq/@name)[1]', 'NVARCHAR(max)')
DECLARE @guid NVARCHAR(max) = @xmlText.value('(/App_GetReportDetailsReq/@guid)[1]', 'NVARCHAR(max)')
BEGIN TRY
        IF @reportId IS NULL OR NOT EXISTS (SELECT 1 FROM APP_Reports WHERE reportId = @reportId)
        BEGIN
                IF @guid IS NOT NULL
                        SELECT @reportId = reportId FROM APP_Reports WHERE guid = @guid
                ELSE IF @name IS NOT NULL
                        SELECT @reportId = reportId FROM APP_Reports WHERE name = @name
                ELSE
                        RAISERROR('No input id is present.', 16, 1);
                IF @reportId IS NULL
                        RAISERROR('No qualified id is present.', 16, 1);
        END
        SET @outXml = (
                SELECT  REP.reportId AS '@reportId',
                        REP.name AS '@name',
                        REP.description AS '@description',
                        REP.version AS '@version',
                        REP.deployedVersion AS '@deployedVersion',
                        REP.createTime AS '@createTime',
                        REP.modifiedTime AS '@modifiedTime',
                        REP.guid AS '@guid',
                        REP.revision AS '@revision',
                        REP.flags AS '@flags',
                        REP.engineVersion AS '@engineVersion',
                        REP.referenceId AS '@referenceId',
                        REP.source AS '@source',
                        REP.userReportId AS '@userReportId',
                        REP.type AS '@type',
                        REP.tileType AS '@tileType',
                        REP.categoryId AS '@categoryId'
                FROM APP_Reports AS REP
                WHERE REP.reportId = @reportId
                FOR XML PATH('App_GetReportDetailsResp'), TYPE
        );
        SELECT @outXml
END TRY
BEGIN CATCH
        SET @outXml = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GetReportDetailsResp'), TYPE);
        SELECT @outXml
END CATCH

IF EXISTS (select * from GxQscripts where name = 'AppGetReportDetails')
	delete from GxQscripts where name = 'AppGetReportDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetReportDetails')
	delete from GXDBVersions where aliasname = 'AppGetReportDetails'
GO

insert into GXDBVersions values(2, 'AppGetReportDetails',  '00000000000000000000', 'AppGetReportDetails', '00000000000000000000')
GO

