

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetReplicationGroupList.sp] ---------- 

--  +=============================================================================================+
--  |                       Name: AppGetReplicationGroupList()
--  | Description: List all the replication groups
--  |
--  |       Input: None
--  |      Output: list of all replication groups
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetReplicationGroupList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetReplicationGroupList <<<'
	drop procedure AppGetReplicationGroupList
END
IF EXISTS (select * from GxQscripts where name='AppGetReplicationGroupList')
	delete from GxQscripts where name = 'AppGetReplicationGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetReplicationGroupList')
	delete from GXDBVersions where aliasname = 'AppGetReplicationGroupList'
GO
print '... Creating Procedure: AppGetReplicationGroupList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetReplicationGroupList
  @userId INT,
  @localeId INT
AS
  DECLARE @repGroupListXML XML 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF OBJECT_ID('tempdb.dbo.#TM_GetReplicationSchedulesExtXmlTbl') IS NOT NULL
		DROP TABLE #TM_GetReplicationSchedulesExtXmlTbl
	IF OBJECT_ID('tempdb.dbo.#GetBlockReplicationInfoExtXmlTbl') IS NOT NULL
		DROP TABLE #GetBlockReplicationInfoExtXmlTbl
	IF OBJECT_ID('tempdb.dbo.#pRepGroup') IS NOT NULL
		DROP TABLE #pRepGroup
	IF OBJECT_ID('tempdb.dbo.#cRepGroup') IS NOT NULL
		DROP TABLE #cRepGroup
	IF OBJECT_ID('tempdb.dbo.#cRepGroupUnique') IS NOT NULL
		DROP TABLE #cRepGroupUnique
	CREATE TABLE #TM_GetReplicationSchedulesExtXmlTbl(repInfo XML)
	CREATE TABLE #GetBlockReplicationInfoExtXmlTbl (continuous XML)
	CREATE TABLE #pRepGroup (periodicXML XML,replicationGroupId int,replicationGroupName nvarchar(510))
	CREATE TABLE #cRepGroup (continuousXML XML,replicationGroupId int,replicationGroupName nvarchar(510),recTargetId int, recTargetName nvarchar(510))
	CREATE TABLE #cRepGroupUnique (contXML XML,replicationGroupId int,replicationGroupName nvarchar(510),recTargetId int, recTargetName nvarchar(510))
	-- Fetch the periodic task list
	EXEC DBO.TM_GetReplicationSchedules @userId, @localeId, 0,0,0
	INSERT INTO #pRepGroup
			select x.XmlCol.query('.'),ISNULL(REP.componentNameId,0),ISNULL(R.name, '')
				from #TM_GetReplicationSchedulesExtXmlTbl b cross apply b.repInfo.nodes('/TMMsg_GetTaskListResp/taskDetail') AS x(XmlCol)
					left join App_replicationGroupAssociation REP on REP.taskId = x.XmlCol.value('(task/@taskId)[1]','INT')
					left join App_replicationGroup R on R.id = REP.componentNameId
	-- Fetch the continuous blr pair list
	DECLARE @tempStr NVARCHAR(MAX) = '<BlockReplication_GetBlockReplicationInfoReq localeID="' + CONVERT(NVARCHAR(10),@localeId) + '"><siteInfo id="0"><entity subclientId="0"/><processinginstructioninfo> <user userId= "'+ CONVERT(NVARCHAR(50),@userId)+ '" /></processinginstructioninfo></siteInfo></BlockReplication_GetBlockReplicationInfoReq>'
	DECLARE @fetchBlrInpXML XML = CAST(@tempStr AS XML)
	EXEC DBO.GetBlockReplicationInfo @fetchBlrInpXML
	-- type = 2 implies continuous replication group
	INSERT INTO #cRepGroup
			SELECT x.XmlCol.query('.'),ISNULL(R.id,0), ISNULL(R.name,''),
				CONVERT(INT, convert(xml, right(SUB.attrval,len(attrval) - CHARINDEX('<TMMsg_TaskInfo>',SUB.attrVal) +1)).value('(/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','INT')),
				CONVERT(NVARCHAR(510), convert(xml, right(SUB.attrval,len(attrval) - CHARINDEX('<TMMsg_TaskInfo>',SUB.attrVal) +1)).value('(/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyName)[1]','NVARCHAR(510)'))
				from #GetBlockReplicationInfoExtXmlTbl b cross apply b.continuous.nodes('/BlockReplication_GetBlockReplicationInfoResp/siteInfo') AS x(XmlCol)
					right join App_replicationGroupAssociation REP on REP.blrpairId = x.XmlCol.value('(@id)[1]','INT')
					right join App_replicationGroup R on R.id = REP.componentNameId
					left join App_SubclientProp SUB on SUB.componentNameId = x.XmlCol.value('(entity/@subclientId)[1]','INT')
and SUB.attrName = 'Virtual Server Block Level Replication Restore XML' AND SUB.modified = 0 WHERE R.type = 2
	UPDATE #cRepGroup SET [continuousXML].modify('insert (
										attribute clientName {sql:column("C.name")},
										attribute applicationId {sql:column("APP.appTypeId")}
									)into (/siteInfo/entity)[1]')
			FROM app_application APP JOIN app_client C ON APP.clientId = C.id
			JOIN app_subclientProp SUB ON SUB.componentNameId = APP.id
			where APP.id = [continuousXML].value('(/siteInfo/entity/@subclientId)[1]','INT')
	-- FOR REP GROUPS WHICH DONT HAVE A PAIR YET, ONLY SHOW THESE REP GROUPS, IF USER IS THE OWNER
	DELETE C
	FROM #cRepGroup C
JOIN App_ReplicationGroupProp PROP (NOLOCK) ON C.continuousXML IS NULL AND PROP.attrName = 'Associated Plan' AND C.replicationGroupId = PROP.componentNameId
	JOIN App_Plan P (NOLOCK) ON PROP.attrVal = CAST(P.id AS NVARCHAR(128))
	WHERE P.ownerId <> @userId
	--For rep groups which dont have a pair yet
	UPDATE #cRepGroup SET continuousXML = attrXML,
	    recTargetId = attrXML.value('(/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyId)[1]','int'),
		recTargetName =  attrXML.value('(/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/allocationPolicy/@vmAllocPolicyName)[1]','nvarchar(510)')
FROM App_ReplicationGroupProp REPPROP WHERE REPPROP.componentNameId = replicationGroupId AND REPPROP.attrName = 'Virtual Server Block Level Replication Restore XML'
		AND continuousXML is NULL
	INSERT into #cRepGroupUnique
	select CAST(STUFF(
		(SELECT ' ' + CONVERT(NVARCHAR(MAX),continuousXML) FROM #cRepGroup WHERE ALA.replicationGroupId = replicationGroupId FOR XML PATH('')),1, 1, '') AS XML).value('.[1]','NVARCHAR(MAX)'),
		replicationGroupId, replicationGroupName, recTargetId, recTargetName from #cRepGroup ALA group by replicationGroupId,replicationGroupName,recTargetId,recTargetName
	-- Combine both periodic and continuous rep groups
	SET @repGroupListXML = (SELECT
							(select (
									(SELECT 1 AS '@type',
									(SELECT periodicXML AS '@taskDetails') ,
									(SELECT replicationGroupId AS '@replicationGroupId', replicationGroupName as '@replicationGroupName' FOR XML PATH('replicationGroup'), TYPE)
										from #pRepGroup FOR XML PATH('replicationGroups'), TYPE)
										),
							(select	(
									(SELECT 2 AS '@type',
									(SELECT contXML AS '@siteInfo'),
									(SELECT replicationGroupId AS '@replicationGroupId', replicationGroupName as '@replicationGroupName' FOR XML PATH('replicationGroup'), TYPE),
									(SELECT recTargetId AS '@vmAllocPolicyId', recTargetName AS '@vmAllocPolicyName' FOR XML PATH('recoveryTarget'), TYPE)
										from #cRepGroupUnique FOR XML PATH('replicationGroups'), TYPE)
										)
							)
									FOR XML PATH(''), ROOT('TMMsg_ReplicationGroupListResp')
							))
	IF @repGroupListXML IS NULL
        SET @repGroupListXML = '<BlockReplication_GetBlockReplicationInfoResp/>'
    DROP TABLE #TM_GetReplicationSchedulesExtXmlTbl
	DROP TABLE #GetBlockReplicationInfoExtXmlTbl
	DROP TABLE #pRepGroup
	DROP TABLE #cRepGroup
	DROP TABLE #cRepGroupUnique
	SELECT @repGroupListXML as repGroupListXML
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetReplicationGroupList')
	delete from GxQscripts where name = 'AppGetReplicationGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetReplicationGroupList')
	delete from GXDBVersions where aliasname = 'AppGetReplicationGroupList'
GO

insert into GXDBVersions values(2, 'AppGetReplicationGroupList',  '00000000000000000000', 'AppGetReplicationGroupList', '00000000000000000000')
GO

