

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetReplicationGroupDetails.sp] ---------- 

--  +=============================================================================================+
--  |                       Name: AppGetReplicationGroupDetails()
--  | Description: Fetches details of replication group (implemented for continuous rep groups)
--  |
--  |       Input: userId, localeId and replicationGroupId
--  |      Output: Replication group details(continuous)
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetReplicationGroupDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetReplicationGroupDetails <<<'
	drop procedure AppGetReplicationGroupDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetReplicationGroupDetails')
	delete from GxQscripts where name = 'AppGetReplicationGroupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetReplicationGroupDetails')
	delete from GXDBVersions where aliasname = 'AppGetReplicationGroupDetails'
GO
print '... Creating Procedure: AppGetReplicationGroupDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetReplicationGroupDetails
  @userId INT,
  @localeId INT,
  @repGroupId INT
AS
  DECLARE @repGroupDetailsXML XML 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF OBJECT_ID('tempdb.dbo.#GetBlockReplicationInfoExtXmlTbl') IS NOT NULL
		DROP TABLE #GetBlockReplicationInfoExtXmlTbl
	IF OBJECT_ID('tempdb.dbo.#cRepGroup') IS NOT NULL
		DROP TABLE #cRepGroup
	IF OBJECT_ID('tempdb.dbo.#cRepGroupUnique') IS NOT NULL
		DROP TABLE #cRepGroupUnique
	IF OBJECT_ID('tempdb.dbo.#pairAssocTasksTbl') IS NOT NULL
		DROP TABLE #pairAssocTasksTbl
	CREATE TABLE #GetBlockReplicationInfoExtXmlTbl (continuous XML)
	CREATE TABLE #cRepGroup (continuousXML XML,replicationGroupId int,replicationGroupName nvarchar(510))
	CREATE TABLE #cRepGroupUnique (contXML XML,replicationGroupId int,replicationGroupName nvarchar(510))
	CREATE TABLE #pairAssocTasksTbl (taskStr NVARCHAR(MAX), startTag INT, startEncodeTag INT, taskXml XML)
	DECLARE @tempStr NVARCHAR(MAX) = '<BlockReplication_GetBlockReplicationInfoReq localeID="' + CONVERT(NVARCHAR(10),@localeId) + '"><siteInfo id="0"><entity subclientId="0"/><processinginstructioninfo> <user userId= "'+ CONVERT(NVARCHAR(50),@userId)+ '" /></processinginstructioninfo></siteInfo></BlockReplication_GetBlockReplicationInfoReq>'
	DECLARE @fetchBlrInpXML XML = CAST(@tempStr AS XML)
	EXEC DBO.GetBlockReplicationInfo @fetchBlrInpXML
	INSERT INTO #cRepGroup
			SELECT x.XmlCol.query('.'),R.id,R.name
				from #GetBlockReplicationInfoExtXmlTbl b cross apply b.continuous.nodes('/BlockReplication_GetBlockReplicationInfoResp/siteInfo') AS x(XmlCol)
					right join App_replicationGroupAssociation REP on REP.blrpairId = x.XmlCol.value('(@id)[1]','INT')
					right join App_replicationGroup R on R.id = REP.componentNameId WHERE R.id = @repGroupId
	UPDATE #cRepGroup SET [continuousXML].modify('insert (
										attribute clientName {sql:column("C.name")},
										attribute applicationId {sql:column("APP.appTypeId")}
									)into (/siteInfo/entity)[1]')
			FROM app_application APP JOIN app_client C ON APP.clientId = C.id
			JOIN app_subclientProp SUB ON SUB.componentNameId = APP.id
			where APP.id = [continuousXML].value('(/siteInfo/entity/@subclientId)[1]','INT')
	INSERT into #cRepGroupUnique
	select CAST(STUFF(
		(SELECT ' ' + CONVERT(NVARCHAR(MAX),continuousXML) FROM #cRepGroup WHERE ALA.replicationGroupId = replicationGroupId FOR XML PATH('')),1, 1, '') AS XML).value('.[1]','NVARCHAR(MAX)'),
		replicationGroupId, replicationGroupName from #cRepGroup ALA group by replicationGroupId,replicationGroupName
	-- Fetching taskinfo for continuous replication group
	DECLARE @taskInfoXML XML = ''
	INSERT INTO #pairAssocTasksTbl
	SELECT SUB.attrval,CHARINDEX( '<',SUB.attrval,1),CHARINDEX( '?xml',SUB.attrval,1),'' from APP_SubClientProp SUB WITH(NOLOCK)
		JOIN BlrPair BLR WITH(NOLOCK) ON BLR.subClientId = SUB.componentNameId
		JOIN App_ReplicationGroupAssociation REPASSOC WITH(NOLOCK) ON REPASSOC.blrpairId = BLR.id
WHERE SUB.attrname = 'Virtual Server Block Level Replication Restore XML' AND SUB.modified = 0 AND REPASSOC.componentNameId = @repGroupId
AND SUB.cs_attrname = CHECKSUM(N'Virtual Server Block Level Replication Restore XML')
	UPDATE #pairAssocTasksTbl
		set taskXml = (SELECT CONVERT(XML,SUBSTRING(taskStr,CHARINDEX('?>',taskStr,1)+2,LEN(taskStr)),2)) where startEncodeTag = (startTag + 1)
	UPDATE #pairAssocTasksTbl
		set taskXml = (SELECT CONVERT(XML,taskStr)) where startEncodeTag <> (startTag + 1)
	SET @taskInfoXML = (SELECT taskXml.query('/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions') from #pairAssocTasksTbl FOR XML PATH(''))
DECLARE @taskTemplate XML = (SELECT attrxml FROM App_ReplicationGroupProp WITH(NOLOCK) WHERE componentNameId = @repGroupId AND attrName = 'Virtual Server Block Level Replication Restore XML')
	SET @taskTemplate.modify('delete TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[1]')
	SET @taskTemplate.modify('insert sql:variable("@taskInfoXML") into (/TMMsg_TaskInfo/subTasks/options/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption)[1]') ;
	SET @repGroupDetailsXML = (SELECT
							(SELECT	(
									(SELECT 2 AS '@type',
									(SELECT C.contXML AS '@siteInfo'),
									(SELECT @taskTemplate.query('element taskDetail {TMMsg_TaskInfo/@*, /TMMsg_TaskInfo/*}')),
									(SELECT C.replicationGroupId AS '@replicationGroupId', C.replicationGroupName as '@replicationGroupName' FOR XML PATH('replicationGroup'), TYPE),
									(SELECT (SELECT REPPROP2.attrVal AS '@userName' FOR XML PATH('userPassword'), TYPE) FOR XML PATH('vmGuestCredentials'), TYPE),
									(SELECT REPPROP.attrXML)
										from #cRepGroupUnique C JOIN App_ReplicationGroupProp REPPROP WITH(NOLOCK) ON C.replicationGroupId = REPPROP.componentNameId
LEFT JOIN App_ReplicationGroupProp REPPROP2 WITH(NOLOCK) ON C.replicationGroupId = REPPROP2.componentNameId AND REPPROP2.attrName = 'VM Guest Credential User Name'
WHERE REPPROP.attrName = 'BLR recovery options'
										FOR XML PATH('replicationGroupDetails'), TYPE)
										)
									FOR XML PATH(''), ROOT('Api_GetReplicationGroupResp')
							))
	IF OBJECT_ID('tempdb.dbo.#GetBlockReplicationInfoExtXmlTbl') IS NOT NULL
		DROP TABLE #GetBlockReplicationInfoExtXmlTbl
	IF OBJECT_ID('tempdb.dbo.#cRepGroup') IS NOT NULL
		DROP TABLE #cRepGroup
	IF OBJECT_ID('tempdb.dbo.#cRepGroupUnique') IS NOT NULL
		DROP TABLE #cRepGroupUnique
	IF OBJECT_ID('tempdb.dbo.#pairAssocTasksTbl') IS NOT NULL
		DROP TABLE #pairAssocTasksTbl
	SELECT @repGroupDetailsXML as repGroupDetailsXML
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetReplicationGroupDetails')
	delete from GxQscripts where name = 'AppGetReplicationGroupDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetReplicationGroupDetails')
	delete from GXDBVersions where aliasname = 'AppGetReplicationGroupDetails'
GO

insert into GXDBVersions values(2, 'AppGetReplicationGroupDetails',  '00000000000000000000', 'AppGetReplicationGroupDetails', '00000000000000000000')
GO

