

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRefCopyAssocSubClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetRefCopyAssocSubClients.sp,v $ $Id: AppGetRefCopyAssocSubClients.sp,v 1.14.44.9 2018/04/05 17:19:16 snagendra Exp $"
--
--  +========================================================================+
--  | Stored Precedure: AppGetRefCopyAssocSubClients()
--  | To get the list of subclients from the reference copy association
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRefCopyAssocSubClients <<<'

IF EXISTS (select * from sysobjects where name='AppGetRefCopyAssocSubClients')
	drop procedure AppGetRefCopyAssocSubClients
IF EXISTS (select * from GxQscripts where name='AppGetRefCopyAssocSubClients')
	delete from GxQscripts where name = 'AppGetRefCopyAssocSubClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRefCopyAssocSubClients')
	delete from GXDBVersions where aliasname = 'AppGetRefCopyAssocSubClients'
GO
print '... Creating Procedure: AppGetRefCopyAssocSubClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRefCopyAssocSubClients
  @i_refAppId INT,
  @i_refAppType INT,
  @i_userId INT,
  @i_requestType INT,
  @i_expandLevel INT,
  @i_assocXml XML,
  @i_flag INT = 0
AS
  DECLARE @o_appId INT
  DECLARE @o_appTypeId INT
  DECLARE @o_clientId INT
  DECLARE @o_instanceId INT
  DECLARE @o_backupsetId INT
  DECLARE @o_status INT
DECLARE @ErrorMessage		NVARCHAR(4000)
DECLARE @ErrorSeverity		INT
DECLARE @ErrorState			INT
DECLARE @releaseId			INT
DECLARE @allAssociations	INT
DECLARE @commcellParam		INT
DECLARE @capability			INT
DECLARE @capability2		INT = 0
DECLARE @ERROR_STATE		INT
DECLARE @ERROR_SEVERITY		INT
DECLARE @isPstArchiving		INT
DECLARE @isCaseManagerRegular INT = 0
DECLARE @filterDeletedSubclient INT = 0
DECLARE @isExchangeImport	INT = 0
SELECT @filterDeletedSubclient = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'CaseManagerFilterDeletedSubclients'
SET	@ERROR_STATE		=	1
SET @ERROR_SEVERITY		=	10
SET @ErrorSeverity		=	0
SET @ErrorState			=	0
SET @ErrorMessage		=	''
SET @isPstArchiving		=	0
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- Create temp tables
	-- None of these temp tables should ever exist when this procedure is called!
	IF object_id('tempdb.dbo.#appIdTbl') IS NOT NULL
	   DROP TABLE #appIdTbl
	CREATE TABLE #appIdTbl ( appId INT,  appTypeId INT, clientId INT, instanceId INT, backupsetId INT,  status INT, refTime INT, clientGrp Int)
	-- None of these temp tables should ever exist when this procedure is called!
	IF object_id('tempdb.dbo.#includeEntity') IS NOT NULL
		DROP TABLE #includeEntity
	CREATE TABLE #includeEntity
	(
		entityType integer,
		commcellId integer ,
		clientId integer ,
		appType integer ,
		instanceId integer ,
		backupsetId integer ,
		subclientId integer ,
		clientgroupId integer,
		reviewSetId	integer,
		exclude integer
	)
	IF object_id('tempdb.dbo.#excludeEntity') IS NOT NULL
    			DROP TABLE #excludeEntity
	CREATE TABLE #excludeEntity
	(
		entityType integer,
		commcellId integer ,
		clientId integer ,
		appType integer ,
		instanceId integer ,
		backupsetId integer ,
		subclientId integer ,
		clientgroupId integer,
		reviewSetId	integer,
		exclude integer
	)
	IF OBJECT_ID('tempdb.dbo.#associatedEntitiesWithCapability') IS NOT null
	   DROP TABLE #associatedEntitiesWithCapability
	create table #associatedEntitiesWithCapability ( [capabilities] bigint NOT null, [flag] int NOT null default 0, [commCellId] int NOT null, [clientGroupId] int NOT null, [clientId] int NOT null, [appTypeId] int NOT null, [instanceId] int NOT null, [backupsetId] int NOT null, [subClientId] int NOT null, [mediaAgentId] int NOT null, [libraryId] int NOT null, [archGroupId] int NOT null, [vtContainerId] int NOT null, [vtPolicyId] int NOT null, [vtShelfId] int NOT null, [reviewSetId] int NOT null default 0, [querySetId] int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId] int NOT null default 0, [legalHoldId] int NOT null default 0, [tagId] int NOT null default 0, [cdPolicyId] int NOT null default 0, [complianceReportId] int NOT null default 0, [taskId]        int	NOT null default 0, [workflowId] int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId] int	NOT null default 0, [cloudId] int	NOT null default 0, [userGroupId] int	NOT null default 0, [providerId] int	NOT null default 0, [entityId1] int	NOT null default 0, [entityId2] int	NOT null default 0, [entityId3] int	NOT null default 0, [entityId4] int	NOT null default 0, [entityId5] int	NOT null default 0, [entityId6] int	NOT null default 0, [entityId7] int	NOT null default 0, [entityId8] int	NOT null default 0, [entityId9] int	NOT null default 0)
	IF(@i_requestType = 1)
	BEGIN
	-- Populate the selected entity information
	INSERT INTO #includeEntity
	SELECT
		ISNULL(Tbl.Col.value('@_type_', 'int'),0) ,
		ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
		ISNULL(Tbl.Col.value('@clientId', 'int'),0),
		ISNULL(Tbl.Col.value('@applicationId', 'int'),0) ,
		ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
		ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
		ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
		ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
		ISNULL(Tbl.Col.value('@reviewSetId', 'int'),0),
		ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),0)
		FROM @i_assocXml.nodes('/databrowse_ReferenceCopyAssociations/associations') as Tbl(Col)
	END
	ELSE IF(@i_requestType = 2) --Request is from assocation
	BEGIN
	INSERT INTO #includeEntity
	SELECT
		ISNULL(Tbl.Col.value('@_type_', 'int'),0) ,
		ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
		ISNULL(Tbl.Col.value('@clientId', 'int'),0),
		ISNULL(Tbl.Col.value('@applicationId', 'int'),0) ,
		ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
		ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
		ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
		ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
		ISNULL(Tbl.Col.value('@reviewSetId', 'int'),0),
		ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),0)
		FROM @i_assocXml.nodes('entity') as Tbl(Col)
	END
	ELSE IF(@i_requestType = 3) --Request is from assocation
	BEGIN
		INSERT INTO #includeEntity
		SELECT
			ISNULL(Tbl.Col.value('@_type_', 'int'),0) ,
			ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
			ISNULL(Tbl.Col.value('@clientId', 'int'),0),
			ISNULL(Tbl.Col.value('@applicationId', 'int'),0) ,
			ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
			ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
			ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
			ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
			ISNULL(Tbl.Col.value('@reviewSetId', 'int'),0),
			ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),0)
		FROM @i_assocXml.nodes('associations') as Tbl(Col)
	END
	-- exclude entity should contain exlcude list
	INSERT INTO #excludeEntity
	SELECT * FROM #includeEntity WHERE exclude = 1
	-- Include entity should contain only include list
	DELETE FROM #includeEntity WHERE exclude = 1
	select @isPstArchiving = ISNULL(cast(attrVal AS Int), 0) From app_subclientprop where componentNameId = @i_refAppId and attrName = 'ReferenceCopy PST Archiving' and modified = 0
IF EXISTS(SELECT 1 FROM App_Application WHERE id = @i_refAppId AND appTypeId = 137)
		SET @isExchangeImport = 1
	SET @i_flag = ISNULL((SELECT attrVal From APP_SubClientProp(NOLOCK) WHERE componentNameId = @i_refAppId AND attrName = 'Reference Copy Flag' and modified = 0), @i_flag)
	-- Populate the subclient information from includeEntity
	INSERT INTO #appIdTbl
	--All clients
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType in(1 , 2)
	-- Include all CLIENTGROUPS
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B, APP_ClientGroupAssoc C
WHERE B.entityType = 27 AND A.clientId = C.clientId
	--CLIENT GROUP
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 28
	AND A.clientId in(SELECT DISTINCT (clientId) FROM APP_ClientGroupAssoc where clientgroupid = B.clientGroupId)
	--CLIENT
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 3
	AND A.clientId = B.clientId
	--APPTYPE
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 4
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	--INSTANCE
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 5
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	--BACKUPSET
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 6
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	AND A.backupset = B.backupsetId
	--SUBCLIENT
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 7
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	AND A.backupset = B.backupsetId
	AND A.id = B.subclientId
	-- Delete the excluded entity information
	-- All clients
IF Exists(Select *From #excludeEntity where entityType = 2)
		DELETE FROM #appIdTbl
	--CLIENT GROUP
	DELETE FROM #appIdTbl where clientId IN
    ( SELECT DISTINCT (clientId) FROM APP_ClientGroupAssoc where clientgroupid in
( SELECT clientGroupId from #excludeEntity where entityType = 28))
	--CLIENT
	DELETE FROM #appIdTbl where appId IN
( SELECT id from #excludeEntity En, APP_Application App where En.entityType = 3 AND App.clientId = En.clientId)
	--AppType
	DELETE FROM #appIdTbl where appId IN
( SELECT id from #excludeEntity En, APP_Application App where En.entityType = 4 AND App.clientId = En.clientId AND App.appTypeId = En.appType)
	--Instance
	DELETE FROM #appIdTbl where appId IN
( SELECT id from #excludeEntity En, APP_Application App where En.entityType = 5 AND App.clientId = En.clientId AND App.appTypeId = En.appType AND App.instance = En.instanceId)
	--Backupset
	DELETE FROM #appIdTbl where appId IN
( SELECT id from #excludeEntity En, APP_Application App where En.entityType = 6 AND App.clientId = En.clientId AND App.appTypeId = En.appType AND App.instance = En.instanceId AND App.backupSet = En.backupsetId)
	--SubclientId
	DELETE FROM #appIdTbl where appId IN
    ( SELECT subclientId from #excludeEntity)
    -- Filter the dummy, hidden subclient
    DELETE FROM #appIdTbl where (
--				(( status & 2 ) = 2)   -- CV_STATUS_UNINSTALLED
--				OR (( status & 4 ) = 4)   -- CV_STATUS_DELETED
				(( status & 16 ) = 16)  -- CV_STATUS_DUMMY
				OR (( status & 32 ) = 32)  -- CV_STATUS_HIDDEN
				)
	IF @filterDeletedSubclient = 1
		DELETE FROM #appIdTbl WHERE status & 4 = 4
	-- Delete the input referenceCopy subclient
	DELETE FROM #appIdTbl where appId = @i_refAppId
IF @i_flag & 0x2 = 0x2
	BEGIN
		DELETE FROM #appIdTbl WHERE
		backupsetId NOT IN(SELECT backupsetId FROM #includeEntity)
		DELETE #appIdTbl
		FROM #appIdTbl A, App_SubClientProp B where
A.appId = B.ComponentNameId AND B.AttrName = 'Reference Copy Flag' AND B.modified = 0 AND CAST(B.attrVal as INT) & 0x2= 0x2
	END
	SET @isCaseManagerRegular = ISNULL((Select cast(attrVal as int) From App_ClientProp(NOLOCK) Where componentNameId In (Select distinct clientId From App_Application(NOLOCK) Where id = @i_refAppId) and attrName = 'ReferenceCopyClientType' and modified = 0), 0)
	-- Delete DDB ,SILO subclients and Indexing subclients
	DELETE #appIdTbl
	FROM #appIdTbl A, App_SubClientProp B where
	A.appId = B.ComponentNameId and B.AttrName in('SILO Copy ID', 'DDB Backup', 'Index SubClient') and B.modified = 0
	--
	-- Do not delete SnapBackup subclients if setting EnableSnapSubClientsForCaseManager is True and current reference copy backup job is for a case manager.
	-- CV_REFCOPY_CM_REGULAR = 2
	IF NOT (@isCaseManagerRegular = 2 AND EXISTS (SELECT id FROM GxGlobalParam WHERE Name = 'EnableSnapSubClientsForCaseManager' and value = 'True'))
	BEGIN
	DELETE #appIdTbl
	FROM #appIdTbl A, App_SubClientProp B where
	A.appId = B.ComponentNameId and B.AttrName in('Enable Snap Backups') and B.modified = 0 and cast(B.attrVal as Int) = 1
	END
	--
	-- For reference copy Delete less than 10.0 clients
	-- For Exchange import delete clients older than 11.0
	DELETE #appIdTbl
	FROM #appIdTbl A, App_Client B where
A.clientId = B.id and B.releaseId < (CASE WHEN @isExchangeImport = 1 THEN 16 ELSE 15 END)
	if(@i_refAppType = 33 OR @isPstArchiving = 1) -- File System
		DELETE From #appIdTbl Where appTypeId not in (11, 33, 34, 42, 43, 1)
	else if (@i_refAppType = 54 OR @i_refAppType = 137) -- Exchange
		DELETE From #appIdTbl Where appTypeId not in (54)
	else if(@i_refAppType = 29) -- Unix Agent
		DELETE From #appIdTbl Where appTypeId not in (17, 18, 19, 20, 21, 29, 36, 38, 63, 64, 74)
	else
		DELETE From #appIdTbl Where appTypeId not in (@i_refAppType)
	SET @allAssociations = 0
SET @capability = 22
	IF @isCaseManagerRegular = 2 -- CV_REFCOPY_CM_REGULAR
SET @capability2 = 25
	SET @commcellParam = 2
	EXEC sec_getUserObjects @i_userId, 0, 0, '#associatedEntitiesWithCapability'
	IF @isCaseManagerRegular = 2
		DELETE FROM #associatedEntitiesWithCapability where ((capabilities & POWER(2, @capability - 1)) = 0) OR ((capabilities & POWER(2, @capability2 - 1)) = 0)
	ELSE
		-- Delete those entities on which user doesn't have out of place restore capability
		DELETE FROM #associatedEntitiesWithCapability where ((capabilities & POWER(2, @capability - 1)) = 0)
	-- Now we have come to Entities(clientGrp/client/appType/instance/bs/sc), we can remove associations not involving these. like lib, ma, sp etc
	delete #associatedEntitiesWithCapability
	WHERE 	mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 or vtContainerId <> 0 or vtPolicyId <> 0 or vtShelfId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	if exists(select 1 from #associatedEntitiesWithCapability
					WHERE commCellId = @commcellParam
					AND (
clientId = -10
OR appTypeId = -10
OR instanceId = -10
OR backupSetId = -10
OR subClientId = -10
					)
					AND ((capabilities & POWER(2, @capability - 1)) > 0)
					)
	begin
		SET @allAssociations = 1
	end
	if exists(select 1 from #associatedEntitiesWithCapability
					WHERE commCellId = @commcellParam
					AND clientId    = 0
					AND appTypeId   = 0
					AND instanceId  = 0
					AND backupSetId = 0
					AND subClientId = 0
					AND clientGroupId = 0
					AND ((capabilities & POWER(2, @capability - 1)) > 0)
					)
	begin
		SET @allAssociations = 1
	end
if @i_expandLevel = 28
	begin
			DELETE FROM #appIdTbl
			Where @allAssociations =0 AND
			clientGrp Not In(select AEWC.clientGroupId from #associatedEntitiesWithCapability AEWC Where ((AEWC.capabilities & POWER(2, @capability - 1)) > 0))
	end
	-- Filter based upon user capability
if @i_expandLevel = 3 OR @i_expandLevel = 2
	begin
			DELETE FROM #appIdTbl
			Where @allAssociations =0 AND
			ClientId Not In(select AEWC.clientId from #associatedEntitiesWithCapability AEWC Where ((AEWC.capabilities & POWER(2, @capability - 1)) > 0))
	end
else if @i_expandLevel = 4
	begin
			DELETE FROM #appIdTbl
			Where not exists
			(
				select *From #associatedEntitiesWithCapability AEWC where
				@allAssociations =1 OR
					(
						AEWC.clientId = #appIdTbl.clientId and (AEWC.appTypeId = #appIdTbl.appTypeId or AEWC.appTypeId=0)
						and ((capabilities & POWER(2, @capability - 1)) > 0)
					)
			)
	end
else if @i_expandLevel = 5
	begin
			DELETE FROM #appIdTbl
			Where not exists
			 (
				select *From #associatedEntitiesWithCapability AEWC where
				@allAssociations =1 OR
					(
						AEWC.clientId = #appIdTbl.clientId
						and (AEWC.appTypeId = #appIdTbl.appTypeId or AEWC.appTypeId=0)
						and (AEWC.instanceId = #appIdTbl.instanceId or AEWC.instanceId=0)
						and ((capabilities & POWER(2, @capability - 1)) > 0)
					)
			)
	end
else if @i_expandLevel = 6
	begin
			DELETE FROM #appIdTbl
			Where not exists
			 (
				select *From #associatedEntitiesWithCapability AEWC where
				@allAssociations =1 OR
					(
						AEWC.clientId = #appIdTbl.clientId
						and (AEWC.appTypeId = #appIdTbl.appTypeId or AEWC.appTypeId=0)
						and (AEWC.instanceId = #appIdTbl.instanceId or AEWC.instanceId=0)
						and (AEWC.backupsetId = #appIdTbl.backupsetId or AEWC.backupsetId=0)
						and ((capabilities & POWER(2, @capability - 1)) > 0)
					)
			)
	end
else if @i_expandLevel = 7
	begin
			DELETE FROM #appIdTbl
			Where not exists
			 (
				select *From #associatedEntitiesWithCapability AEWC where
				@allAssociations =1 OR
					(
						AEWC.clientId = #appIdTbl.clientId
						and (AEWC.appTypeId = #appIdTbl.appTypeId or AEWC.appTypeId=0)
						and (AEWC.instanceId = #appIdTbl.instanceId or AEWC.instanceId=0)
						and (AEWC.backupsetId = #appIdTbl.backupsetId or AEWC.backupsetId=0)
						and (AEWC.subclientId = #appIdTbl.appId or AEWC.subclientId=0)
						and ((capabilities & POWER(2, @capability - 1)) > 0)
					)
			)
	end
	BEGIN
		-- After all filteration,Delete clients which are locked and I am not owner of.
		-- Deleting the rows which have attribute name "CV_PROP_ENABLE_DATA_SECURITY" and attribute value CV_PROP_DATA_SECURITY_ENABLE
		DELETE #appIdTbl FROM #appIdTbl A,APP_ClientProp P
		WHERE A.clientId = P.componentNameId
and P.attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' and P.modified = 0 and P.attrVal='a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'
		and dbo.IsClientOwner(P.componentNameId,@i_userId) = 0
	END
	-- Add reviewSetId column to tempTable.
	Alter table #appIdTbl Add reviewSetId int Not Null Default 0
	-- Add reviewSetId column to tempTable.
	Alter table #appIdTbl Add componentType int Not Null Default 0
	Insert into #appIdTbl
Select 0, 0, 0, 0, 0, 0, 0, 0, reviewSetId, 1/*ReviewSet*/ From #includeEntity Where EntityType = 9501 And reviewSetId > 0
	SELECT *FROM #appIdTbl
	DROP TABLE #associatedEntitiesWithCapability
	DROP TABLE #appIdTbl
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	 SELECT
        @ErrorMessage = @ErrorMessage + ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE();
END CATCH
IF @ErrorSeverity <> 0 OR @ErrorState <> 0
	RAISERROR(@ErrorMessage,@ErrorSeverity,@ErrorState)
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRefCopyAssocSubClients')
	delete from GxQscripts where name = 'AppGetRefCopyAssocSubClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRefCopyAssocSubClients')
	delete from GXDBVersions where aliasname = 'AppGetRefCopyAssocSubClients'
GO

insert into GXDBVersions values(2, 'AppGetRefCopyAssocSubClients',  '00010014004400090000', 'AppGetRefCopyAssocSubClients', '00010014004400090000')
GO

