

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRFCMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Author: Aravind Senguttuvan
--
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetRFCMA')
BEGIN
	print '>>> Drop Stored Procedure: AppGetRFCMA <<<'
	drop procedure AppGetRFCMA
END
IF EXISTS (select * from GxQscripts where name='AppGetRFCMA')
	delete from GxQscripts where name = 'AppGetRFCMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRFCMA')
	delete from GXDBVersions where aliasname = 'AppGetRFCMA'
GO
print '... Creating Procedure: AppGetRFCMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetRFCMA
  @i_backupsetGuid nvarchar(36),
  @i_appGuid nvarchar(36),
  @i_appId INT,
  @i_backupsetId INT,
  @i_copyPrecedence INT,
  @o_RFCMAClientid nvarchar(max) OUTPUT
AS
DECLARE @tempAvailIdxMas TABLE (clientId INT, copyPrecedence SMALLINT, isDefaultDatapath SMALLINT)
--Get Index DBGUID based on type of IndexDB
DECLARE @tempDBGUID NVARCHAR(36) = @i_backupsetGuid
IF (dbo.isSubClientIndexEnabled(@i_backupsetId) = 1)
BEGIN
	SET @tempDBGUID = @i_appGuid
END
DECLARE @idxAppType INT = 0
SET @o_RFCMAClientid = 0
--Since Index server may be user assigned and not be a part of datapath MAs
SELECT @o_RFCMAClientid = currentIdxServer, @idxAppType = type FROM App_IndexDBInfo WITH(NOLOCK) WHERE dbName = @tempDBGUID and idxDbEngineType = 1 --CTREE
-- For vCenter index uploads always choose the MA based on availability. Do not check App_IndexDBInfo and use index server by default.
-- For ex., index server is set to MA1 and backup is running for SC2(SP2/MA2). MA1 and MA2 cannot communicate to each other -> since index server is by default assigned at the backupset level
-- jobs running in MA2 try to perform RFC upload to MA1 and fail.
DECLARE @useIdxSrvrForUploads INT = 1 --By default for all agents use index server for RFC uploads
IF @idxAppType = 200107
BEGIN
	SET @useIdxSrvrForUploads = 0 -- Special case for vCenter, RFC operations should go to subclient level MA nodes instead of backupset level
	IF EXISTS(SELECT TOP 1 * FROM GxGlobalParam(NOLOCK) WHERE name = 'UseIdxSrvrForVCenterUploads' and value = '1' and modified = 0) -- Global param to change the above behavior in case this approach blows up in our face
		SET @useIdxSrvrForUploads = 1
END
SET @o_RFCMAClientid = 0
--Since Index server may be user assigned and not be a part of datapath MAs
SELECT @o_RFCMAClientid = currentIdxServer FROM App_IndexDBInfo WITH(NOLOCK) WHERE dbName = @tempDBGUID and idxDbEngineType = 1 --CTREE
--Fetch IndexServer online state.
--If IndexServer is online and copyPrecedence is 0, return current IndexServer.
IF @i_copyPrecedence = 0 AND EXISTS(SELECT 1 FROM mmhost WITH(NOLOCK) WHERE ClientId=@o_RFCMAClientid AND MmHostSoftState = 1 AND MmHostEnabled = 1 AND (Attribute & 16) = 0)
AND @useIdxSrvrForUploads <> 0
BEGIN
	GOTO CX_SELECTION_RFCMA_DONE
END
--If IndexServer is not set OR IndexServer is offline OR copyPrecedence != 0
--Find all available MAs across all copies and datapaths
INSERT INTO @tempAvailIdxMas
SELECT DISTINCT MM.clientId, AGC.copy as copyPrecedence, MMD.Flag & 1 as isDefaultDatapath
FROM MmHost AS MM WITH(NOLOCK)
INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = @i_appId
INNER JOIN MMDataPath MMD WITH(NOLOCK) ON  MMD.Flag & 4 = 4  --Get both default datapath and all secondary datapaths
INNER JOIN MMDrivePool MMDP WITH(NOLOCK) ON MM.clientId = MMDP.ClientId AND MMD.DrivePoolId = MMDP.DrivePoolId AND MM.MmHostSoftState = 1 AND MM.MmHostEnabled = 1 AND (MM.Attribute & 16) = 0
INNER JOIN archGroupCopy AGC WITH(NOLOCK) ON AGC.archGroupId = APP.dataArchGrpID AND AGC.id=MMD.CopyId
WHERE @i_copyPrecedence = 0 OR AGC.copy = @i_copyPrecedence
--If there is at least one other MA available, pick it as RFC MA
--Else we return 0 as clientId
IF NOT EXISTS(SELECT 1 FROM @tempAvailIdxMas)
BEGIN
	-- No MA is available
	SET @o_RFCMAClientid = 0
	GOTO CX_SELECTION_RFCMA_DONE
END
--Give preference based on copy precedence then default(preferred) or other data path.
SELECT TOP 1 @o_RFCMAClientid = clientId FROM @tempAvailIdxMas ORDER BY copyPrecedence ASC, isDefaultDatapath DESC
CX_SELECTION_RFCMA_DONE:
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRFCMA')
	delete from GxQscripts where name = 'AppGetRFCMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRFCMA')
	delete from GXDBVersions where aliasname = 'AppGetRFCMA'
GO

insert into GXDBVersions values(2, 'AppGetRFCMA',  '00000000000000000000', 'AppGetRFCMA', '00000000000000000000')
GO

