

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRFCDetails.sp] ---------- 

--      +-----------------------------------------------------------------------+
--      |                       Procedure : "AppGetRFCDetails"
--      +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetRFCDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetRFCDetails <<<'
	drop procedure AppGetRFCDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetRFCDetails')
	delete from GxQscripts where name = 'AppGetRFCDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRFCDetails')
	delete from GXDBVersions where aliasname = 'AppGetRFCDetails'
GO
print '... Creating Procedure: AppGetRFCDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetRFCDetails
  @xmlText XML OUTPUT
AS
--This shouldnt be used because there are nested stored procs which need read committed
--SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--input variables
declare @inputClientName nvarchar(max) = @xmlText.value('(/App_GetRFCDetailsReq/@clientName)[1]', 'nvarchar(max)')
declare @inputAppguid nvarchar(max) =  ISNULL(@xmlText.value('(/App_GetRFCDetailsReq/@appGUID)[1]', 'nvarchar(max)'),N'')
declare @inputCommCellId int = ISNULL(@xmlText.value('(/App_GetRFCDetailsReq/@commCellId)[1]', 'integer'),0)
declare @inputJobId int = @xmlText.value('(/App_GetRFCDetailsReq/@jobId)[1]', 'integer')
declare @inputRFCServerType int = @xmlText.value('(/App_GetRFCDetailsReq/@RFCServerType)[1]', 'integer')
declare @inputArchLogFileName nvarchar(max) = @xmlText.value('(/App_GetRFCDetailsReq/@archLogFileName)[1]', 'nvarchar(max)')
declare @copyFromPrevJob int = ISNULL(@xmlText.value('(/App_GetRFCDetailsReq/@getPrevRFCDetails)[1]', 'integer'), 0)
declare @runningJobId int = ISNULL(@xmlText.value('(/App_GetRFCDetailsReq/@runningJobId)[1]', 'integer'), 0)
declare @uploadMode int = ISNULL(@xmlText.value('(/App_GetRFCDetailsReq/@uploadMode)[1]', 'integer'), 0)
DECLARE @copyPrecedence INT = ISNULL(@xmlText.value('(/App_GetRFCDetailsReq/@copyPrecedence)[1]', 'INTEGER'), 0)
DECLARE @useSnapJobId INT = ISNULL(@xmlText.value('(/App_GetRFCDetailsReq/@useSnapJobId)[1]', 'INTEGER'), 0)
declare @previousCommCellId int = ISNULL(@xmlText.value('(/App_GetRFCDetailsReq/@previousCommCellId)[1]', 'integer'),0)
declare @previousJobId int = @xmlText.value('(/App_GetRFCDetailsReq/@previousJobId)[1]', 'integer')
declare @retVal int = 0
--output variables
declare @outXml XML
declare @outBackupSetGUID nvarchar(max)
declare @outJobId int = 0
declare @outAfileId int = 0
declare @outArchGroupId int = 0
DECLARE @outRFCClientName NVARCHAR(500)= N'', @outRFCHostName NVARCHAR(500)= N''
DECLARE @outcvdPort INT =0 , @outevmgrcPort INT = 0
DECLARE @outAppId int = 0
DECLARE @outErrorCode int = 0
DECLARE @outErrorMessage nvarchar(max)
DECLARE @outIsRFCServerSelectedFirstTime int = 0
--temp variables
declare @tempDBGUID nvarchar(max)
declare @tempAppType int
declare @tempBackupSet int
declare @lastHardIndexingFailureTime int = 0
DECLARE @jobOptionsRFCDetailsXml XML
DECLARE @jobOptionsRFCDetailsStr nvarchar(max) = N''
DECLARE @tempNumInsertedRows int = 0
DECLARE @outRunningJobId int = 0
DECLARE @TempTableCount int = 0
--THREE MODES FOR CLIENT INITIALIZE
--MODE USED IN INIT		- MEANING						- How to identify with variables in the storedProc
--1) READONLY 			-	Download mode				- @outRunningJobId = 0
--2) APPEND_TO_EXISTING - 	Upload and download mode	- @uploadMode is set to 1 and @outRunningJobId <> 0
--3) READONLY 			-	Archive index 				- @uploadMode is set to 0 and @outRunningJobId <> 0
--Note: Due to archFile table & SP14 VSA design,
--For backup copy job, @inputJobId(SNAP jobid) and @outRunningJobid(BACKUPCOPY jobid) are different
BEGIN TRY
	IF (@inputCommCellId=0)
	BEGIN
		SET @outErrorCode = 1
		SET @outErrorMessage = N'Invalid CommCellId input'
		goto CX_EXIT
	END
	--For Downloads, if job is zero, Pick the latest completed job id for appGUID and inputcommcellid. Not supported for commcell migration cases.
	IF @inputJobId=0
	BEGIN
		IF @uploadMode = 1
		BEGIN
			set @outErrorCode = 1
			set @outErrorMessage = N'JobID is zero and cant be used for upload'
			goto CX_EXIT
		END
		IF (LEN(@inputAppguid)=0)
		BEGIN
			set @outErrorCode = 1
			set @outErrorMessage = N'Invalid appGUID to find latest job'
			goto CX_EXIT
		END
		--set Input JobID for further use
		select top 1 @inputJobId=jobId
		from archFile AF (NOLOCK) INNER JOIN APP_Application APPL (NOLOCK)
		ON APPL.id = AF.appId
		WHERE AF.cs_afname = CHECKSUM(@inputArchLogFileName) AND AF.name=@inputArchLogFileName
AND AF.fileType in (1, 7) and AF.isValid=1
		AND APPL.GUID = @inputAppguid --CommcellId check is not needed
		order by AF.cTime DESC, AF.id DESC
	END
	IF @inputJobId=0
	BEGIN
		set @outErrorCode = 1
		set @outErrorMessage = N'Input JobID is zero'
		goto CX_EXIT
	END
	IF (@inputCommCellId=0)
	BEGIN
		SET @outErrorCode = 1
		SET @outErrorMessage = N'Invalid CommCellId input'
		goto CX_EXIT
	END
	-- fetch snap jobid if backup copy job
	IF @useSnapJobId<>0
	BEGIN
		SELECT @inputJobId = (CASE WHEN JMB.jobIdActedOn IS NOT NULL AND (JMB.opType = 60 OR (opType = 59 and bkpattributes & 0x200000000 = 0x200000000)) THEN JMB.jobIdActedOn ELSE JMB.jobId END)
		FROM JMBkpStats JMB WITH (NOLOCK) WHERE JMB.jobId = @inputJobId
	END
	--Query for running job id.
	--Since archFiles for both snap and backup copy jobid are created against snap jobid.
	--SNAP, backup copy or inline backup copy job use the same SNAP jobid for upload/download/archive index
	CREATE TABLE #TempJobDetails (jobid INT, appId INT)
	INSERT INTO #TempJobDetails (jobid, appId)
	(
	select JMBkpJobInfo.jobId,JMBkpJobInfo.applicationId as appId from JMBkpJobInfo (NOLOCK)
	INNER JOIN JMJobInfo (NOLOCK) ON JMJobInfo.jobId=JMBkpJobInfo.jobId AND JMJobInfo.commCellId=JMBkpJobInfo.commCellId
	AND JMJobInfo.state IN (1, 2, 3, 7, 8) --RUNNING, PENDING, WAITING, STOPPENDING, INTERRUPTPENDING Relaxing check to allow pending and waiting jobs upload to work around JM timing issues related to job state
	AND (JMBkpJobInfo.jobId=@inputJobId OR JMBkpJobInfo.jobIdActedOn=@inputJobId) AND JMBkpJobInfo.commCellId=@inputCommCellId
	UNION
	select jobid,appId from JMAdminJobInfoTable (NOLOCK) where jobid=@runningJobId and commCellId=@inputCommCellId
	)
	SELECT @TempTableCount = COUNT(*) from #TempJobDetails
	If @TempTableCount > 1
	BEGIN
		SET @outErrorCode = 1
		SET @outErrorMessage = N'More than one job details collected.'
		goto CX_EXIT
	END
	select @outRunningJobId=jobid from #TempJobDetails
	--Fail uploads if job is not running
	IF @uploadMode = 1 AND @outRunningJobId=0
	BEGIN
		set @outErrorCode = 1
		set @outErrorMessage = N'Job is not running. Upload is restricted'
		goto CX_EXIT
	END
	--At this point, we know which mode we are dealing with.
	--THREE MODES FOR CLIENT INITIALIZE
	--MODE USED IN INIT		- MEANING						- How to identify with variables in the storedProc
	--1) READONLY 			-	Download mode				- @outRunningJobId = 0
	--2) APPEND_TO_EXISTING - 	Upload and download mode	- @uploadMode is set to 1 and @outRunningJobId <> 0
	--3) READONLY 			-	Archive index 				- @uploadMode is set to 0 and @outRunningJobId <> 0
	--Fill Appid and fill APPGUID from JobId if not present.
	IF (LEN(@inputAppguid)>0)
	BEGIN
		select @outAppId=id from app_application (NOLOCK) where GUID=@inputAppguid
	END
	ELSE
	BEGIN
		SELECT @outAppId = applicationId FROM JMBkpJobInfo (NOLOCK) WHERE jobId=@inputJobId and commCellId=@inputCommCellId
		IF (@outAppId=0)
		BEGIN
			select @outAppId=appId from JMAdminJobInfoTable (NOLOCK) where jobId=@inputJobId and commCellId=@inputCommCellId
			IF (@outAppId=0)
			BEGIN
				select @outAppId=appId from JMBkpStats (NOLOCK) where jobId=@inputJobId and commCellId=@inputCommCellId
				IF (@outAppId=0)
				BEGIN
				select @outAppId=appId from JMAdminJobStatsTable (NOLOCK) where jobId=@inputJobId and commCellId=@inputCommCellId
				END
			END
		END
		select @inputAppguid=GUID from app_application (NOLOCK) where id=@outAppId
	END
	IF (@outAppId=0)
	BEGIN
		SET @outErrorCode = 1
		SET @outErrorMessage = N'Invalid AppId selected'
		goto CX_EXIT
	END
	--Fill Backupset Details for IndexServer Query
	select @outBackupSetGUID=BS.GUID , @tempAppType=APPL.appTypeId, @tempBackupSet=BS.id
	from APP_Application (NOLOCK) APPL inner join APP_BackupSetName (NOLOCK) as BS on BS.id= APPL.backupSet
	where APPL.id=@outAppId
	--Backward compatibility: Pre-SP18 Clients set Uploadmode to track uploaded files.
	--For Upload mode open, set Job option so that archive index backs up files for the job.
	IF @uploadMode = 1
	BEGIN
		INSERT INTO JMJobOptions(jobId, commCellId, attributeId, attributeName, attributeValueInt, attributeValue)
SELECT @outRunningJobId, @inputCommCellId, 82, N'Is Remote File Cache Files Uploaded', 1, ''
		WHERE NOT EXISTS (
		SELECT 1 FROM JMJobOptions (NOLOCK)
WHERE jobId = @outRunningJobId AND commcellId = @inputCommCellId AND attributeId = 82 AND attributeValueInt=1
		)
	END
	--For Uploads and Downloads, pick the afile with highest cTime in case of hard indexing failure
	--For Downloads, lastHardIndexingFailureTime would be zero.
	--For Uploads, fetch timestamp when last hard indexing failure happened.
	SELECT @lastHardIndexingFailureTime = intData FROM JMMisc (NOLOCK)
	WHERE jobId = @inputJobId AND commcellId = @inputCommCellId
	AND itemType = 36 --JM_LAST_HARD_INDEXING_FAILURE
	--For Downloads, fill AfileId details
	select top 1 @outAfileId=id, @outArchGroupId=archGroupId, @outJobId=jobId
	from archFile (NOLOCK) where jobId = @inputJobId and name=@inputArchLogFileName and commCellId=@inputCommCellId
and fileType in (1, 7) and isValid=1 and cTime>@lastHardIndexingFailureTime
	order by cTime DESC,id DESC
	--Copy from previous Job for same appId as current job id
	declare @copyFromJobId int = 0
	declare @copyFromAFileId int = 0
	declare @copyFromAGroupId int = 0
	declare @copyFromCCId int = 0
	IF @copyFromPrevJob = 1
	BEGIN
		IF @runningJobId = 0
	    BEGIN
			--Incase of backward compatibility for client
			--Copy from the latest
			select top 1 @copyFromAFileId=id, @copyFromAGroupId=archGroupId, @copyFromJobId=jobId, @copyFromCCId = commCellId
from archFile (NOLOCK) where appId=@outAppId and fileType in (1, 7) and isValid=1 and name=@inputArchLogFileName
			order by cTime DESC,id DESC
	    END
	    ELSE
	    BEGIN
			DECLARE @previousCopyPrecedence INT = 0
			if @previousJobId>0 AND @previousCommCellId>0
			BEGIN
				SET @copyFromJobId = @previousJobId
				SET @copyFromCCId = @previousCommCellId
			END
			ELSE
			BEGIN
				--Copy from the latest
				DECLARE @currentCommCellId INT = 2
				DECLARE @jobStartTime INT
				DECLARE @appId INT
				SELECT  @jobStartTime = JI.jobStartTime, @appId = JB.applicationId
				FROM JMJobInfo JI (NOLOCK) INNER JOIN JMBkpJobInfo JB (NOLOCK)
				ON JB.jobId = JI.jobId
				AND JI.jobId = @runningJobId AND JI.commCellId = @currentCommCellId
				SELECT TOP 1
				@copyFromJobId = (CASE WHEN opType in (59, 60) THEN J.jobIdActedOn ELSE J.jobId END), @copyFromCCId = J.commCellId
				FROM JMBkpStats J (NOLOCK)
				WHERE J.appId = @appID
				AND J.status IN (1, 3 ,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND J.servStartDate < @jobStartTime
				AND J.opType IN (4, 14, 59, 60) -- BACKUP, SNAPTOTAPE
				ORDER BY J.servStartDate DESC
				IF @copyFromJobId = 0
				BEGIN
					SET @outErrorCode = 1
					SET @outErrorMessage = N'Unable to find previous job to copy from'
					goto CX_EXIT
				END
SET @previousCopyPrecedence = -1
			END
			CREATE TABLE #tempAFiles (r_archFileId INT, r_commCellId INT, r_archGroupId INT, r_archCopyId INT, r_archFileFlags INT, r_archFileCopyFlags INT, r_streamNum INT, r_jobId INT, r_cTime INT)
			INSERT INTO #tempAFiles
			EXEC archFileByNameJob 0 /*appid*/, @inputArchLogFileName, @copyFromCCId, @copyFromJobId, @previousCopyPrecedence, 0 /*aged data*/, 0 /*client id*/, 0 /*instance id*/, 0 /*afile id*/
			SELECT TOP 1 @copyFromAFileId = AF.r_archFileId, @copyFromAGroupId = AF.r_archGroupId, @copyFromJobId = AF.r_jobId, @copyFromCCId = r_commCellId FROM #tempAFiles AF
		END
	END
    --Pick RFC MA
    IF @inputRFCServerType = 101 --Index Server
    BEGIN
		--For current running job, fetch already picked MA details.
		--If Job option is present, Use already picked MA throughout the job to avoid MA failover.
		IF (@outRunningJobId!=0)
		BEGIN
			--For backward compatibility with SP18 DVD Cut, Delete old JMJoboptions with name not equal to JM_REMOTEFILECACHE_DETAILS and id 85
DELETE FROM JMJobOptions where commcellId = @inputCommCellId AND jobid=@outRunningJobId AND attributeid = 85 AND attributeName!= N'Remote File Cache Details'
			--Fetch RFC details from Job Options
			SET @jobOptionsRFCDetailsStr = ISNULL((SELECT top 1 attributeValue FROM JMJobOptions (NOLOCK)
WHERE jobId = @outRunningJobId AND commcellId = @inputCommCellId AND attributeId = 85),N'')
			IF (@jobOptionsRFCDetailsStr!='')
			BEGIN
				SET @jobOptionsRFCDetailsXml = CONVERT(XML, @jobOptionsRFCDetailsStr)
				SELECT @outRFCClientName = req.value('@clientName_RFCServer', 'NVARCHAR(500)'), @outRFCHostName = req.value('@hostName_RFCServer', 'NVARCHAR(500)'),
				@outcvdPort = req.value('@cvdPort_RFCServer', 'INT'), @outevmgrcPort = req.value('@evmgrcPort_RFCServer', 'INT')
				FROM @jobOptionsRFCDetailsXml.nodes('/App_JobOptionsRFCDetails') as T(req)
				goto CX_SELECTION_RFCSERVER_DONE
			END
		END
		--For Downloads from completed job (or) if MA is not already picked in JobOptions,
		--Pick RFC MA as IndexServer if available or any available backup MA
		DECLARE @tempIdxSrvrClId INT = 0
		EXEC dbo.AppGetRFCMA @outBackupSetGUID, @inputAppguid, @outAppId, @tempBackupSet, @copyPrecedence, @tempIdxSrvrClId OUTPUT
		IF (@tempIdxSrvrClId=0)
		BEGIN
			SET @outErrorCode = 1
			SET @outErrorMessage = N'All MAs are offline'
			GOTO CX_EXIT
		END
		SELECT @outRFCClientName = name, @outRFCHostName = net_hostname, @outcvdPort = cvdPort, @outevmgrcPort = evmgrcPort
		FROM App_Client (NOLOCK) WHERE id = @tempIdxSrvrClId
		--For current running job, Seal RFC Server MA in JMJoboptions to be used throughout the job, to avoid MA failover.
		IF (@outRunningJobId != 0)
		BEGIN
			--Insert picked MA into JMJoboptions for picking the next client initialize.
			DECLARE @newJobOptionsRFCDetailsXml XML = (
			SELECT @outRFCClientName as '@clientName_RFCServer', @outRFCHostName as '@hostName_RFCServer',
			@outcvdPort as '@cvdPort_RFCServer', @outevmgrcPort as '@evmgrcPort_RFCServer'
			FOR XML PATH('App_JobOptionsRFCDetails'), TYPE)
			INSERT INTO JMJobOptions(jobId, commCellId, attributeId, attributeName, attributeValueInt, attributeValue)
SELECT @outRunningJobId, @inputCommCellId, 85, N'Remote File Cache Details', 0, CONVERT(nvarchar(max),@newJobOptionsRFCDetailsXml)
			WHERE NOT EXISTS (
			SELECT 1 FROM JMJobOptions (NOLOCK)
WHERE jobId = @outRunningJobId AND commcellId = @inputCommCellId AND attributeId = 85
			)
			--Handling race condition for point of check and use.
			--If row count is not one, then insert failed because there was already a row inserted meanwhile.
			--Just retrieve the already present record in that case, and complete procedure successfully.
			SET @tempNumInsertedRows = @@ROWCOUNT
			IF (@tempNumInsertedRows=1)
			BEGIN
				SET @outIsRFCServerSelectedFirstTime = 1
			END
			ELSE
			BEGIN
				--Fetch MA details from Job Options
				SET @jobOptionsRFCDetailsStr = ISNULL((SELECT top 1 attributeValue FROM JMJobOptions (NOLOCK)
WHERE jobId = @outRunningJobId AND commcellId = @inputCommCellId AND attributeId = 85 order by id DESC),N'')
				IF (@jobOptionsRFCDetailsStr!='')
				BEGIN
					SET @jobOptionsRFCDetailsXml = CONVERT(XML, @jobOptionsRFCDetailsStr)
					SELECT @outRFCClientName = req.value('@clientName_RFCServer', 'NVARCHAR(500)'), @outRFCHostName = req.value('@hostName_RFCServer', 'NVARCHAR(500)'),
					@outcvdPort = req.value('@cvdPort_RFCServer', 'INT'), @outevmgrcPort = req.value('@evmgrcPort_RFCServer', 'INT')
					FROM @jobOptionsRFCDetailsXml.nodes('/App_JobOptionsRFCDetails') as T(req)
				END
				ELSE
				BEGIN
					SET @outErrorCode = 1
					SET @outErrorMessage = N'RFCDetails not found in JMJobOptions.'
					goto CX_EXIT
				END
			END
		END
	END --IndexServer
CX_SELECTION_RFCSERVER_DONE:
    SET @outXml = (
	      select  @outJobId as '@jobId' , @outAfileId as '@aFileId', @outArchGroupId as '@aGroupNumber', @outBackupSetGUID as '@backupSetGUID', @outAppId as '@appId',
	      @outRFCClientName as '@clientName_RFCServer' , @outRFCHostName as '@hostName_RFCServer', @outcvdPort as '@cvdPort_RFCServer', @outevmgrcPort as '@evmgrcPort_RFCServer',
		  @inputCommCellId as '@commCellId', @inputAppguid as '@appGUID', @outIsRFCServerSelectedFirstTime as '@isRFCServerSelectedFirstTime',  @outRunningJobId as '@uploadingJobId',
	      (SELECT @copyFromAFileId as '@aFileId', @copyFromAGroupId as '@aGroupNumber', @copyFromCCId as '@commCellId', @copyFromJobId  as '@jobId'
		  FOR XML PATH('prevRFCDetails'), TYPE)
	      FOR XML PATH('App_GetRFCDetailsResp') , TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @outErrorCode = ERROR_NUMBER()
	SET @outErrorMessage = N'Exception Caught with FATAL ERROR : ' + ERROR_MESSAGE()
	IF @outErrorCode = 1205  --DEADLOCK error
    BEGIN
		;THROW;   -- rethrow the DEADLOCK so XE captures.
    END
END CATCH
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#tempAFiles') IS NOT NULL     DROP TABLE #tempAFiles
IF OBJECT_ID('tempdb.dbo.#TempUploadedFilesList') IS NOT NULL     DROP TABLE #TempUploadedFilesList
IF OBJECT_ID('tempdb.dbo.#TempJobDetails') IS NOT NULL     DROP TABLE #TempJobDetails
IF @outErrorCode <> 0
BEGIN
	SET @outXml = ( SELECT
	(SELECT @outErrorCode as '@errorCode',
	@outErrorMessage as '@errorMessage'
    FOR XML PATH('errorResp'), TYPE)
	FOR XML PATH('App_GetRFCDetailsResp'), TYPE)
END
SELECT @xmlText = @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRFCDetails')
	delete from GxQscripts where name = 'AppGetRFCDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRFCDetails')
	delete from GXDBVersions where aliasname = 'AppGetRFCDetails'
GO

insert into GXDBVersions values(2, 'AppGetRFCDetails',  '00000000000000000000', 'AppGetRFCDetails', '00000000000000000000')
GO

