

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRCAUsers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--		This SP takes clientId of the Remote Client Access (RCA) target as input and returns the list of user IDs, which are allowed to connect to this target.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRCAUsers <<<'

IF EXISTS (select * from sysobjects where name='AppGetRCAUsers')
	drop procedure AppGetRCAUsers
IF EXISTS (select * from GxQscripts where name='AppGetRCAUsers')
	delete from GxQscripts where name = 'AppGetRCAUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAUsers')
	delete from GXDBVersions where aliasname = 'AppGetRCAUsers'
GO
print '... Creating Procedure: AppGetRCAUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRCAUsers
  @clientId INT
AS
  DECLARE @o_userId INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@resultTbl				TABLE(id INT)
DECLARE	@rcaRule				nvarchar(max) = NULL
DECLARE	@ruleXML				XML
DECLARE	@allowAnyOwner			INT = 0
DECLARE	@allowSpecificUsers		INT = 0
DECLARE	@userGroupsTbl			TABLE(id INT)
DECLARE	@adGroupsTbl			TABLE(id INT, name nvarchar(255))
DECLARE @RCAEnabled	INT = 0                                                                                                                                                                         
  SET @RCAEnabled = ISNULL((SELECT attrVal FROM APP_clientProp WHERE attrName = 'VPNEnableRemoteClientAccess' AND componentNameId = @clientId AND modified = 0), 0)                                   
  IF @RCAEnabled <> 0                                                                                                                                                                                 
  BEGIN                                                                                                                                                                                               
      SET @rcaRule = (SELECT TOP 1 remoteAccessRules FROM App_FirewallRemoteAccess WHERE clientId = @clientId AND modified = 0)                                                                       
  END                                                                                                                                                                                                 
  ELSE                                                                                                                                                                                                
  BEGIN                                                                                                                                                                                               
      DECLARE	@clientGroupsTbl TABLE(id INT)                                                                                                                                                          
      INSERT INTO @clientGroupsTbl                                                                                                                                                                    
      SELECT ACGA.clientGroupId                                                                                                                                                                       
      FROM APP_ClientGroupAssoc as ACGA                                                                                                                                                               
      INNER JOIN APP_ClientGroup ACG ON ACG.id = ACGA.clientGroupId AND ACGA.clientId = @clientId AND(ACG.flag & 0x10000) = 0x10000 -- CV_FLAG_VPN_REMOTE_CLIENT_ACCESS_ENABLED                       
                                                                                                                                                                                                      
      DECLARE @pickClientGroup INT = 0                                                                                                                                                                
      SET @pickClientGroup = ISNULL((SELECT TOP 1 id from @clientGroupsTbl), 0)                                                                                                                       
      IF @pickClientGroup <> 0                                                                                                                                                                        
      BEGIN                                                                                                                                                                                           
          SET @rcaRule = (SELECT TOP 1 remoteAccessRules FROM App_FirewallRemoteAccess WHERE clientGroupId = @pickClientGroup AND modified = 0)                                                       
      END                                                                                                                                                                                             
  END
IF @rcaRule IS NOT NULL
BEGIN
    SET @ruleXML = CAST(CAST(@rcaRule AS TEXT) AS XML)
    SET @allowAnyOwner = ISNULL((SELECT ref.value('@allowAnyOwner', 'int') FROM @ruleXML.nodes('App_RemoteClientAccess') R(ref)), 0)
    IF @allowAnyOwner <> 0
    BEGIN
        INSERT INTO @resultTbl SELECT o.userId FROM sec_getClientOwners(1) o WHERE o.clientId = @clientId AND o.userId <> 0
    END
    SET @allowSpecificUsers = ISNULL((SELECT ref.value('@allowSpecificUsers', 'int') FROM @ruleXML.nodes('App_RemoteClientAccess') R(ref)), 0)
    IF @allowSpecificUsers <> 0
    BEGIN
        INSERT INTO @resultTbl SELECT ref.value('@userId', 'int') FROM @ruleXML.nodes('App_RemoteClientAccess/users') R(ref)
        INSERT INTO @userGroupsTbl SELECT ref.value('@userGroupId', 'int') FROM @ruleXML.nodes('App_RemoteClientAccess/userGroups') R(ref)
        INSERT INTO @adGroupsTbl SELECT ref.value('@providerId', 'int'), ref.value('@externalGroupName', 'nvarchar(255)') FROM @ruleXML.nodes('App_RemoteClientAccess/adGroups') R(ref)
        INSERT INTO @userGroupsTbl SELECT UMDS.id FROM @adGroupsTbl as AD INNER JOIN UMDSgroups UMDS ON UMDS.umdsProviderId = AD.id AND UMDS.name = AD.name
		INSERT INTO @resultTbl SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN (SELECT id FROM @userGroupsTbl)
    END
END
SELECT DISTINCT id from @resultTbl WHERE id <> 0 ORDER BY id
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRCAUsers')
	delete from GxQscripts where name = 'AppGetRCAUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAUsers')
	delete from GXDBVersions where aliasname = 'AppGetRCAUsers'
GO

insert into GXDBVersions values(2, 'AppGetRCAUsers',  '00000000000000000000', 'AppGetRCAUsers', '00000000000000000000')
GO

