

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRCAServices.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--		This SP takes clientId of the Remote Client Access (RCA) target as input and returns the services enabled on it.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRCAServices <<<'

IF EXISTS (select * from sysobjects where name='AppGetRCAServices')
	drop procedure AppGetRCAServices
IF EXISTS (select * from GxQscripts where name='AppGetRCAServices')
	delete from GxQscripts where name = 'AppGetRCAServices'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAServices')
	delete from GXDBVersions where aliasname = 'AppGetRCAServices'
GO
print '... Creating Procedure: AppGetRCAServices'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRCAServices
  @clientId INT
AS
  DECLARE @o_service INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@resultTbl				TABLE(service INT)
DECLARE	@rcaRule				nvarchar(max) = NULL
DECLARE	@ruleXML				XML
DECLARE	@service				INT = 0
DECLARE @RCAEnabled	INT = 0                                                                                                                                                                         
  SET @RCAEnabled = ISNULL((SELECT attrVal FROM APP_clientProp WHERE attrName = 'VPNEnableRemoteClientAccess' AND componentNameId = @clientId AND modified = 0), 0)                                   
  IF @RCAEnabled <> 0                                                                                                                                                                                 
  BEGIN                                                                                                                                                                                               
      SET @rcaRule = (SELECT TOP 1 remoteAccessRules FROM App_FirewallRemoteAccess WHERE clientId = @clientId AND modified = 0)                                                                       
  END                                                                                                                                                                                                 
  ELSE                                                                                                                                                                                                
  BEGIN                                                                                                                                                                                               
      DECLARE	@clientGroupsTbl TABLE(id INT)                                                                                                                                                          
      INSERT INTO @clientGroupsTbl                                                                                                                                                                    
      SELECT ACGA.clientGroupId                                                                                                                                                                       
      FROM APP_ClientGroupAssoc as ACGA                                                                                                                                                               
      INNER JOIN APP_ClientGroup ACG ON ACG.id = ACGA.clientGroupId AND ACGA.clientId = @clientId AND(ACG.flag & 0x10000) = 0x10000 -- CV_FLAG_VPN_REMOTE_CLIENT_ACCESS_ENABLED                       
                                                                                                                                                                                                      
      DECLARE @pickClientGroup INT = 0                                                                                                                                                                
      SET @pickClientGroup = ISNULL((SELECT TOP 1 id from @clientGroupsTbl), 0)                                                                                                                       
      IF @pickClientGroup <> 0                                                                                                                                                                        
      BEGIN                                                                                                                                                                                           
          SET @rcaRule = (SELECT TOP 1 remoteAccessRules FROM App_FirewallRemoteAccess WHERE clientGroupId = @pickClientGroup AND modified = 0)                                                       
      END                                                                                                                                                                                             
  END
IF @rcaRule IS NOT NULL
BEGIN
	SET @ruleXML = CAST(CAST(@rcaRule AS TEXT) AS XML)
	INSERT INTO @resultTbl SELECT ref.value('@val', 'int') FROM @ruleXML.nodes('App_RemoteClientAccess/services') R(ref)
END
SELECT DISTINCT service from @resultTbl ORDER BY service
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRCAServices')
	delete from GxQscripts where name = 'AppGetRCAServices'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAServices')
	delete from GXDBVersions where aliasname = 'AppGetRCAServices'
GO

insert into GXDBVersions values(2, 'AppGetRCAServices',  '00000000000000000000', 'AppGetRCAServices', '00000000000000000000')
GO

