

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRCAProxy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--		This SP takes clientId of the Remote Client Access (RCA) target as input and returns the details of Proxy that other clients are expected to use in order to contact this target.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRCAProxy <<<'

IF EXISTS (select * from sysobjects where name='AppGetRCAProxy')
	drop procedure AppGetRCAProxy
IF EXISTS (select * from GxQscripts where name='AppGetRCAProxy')
	delete from GxQscripts where name = 'AppGetRCAProxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAProxy')
	delete from GXDBVersions where aliasname = 'AppGetRCAProxy'
GO
print '... Creating Procedure: AppGetRCAProxy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRCAProxy
  @clientId INT
AS
  DECLARE @o_proxyId INT
  DECLARE @o_proxyName nvarchar(255)
  DECLARE @o_proxyHostName nvarchar(255)
  DECLARE @o_proxyGUID nvarchar(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@resultTbl				TABLE(id INT, name nvarchar(255), hostName nvarchar(255), GUID nvarchar(255))
DECLARE	@rcaRule				nvarchar(max) = NULL
DECLARE	@ruleXML				XML
DECLARE	@proxy					INT = 0
DECLARE @RCAEnabled	INT = 0                                                                                                                                                                         
  SET @RCAEnabled = ISNULL((SELECT attrVal FROM APP_clientProp WHERE attrName = 'VPNEnableRemoteClientAccess' AND componentNameId = @clientId AND modified = 0), 0)                                   
  IF @RCAEnabled <> 0                                                                                                                                                                                 
  BEGIN                                                                                                                                                                                               
      SET @rcaRule = (SELECT TOP 1 remoteAccessRules FROM App_FirewallRemoteAccess WHERE clientId = @clientId AND modified = 0)                                                                       
  END                                                                                                                                                                                                 
  ELSE                                                                                                                                                                                                
  BEGIN                                                                                                                                                                                               
      DECLARE	@clientGroupsTbl TABLE(id INT)                                                                                                                                                          
      INSERT INTO @clientGroupsTbl                                                                                                                                                                    
      SELECT ACGA.clientGroupId                                                                                                                                                                       
      FROM APP_ClientGroupAssoc as ACGA                                                                                                                                                               
      INNER JOIN APP_ClientGroup ACG ON ACG.id = ACGA.clientGroupId AND ACGA.clientId = @clientId AND(ACG.flag & 0x10000) = 0x10000 -- CV_FLAG_VPN_REMOTE_CLIENT_ACCESS_ENABLED                       
                                                                                                                                                                                                      
      DECLARE @pickClientGroup INT = 0                                                                                                                                                                
      SET @pickClientGroup = ISNULL((SELECT TOP 1 id from @clientGroupsTbl), 0)                                                                                                                       
      IF @pickClientGroup <> 0                                                                                                                                                                        
      BEGIN                                                                                                                                                                                           
          SET @rcaRule = (SELECT TOP 1 remoteAccessRules FROM App_FirewallRemoteAccess WHERE clientGroupId = @pickClientGroup AND modified = 0)                                                       
      END                                                                                                                                                                                             
  END
IF @rcaRule IS NOT NULL
BEGIN
	SET @ruleXML = CAST(CAST(@rcaRule AS TEXT) AS XML)
    SET @proxy = ISNULL((SELECT ref.value('@clientId', 'int') FROM @ruleXML.nodes('App_RemoteClientAccess/proxy') R(ref)), 0)
	IF @proxy <> 0
	BEGIN
		INSERT INTO @resultTbl
        SELECT AC.id, AC.name, AC.net_hostname, AC.GUID
        FROM APP_CLIENT as AC
WHERE AC.id = @proxy AND AC.GUID IS NOT NULL AND AC.releaseId >= 16
	END
END
SELECT DISTINCT * from @resultTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRCAProxy')
	delete from GxQscripts where name = 'AppGetRCAProxy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAProxy')
	delete from GXDBVersions where aliasname = 'AppGetRCAProxy'
GO

insert into GXDBVersions values(2, 'AppGetRCAProxy',  '00000000000000000000', 'AppGetRCAProxy', '00000000000000000000')
GO

