

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRCAMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- This SP takes a clientId as input and returns the list of Remote Client Access targets that have any service enabled and that grant by virtue of
-- their rdpUsers ownership access from this client. This is a reverse setting that will be present on clients even w/o services enabled.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRCAMap <<<'

IF EXISTS (select * from sysobjects where name='AppGetRCAMap')
	drop procedure AppGetRCAMap
IF EXISTS (select * from GxQscripts where name='AppGetRCAMap')
	delete from GxQscripts where name = 'AppGetRCAMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAMap')
	delete from GXDBVersions where aliasname = 'AppGetRCAMap'
GO
print '... Creating Procedure: AppGetRCAMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRCAMap
  @clientId INT
AS
  DECLARE @o_id INT
  DECLARE @o_name nvarchar(255)
  DECLARE @o_hostName nvarchar(255)
  DECLARE @o_GUID nvarchar(255)
  DECLARE @o_proxyId INT
  DECLARE @o_proxyName nvarchar(255)
  DECLARE @o_proxyHostName nvarchar(255)
  DECLARE @o_proxyGUID nvarchar(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@resultTbl				TABLE(id INT, name nvarchar(255), hostName nvarchar(255), GUID nvarchar(255), proxyId INT, proxyName nvarchar(255), proxyHostName nvarchar(255), proxyGUID nvarchar(255))
DECLARE	@processClientsTbl		TABLE(id INT)
DECLARE	@processClientGroupsTbl	TABLE(id INT)
DECLARE	@servicesTbl			TABLE(service INT)
DECLARE	@proxyTbl				TABLE(id INT, name nvarchar(255), hostName nvarchar(255), GUID nvarchar(255))
DECLARE	@usersTbl				TABLE(id INT)
DECLARE	@clientsTbl				TABLE(id INT)
DECLARE	@processClientId		INT
-- Enumerate all clients other than this target with RCA directly enabled on them
INSERT INTO @processClientsTbl
SELECT AC.id
FROM APP_clientProp AS ACP
INNER JOIN APP_CLIENT AC
ON AC.id = ACP.componentNameId AND ACP.attrName = 'VPNEnableRemoteClientAccess' AND ACP.attrVal = '1' AND ACP.modified = 0 AND AC.id <> @clientId AND AC.releaseId >= 16
-- Enumerate all clients other than this target with RCA enabled on them via client groups
INSERT INTO @processClientGroupsTbl
SELECT ACG.id
FROM APP_ClientGroup ACG
WHERE (ACG.flag & 0x10000) = 0x10000
INSERT INTO @processClientsTbl
SELECT AC.id
FROM @processClientGroupsTbl as CG
INNER JOIN APP_ClientGroupAssoc ACGA ON CG.id = ACGA.clientGroupId
INNER JOIN APP_CLIENT AC ON AC.id = ACGA.clientId AND AC.id <> @clientId AND AC.releaseId >= 16
DECLARE cur CURSOR STATIC FOR SELECT DISTINCT id FROM @processClientsTbl WHERE id <> @clientId ORDER BY id
OPEN cur
FETCH NEXT FROM cur INTO @processClientId
    WHILE @@FETCH_STATUS = 0
    BEGIN
		DELETE @servicesTbl
		DELETE @proxyTbl
		DELETE @usersTbl
		DELETE @clientsTbl
		INSERT INTO @servicesTbl EXEC APPGetRCAServices @processClientId
		IF EXISTS (SELECT * FROM @servicesTbl)
		BEGIN
			INSERT INTO @proxyTbl EXEC APPGetRCAProxy @processClientId
			IF EXISTS (SELECT * FROM @proxyTbl)
			BEGIN
				INSERT INTO @usersTbl EXEC APPGetRCAUsers @processClientId
				INSERT INTO @clientsTbl
				SELECT DISTINCT o.clientId
				FROM sec_getClientOwners(1) o
				INNER JOIN @usersTbl U ON U.id = o.userId AND o.clientId <> @processClientId
INNER JOIN APP_CLIENT AC ON AC.id = o.clientId AND AC.releaseId >= 16
				IF EXISTS (SELECT id FROM @clientsTbl WHERE id = @clientId)
				BEGIN
				    INSERT INTO @resultTbl
					SELECT AC.id, AC.name, AC.net_hostname, AC.GUID, P.id, P.name, P.hostName, P.GUID
					FROM @proxyTbl as P
INNER JOIN APP_CLIENT AC ON AC.id = @processClientId AND AC.GUID IS NOT NULL AND AC.releaseId >= 16
				END
			END
		END
		FETCH NEXT FROM cur INTO @processClientId
	END
CLOSE  cur
DEALLOCATE cur
SELECT DISTINCT * FROM @resultTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRCAMap')
	delete from GxQscripts where name = 'AppGetRCAMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAMap')
	delete from GXDBVersions where aliasname = 'AppGetRCAMap'
GO

insert into GXDBVersions values(2, 'AppGetRCAMap',  '00000000000000000000', 'AppGetRCAMap', '00000000000000000000')
GO

