

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetRCAClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- This SP takes clientId of the Remote Client Access (RCA) target as input and returns the list of clients (other than the current target) owned by rdpUsers
-- where rdpUsers is the output of AppGetRCAUsers.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetRCAClients <<<'

IF EXISTS (select * from sysobjects where name='AppGetRCAClients')
	drop procedure AppGetRCAClients
IF EXISTS (select * from GxQscripts where name='AppGetRCAClients')
	delete from GxQscripts where name = 'AppGetRCAClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAClients')
	delete from GXDBVersions where aliasname = 'AppGetRCAClients'
GO
print '... Creating Procedure: AppGetRCAClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetRCAClients
  @clientId INT
AS
  DECLARE @o_clientId INT
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_clientHostName nvarchar(255)
  DECLARE @o_clientGUID nvarchar(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @rcaRule                nvarchar(max) = NULL
DECLARE @RCAEnabled	INT = 0                                                                                                                                                                         
  SET @RCAEnabled = ISNULL((SELECT attrVal FROM APP_clientProp WHERE attrName = 'VPNEnableRemoteClientAccess' AND componentNameId = @clientId AND modified = 0), 0)                                   
  IF @RCAEnabled <> 0                                                                                                                                                                                 
  BEGIN                                                                                                                                                                                               
      SET @rcaRule = (SELECT TOP 1 remoteAccessRules FROM App_FirewallRemoteAccess WHERE clientId = @clientId AND modified = 0)                                                                       
  END                                                                                                                                                                                                 
  ELSE                                                                                                                                                                                                
  BEGIN                                                                                                                                                                                               
      DECLARE	@clientGroupsTbl TABLE(id INT)                                                                                                                                                          
      INSERT INTO @clientGroupsTbl                                                                                                                                                                    
      SELECT ACGA.clientGroupId                                                                                                                                                                       
      FROM APP_ClientGroupAssoc as ACGA                                                                                                                                                               
      INNER JOIN APP_ClientGroup ACG ON ACG.id = ACGA.clientGroupId AND ACGA.clientId = @clientId AND(ACG.flag & 0x10000) = 0x10000 -- CV_FLAG_VPN_REMOTE_CLIENT_ACCESS_ENABLED                       
                                                                                                                                                                                                      
      DECLARE @pickClientGroup INT = 0                                                                                                                                                                
      SET @pickClientGroup = ISNULL((SELECT TOP 1 id from @clientGroupsTbl), 0)                                                                                                                       
      IF @pickClientGroup <> 0                                                                                                                                                                        
      BEGIN                                                                                                                                                                                           
          SET @rcaRule = (SELECT TOP 1 remoteAccessRules FROM App_FirewallRemoteAccess WHERE clientGroupId = @pickClientGroup AND modified = 0)                                                       
      END                                                                                                                                                                                             
  END
IF @rcaRule IS NOT NULL
BEGIN
	DECLARE	@resultTbl				TABLE(id INT, name nvarchar(255), hostName nvarchar(255), GUID nvarchar(255))
	DECLARE	@usersTbl				TABLE(id INT)
	INSERT INTO @usersTbl EXEC APPGetRCAUsers @clientId
	INSERT INTO @resultTbl
	SELECT DISTINCT AC.id, AC.name, AC.net_hostname, AC.GUID
	FROM sec_getClientOwners(1) o
	INNER JOIN @usersTbl U ON U.id = o.userId AND o.clientId <> @clientId
INNER JOIN APP_CLIENT AC ON AC.id = o.clientId AND AC.releaseId >= 16
	SELECT * FROM @resultTbl ORDER BY id
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetRCAClients')
	delete from GxQscripts where name = 'AppGetRCAClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetRCAClients')
	delete from GXDBVersions where aliasname = 'AppGetRCAClients'
GO

insert into GXDBVersions values(2, 'AppGetRCAClients',  '00000000000000000000', 'AppGetRCAClients', '00000000000000000000')
GO

