

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetPushNotificationConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetPushNotificationConfig.sp,v $ $Id: AppGetPushNotificationConfig.sp,v 1.1.2.3 2018/09/16 03:30:16 vdevassy Exp $";
-- =============================================================
-- Author:		Rohit Iyer
-- Create date: 03/14/2018
-- Description:	Get configuration details for Push notification
-- =============================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetPushNotificationConfig <<<'

IF EXISTS (select * from sysobjects where name='AppGetPushNotificationConfig')
	drop procedure AppGetPushNotificationConfig
IF EXISTS (select * from GxQscripts where name='AppGetPushNotificationConfig')
	delete from GxQscripts where name = 'AppGetPushNotificationConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPushNotificationConfig')
	delete from GXDBVersions where aliasname = 'AppGetPushNotificationConfig'
GO
print '... Creating Procedure: AppGetPushNotificationConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetPushNotificationConfig
  @in_xml XML
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @userId						      		INT
DECLARE @localeId           					INT
DECLARE @isAdminUser        					INT
declare @pushNotifConfigXml					XML
DECLARE @errorCode 							INT
DECLARE @errorMessage 						VARCHAR(MAX)
DECLARE @bDisableMobileNotification      		INT
DECLARE @bMobileNotificatonFreq		      		INT
declare @r_errorsXml						XML
declare @r_pushConfigXml					XML
declare @r_notifServerXml					XML
declare @r_activeMqServerXml				XML
declare @outXml								XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS col1
                         FROM    @in_xml.nodes('App_GetPushNotificationConfigReq/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS col1
                         FROM    @in_xml.nodes('App_GetPushNotificationConfigReq/processinginstructioninfo/locale') R ( ref )),0)
--check requesting user details
IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @userId))
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	SET @errorMessage = REPLACE(@errorMessage, '^1%s', @userId)
	GOTO SEND_RESPONSE
END
--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
IF(@isAdminUser = 0)
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO SEND_RESPONSE
END
--Set the config values here
SET @bDisableMobileNotification = (select CAST(value as nvarchar(10)) from GxGlobalParam where name = 'bDisableMobilePushNotification')
SET @bMobileNotificatonFreq = (select CAST(value as nvarchar(10)) from GxGlobalParam where name = 'bMobilePushConsumerSleepInMins')
SET @r_notifServerXml = (select A.id as '@clientId', A.name as '@clientName' from App_Client A
						  where A.id in (select top 1 CAST(value as INT) from GxGlobalParam with(nolock) where name = 'mobilePushServerId')
						  for xml path('mobilePushServer'))
SET @r_activeMqServerXml = (select A.id as '@clientId', A.name as '@clientName' from App_Client A
						  where A.id in (select top 1 CAST(value as INT) from GxGlobalParam with(nolock) where name = 'mobileActiveMQServerId')
						  for xml path('mobileActiveMQServer'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;
END CATCH
SEND_RESPONSE:
SET @r_errorsXml = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorString'
                    FOR xml PATH('error'))
SET @r_pushConfigXml = (select	@bDisableMobileNotification as '@disableMobilePushNotification',
								@bMobileNotificatonFreq  as '@consumerSleepDurationInMins',
								ISNULL(@r_notifServerXml,''),
								ISNULL(@r_activeMqServerXml,'')
						for xml path('pushConfig'))
SET @outXml = ( select isnull(@r_errorsXml, ''),
						isnull(@r_pushConfigXml, '')
				for xml path(''),
				ROOT('App_GetPushNotificationConfigResp'))
select @outXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetPushNotificationConfig')
	delete from GxQscripts where name = 'AppGetPushNotificationConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPushNotificationConfig')
	delete from GXDBVersions where aliasname = 'AppGetPushNotificationConfig'
GO

insert into GXDBVersions values(2, 'AppGetPushNotificationConfig',  '00010001000200030000', 'AppGetPushNotificationConfig', '00010001000200030000')
GO

