

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetPreviewInventoryListReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Manoj Kumar Gopinath
--	Date:   02/22/2020
-- ----------------------------------------------------------------------*/
/*
--  +------------------------------------------------------------------------------------------+
--  |           Procedure : "AppGetPreviewInventoryListReq"
--  |   This Procedure is used to get a preview request for a given Smart client group ID.
--  +------------------------------------------------------------------------------------------+
*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetPreviewInventoryListReq')
BEGIN
	print '>>> Drop Stored Procedure: AppGetPreviewInventoryListReq <<<'
	drop procedure AppGetPreviewInventoryListReq
END
IF EXISTS (select * from GxQscripts where name='AppGetPreviewInventoryListReq')
	delete from GxQscripts where name = 'AppGetPreviewInventoryListReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPreviewInventoryListReq')
	delete from GXDBVersions where aliasname = 'AppGetPreviewInventoryListReq'
GO
print '... Creating Procedure: AppGetPreviewInventoryListReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetPreviewInventoryListReq
  @i_clientGroupId INT,
  @i_newEntities VARCHAR(MAX) = NULL
AS
  DECLARE @o_xmlResp XML 
DECLARE @xmlResp XML
DECLARE @commaSeparated nvarchar(max)
DECLARE @deletedEntitiesCS NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
IF Object_id('tempdb.dbo.#VMProps') IS NOT NULL
	DROP TABLE #VMProps
CREATE TABLE #VMProps
(
	clientGroupId	INT,
	oldVMId			INT,
	newVMId			INT,
	vmGUID			UNIQUEIDENTIFIER,
	instanceId		INT,
	clientId		INT
)
CREATE CLUSTERED INDEX #VMProps_idx
	ON #VMProps(instanceId, clientId)
IF Object_id('tempdb.dbo.#instanceClientMap') IS NOT NULL
	DROP TABLE #instanceClientMap
CREATE TABLE #instanceClientMap
(
	instanceId		INT,
	clientId		INT
)
CREATE CLUSTERED INDEX #instanceClientMap_idx
	ON #instanceClientMap(instanceId, clientId)
DECLARE @DeletedEntities TABLE
	(VMId INT PRIMARY KEY)
DECLARE @NewEntities TABLE
	(VMId INT PRIMARY KEY)
SELECT @commaSeparated = stringval
FROM	App_ComponentProp
	WHERE	componentType = 8 --CV_COMPONENT_TYPE_CLIENTGROUP
			AND propertyTypeId = 3314 --CV_COMPONENT_CG_VM_CLIENTID_CSV_STRING
			AND componentId = @i_clientGroupId
			AND modified = 0
IF (@commaSeparated IS NULL)
BEGIN
GOTO XMLGEN
END
INSERT INTO #VMProps(clientGroupId, oldVMId)
SELECT DISTINCT @i_clientGroupId,
		data
FROM dbo.Splitstring((@commaSeparated), ',')
IF(@i_newEntities IS NOT NULL)
BEGIN
	INSERT INTO @NewEntities
	SELECT DISTINCT CAST(data as INT) FROM dbo.SplitString((@i_newEntities),',')
	UPDATE #VMProps
	SET newVMId = newETList.vmId
	FROM #VMProps vmp
		LEFT JOIN @NewEntities newETList
		on vmp.oldVMId = newETList.vmId
	DELETE FROM #VMProps
	WHERE newVMId IS NOT NULL
END
-- Delete the entities which are deleted in the previous iteration
SELECT @deletedEntitiesCS = stringval
FROM	App_ComponentProp
	WHERE	componentType = 8 --CV_COMPONENT_TYPE_CLIENTGROUP
			AND propertyTypeId = 3323 --CV_COMPONENT_CG_VM_DELETED_CLIENTID_CSV_STRING
			AND componentId = @i_clientGroupId
			AND modified = 0
IF(@deletedEntitiesCS IS NOT NULL)
BEGIN
	INSERT INTO @DeletedEntities
	SELECT DISTINCT CAST(data as INT) FROM dbo.SplitString((@deletedEntitiesCS),',')
	DELETE vp FROM #VMProps vp
	INNER JOIN @DeletedEntities de
	ON vp.oldVMId = de.VMId
END
UPDATE #VMProps
SET	vmGUID = ac.GUID,
	instanceId = ap.attrval
FROM	#VMProps vmp
	LEFT JOIN App_client ac
		ON ac.id = vmp.oldVMId
	LEFT JOIN App_clientProp ap
		ON ap.componentNameId = vmp.oldVMId
			AND ap.attrname = N'Virtual Machine Instance ID'
			AND ap.modified = 0
UPDATE #VMProps
SET	clientId = aap.clientId
FROM	#VMProps vmp
	LEFT JOIN App_Application aap
		on aap.instance = vmp.instanceId
INSERT INTO #instanceClientMap
SELECT DISTINCT instanceId, clientId
FROM	#VMProps
XMLGEN:
SET @xmlResp = ISNULL((SELECT (SELECT (SELECT DISTINCT
                                        instanceid AS '@instanceId',
                                        clientid   AS '@clientId'
                                         FROM   #VMProps
                                         WHERE	instanceid = #instanceClientMap.instanceid
												AND clientid = #instanceClientMap.clientid
                                         FOR XML PATH('appId'), TYPE),
                                        (SELECT (SELECT
													1		AS '@allOrAnyChildren',
													1		AS '@equalsOrNotEquals',
													oldVMId	AS '@value',
													LOWER(vmguid) AS '@name',
													9      AS '@type'  -- VMType
                                                 FROM   #VMProps
                                                 WHERE  instanceid = #instanceClientMap.instanceid
														AND clientid = #instanceClientMap.clientid
												FOR XML PATH('children'), TYPE)
										FOR XML PATH('contentEntity'), TYPE)
										FROM   #instanceClientMap
									FOR XML PATH('previewInventoryReq'), TYPE)
								FOR XML PATH('EVGui_PreviewInventoryBulkReq')),
							'<EVGui_PreviewInventoryBulkReq/>')
select @xmlResp
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetPreviewInventoryListReq')
	delete from GxQscripts where name = 'AppGetPreviewInventoryListReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPreviewInventoryListReq')
	delete from GXDBVersions where aliasname = 'AppGetPreviewInventoryListReq'
GO

insert into GXDBVersions values(2, 'AppGetPreviewInventoryListReq',  '00000000000000000000', 'AppGetPreviewInventoryListReq', '00000000000000000000')
GO

