

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetPlanfromStoragePolicyV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetPlanfromStoragePolicyV2.sp,v $ $Id: AppGetPlanfromStoragePolicyV2.sp,v 1.1.2.6 2020/08/24 08:43:10 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetPlanfromStoragePolicyV2')
BEGIN
	print '>>> Drop Stored Procedure: AppGetPlanfromStoragePolicyV2 <<<'
	drop procedure AppGetPlanfromStoragePolicyV2
END
IF EXISTS (select * from GxQscripts where name='AppGetPlanfromStoragePolicyV2')
	delete from GxQscripts where name = 'AppGetPlanfromStoragePolicyV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanfromStoragePolicyV2')
	delete from GXDBVersions where aliasname = 'AppGetPlanfromStoragePolicyV2'
GO
print '... Creating Procedure: AppGetPlanfromStoragePolicyV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetPlanfromStoragePolicyV2
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_subclientId INTEGER,
  @i_storagePolicyId INTEGER,
  @i_planId INTEGER			OUTPUT,
  @o_errorCode INTEGER			OUTPUT,
  @o_errorMsg VARCHAR(MAX)	OUTPUT
AS
  DECLARE @planId INT
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
SET NOCOUNT ON
--Variable Declarations
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_errorCode	= 0
SET @o_errorMsg		= N' '
SET @i_planId		= 0
BEGIN TRY
	-- check if Additional key is set
	IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WHERE name='LookupPlanfromStoragePolicy' AND value='0')
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#subclientList_PlanStoragePolicy')	IS NOT null DROP TABLE #subclientList_PlanStoragePolicy
		IF OBJECT_ID('tempdb.dbo.#plansTemp_PlanStoragePolicy')		IS NOT null DROP TABLE #plansTemp_PlanStoragePolicy
		IF OBJECT_ID('tempdb.dbo.#PlansList')						IS NOT NULL DROP TABLE #PlansList
		IF OBJECT_ID('tempdb.dbo.#Subclients_Siblings_Plan')		IS NOT null DROP TABLE #Subclients_Siblings_Plan
		IF OBJECT_ID('tempdb.dbo.#AppPlanHierarchy_tmp__Plans')	IS NOT null DROP TABLE #AppPlanHierarchy_tmp__Plans
		CREATE TABLE #subclientList_PlanStoragePolicy
		(
			subclientId INT, backupSet INT, storagePolicy INT, directPlanId INT, isBasePlan INT, planId INT
		)
		CREATE TABLE #Subclients_Siblings_Plan
		(
			id INT IDENTITY(1,1) PRIMARY KEY, subclientId INT , preferedSiblingPlan INT, row_count INT
		)
		CREATE CLUSTERED INDEX subclientList_PlanStoragePolicy_subclientId_idx ON #subclientList_PlanStoragePolicy(subclientId)
		CREATE TABLE #plansTemp_PlanStoragePolicy
		(
			derivedplanId INT, basePlanId INT, storagePolicyId INT
		)
		CREATE CLUSTERED INDEX Idx_plansTemp_PlanStoragePolicy_1 ON #plansTemp_PlanStoragePolicy (derivedplanId, storagePolicyId)
		CREATE TABLE #PlansList(planId INT NOT NULL)
		CREATE CLUSTERED INDEX PlansList_planId_idx ON #PlansList(planId)
		-- table that holds records on plans derived from @planId can be modified to include only necessary tables
		CREATE TABLE #AppPlanHierarchy_tmp__Plans(planId INT PRIMARY KEY, planName NVARCHAR(512), basePlanId INT,  basePlanName NVARCHAR(512), depth INT)
		DECLARE @ServerPlanTbl TABLE
		(
			id INT IDENTITY(1,1) PRIMARY KEY, appTypeId INT
		)
		-- -- plans that user has rights to edit
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 157, '#PlansList'
		-- -- plans that user has rights to associate/deassociate
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#PlansList'
		INSERT INTO @ServerPlanTbl
SELECT _ID FROM dbo.SplitIDs('3,5,11,33,34,42,43,19,20,17,18,21,29,38,36,63,64,74,106,134,22,80,81,135,125,104,53,78,37,62,80')
		IF (@i_subclientId > 0)
		BEGIN
			IF  (@i_storagePolicyId > 0)
			BEGIN
				-- Storage Policy is present as input
				INSERT INTO #subclientList_PlanStoragePolicy
				SELECT DISTINCT AAP.id, AAP.backupSet, @i_storagePolicyId, APP.componentNameId, 0, 0 FROM APP_Application AAP WITH(NOLOCK)
				INNER JOIN APP_CLIENT C  WITH(NOLOCK)
ON C.id = AAP.clientId AND C.status & 0x1000 = 0 AND C.status & 0x10000000 = 0
				INNER JOIN  @ServerPlanTbl DB
					ON DB.appTypeId=AAP.appTypeId
				INNER JOIN App_PlanProp APP WITH(NOLOCK)
ON APP.attrVal=CAST(@i_storagePolicyId AS NVARCHAR(16)) AND APP.attrName='Storage policy' AND APP.modified=0
				LEFT OUTER JOIN APP_SubClientProp ASCP  WITH(NOLOCK)
					ON ASCP.componentNameId=AAP.id AND ASCP.attrName IN ('Turbo Mode Enable Stubbing', 'DDB Backup', 'Index SubClient') AND ASCP.modified=0 AND ASCP.attrval='1'
						AND ASCP.cs_attrName IN (CHECKSUM(N'Turbo Mode Enable Stubbing'), CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
				LEFT OUTER JOIN APP_ClientProp ACP  WITH(NOLOCK)
					ON ACP.componentNameId=C.id AND ACP.attrName='Index Server Type' AND ACP.modified=0
				LEFT OUTER JOIN APP_BackupSetProp ABP WITH(NOLOCK)
					ON ABP.componentNameId=AAP.backupSet AND ABP.attrName='Is Archiving Enabled' AND ABP.modified=0 AND ABP.attrval='1'
				WHERE AAP.id=@i_subclientId
AND AAP.subclientStatus & 0x00004= 0 AND AAP.subclientStatus & 0x00002 = 0 AND AAP.subclientStatus & 0x200000 = 0 AND AAP.subclientStatus & 0x00010 = 0 AND AAP.subclientStatus & 0x00020 = 0
AND AAP.subclientStatus & 0x2000 = 0
				AND AAP.subclientName NOT IN ('IndexBackup', 'IndexingSubclient', 'DDBbackup', 'System State', 'DR Subclient', 'CvFailoverLogShipping')
				AND ASCP.id IS NULL
				AND ACP.id IS NULL
				AND ABP.id IS NULL
			END
			ELSE
			BEGIN
				-- Storage Policy is not present as input
				INSERT INTO #subclientList_PlanStoragePolicy
				SELECT DISTINCT AAP.id, AAP.backupSet, AAP.dataArchGrpID, APP.componentNameId, 0, 0 FROM APP_Application AAP WITH(NOLOCK)
				INNER JOIN APP_CLIENT C WITH(NOLOCK)
ON C.id = AAP.clientId AND C.status & 0x1000 = 0 AND C.status & 0x10000000 = 0
				INNER JOIN  @ServerPlanTbl DB
					ON DB.appTypeId=AAP.appTypeId
				INNER JOIN App_PlanProp APP WITH(NOLOCK)
ON APP.attrVal=CAST(AAP.dataArchGrpID AS NVARCHAR(16)) AND APP.attrName='Storage policy' AND APP.modified=0
				LEFT OUTER JOIN APP_SubClientProp ASCP WITH(NOLOCK)
					ON ASCP.componentNameId=AAP.id AND ASCP.attrName IN ('Turbo Mode Enable Stubbing', 'DDB Backup', 'Index SubClient') AND ASCP.modified=0 AND ASCP.attrval='1'
						AND ASCP.cs_attrName IN (CHECKSUM(N'Turbo Mode Enable Stubbing'), CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
				LEFT OUTER JOIN APP_ClientProp ACP  WITH(NOLOCK)
					ON ACP.componentNameId=C.id AND ACP.attrName='Index Server Type' AND ACP.modified=0
				LEFT OUTER JOIN APP_BackupSetProp ABP WITH(NOLOCK)
					ON ABP.componentNameId=AAP.backupSet AND ABP.attrName='Is Archiving Enabled' AND ABP.modified=0 AND ABP.attrval='1'
				WHERE AAP.id=@i_subclientId
AND AAP.subclientStatus & 0x00004= 0 AND AAP.subclientStatus & 0x00002 = 0 AND AAP.subclientStatus & 0x200000 = 0 AND AAP.subclientStatus & 0x00010 = 0 AND AAP.subclientStatus & 0x00020 = 0
AND AAP.subclientStatus & 0x2000 = 0
				AND AAP.subclientName NOT IN ('IndexBackup', 'IndexingSubclient', 'DDBbackup', 'System State', 'DR Subclient', 'CvFailoverLogShipping')
				AND ASCP.id IS NULL
				AND ACP.id IS NULL
				AND ABP.id IS NULL
			END
		END
		ELSE
		BEGIN
			-- Get All subclients
			INSERT INTO #subclientList_PlanStoragePolicy
			SELECT DISTINCT AAP.id, AAP.backupSet, AAP.dataArchGrpID, APP.componentNameId, 0, 0 FROM APP_Application AAP WITH(NOLOCK)
			INNER JOIN APP_CLIENT C WITH(NOLOCK)
ON C.id = AAP.clientId AND C.status & 0x1000 = 0 AND C.status & 0x10000000 = 0
			INNER JOIN  @ServerPlanTbl DB
					ON DB.appTypeId=AAP.appTypeId
			INNER JOIN App_PlanProp APP WITH(NOLOCK)
ON APP.attrVal=CAST(AAP.dataArchGrpID AS NVARCHAR(16)) AND APP.attrName='Storage policy' AND APP.modified=0
			LEFT OUTER JOIN APP_SubClientProp ASCP WITH(NOLOCK)
ON ASCP.componentNameId=AAP.id AND ASCP.attrName='Associated Plan' AND ASCP.modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Associated Plan')
			LEFT OUTER JOIN APP_SubClientProp ASCP1 WITH(NOLOCK)
					ON ASCP1.componentNameId=AAP.id AND ASCP1.attrName IN ('Turbo Mode Enable Stubbing', 'DDB Backup', 'Index SubClient') AND ASCP1.modified=0 AND ASCP1.attrval='1'
						AND ASCP1.cs_attrName IN (CHECKSUM(N'Turbo Mode Enable Stubbing'), CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
			LEFT OUTER JOIN APP_ClientProp ACP  WITH(NOLOCK)
					ON ACP.componentNameId=C.id AND ACP.attrName='Index Server Type' AND ACP.modified=0
			LEFT OUTER JOIN APP_BackupSetProp ABP WITH(NOLOCK)
					ON ABP.componentNameId=AAP.backupSet AND ABP.attrName='Is Archiving Enabled' AND ABP.modified=0 AND ABP.attrval='1'
			WHERE ASCP.id IS NULL AND ASCP1.id IS NULL
AND AAP.subclientStatus & 0x00004= 0 AND AAP.subclientStatus & 0x00002 = 0 AND AAP.subclientStatus & 0x200000 = 0 AND AAP.subclientStatus & 0x00010 = 0 AND AAP.subclientStatus & 0x00020 = 0
AND AAP.subclientStatus & 0x2000 = 0
			AND AAP.subclientName NOT IN ('IndexBackup', 'IndexingSubclient', 'DDBbackup', 'System State', 'DR Subclient', 'CvFailoverLogShipping')
			AND ACP.id IS NULL
			AND ABP.id IS NULL
		END
		IF EXISTS (SELECT TOP 1 1 FROM #subclientList_PlanStoragePolicy)
		BEGIN
			-- Keep Only Server Plan
			DELETE PT
			FROM #PlansList PT
			LEFT OUTER JOIN App_Plan AP
ON AP.id=PT.planId AND AP.subType=33554437
			WHERE AP.id IS NULL
			UPDATE SC
			SET SC.isBasePlan=1
			FROM #subclientList_PlanStoragePolicy SC
			INNER JOIN App_PlanProp Apbase WITH(NOLOCK)
ON Apbase.attrVal=CAST(SC.directPlanId AS NVARCHAR(16)) AND Apbase.attrName='Base plan' AND Apbase.modified=0
			-- Update Association in case there is no base plan
			UPDATE SC
			SET SC.planId=SC.directPlanId
			FROM #subclientList_PlanStoragePolicy SC
			INNER JOIN #PlansList PL
					ON PL.planId=SC.directPlanId
			WHERE isBasePlan=0
			DECLARE @curPlanId INT
			DECLARE @curStoragePolicyId INT
			DECLARE PlanCursor CURSOR
			FOR
			SELECT  storagePolicy, directPlanId
				FROM    #subclientList_PlanStoragePolicy
				GROUP BY storagePolicy, directPlanId
				-- Derived-Base Plan Association
			OPEN PlanCursor
			FETCH FROM PlanCursor INTO @curStoragePolicyId, @curPlanId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DELETE FROM #AppPlanHierarchy_tmp__Plans
				-- this call will give us list of plans derived from @planId (not including planId iteslf)
				-- actually, this CTE expression returns way more information that we actually need, but for development/debug purposes it is ok. the expression
				-- and #AppPlanHierarchy_tmp__Plans temp table definition to be modified to include only necessary fields and to include @planId if desired
					;WITH T(planId, planName, basePlanId, basePlanName, depth) AS
					(
						SELECT  P.id, P.[name], CAST(PP.attrVal AS INT), '', 0
FROM    APP_Plan P WITH(NOLOCK) INNER JOIN APP_PlanProp PP WITH(NOLOCK) ON PP.attrName = 'Base plan' AND  attrVal = @curPlanId AND PP.componentNameId = P.id
						UNION ALL
						SELECT  PP.componentNameId, P.[name], T.planId, '', (T.depth + 1)
FROM    APP_PlanProp PP WITH(NOLOCK) INNER JOIN T ON PP.attrVal = CAST(T.planId AS VARCHAR) AND attrName = 'Base plan'
																INNER JOIN APP_Plan P WITH(NOLOCK) ON P.id = PP.componentNameId
					)
					-- store plans hierarchy into temporary table
					INSERT INTO #AppPlanHierarchy_tmp__Plans SELECT DISTINCT * FROM T
					INSERT INTO #plansTemp_PlanStoragePolicy
SELECT DISTINCT planId, @curPlanId,ISNULL(dbo.AppPlanGetEntityValueV2(planId, 'Storage policy',  default), 0)
					FROM #AppPlanHierarchy_tmp__Plans
					LEFT OUTER JOIN #plansTemp_PlanStoragePolicy PT
						ON PT.basePlanId=planId
					WHERE PT.basePlanId IS NULL
					FETCH FROM PlanCursor INTO @curStoragePolicyId, @curPlanId
				END
			CLOSE PlanCursor
			DEALLOCATE PlanCursor
			-- Save base plan details tooas above code exlcudes that
			INSERT INTO #plansTemp_PlanStoragePolicy
SELECT SPT.directPlanId, SPT.directPlanId,ISNULL(dbo.AppPlanGetEntityValueV2(SPT.directPlanId, 'Storage policy',  default), 0)
				FROM #subclientList_PlanStoragePolicy SPT
			LEFT OUTER JOIN #plansTemp_PlanStoragePolicy PT
				ON PT.derivedplanId=SPT.directPlanId
			WHERE PT.derivedplanId IS NULL
			-- Keep this record in table as this logic might change
			-- Keeping records with count in table will help us to change logic as per requirement with minimal change
			INSERT INTO #Subclients_Siblings_Plan
			SELECT subclientId, derivedplanId, COUNT(*) as totalCount
			FROM
			(
				SELECT DISTINCT SC.subclientId,AAP.id, Pt.derivedplanId
					FROM #subclientList_PlanStoragePolicy SC
				INNER JOIN APP_Application AAP WITH(NOLOCK)
					ON AAP.backupSet=SC.backupSet
				INNER JOIN #plansTemp_PlanStoragePolicy PT
					ON PT.basePlanId=SC.directPlanId AND PT.storagePolicyId=SC.storagePolicy
				INNER JOIN #PlansList PL
						ON PL.planId=PT.derivedplanId
				INNER JOIN APP_SubClientProp ASCP WITH(NOLOCK)
ON ASCP.componentNameId=AAP.id AND ASCP.attrName='Associated Plan' AND ASCP.attrVal=CAST(PT.derivedplanId AS NVARCHAR(16)) AND ASCP.modified=0 AND ASCP.cs_attrName=CHECKSUM(N'Associated Plan')
				WHERE SC.planId=0 AND AAP.id<>SC.subclientId
			) T
			GROUP BY subclientId, derivedplanId
			ORDER BY 3 DESC
			-- In case of sibling have same count of base and derived plan, then we will consider derived plan
			-- In case of 2 derived plan with same count, we will select top 1
			DELETE FROM A
			FROM #Subclients_Siblings_Plan AS A
			INNER JOIN #Subclients_Siblings_Plan AS B
			  ON A.subclientId = B.subclientId AND A.row_count=B.row_count
			INNER JOIN #plansTemp_PlanStoragePolicy PT
				ON PT.basePlanId=A.preferedSiblingPlan
			WHERE A.id<>B.id
			-- As per current discussed logic, we will first try to use the most famous plan in peers
			-- This will be irrespective of derived or base
			DELETE FROM A
			FROM #Subclients_Siblings_Plan AS A
			INNER JOIN #Subclients_Siblings_Plan AS B
			  ON A.subclientId = B.subclientId AND A.id > B.id
			-- Will update with most used plan in siblings
			UPDATE SC
			SET SC.planId=PT.preferedSiblingPlan
			FROM #subclientList_PlanStoragePolicy SC
			INNER JOIN #Subclients_Siblings_Plan PT
				ON PT.subclientId=SC.subclientId
			WHERE SC.planId=0
			-- If for some subclient, we still haven't find correct plan, then take top one derived plan
			UPDATE SC
			SET SC.planId=PT.derivedplanId
			FROM #subclientList_PlanStoragePolicy SC
			INNER JOIN #plansTemp_PlanStoragePolicy PT
				ON PT.basePlanId=SC.directPlanId AND PT.storagePolicyId=SC.storagePolicy
			INNER JOIN #PlansList PL
					ON PL.planId=PT.derivedplanId AND PT.derivedplanId<>SC.directPlanId
			WHERE SC.planId=0
			-- IF Still nothing, then use base plan
			UPDATE SC
			SET SC.planId=SC.directPlanId
			FROM #subclientList_PlanStoragePolicy SC
			INNER JOIN #PlansList PL
					ON PL.planId=SC.directPlanId
			WHERE SC.planId=0
			SET @i_planId = ISNULL((SELECT TOP 1 planId FROM #subclientList_PlanStoragePolicy SC  WHERE subclientId=@i_subclientId), 0)
		END
	END
	IF OBJECT_ID('tempdb.dbo.#subclientList_PlanStoragePolicy')	IS NOT null DROP TABLE #subclientList_PlanStoragePolicy
	IF OBJECT_ID('tempdb.dbo.#plansTemp_PlanStoragePolicy')		IS NOT null DROP TABLE #plansTemp_PlanStoragePolicy
	IF OBJECT_ID('tempdb.dbo.#PlansList')						IS NOT NULL DROP TABLE #PlansList
	IF OBJECT_ID('tempdb.dbo.#Subclients_Siblings_Plan')		IS NOT null DROP TABLE #Subclients_Siblings_Plan
	IF OBJECT_ID('tempdb.dbo.#AppPlanHierarchy_tmp__Plans')	IS NOT null DROP TABLE #AppPlanHierarchy_tmp__Plans
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errorCode = ERROR_NUMBER()
	SET @o_errorMsg = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
END CATCH
SET @planId			= @i_planId
SET @errorCode		= @o_errorCode
SET @errorString	= @o_errorMsg
SELECT @planId, @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetPlanfromStoragePolicyV2')
	delete from GxQscripts where name = 'AppGetPlanfromStoragePolicyV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanfromStoragePolicyV2')
	delete from GXDBVersions where aliasname = 'AppGetPlanfromStoragePolicyV2'
GO

insert into GXDBVersions values(2, 'AppGetPlanfromStoragePolicyV2',  '00010001000200060000', 'AppGetPlanfromStoragePolicyV2', '00010001000200060000')
GO

