

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetPlanfromStoragePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetPlanfromStoragePolicy.sp,v $ $Id: AppGetPlanfromStoragePolicy.sp,v 1.1.2.1 2019/11/22 14:03:08 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetPlanfromStoragePolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppGetPlanfromStoragePolicy <<<'
	drop procedure AppGetPlanfromStoragePolicy
END
IF EXISTS (select * from GxQscripts where name='AppGetPlanfromStoragePolicy')
	delete from GxQscripts where name = 'AppGetPlanfromStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanfromStoragePolicy')
	delete from GXDBVersions where aliasname = 'AppGetPlanfromStoragePolicy'
GO
print '... Creating Procedure: AppGetPlanfromStoragePolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetPlanfromStoragePolicy
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_clientId INTEGER,
  @i_planId INTEGER			OUTPUT,
  @o_errorCode INTEGER			OUTPUT,
  @o_errorMsg VARCHAR(MAX)	OUTPUT
AS
  DECLARE @planId INT
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
SET NOCOUNT ON
--Variable Declarations
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_errorCode	= 0
SET @o_errorMsg		= N' '
SET @i_planId		= 0
BEGIN TRY
	DECLARE @storagePolicyId  INT = 0
	-- check if Additional key is set
	IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name='LookupPlanfromStoragePolicy' AND value='1')
	BEGIN
		IF (@i_clientId > 0)
		BEGIN
			-- Figure out storage policy for any subclient which is not 1
			SET @storagePolicyId = (SELECT TOP 1 dataArchGrpID FROM APP_Application WHERE dataArchGrpID<>1 /*CV_DEFAULT_ARCHIVE_GROUP*/ AND clientId=@i_clientId)
			-- Current code also update user id in case of tenant admin id
SET @i_userId = ISNULL((SELECT CAST(attrval AS INT) FROM APP_ClientProp WHERE componentNameId=@i_clientId AND attrName='Installation User ID' AND modified=0), 1)
		END
		IF (@storagePolicyId > 0)
		BEGIN
			-- We are overriding userId here. We are not reading from input but from client prop based on the user who installed that client.
			-- Get all the plans that this user have rights to use
			IF OBJECT_ID('tempdb.dbo.#PlansList')   IS NOT NULL DROP TABLE #PlansList
			IF OBJECT_ID('tempdb.dbo.#PlansProp')   IS NOT NULL DROP TABLE #PlansProp
			CREATE TABLE #PlansList(planId INT NOT NULL)
			CREATE CLUSTERED INDEX PlansList_planId_idx ON #PlansList(planId)
			CREATE TABLE #PlansProp(planId INT NOT NULL, storagePolicyId INT, hasBasePlan INT)
			CREATE CLUSTERED INDEX PlansProp_planId_storagePolicyId_idx ON #PlansProp(planId)
			-- -- plans that user has rights to edit
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 157, '#PlansList'
			-- -- plans that user has rights to associate/deassociate
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 158, 159, '#PlansList'
			-- Get details about all plan along with base plan storage Policy
			INSERT INTO #PlansProp
			SELECT DISTINCT AP.id, ISNULL(CAST(APP1.attrval AS INT), 0), CASE WHEN APP2.attrval IS NULL THEN 0 ELSE 1 END
			FROM #PlansList PL
			INNER JOIN APP_Plan AP
ON AP.id=PL.planId AND AP.subType in (33554437, 50331655)
			LEFT OUTER JOIN APP_PlanProp APP1
ON APP1.componentNameid=AP.id AND APP1.attrname='Storage policy'
			LEFT OUTER JOIN APP_PlanProp APP2
ON APP2.componentNameid=AP.id AND APP2.attrname='Base plan'
			-- If we have atleast one derived plan, then we need to get details of those derived plans
			UPDATE PP
SET PP.storagePolicyId = ISNULL(dbo.AppPlanGetEntityValueV2(planId, 'Storage policy',  default), 0)
			FROM #PlansProp PP
				WHERE PP.hasBasePlan=1
			-- By now, we should have storage policy of all plan applicable for this user
			-- Let's match our storagePolicyId giving higher preference to derived plan
			SET @i_planId = ISNULL((SELECT TOP 1 planId FROM #PlansProp WHERE storagePolicyId=@storagePolicyId ORDER BY hasBasePlan DESC), 0)
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errorCode = ERROR_NUMBER()
	SET @o_errorMsg = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
END CATCH
SET @planId			= @i_planId
SET @errorCode		= @o_errorCode
SET @errorString	= @o_errorMsg
SELECT @planId, @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetPlanfromStoragePolicy')
	delete from GxQscripts where name = 'AppGetPlanfromStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanfromStoragePolicy')
	delete from GXDBVersions where aliasname = 'AppGetPlanfromStoragePolicy'
GO

insert into GXDBVersions values(2, 'AppGetPlanfromStoragePolicy',  '00010001000200010000', 'AppGetPlanfromStoragePolicy', '00010001000200010000')
GO

