

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetPlanFeatures.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetPlanFeatures
--  |
--  | Description:  SP for retrieving the features of a plan associated to pseudo client
--  |
--  |       Input:  pseudo client id
--  |      Output:  XML with plan entity and its features
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  snagendra  	To activate a laptop client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetPlanFeatures <<<'

IF EXISTS (select * from sysobjects where name='AppGetPlanFeatures')
	drop procedure AppGetPlanFeatures
IF EXISTS (select * from GxQscripts where name='AppGetPlanFeatures')
	delete from GxQscripts where name = 'AppGetPlanFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanFeatures')
	delete from GXDBVersions where aliasname = 'AppGetPlanFeatures'
GO
print '... Creating Procedure: AppGetPlanFeatures'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetPlanFeatures
  @clientId INTEGER
AS
  DECLARE @xmlData XML 
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @profileId INT = 0
SET @profileId = (
				SELECT ISNULL(attrval,0) FROM APP_CLIENTPROP
WHERE attrname = 'Associated Plan'
				and componentNameId = @clientId
			   )
SET @xmlData = ( SELECT
					(
						SELECT id as '@planId',
						name as '@planName'
						FROM App_PLAN
						WHERE id = @profileId
						FOR XML PATH ('plan'),TYPE
					),
					(
						SELECT  UP.id AS '@permissionId', UP.permissionName AS '@permissionName'
                        FROM    UMRolesPermissions URP INNER JOIN UMPermissions UP ON URP.permissionId = UP.id
WHERE   URP.roleId = CAST(dbo.AppPlanGetEntityValue(@profileId, 'Feature', default) AS INT)
						FOR XML PATH ('permissions'),TYPE
				    )
					FOR XML PATH ('App_UserCentricClientAssociatedPlan'),TYPE)
IF @xmlData IS NULL
	SET @xmlData = '<App_UserCentricClientAssociatedPlan/>'
SELECT @xmldata
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetPlanFeatures')
	delete from GxQscripts where name = 'AppGetPlanFeatures'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanFeatures')
	delete from GXDBVersions where aliasname = 'AppGetPlanFeatures'
GO

insert into GXDBVersions values(2, 'AppGetPlanFeatures',  '00000000000000000000', 'AppGetPlanFeatures', '00000000000000000000')
GO

