

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetPlanContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +------------------------------------------------------------------------------------------+
--  |           Procedure : "AppGetPlanContent"
--  |   This Procedure is used to list the contents for a given Plan Id based on the IDA Type Provided.
--  |
--  +------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetPlanContent')
BEGIN
	print '>>> Drop Stored Procedure: AppGetPlanContent <<<'
	drop procedure AppGetPlanContent
END
IF EXISTS (select * from GxQscripts where name='AppGetPlanContent')
	delete from GxQscripts where name = 'AppGetPlanContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanContent')
	delete from GXDBVersions where aliasname = 'AppGetPlanContent'
GO
print '... Creating Procedure: AppGetPlanContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetPlanContent
  @i_userId INT,
  @i_localeId INT,
  @i_planId INT,
  @i_idaType NVARCHAR(1),
  @o_xmlResp XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
IF object_id('tempdb.dbo.#contentInfo') IS NOT NULL
DROP TABLE #contentInfo
CREATE TABLE #contentInfo
  (
     content     NVARCHAR(max),
     backupsetid INT,
     type        INT,
     ida         NVARCHAR(1)
  )
CREATE CLUSTERED INDEX #contentInfo_idx ON #contentInfo(backupsetid ASC)
DECLARE @userHasPermission INT = 0
DECLARE @content NVARCHAR(max)
DECLARE @idaTypePolicy NVARCHAR(30) = CONCAT('Subclient policy', ' '+@i_idaType)
DECLARE @idaTypeContent NVARCHAR(30) = CONCAT('Subclient content', ' '+@i_idaType)
EXEC sec_checkPermissionOnEntity @i_userId, 31, @userHasPermission OUTPUT,  158, @i_planId
IF(@userHasPermission = 0)
BEGIN
	SET @o_xmlResp = '<Api_planContent />'
	RETURN
END
-- Check if App_PlanProp table's Subclient Content attribute has some data
-- If yes, check if it is numeric
-- 		If not numeric, then it is the content XML, cast it and convert the xml to Api_planContent XML and return the same.
--		Else, it is subclient policy ID
-- Else, get the subclient policy attribute from App_PlanProp table and store the value in @content variable
SELECT @content = dbo.AppPlanGetEntityValueV2(@i_planId, @idaTypeContent, 1)
IF @content IS NULL
	BEGIN
	  SELECT @content = dbo.Appplangetentityvaluev2(@i_planId, @idaTypePolicy, 1)
	END
IF ISNUMERIC(@content) = 1
	BEGIN
		-- For the fetched subclient policy ID, get the content from App_SCFilterFile table and return the same
		INSERT INTO #contentInfo
		SELECT dbo.Encodeinvalidxmlchar(filename) AS path,
			   app.backupset                      AS backupset,
			   type,
			   @i_idaType            AS ida
		FROM   app_scfilterfile asf
			   INNER JOIN app_application app
					   ON asf.componentnameid = app.id
						  AND asf.modified = 0
						  AND app.backupset = CAST(@content AS INT)
	END
ELSE
	BEGIN
		-- Content is directly stored in App_PlanProp table's Subclient Content Property.
		SET @o_xmlResp = Cast(@content AS XML)
		-- Convert App_SubClientInfo to Api_PlanContent and return that XML
		INSERT INTO #contentinfo
					(content,
					 type,
					 ida)
		SELECT tbl.col.value('@path', 'nvarchar(max)') AS path,
			   1                                       AS type,
			   @i_idaType
		FROM   @o_xmlResp.nodes('//App_SubClientInfo/content') Tbl(col)
		INSERT INTO #contentinfo
					(content,
					 type,
					 ida)
		SELECT tbl.col.value('@excludePath', 'nvarchar(max)') AS path,
			   3                                              AS type,
			   @i_idaType
		FROM   @o_xmlResp.nodes('//App_SubClientInfo/content') Tbl(col)
		DELETE FROM #contentinfo
		WHERE  content IS NULL
	END
SET @o_xmlResp = ISNULL((SELECT
							(SELECT ida AS [@idatype],
								(SELECT backupsetid AS 'backupSetEntity/@backupsetId',
									(SELECT [@path] 		= CASE
																WHEN ( type = 1 ) THEN content
																ELSE NULL
																END,
											[@excludePath] 	= CASE
																WHEN ( type = 3 ) THEN content
																ELSE NULL
																END
									FROM   #contentInfo content
									WHERE  (content.backupsetid = scp.backupsetid OR content.backupsetId IS NULL)
										AND content.ida = bs.ida
									FOR XML PATH('content'), TYPE)
								FROM   #contentInfo AS scp
								WHERE  scp.ida = bs.ida
								GROUP  BY backupsetid
								FOR XML PATH('subClientPolicy'), TYPE)
							FROM   #contentInfo AS bs
							GROUP  BY ida
							FOR XML PATH('backupContent'), TYPE)
						FOR XML PATH('Api_PlanContent')), '<Api_PlanContent />')
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetPlanContent')
	delete from GxQscripts where name = 'AppGetPlanContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanContent')
	delete from GXDBVersions where aliasname = 'AppGetPlanContent'
GO

insert into GXDBVersions values(2, 'AppGetPlanContent',  '00000000000000000000', 'AppGetPlanContent', '00000000000000000000')
GO

