

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetPlanClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016 CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetPlanClients()
--  |
--  | Description:  SP for Fetching physical clients associated with a plan.
--  |
--  |       Input:  PlanId
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   1.0		   rengu  	To Send Updated Feature List
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetPlanClients <<<'

IF EXISTS (select * from sysobjects where name='AppGetPlanClients')
	drop procedure AppGetPlanClients
IF EXISTS (select * from GxQscripts where name='AppGetPlanClients')
	delete from GxQscripts where name = 'AppGetPlanClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanClients')
	delete from GXDBVersions where aliasname = 'AppGetPlanClients'
GO
print '... Creating Procedure: AppGetPlanClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetPlanClients
  @planId INT,
  @xmldata XML OUTPUT
AS
DECLARE @allClients TABLE( clientId INT )
DECLARE @clientsList XML
DECLARE @errorCode INT=0
DECLARE @errorString nvarchar(MAX)=N''
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
		-- SELECT ALL Types of Clients associated with the client
		INSERT INTO @allClients
		    SELECT  owners.clientId FROM sec_getClientOwners(1) owners
		        INNER JOIN APP_ClientProp ACP ON owners.clientId = ACP.componentNameId
WHERE  ACP.attrName = 'Associated Plan'
		            AND CAST( ACP.attrVal AS INT) = @planId
		            AND owners.userId IN (SELECT userId FROM UMUserGroup WHERE groupId IN (
				        SELECT attrVal FROM App_PlanProp
				        WHERE componentNameId = @planId
AND attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group')))
		--update only if there is a User Centric client Property set for client id in App_clientprop
		UPDATE AC
		SET AC.clientId = CAST(CP.attrVal AS INT)
		FROM @allClients AC
		INNER JOIN APP_ClientProp CP on CP.componentNameId = AC.clientId
AND CP.attrName = 'Physical Client Id'
AND EXISTS ( SELECT * FROM APP_ClientProp  WHERE attrname = 'User Centric Client' and attrval = '1' and componentNameId = AC.clientId)
		SET @clientsList = (
								SELECT DISTINCT(clientId) as '@clientId'
								FROM @allClients
								FOR XML PATH('clients'),TYPE
						   )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = N'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SET @xmldata = (
						SELECT @clientsList,
							  ( SELECT      @errorCode as '@errorCode',
											@errorString as '@errorMessage'
											FOR XML PATH ('error'),TYPE
							  )
							  FOR XML PATH(''),ROOT('Api_GetPlanClientsListResp')
						)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetPlanClients')
	delete from GxQscripts where name = 'AppGetPlanClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPlanClients')
	delete from GXDBVersions where aliasname = 'AppGetPlanClients'
GO

insert into GXDBVersions values(2, 'AppGetPlanClients',  '00000000000000000000', 'AppGetPlanClients', '00000000000000000000')
GO

