

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetPSTAssocSubClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetPSTAssocSubClients.sp,v $ $Id: AppGetPSTAssocSubClients.sp,v 1.1.2.3 2019/07/24 14:47:05 nlakade Exp $"
--
--  +========================================================================+
--  | Stored Precedure: AppGetPSTAssocSubClients()
--  | To get the list of subclients from the PST association
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetPSTAssocSubClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetPSTAssocSubClients <<<'
	drop procedure AppGetPSTAssocSubClients
END
IF EXISTS (select * from GxQscripts where name='AppGetPSTAssocSubClients')
	delete from GxQscripts where name = 'AppGetPSTAssocSubClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPSTAssocSubClients')
	delete from GXDBVersions where aliasname = 'AppGetPSTAssocSubClients'
GO
print '... Creating Procedure: AppGetPSTAssocSubClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetPSTAssocSubClients
  @i_request XML
AS
  DECLARE @o_response XML
DECLARE @userId				INT = 0
DECLARE @releaseId			INT
DECLARE @allAssociations	INT
DECLARE @commcellParam		INT
DECLARE @restoreCapability	BIGINT
DECLARE @ERROR_SEVERITY		INT = 10
DECLARE @ErrorMessage		NVARCHAR(4000) = ''
DECLARE @ErrorSeverity		INT = 0
DECLARE @ErrorState			INT = 0
DECLARE @ErrorCode			INT = 0
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
BEGIN TRY
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- Create temp tables
	-- None of these temp tables should ever exist when this procedure is called!
	IF object_id('tempdb.dbo.#appIdTbl') IS NOT NULL
	   DROP TABLE #appIdTbl
	CREATE TABLE #appIdTbl ( appId INT,  appTypeId INT, clientId INT, instanceId INT, backupsetId INT,  status INT, refTime INT, clientGrp Int)
	-- None of these temp tables should ever exist when this procedure is called!
	IF object_id('tempdb.dbo.#includeEntity') IS NOT NULL
		DROP TABLE #includeEntity
	CREATE TABLE #includeEntity
	(
		entityType integer,
		commcellId integer ,
		clientId integer ,
		appType integer ,
		instanceId integer ,
		backupsetId integer ,
		subclientId integer ,
		clientgroupId integer,
		reviewSetId	integer,
		exclude integer
	)
	IF object_id('tempdb.dbo.#excludeEntity') IS NOT NULL
    			DROP TABLE #excludeEntity
	CREATE TABLE #excludeEntity
	(
		entityType integer,
		commcellId integer ,
		clientId integer ,
		appType integer ,
		instanceId integer ,
		backupsetId integer ,
		subclientId integer ,
		clientgroupId integer,
		reviewSetId	integer,
		exclude integer
	)
	IF OBJECT_ID('tempdb.dbo.#associatedEntitiesWithCapability') IS NOT null
	   DROP TABLE #associatedEntitiesWithCapability
create table  #associatedEntitiesWithCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	SELECT  @userId = ISNULL(col.value('processinginstructioninfo[1]/user[1]/@userId', 'int'), @userId)
	FROM @i_request.nodes('App_GetPSTAssocSubClientsReq') as Tbl (col)
	-- Populate the selected entity information
	INSERT INTO #includeEntity
	SELECT
		ISNULL(Tbl.Col.value('@_type_', 'int'),0) ,
		ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
		ISNULL(Tbl.Col.value('@clientId', 'int'),0),
		ISNULL(Tbl.Col.value('@applicationId', 'int'),0) ,
		ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
		ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
		ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
		ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
		ISNULL(Tbl.Col.value('@reviewSetId', 'int'),0),
		ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),0)
		FROM @i_request.nodes('App_GetPSTAssocSubClientsReq/associations') as Tbl(Col)
	-- exclude entity should contain exlcude list
	INSERT INTO #excludeEntity
	SELECT * FROM #includeEntity WHERE exclude = 1
	-- Include entity should contain only include list
	DELETE FROM #includeEntity WHERE exclude = 1
	-- Populate the subclient information from includeEntity
	INSERT INTO #appIdTbl
	--All clients
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType in(1 , 2)
	-- Include all CLIENTGROUPS
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B, APP_ClientGroupAssoc C
WHERE B.entityType = 27 AND A.clientId = C.clientId
	--CLIENT GROUP
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 28
	AND A.clientId in(SELECT DISTINCT (clientId) FROM APP_ClientGroupAssoc where clientgroupid = B.clientGroupId)
	--CLIENT
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 3
	AND A.clientId = B.clientId
	--APPTYPE
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 4
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	--INSTANCE
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 5
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	--BACKUPSET
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 6
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	AND A.backupset = B.backupsetId
	--SUBCLIENT
	UNION
	SELECT A.id, A.appTypeId,A.clientId, A.instance, A.backupset, A.subclientStatus, 0, 0 FROM APP_Application as A, #includeEntity B
WHERE B.entityType = 7
	AND A.clientId = B.clientId
	AND A.appTypeId = B.appType
	AND A.instance = B.instanceId
	AND A.backupset = B.backupsetId
	AND A.id = B.subclientId
	-- Delete the excluded entity information
	-- All clients
IF Exists(Select *From #excludeEntity where entityType = 2)
		DELETE FROM #appIdTbl
	--CLIENT GROUP
	DELETE FROM #appIdTbl where clientId IN
    ( SELECT DISTINCT (clientId) FROM APP_ClientGroupAssoc where clientgroupid in
( SELECT clientGroupId from #excludeEntity where entityType = 28))
	--CLIENT
	DELETE FROM #appIdTbl where appId IN
( SELECT id from #excludeEntity En, APP_Application App where En.entityType = 3 AND App.clientId = En.clientId)
	--AppType
	DELETE FROM #appIdTbl where appId IN
( SELECT id from #excludeEntity En, APP_Application App where En.entityType = 4 AND App.clientId = En.clientId AND App.appTypeId = En.appType)
	--Instance
	DELETE FROM #appIdTbl where appId IN
( SELECT id from #excludeEntity En, APP_Application App where En.entityType = 5 AND App.clientId = En.clientId AND App.appTypeId = En.appType AND App.instance = En.instanceId)
	--Backupset
	DELETE FROM #appIdTbl where appId IN
( SELECT id from #excludeEntity En, APP_Application App where En.entityType = 6 AND App.clientId = En.clientId AND App.appTypeId = En.appType AND App.instance = En.instanceId AND App.backupSet = En.backupsetId)
	--SubclientId
	DELETE FROM #appIdTbl where appId IN
    ( SELECT subclientId from #excludeEntity)
    -- Filter the dummy, hidden subclient
DELETE FROM #appIdTbl where ( status & 0x00020  = 0x00020) -- 0x00020
OR ( status & 0x00010  = 0x00010)
	-- Delete older than 11.0
    DELETE #appIdTbl
    FROM #appIdTbl A, App_Client B where
A.clientId = B.id AND B.releaseId < (16)
	-- Delete DDB ,SILO subclients and Indexing subclients
	DELETE #appIdTbl
	FROM #appIdTbl A, App_SubClientProp B where
	A.appId = B.ComponentNameId AND B.AttrName in('SILO Copy ID', 'DDB Backup', 'Index SubClient') AND B.modified = 0
	--
	-- TO DO Delete the reference copy subclients.
	-- Windows File System only
DELETE From #appIdTbl Where appTypeId NOT in (	1, 11 , 33,
34,42, 43, 64)
	SET @allAssociations = 0
SET @restoreCapability = POWER(2, 22 - 1)
	SET @commcellParam = 2
	EXEC sec_getUserObjects @userId, 0, 0, '#associatedEntitiesWithCapability'
	-- Delete those entities on which user doesn't have out of place restore capability
	DELETE FROM #associatedEntitiesWithCapability where ((capabilities &  @restoreCapability) = 0)
	-- Now we have come to Entities(clientGrp/client/appType/instance/bs/sc), we can remove associations not involving these. like lib, ma, sp etc
	delete #associatedEntitiesWithCapability
	WHERE 	mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 or vtContainerId <> 0 or vtPolicyId <> 0 or vtShelfId <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0 OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
	OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
	OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
	OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	IF EXISTS(select 1 from #associatedEntitiesWithCapability
					WHERE commCellId = @commcellParam
					AND (
clientId = -10
OR appTypeId = -10
OR instanceId = -10
OR backupSetId = -10
OR subClientId = -10
					)
					AND ((capabilities &  @restoreCapability) > 0)
					)
	BEGIN
		SET @allAssociations = 1
	END
	IF EXISTS(select 1 from #associatedEntitiesWithCapability
					WHERE commCellId = @commcellParam
					AND clientId    = 0
					AND appTypeId   = 0
					AND instanceId  = 0
					AND backupSetId = 0
					AND subClientId = 0
					AND clientGroupId = 0
					AND ((capabilities &  @restoreCapability) > 0)
					)
	BEGIN
		SET @allAssociations = 1
	END
	DELETE FROM #appIdTbl
	Where NOT exists
		(
		select *From #associatedEntitiesWithCapability AEWC where
		@allAssociations = 1 OR
			(
				AEWC.clientId = #appIdTbl.clientId
				AND (AEWC.appTypeId = #appIdTbl.appTypeId or AEWC.appTypeId=0)
				AND (AEWC.instanceId = #appIdTbl.instanceId or AEWC.instanceId=0)
				AND (AEWC.backupsetId = #appIdTbl.backupsetId or AEWC.backupsetId=0)
				AND (AEWC.subclientId = #appIdTbl.appId or AEWC.subclientId=0)
				AND ((capabilities &  @restoreCapability) > 0)
			)
	)
	BEGIN
		-- After all filteration,Delete clients which are locked and I am not owner of.
		-- Deleting the rows which have attribute name "CV_PROP_ENABLE_DATA_SECURITY" AND attribute value CV_PROP_DATA_SECURITY_ENABLE
		DELETE #appIdTbl FROM #appIdTbl A,APP_ClientProp P
		WHERE A.clientId = P.componentNameId
AND P.attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' AND P.modified = 0 AND P.attrVal='a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'
		AND dbo.IsClientOwner(P.componentNameId,@userId) = 0
	END
	SET @o_response = (SELECT @ErrorCode AS '@errorCode', @ErrorMessage AS '@errorString',
							(	SELECT appId as '@subclientId', backupsetId as '@backupsetId', clientId as '@clientId',
									instanceId  as '@instanceId', appTypeId as '@applicationId'
								FROM #appIdTbl
								FOR XML PATH('subclients'), TYPE )
							FOR XML PATH('App_GetPSTAssocSubClientsResp'), TYPE);
	DROP TABLE #associatedEntitiesWithCapability
	DROP TABLE #appIdTbl
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	 SELECT
        @ErrorMessage = @ErrorMessage + ERROR_MESSAGE(),
		@ErrorCode = ERROR_NUMBER(),
        @ErrorSeverity = ERROR_SEVERITY(),
		@ErrorState = ERROR_STATE();
		SET @o_response = (SELECT @ErrorCode AS '@errorCode', @ErrorMessage AS '@errorString'
							FOR XML PATH('App_GetPSTAssocSubClientsResp'), TYPE);
END CATCH
SELECT @o_response
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetPSTAssocSubClients')
	delete from GxQscripts where name = 'AppGetPSTAssocSubClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetPSTAssocSubClients')
	delete from GXDBVersions where aliasname = 'AppGetPSTAssocSubClients'
GO

insert into GXDBVersions values(2, 'AppGetPSTAssocSubClients',  '00010001000200030000', 'AppGetPSTAssocSubClients', '00010001000200030000')
GO

