

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetOutlookAddinStoreDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetOutlookAddinStoreDetails.sp,v $ $Id: AppGetOutlookAddinStoreDetails.sp,v 1.2.2.1 2018/03/22 01:41:28 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetOutlookAddinStoreDetails
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Gokul Pattabiraman   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetOutlookAddinStoreDetails <<<'

IF EXISTS (select * from sysobjects where name='AppGetOutlookAddinStoreDetails')
	drop procedure AppGetOutlookAddinStoreDetails
IF EXISTS (select * from GxQscripts where name='AppGetOutlookAddinStoreDetails')
	delete from GxQscripts where name = 'AppGetOutlookAddinStoreDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOutlookAddinStoreDetails')
	delete from GXDBVersions where aliasname = 'AppGetOutlookAddinStoreDetails'
GO
print '... Creating Procedure: AppGetOutlookAddinStoreDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetOutlookAddinStoreDetails
  @i_xml XML,
  @o_xml XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @userId INT = ISNULL(( SELECT ref.value('@userId', 'int')
								FROM @i_xml . nodes('App_GetOutlookAddinStoreDetailsReq/user') R ( ref )
							), 0)
	DECLARE @clientId INT = 0
	DECLARE @subclientId INT = 0
	DECLARE @privateShareId INT = 0
	DECLARE @publicShareId INT = 0
	DECLARE @uploadURL NVARCHAR(MAX) = 'drive/share/file'
	DECLARE @downloadURL NVARCHAR(MAX) = 'contentstore/publicshare/{shareId}/file/{fileId}/action/download'
	DECLARE @errorCode INT
	DECLARE @errorMessage NVARCHAR(MAX)
	SET @clientId = ISNULL((SELECT TOP 1 C.id
							FROM APP_Client C
							INNER JOIN APP_ClientProp CP ON C.id = CP.componentNameId AND CP.modified = 0 AND CP.attrName = 'OutlookAddin ContentStore UserGroups' --CV_PROP_OUTLOOK_ADDIN_USERGROUPS
							WHERE C.status & 0x40000000 = 0x40000000 --CV_STATUS_SYSTEM_EDGE_DRIVE
							AND EXISTS( SELECT 1
										FROM dbo.SplitStringByDelimiter(CP.attrVal, ':') A
										INNER JOIN UMUserGroup G ON A._ID = G.groupId
										WHERE G.userId = @userId)
							), 0)
	IF @clientId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorMessage = 'No outlook addin content stor found.'
		GOTO PROC_EXIT
	END
	SET @subclientId = ISNULL((	SELECT id
								FROM APP_Application WHERE clientId = @clientId
								AND subclientStatus& 0x20000 = 0x20000 --CV_STATUS_EDGEDRIVE_SUB
							  ), 0)
	IF @subclientId = 0
	BEGIN
		SET @errorCode = 2
		SET @errorMessage = 'No outlook addin content stor found.'
		GOTO PROC_EXIT
	END
	SET @privateShareId = ISNULL((	SELECT CAST(SP.attrVal AS INT)
									FROM APP_SubClientProp SP
									WHERE SP.componentNameId = @subclientId
									AND SP.attrName = 'OutlookAddinStore Private Share' AND SP.modified = 0
								  ), 0)
	SET @publicShareId = ISNULL((	SELECT CAST(SP.attrVal AS INT)
									FROM APP_SubClientProp SP
									WHERE SP.componentNameId = @subclientId
									AND SP.attrName = 'OutlookAddinStore Public Share' AND SP.modified = 0
								  ), 0)
	IF @privateShareId = 0 OR @publicShareId = 0
	BEGIN
		SET @errorCode = 2
		SET @errorMessage = 'No outlook addin content stor found.'
		GOTO PROC_EXIT
	END
	SET @downloadURL = REPLACE(@downloadURL, '{shareId}', CAST(@publicShareId AS NVARCHAR(MAX)))
	PROC_EXIT:
	IF @errorCode > 0
	BEGIN
		SET @o_xml = (SELECT	@errorCode AS 'error/@errorCode',
								@errorMessage AS 'error/@errorMessage'
					   FOR XML PATH('App_OutlookAddinStoreDetailsResponse'), TYPE
					  )
	END
	ELSE
	BEGIN
		SET @o_xml = (SELECT
								@uploadURL AS 'outlookAddinStoreDetails/@uploadURL',
								@downloadURL AS 'outlookAddinStoreDetails/@downloadURL',
								@privateShareId AS 'outlookAddinStoreDetails/privateShare/@shareId',
								@publicShareId AS 'outlookAddinStoreDetails/publicShare/@shareId'
					   FOR XML PATH('App_OutlookAddinStoreDetailsResponse'), TYPE
					  )
	END
	SELECT @o_xml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetOutlookAddinStoreDetails')
	delete from GxQscripts where name = 'AppGetOutlookAddinStoreDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOutlookAddinStoreDetails')
	delete from GXDBVersions where aliasname = 'AppGetOutlookAddinStoreDetails'
GO

insert into GXDBVersions values(2, 'AppGetOutlookAddinStoreDetails',  '00010002000200010000', 'AppGetOutlookAddinStoreDetails', '00010002000200010000')
GO

