

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetOpWindowRulesList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetOpWindowRulesList.sp,v $ $Id: AppGetOpWindowRulesList.sp,v 1.1.2.12.16.1 2021/03/23 02:07:07 nramalingam Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppGetOpWindowRulesList"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetOpWindowRulesList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetOpWindowRulesList <<<'
	drop procedure AppGetOpWindowRulesList
END
IF EXISTS (select * from GxQscripts where name='AppGetOpWindowRulesList')
	delete from GxQscripts where name = 'AppGetOpWindowRulesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOpWindowRulesList')
	delete from GXDBVersions where aliasname = 'AppGetOpWindowRulesList'
GO
print '... Creating Procedure: AppGetOpWindowRulesList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetOpWindowRulesList
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- 9.0 Changes:
--	1. (cluster) CS nodes can now have more than one client ID.
--
-- ---------------------------------------------------------------
  @i_clientId integer,
  @i_appTypeId integer,
  @i_instanceId integer,
  @i_backupsetId integer,
  @i_subclientId integer,
  @i_schedulePolicyId integer,
  @i_clientgroupId integer,
  @i_getAll integer,
  @i_ruleId integer
AS
  DECLARE @id integer 
  DECLARE @opType integer 
  DECLARE @daysOfWeek integer 
  DECLARE @startDate integer 
  DECLARE @endDate integer 
  DECLARE @startTime integer 
  DECLARE @endTime integer
  DECLARE @enable integer
  DECLARE @utilization integer
  DECLARE @level integer
  DECLARE @description nvarchar(1024)
  DECLARE @clientGroupId integer
  DECLARE @clientId integer
  DECLARE @appTypeId integer
  DECLARE @instanceId integer
  DECLARE @backupsetId integer
  DECLARE @subclientId integer
  DECLARE @schedulePolicyId integer
  DECLARE @commcellName nvarchar(255)
  DECLARE @clientGroupName nvarchar(512)
  DECLARE @clientName nvarchar(255)
  DECLARE @idaName nvarchar(255)
  DECLARE @instanceName nvarchar(512)
  DECLARE @backupsetName nvarchar(128)
  DECLARE @subclientName nvarchar(128)
  DECLARE @schedulePolicyName nvarchar(255)
  DECLARE @companyId integer
  DECLARE @companyName nvarchar(510)
  DECLARE @weekOfTheMonth integer
  DECLARE @doNotSubmitJob integer
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @inSubclientId integer = 0
	DECLARE @inBackupsetId integer = 0
	DECLARE @inInstanceId integer = 0
	DECLARE @inAppTypeId integer = 0
	DECLARE @inClientId integer = 0
	DECLARE @inClientGroupId integer = 0
	DECLARE @inschedulePolicyId integer = 0
	DECLARE @inClientGroupIdFilters integer = 0
	IF @i_subclientId <> 0
		SET @inSubclientId = @i_subclientId
	ELSE IF @i_backupsetId <> 0
		SET @inBackupsetId = @i_backupsetId
	ELSE IF @i_instanceId <> 0
		SET @inInstanceId = @i_instanceId
	ELSE IF @i_clientgroupId <> 0
		SET @inClientGroupId = @i_clientgroupId
	ELSE IF @i_appTypeId <> 0
		BEGIN
			SET @inClientId = @i_clientId
			SET @inAppTypeId = @i_appTypeId
		END
	ELSE IF @i_schedulePolicyId <> 0
		SET @inschedulePolicyId = @i_schedulePolicyId
	ELSE
		SET @inClientId = @i_clientId
	-- Initialise companyId to 0 (Commcell) by default
	SET @companyId = 0
	-- Fetching companyId given clientGroupId
	IF @inClientGroupId > 0
	BEGIN
SET @companyId = ISNULL((SELECT componentNameId FROM APP_CompanyProp WITH(NOLOCK) WHERE attrName = 'Associated Smart Client Group' AND
attrValInt=@inClientGroupId AND cs_attrName=checksum('Associated Smart Client Group')),0)
	END
	-- Fetching companyName from companyId
	SET @companyName = (SELECT domainName FROM UMDSProviders WITH(NOLOCK) WHERE id = @companyId)
	IF object_id('tempdb.dbo.#opWindow') is NOT NULL DROP TABLE #opWindow
	CREATE TABLE #opWindow (
		id integer,
		opType integer,
		daysOfWeek integer,
		startDate integer,
		endDate integer,
		startTime integer,
		endTime integer,
		enable integer,
		utilization integer,
		level integer,
		description nvarchar(1024),
		clientGroupId integer,
		clientId integer,
		appTypeId integer,
		instanceId integer,
		backupsetId integer,
		subclientId integer,
		schedulePolicyId integer,
		commcellName nvarchar(255),
		clientGroupName nvarchar(512),
		clientName nvarchar(255),
		idaName nvarchar(255),
		instanceName nvarchar(512),
		backupsetName nvarchar(128),
		subclientName nvarchar(128),
		schedulePolicyName nvarchar(255),
		companyId integer,
		companyName nvarchar(510),
		weekOfTheMonth integer,
		doNotSubmitJob integer
	)
	SELECT TOP 1
			  @inBackupsetId = CASE WHEN @inSubclientId > 0 THEN backupset ELSE @inBackupsetId END,
			  @inInstanceId = CASE WHEN @inBackupsetId > 0 THEN instance ELSE @inInstanceId END ,
			  @inAppTypeId = CASE WHEN @inInstanceId > 0 THEN apptypeId ELSE @inAppTypeId END,
			  @inClientId = CASE WHEN @inAppTypeId > 0 THEN clientId ELSE @inClientId END
	FROM App_Application
	WHERE  (@inSubclientId > 0 AND id = @inSubclientId)
								OR
		   (@inBackupsetId > 0 AND backupset = @inBackupsetId)
								OR
		   (@inInstanceId > 0 AND instance = @inInstanceId)
								OR
		   (@inAppTypeId > 0 AND apptypeId = @inAppTypeId AND clientId = @inClientId)
-- get client groups for client
	if OBJECT_ID('tempdb.dbo.#ClientGroupIdFilter') is not null drop table dbo.#ClientGroupIdFilter
		create table #ClientGroupIdFilter(groupId integer);
	IF @inClientGroupId > 0
		BEGIN
			INSERT INTO #ClientGroupIdFilter
			select @inClientGroupId
		END
	ELSE
		BEGIN
			IF @inClientId > 0
				BEGIN
					INSERT INTO #ClientGroupIdFilter
					select clientGroupId from APP_ClientGroupAssoc where clientId = @inClientId
				END
		END
	SET @inClientGroupIdFilters = ISNULL((SELECT COUNT(*) FROM #ClientGroupIdFilter), 0)
SET @commcellName = (SELECT name FROM APP_CLIENT WHERE id = 2)
	INSERT INTO #opWindow
		SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization, 6 /* OPRULE_SUBCLIENT */ , description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '', NULL, NULL, weekOfTheMonth, doNotSubmitJob
		FROM App_opwindowrule
		WHERE @inSubclientId > 0 AND subclientId = @inSubclientId
	UNION
		SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization, 5 /* OPRULE_BACKUPSET */, description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '', NULL, NULL, weekOfTheMonth, doNotSubmitJob
		FROM App_opwindowrule
		WHERE @inBackupsetId > 0 AND backupsetId = @inBackupsetId AND subclientId = 0
	UNION
		SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization, 4 /* OPRULE_INSTANCE */, description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '', NULL, NULL, weekOfTheMonth, doNotSubmitJob
		FROM App_opwindowrule
		WHERE @inInstanceId > 0 AND instanceId = @inInstanceId AND backupsetId = 0 AND subclientId = 0
	UNION
		SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization, 3 /* OPRULE_IDA */, description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '', NULL, NULL, weekOfTheMonth, doNotSubmitJob
		FROM App_opwindowrule
		WHERE @inClientId > 0 AND @inAppTypeId > 0 AND clientId = @inClientId AND appTypeId = @inAppTypeId AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
	UNION
		SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization, 2 /* OPRULE_CLIENT */, description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '', NULL, NULL, weekOfTheMonth, doNotSubmitJob
		FROM App_opwindowrule
		WHERE @inClientId > 0 AND clientId = @inClientId AND appTypeId = 0
	UNION
		SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization, 1 /* OPRULE_CLIENTGROUP */, description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '',
				(CASE WHEN @inClientGroupId > 0 THEN @companyId ELSE NULL END), (CASE WHEN @inClientGroupId > 0 THEN @companyName ELSE NULL END), weekOfTheMonth, doNotSubmitJob
		FROM App_opwindowrule
		WHERE @inClientGroupIdFilters > 0 AND clientGroupId IN (select groupId from #ClientGroupIdFilter)
	UNION
		SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization, 7 /* OPRULE_SCHEDULEPOLICY */, description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '', NULL, NULL, weekOfTheMonth, doNotSubmitJob
		FROM App_opwindowrule
		WHERE @inschedulePolicyId > 0 AND schedulePolicyId = @inschedulePolicyId
	UNION
		SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization,
			 (CASE WHEN OPWIN.appTypeId = 1000 THEN 0							--OPRULE_CS
				   WHEN schedulePolicyId > 0 THEN 7								--OPRULE_SCHEDULEPOLICY
				   WHEN subclientId > 0 THEN 6									--OPRULE_SUBCLIENT
				   WHEN backupsetId > 0 THEN 5									--OPRULE_BACKUPSET
				   WHEN instanceId > 0 THEN 4									--OPRULE_INSTANCE
				   WHEN OPWIN.clientId > 0 AND OPWIN.appTypeId = 0 THEN 2		--OPRULE_CLIENT
				   WHEN OPWIN.clientId > 0 AND OPWIN.appTypeId <> 1000 THEN 3	--OPRULE_IDA
				   WHEN clientGroupId > 0 THEN 1								--OPRULE_CLIENTGROUP
			 END) AS level, description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '', NULL, NULL, weekOfTheMonth, doNotSubmitJob
		FROM App_opwindowrule OPWIN
		WHERE @i_ruleId > 0 AND id = @i_ruleId
IF @i_getAll = 1 AND @inAppTypeId = 1000
		BEGIN
			INSERT INTO #opWindow
			SELECT OPWIN.id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization,
			 (CASE WHEN OPWIN.appTypeId = 1000 THEN 0							--OPRULE_CS
				   WHEN schedulePolicyId > 0 THEN 7								--OPRULE_SCHEDULEPOLICY
				   WHEN subclientId > 0 THEN 6									--OPRULE_SUBCLIENT
				   WHEN backupsetId > 0 THEN 5									--OPRULE_BACKUPSET
				   WHEN instanceId > 0 THEN 4									--OPRULE_INSTANCE
				   WHEN OPWIN.clientId > 0 AND OPWIN.appTypeId = 0 THEN 2		--OPRULE_CLIENT
				   WHEN OPWIN.clientId > 0 AND OPWIN.appTypeId <> 1000 THEN 3	--OPRULE_IDA
				   WHEN clientGroupId > 0 THEN 1								--OPRULE_CLIENTGROUP
			 END) AS level,
			 OPWIN.description,
			 clientGroupId,
			 OPWIN.clientId,
			 OPWIN.appTypeId,
			 instanceId,
			 backupsetId,
			 subclientId,
			 schedulePolicyId,
			 @commcellName,
			 ISNULL(CLIENTGROUP.name,'') as clientGroupName,
			 CASE WHEN OPWIN.clientId <> 0 AND OPWIN.appTypeId <> 1000 THEN ISNULL(CLIENT.name,'') ELSE '' END as clientName,
			 ISNULL(IDA.displayName,'') as idaName,
			 ISNULL(INSTANCE.name,'') as instanceName,
			 ISNULL(BACKUPSET.name,'') as backupsetName,
			 ISNULL(APP.subclientName,'') as subclientName,
			 ISNULL(SCHEDULEPOLICY.taskName,'') as schedulePolicyName,
			 ISNULL(CONVERT(INT,CLIENTPROP.attrVal),ISNULL(COMPANY.componentNameId,0)) as companyId,
			 NULL as companyName,
			 weekOfTheMonth,
			 doNotSubmitJob
			FROM App_opwindowrule OPWIN
			LEFT OUTER JOIN APP_ClientGroup CLIENTGROUP ON OPWIN.clientGroupId = CLIENTGROUP.id
			LEFT OUTER JOIN APP_Client CLIENT ON OPWIN.clientId = CLIENT.id
			LEFT OUTER JOIN APP_iDAType IDA ON OPWIN.appTypeId = IDA.type AND OPWIN.appTypeId <> 0 AND OPWIN.appTypeId <> 1000
			LEFT OUTER JOIN APP_InstanceName INSTANCE ON OPWIN.instanceId = INSTANCE.id
			LEFT OUTER JOIN APP_BackupSetName BACKUPSET ON OPWIN.backupsetId = BACKUPSET.id
			LEFT OUTER JOIN APP_Application APP ON OPWIN.subclientId = APP.id
			LEFT OUTER JOIN TM_Task SCHEDULEPOLICY ON OPWIN.schedulePolicyId = SCHEDULEPOLICY.taskId
LEFT OUTER JOIN APP_ClientProp CLIENTPROP ON OPWIN.clientId = CLIENTPROP.componentNameId AND OPWIN.clientId <> 0 AND CLIENTPROP.attrName = 'Installation Company ID' AND CLIENTPROP.modified = 0
LEFT OUTER JOIN APP_CompanyProp COMPANY ON  CAST(OPWIN.clientGroupId AS NVARCHAR(MAX)) = COMPANY.attrVal AND COMPANY.attrName = 'Associated Smart Client Group' AND COMPANY.cs_attrName=checksum('Associated Smart Client Group') AND COMPANY.modified = 0
		END
ELSE IF @i_ruleId<=0 AND @i_ruleId <> -1 --If we want for specific ruleId dont get all operation rules at commcell level.
		BEGIN
			-- CV_COMPONENT_COMMCELL_ONLY_RULES used to fetch operation window rules set at only commcell level
			INSERT INTO #opWindow
			SELECT id, opType, daysOfWeek, startDate, endDate, startTime, endTime, enable, utilization, 0 /* OPRULE_CS */, description, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, schedulePolicyId, @commcellName, clientGroupName = '', clientName = '', idaName = '', instanceName = '', backupsetName = '', subclientName = '', schedulePolicyName = '', NULL, NULL, weekOfTheMonth, doNotSubmitJob
			FROM App_opwindowrule
WHERE clientId = 2 AND appTypeId = 1000 AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
		END
	-- Update #opWindow to populate the companyName for corresponding companyId. Running this query separately because its epxensive to find the companyName while we are not sure
	-- if the companyId came from App_clientProp table or App_CompanyProp table
	UPDATE #opWindow SET companyName = UMDS.domainName FROM #opWindow INNER JOIN UMDSProviders UMDS ON UMDS.id = companyId
		SELECT id,
		opType,
		daysOfWeek,
		startDate,
		endDate,
		startTime,
		endTime,
		enable,
		utilization,
		level,
		description,
		clientGroupId,
		clientId,
		appTypeId,
		instanceId,
		backupsetId,
		subclientId,
		schedulePolicyId,
		commcellName,
		clientGroupName,
		clientName,
		idaName,
		instanceName,
		backupsetName,
		subclientName,
		schedulePolicyName,
		companyId,
		companyName,
		weekOfTheMonth,
		doNotSubmitJob FROM #opWindow
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetOpWindowRulesList')
	delete from GxQscripts where name = 'AppGetOpWindowRulesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOpWindowRulesList')
	delete from GXDBVersions where aliasname = 'AppGetOpWindowRulesList'
GO

insert into GXDBVersions values(2, 'AppGetOpWindowRulesList',  'v1.1.2.12.16.1', 'AppGetOpWindowRulesList', 'v1.1.2.12.16.1')
GO

