

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetOneDriveAzureProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Mahesh Kasana
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetOneDriveAzureProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetOneDriveAzureProperties <<<'
	drop procedure AppGetOneDriveAzureProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetOneDriveAzureProperties')
	delete from GxQscripts where name = 'AppGetOneDriveAzureProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOneDriveAzureProperties')
	delete from GXDBVersions where aliasname = 'AppGetOneDriveAzureProperties'
GO
print '... Creating Procedure: AppGetOneDriveAzureProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetOneDriveAzureProperties
  @i_clientId INT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE	@isOnedriveV2 int = 0
	DECLARE @instanceId INT = 0
	DECLARE @onedriveAzureApps NVARCHAR(MAX) = NULL
	DECLARE @onedriveServiceAccounts NVARCHAR(MAX) = NULL
	DECLARE @onedriveMSCloudRegion INT
	DECLARE @clientSecret NVARCHAR(MAX) = NULL
	DECLARE @clientId NVARCHAR(1024) = NULL
	DECLARE @tenant NVARCHAR(1024) = NULL
	IF EXISTS(SELECT * from APP_ClientProp (NOLOCK) WHERE attrName = 'Office 365 Pseudo Client' and componentNameId = @i_clientId)
	SET @isOnedriveV2 = 1
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
SET @instanceId = (SELECT TOP 1 instance from APP_Application (NOLOCK) where clientId = @i_clientId AND appTypeId = 134)
	IF @instanceId <=0 OR @instanceId = NULL
	BEGIN
		SET @errorString = 'ERROR : Invalid Instance Id'
		GOTO ERROR_EXIT
	END
	SET @onedriveServiceAccounts = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'OneDrive Service Accounts' AND modified = 0 AND attrType = 1)
SET @onedriveMSCloudRegion = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'MSCloud Region Type' AND modified = 0 AND attrType = 7)
	IF @onedriveServiceAccounts IS NOT NULL
	SET @onedriveServiceAccounts =  REPLACE(@onedriveServiceAccounts,'App_OneDriveServiceAccounts','serviceAccounts')
	IF @isOnedriveV2 = 1
	BEGIN
		SET @onedriveAzureApps = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'OneDrive Azure Connections' AND modified = 0 AND attrType = 1)
		IF @onedriveAzureApps IS NOT NULL
		SET @onedriveAzureApps =  REPLACE(@onedriveAzureApps,'App_Office365AzureConnections','azureAppList')
	END
	ELSE
	BEGIN
		SET @clientSecret = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'OneDrive Secret Key' AND modified = 0 AND attrType = 1)
		SET @clientId = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'Enterprise App client Id' AND modified = 0 AND attrType = 1)
		SET @tenant = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'OneDrive Tenant' AND modified = 0 AND attrType = 1)
	END
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	SET @o_xmlString =
	(
		SELECT @onedriveMSCloudRegion '@cloudRegion', @clientId '@clientId', @clientSecret '@clientSecret', @tenant '@tenant',
		(
			SELECT CAST( REPLACE(@onedriveAzureApps,'encoding="utf-8"', 'encoding="utf-16"') AS XML)
		),
		(
			SELECT  CAST( REPLACE(@onedriveServiceAccounts,'encoding="utf-8"', 'encoding="utf-16"') AS XML)
		)
		FOR XML PATH('App_OneDriveInstance')
	)
ERROR_EXIT:
	IF @o_xmlString IS NULL
	SET @o_xmlString =
	(
		SELECT
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
				FOR XML PATH ('resp'),TYPE
				)
			FOR XML PATH(''),ROOT('App_OneDriveInstance')
	)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetOneDriveAzureProperties')
	delete from GxQscripts where name = 'AppGetOneDriveAzureProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOneDriveAzureProperties')
	delete from GXDBVersions where aliasname = 'AppGetOneDriveAzureProperties'
GO

insert into GXDBVersions values(2, 'AppGetOneDriveAzureProperties',  '00000000000000000000', 'AppGetOneDriveAzureProperties', '00000000000000000000')
GO

