

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetOfflineClientsEligibleForDeletion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetOfflineClientsEligibleForDeletion')
BEGIN
	print '>>> Drop Stored Procedure: AppGetOfflineClientsEligibleForDeletion <<<'
	drop procedure AppGetOfflineClientsEligibleForDeletion
END
IF EXISTS (select * from GxQscripts where name='AppGetOfflineClientsEligibleForDeletion')
	delete from GxQscripts where name = 'AppGetOfflineClientsEligibleForDeletion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOfflineClientsEligibleForDeletion')
	delete from GXDBVersions where aliasname = 'AppGetOfflineClientsEligibleForDeletion'
GO
print '... Creating Procedure: AppGetOfflineClientsEligibleForDeletion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetOfflineClientsEligibleForDeletion
AS
-- INPUT : NO INPUT FOR THIS SP
-- OUTPUT: IF TEMP TABLE #AppGetOfflineClientsEligibleForDeletionExtTable (clientId INT) EXISTS, OFFLINE CLIENTS THAT ARE ELIGIBLE FOR DELETION WILL BE INSERTED INTO THIS TABLE
--         OTHERWISE, XML THAT WILL BE THE OUTPUT THAT CONTAINS LIST OF CLIENT ENTITIES (GetOfflineClientsEligibleForDeletionResponse DEFINES THE XML STRUCTURE IN APP.X)
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @nowTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())
DECLARE @defaultNumOfDaysToDelete INT = 365
DECLARE @numOfDaysToDeleteCommCell INT = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'Force delete devices after days' AND modified = 0), @defaultNumOfDaysToDelete)
	IF object_id('tempdb.dbo.#clientsEligibleForDeletionTable') IS NOT NULL
		DROP TABLE #clientsEligibleForDeletionTable
	CREATE TABLE #clientsEligibleForDeletionTable
(clientId INT PRIMARY KEY, planId INT DEFAULT -1, companyId INT DEFAULT 0, lastOfflineTime BIGINT, numberOfDaysToDelete INT DEFAULT 365, eligibleForDeletion INT DEFAULT 0)
	-- INSERT ALL OFFLINE LAPTOP CLIENTS THAT ARE CURRENTLY NOT BEING RETIRED IN A JOB TO TABLE INTO #clientsEligibleForDeletionTable
	INSERT INTO #clientsEligibleForDeletionTable
	(clientId, lastOfflineTime, numberOfDaysToDelete)
	SELECT C.id, CCRCTC.lastOfflineTime, @defaultNumOfDaysToDelete
	FROM App_Client C
	JOIN CCRClientToClient CCRCTC
ON C.status & 0x1000 = 0x1000
		AND CCRCTC.fromClientId = 2 AND CCRCTC.lastOnlineTime < CCRCTC.lastOfflineTime 	-- fromClientId FILTER ADDED HERE IS TO MAKE SURE THAT THE RECORDS IS THE CONNECTION FROM COMMCELL TO CLIENT
		AND CCRCTC.toClientId = C.id
	-- UPDATE COMPANY ID AND PLAN ID ASSOCIATED WITH CLIENTS IN #clientsEligibleForDeletionTable
	UPDATE #clientsEligibleForDeletionTable
	SET planId = ISNULL(CAST(P2.attrVal AS INT), -1), companyId = ISNULL(CAST(P1.attrVal AS INT), 0)
	FROM #clientsEligibleForDeletionTable C
LEFT JOIN App_ClientProp P1 ON P1.attrName = 'Installation Company ID' AND P1.modified = 0 AND C.clientId = P1.componentNameId
LEFT JOIN App_ClientProp P2 ON P2.attrName = 'Associated Plan' AND P1.modified = 0 AND C.clientId = P2.componentNameId
	-- GET TRUE COMPANY ID FOR COMPANY ID IS 0
	UPDATE #clientsEligibleForDeletionTable
	SET companyId = C1.companyId
	FROM #clientsEligibleForDeletionTable C
	JOIN
	(
		SELECT companyId, clientId, rownumber FROM
		(
			SELECT ACP.componentNameId companyId, CT.clientId clientId, ROW_NUMBER() OVER (PARTITION BY CT.clientId ORDER BY ACP.componentNameId) AS rownumber
			FROM #clientsEligibleForDeletionTable CT
			INNER JOIN APP_ClientGroupAssoc ACGA ON CT.companyId = 0 AND CT.clientId = ACGA.clientId
			INNER JOIN App_CompanyProp ACP ON ACP.attrVal = CAST(ACGA.clientGroupId AS NVARCHAR(12))
AND ACP.attrName='Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group') AND ACP.modified = 0
		) C2 WHERE rownumber = 1
	) C1 ON C.clientId = C1.clientId
	-- UPDATE numberOfDaysToDelete WITH PLAN LEVEL SETTING
	UPDATE #clientsEligibleForDeletionTable
	SET numberOfDaysToDelete = CAST(PP1.attrVal AS INT)
	FROM #clientsEligibleForDeletionTable C
JOIN App_PlanProp PP1 ON C.planId <> -1 AND PP1.attrName = 'Force delete devices after days' AND PP1.modified = 0 AND C.planId = PP1.componentNameId
	-- UPDATE numberOfDaysToDelete WITH COMPANY LEVEL SETTING, IF IT IS NOT SET AT PLAN LEVEL
	UPDATE #clientsEligibleForDeletionTable
	SET numberOfDaysToDelete = CAST(CP1.attrVal AS INT)
	FROM #clientsEligibleForDeletionTable C
JOIN App_CompanyProp CP1 ON C.companyId > 0 AND CP1.attrName = 'Force delete devices after days' AND CP1.cs_attrName = CHECKSUM('Force delete devices after days') AND CP1.modified = 0 AND C.companyId = CP1.componentNameId
	-- UPDATE numberOfDaysToDelete WITH COMMCELL LEVEL SETTING, IF NEITHER PLAN LEVEL AND COMPANY LEVEL HAS IT SET AND COMMCELL HAS IT SET
	UPDATE #clientsEligibleForDeletionTable
	SET numberOfDaysToDelete = @numOfDaysToDeleteCommCell
	WHERE companyId = 0
	-- FIGURE OUT CLIENTS THAT ARE EILIGIBLE FOR DELETION
	UPDATE #clientsEligibleForDeletionTable
	SET eligibleForDeletion = 1
	FROM #clientsEligibleForDeletionTable
	WHERE numberOfDaysToDelete > 0 AND (numberOfDaysToDelete * 86400) < (@nowTime - lastOfflineTime)
	IF object_id('tempdb.dbo.#AppGetOfflineClientsEligibleForDeletionExtTable') IS NOT NULL
	BEGIN
		INSERT INTO #AppGetOfflineClientsEligibleForDeletionExtTable
		(clientId)
		SELECT clientId
		FROM #clientsEligibleForDeletionTable
		WHERE eligibleForDeletion = 1
	END
	ELSE
	BEGIN
		SET @outXml = (SELECT
			(
				SELECT clientId AS '@clientId'
				FROM #clientsEligibleForDeletionTable
				WHERE eligibleForDeletion = 1
				FOR XML PATH ('client'), TYPE
			)
			FOR XML PATH ('App_GetOfflineClientsEligibleForDeletionResponse'), TYPE)
	END
PROC_EXIT:
	IF @outXml IS NOT NULL
	BEGIN
		SELECT @outXml AS outXml
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetOfflineClientsEligibleForDeletion')
	delete from GxQscripts where name = 'AppGetOfflineClientsEligibleForDeletion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOfflineClientsEligibleForDeletion')
	delete from GXDBVersions where aliasname = 'AppGetOfflineClientsEligibleForDeletion'
GO

insert into GXDBVersions values(2, 'AppGetOfflineClientsEligibleForDeletion',  '00000000000000000000', 'AppGetOfflineClientsEligibleForDeletion', '00000000000000000000')
GO

