

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetOffice365ConnectionProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		  Procedure : "AppGetOffice365ConnectionProperties"
--        Description: This procedure is used to return Office365 client connection details.
--	      Author: Suhail Bhat
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetOffice365ConnectionProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetOffice365ConnectionProperties <<<'
	drop procedure AppGetOffice365ConnectionProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetOffice365ConnectionProperties')
	delete from GxQscripts where name = 'AppGetOffice365ConnectionProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOffice365ConnectionProperties')
	delete from GXDBVersions where aliasname = 'AppGetOffice365ConnectionProperties'
GO
print '... Creating Procedure: AppGetOffice365ConnectionProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetOffice365ConnectionProperties
  @i_clientId INT,
  @i_userId INT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE	@isOffice365PseudoClient INT = 0
	DECLARE @agentId INT = 0
	DECLARE @exchangeAzureApps NVARCHAR(MAX) = NULL
	DECLARE @exchangeServiceAccounts NVARCHAR(MAX) = NULL
	DECLARE @exchangeMSCloudRegion INT = 0
	DECLARE @exchangeModernAuthentication INT = 0
	DECLARE @xml_serviceAccounts XML
	DECLARE @xml_AzureApplications XML
	DECLARE @instanceId 		INT = 0
	DECLARE @backupsetId		INT = 0
	DECLARE @appType			INT = 0
	DECLARE @hasPermission INT = 0
	DECLARE @INSUFFICIENT_PERMISSIONS	INT = 111
	IF EXISTS(SELECT TOP 1 attrVal FROM APP_ClientProp (NOLOCK) WHERE attrName = 'Office 365 Pseudo Client' and componentNameId = @i_clientId)
	SET @isOffice365PseudoClient = 1
	SET @agentId = (SELECT TOP 1 id FROM APP_IDAName (NOLOCK) WHERE clientId = @i_clientId AND appTypeId = 137)
	IF @agentId <=0 OR @agentId = NULL
	BEGIN
		SET @errorString = 'ERROR : Invalid agent Id'
		GOTO ERROR_EXIT
	END
	SET @i_userId = ISNULL(@i_userId, 0)   -- Set 0 if null
	IF @i_userId <= 0
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Error: Invalid user id [' + CAST(@i_userId AS VARCHAR(16)) + ']'
		GOTO ERROR_EXIT
	END
	SET @appType = (SELECT TOP 1 appTypeId FROM APP_IDAName (NOLOCK) WHERE id = @agentId)
	SET @instanceId = (SELECT TOP 1 instance FROM App_Application (NOLOCK) where clientId = @i_clientId AND appTypeId = @appType)
	SET @backupsetId = 	(SELECT TOP 1 backupset FROM App_Application (NOLOCK) where clientId = @i_clientId AND instance = @instanceId AND appTypeId = @appType)
EXEC sec_checkPermissionOnEntity @i_userId, 0, @hasPermission OUTPUT, 3, @i_clientId, 4, @appType, 5, @instanceId, 6, @backupsetId, 0,0
	IF @hasPermission <> 1
	BEGIN
			SET @errorCode = @INSUFFICIENT_PERMISSIONS
			SET @errorString = 'Error : User does not have required permission to perform this operation'
			GOTO ERROR_EXIT
	END
	--Exchange Service Accounts
	SET @exchangeServiceAccounts = ISNULL((
									SELECT attrVal FROM APP_IDAProp (NOLOCK)
									WHERE componentNameId = @agentId AND attrName = N'Exchange OnePass Admin Accounts' AND modified = 0 AND attrType = 1
									), NULL)
	IF @exchangeServiceAccounts IS NOT NULL
	SET @exchangeServiceAccounts =  REPLACE(@exchangeServiceAccounts,'App_ExchangeAdminAccounts','exchangeServiceAccounts')
	--Exchange Azure Apps
	SET @exchangeAzureApps = ISNULL((
							  SELECT attrVal FROM APP_IDAProp (NOLOCK) WHERE componentNameId = @agentId AND attrName = N'Exchange Azure Connections' AND modified = 0 AND attrType = 1
							  ), NULL)
	IF @exchangeAzureApps IS NOT NULL
	SET @exchangeAzureApps =  REPLACE(@exchangeAzureApps,'App_Office365AzureConnections','azureAppList')
	--Exchange Cloud Region
	SET @exchangeMSCloudRegion = ISNULL((
								  SELECT attrVal FROM APP_IDAProp (NOLOCK)
								  WHERE componentNameId = @agentId AND attrName = N'MSCloud Region Type' AND modified = 0 AND attrType = 7
								  ), 0)
	--Exchange Modern Auth Flag
	SET @exchangeModernAuthentication = ISNULL((
										 SELECT attrVal FROM APP_IDAProp (NOLOCK)
										 WHERE componentNameId = @agentId AND attrName = N'Exchange Modern Auth' AND modified = 0 AND attrType = 2
										 ), 0)
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	--MODIFY Service Accounts XML
	--DELETE Password
	SET @xml_serviceAccounts = CAST( REPLACE(@exchangeServiceAccounts,'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
	IF @xml_serviceAccounts.exist('/exchangeServiceAccounts') > 0
		BEGIN
			SET @xml_serviceAccounts.modify('delete //@password')
	END
	--MODIFY Azure Apps XML
	--DELETE App Key
	SET @xml_AzureApplications = CAST( REPLACE(@exchangeAzureApps,'encoding="UTF-8"', 'encoding="UTF-16"') AS XML)
	IF @xml_AzureApplications.exist('/azureAppList') > 0
		BEGIN
			SET @xml_AzureApplications.modify('delete //@azureAppKeyValue')
	END
	SET @o_xmlString =
	(
		SELECT
		@exchangeMSCloudRegion '@cloudRegion',
		@exchangeModernAuthentication '@isModernAuthenticationEnabled',
		@isOffice365PseudoClient '@isOffice365PseudoClient',
		@xml_serviceAccounts,
		@xml_AzureApplications
		FOR XML PATH('App_Office365ConnectionProperties')
	)
ERROR_EXIT:
	IF @o_xmlString IS NULL
	SET @o_xmlString =
	(
		SELECT
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
				FOR XML PATH ('resp'),TYPE
				)
			FOR XML PATH(''),ROOT('App_Office365ConnectionProperties')
	)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetOffice365ConnectionProperties')
	delete from GxQscripts where name = 'AppGetOffice365ConnectionProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOffice365ConnectionProperties')
	delete from GXDBVersions where aliasname = 'AppGetOffice365ConnectionProperties'
GO

insert into GXDBVersions values(2, 'AppGetOffice365ConnectionProperties',  '00000000000000000000', 'AppGetOffice365ConnectionProperties', '00000000000000000000')
GO

