

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetOffice365ClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetOffice365ClientInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetOffice365ClientInfo <<<'
	drop procedure AppGetOffice365ClientInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetOffice365ClientInfo')
	delete from GxQscripts where name = 'AppGetOffice365ClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOffice365ClientInfo')
	delete from GXDBVersions where aliasname = 'AppGetOffice365ClientInfo'
GO
print '... Creating Procedure: AppGetOffice365ClientInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetOffice365ClientInfo
  @i_backupSetId INT,
  @i_userId INT,
  @o_xmlString XML OUTPUT
AS
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	-- App Types
	DECLARE @CV_APPTYPE_EXCHANGE_ONEPASS INT = 137
	DECLARE @CV_APPTYPE_CLOUD_APPS INT = 134
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(1024) = ''
	DECLARE @INSUFFICIENT_PERMISSIONS	INT = 111
	DECLARE @ClientId			INT = 0
	DECLARE @instanceId 		INT = 0
	DECLARE @appType			INT = 0
	DECLARE @hasPermission INT = 0
	DECLARE @subclientId INT = 0
	SET @i_backupSetId = ISNULL(@i_backupSetId, 0)   -- Set 0 if null
	IF @i_backupSetId <= 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error: Invalid backupset id [' + CAST(@i_backupSetId AS VARCHAR(16)) + ']'
		GOTO ERROR_EXIT
	END
	SET @i_userId = ISNULL(@i_userId, 0)   -- Set 0 if null
	IF @i_userId <= 0
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Error: Invalid user id [' + CAST(@i_userId AS VARCHAR(16)) + ']'
		GOTO ERROR_EXIT
	END
	SET @appType = (SELECT TOP 1 appTypeId FROM App_Application (NOLOCK) where backupset = @i_backupSetId)
	SET @ClientId = (SELECT TOP 1 clientId FROM App_Application (NOLOCK) where backupset = @i_backupSetId)
	SET @instanceId = (SELECT TOP 1 instance FROM App_Application (NOLOCK) where backupset = @i_backupSetId)
	SET @subclientId = (SELECT TOP 1 id FROM App_Application (NOLOCK) where backupset = @i_backupSetId)
EXEC sec_checkPermissionOnEntity @i_userId, 0, @hasPermission OUTPUT, 3, @ClientId, 4, @appType, 5, @instanceId, 6, @i_backupsetId, 7,@subclientId
	IF @hasPermission <> 1
	BEGIN
			SET @errorCode = @INSUFFICIENT_PERMISSIONS
			SET @errorString = 'Error : User does not have required permission to perform this operation'
			GOTO ERROR_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#tempOffice365ClientInfo') IS NOT NULL
			DROP TABLE #tempOffice365ClientInfo
	CREATE TABLE #tempOffice365ClientInfo
	(
		clientId INT,
		appType INT,
		clientName NVARCHAR(255),
		clientGUID NVARCHAR(255),
		displayName NVARCHAR(255),
		backupSetId INT,
		backupSetName NVARCHAR(255),
		instanceId INT,
		instanceName NVARCHAR(255),
		subclientId INT,
		subclientName NVARCHAR(255),
		subclientGUID NVARCHAR(255),
		instanceType INT,
		backupSetType INT,
		isDisabledClient INT,
		isOffice365V2Client  INT,
		environmentType INT
	)
	BEGIN TRY
		-- insert basic client details
		INSERT INTO #tempOffice365ClientInfo(subclientId, clientId, appType, instanceId, backupSetId, subclientGUID, subclientName, backupSetName, instanceName, clientName, displayName, clientGUID)
		SELECT
			app.subclientId,
			app.clientId,
			app.appTypeId,
			app.instance,
			app.backupSet,
			app.GUID,
			app.subclientName,
			backupset.name,
			instance.name,
			client.name,
			client.displayName,
			client.GUID
		FROM
		(SELECT id AS subclientId, clientId, appTypeId, instance, backupSet, subclientName, GUID
		FROM APP_Application(NOLOCK)
		WHERE id in (SELECT MIN(id) from APP_Application(NOLOCK) WHERE backupSet = @i_backupSetId)) app
		INNER JOIN APP_BackupSetName(NOLOCK) backupset ON app.backupSet = backupset.id
		INNER JOIN APP_InstanceName(NOLOCK) instance ON app.instance = instance.id
		INNER JOIN APP_Client client(NOLOCK) ON app.clientId = client.id
		-- set instance type if cloup app, backupset type if exchange onepass and both to 0 if sharepoint
		UPDATE #tempOffice365ClientInfo
		SET
		instanceType =
			CASE
				WHEN #tempOffice365ClientInfo.appType = @CV_APPTYPE_CLOUD_APPS THEN
					(SELECT instanceProp.attrVal FROM APP_InstanceProp(NOLOCK) instanceProp WHERE instanceProp.componentNameId = #tempOffice365ClientInfo.instanceId AND attrName = 'Cloud Apps Instance Type' AND modified = 0)
				ELSE 0
			END,
		backupSetType =
			CASE
				WHEN #tempOffice365ClientInfo.appType = @CV_APPTYPE_EXCHANGE_ONEPASS THEN
					(SELECT backupsetProp.attrVal FROM APP_BackupSetProp(NOLOCK) backupsetProp WHERE backupsetProp.componentNameId = #tempOffice365ClientInfo.backupSetId AND attrName = 'Exchange OnePass BackupSet Type' AND modified = 0)
				ELSE 0
			END
		-- set disabled client status
		UPDATE #tempOffice365ClientInfo
		SET isDisabledClient = ISNULL((SELECT attrVal FROM APP_ClientProp(NOLOCK) clientProp
								WHERE clientProp.componentNameId = #tempOffice365ClientInfo.clientId AND clientProp.attrName = 'PlatformDeleted 4' AND modified = 0), 0)
		-- set office365v2 clients status
		UPDATE #tempOffice365ClientInfo
		SET isOffice365V2Client = ISNULL((SELECT attrVal FROM APP_ClientProp(NOLOCK) clientProp
									WHERE clientProp.componentNameId = #tempOffice365ClientInfo.clientId AND clientProp.attrName = 'Office 365 Pseudo Client' AND clientProp.attrVal = 1 AND clientProp.modified = 0),  0)
		-- set environmentType for exchange v1 clients
		UPDATE #tempOffice365ClientInfo
		SET environmentType = (SELECT attrVal FROM APP_IDAProp(NOLOCK) WHERE componentNameId IN (SELECT id FROM APP_IDAName(NOLOCK) WHERE clientId = #tempOffice365ClientInfo.clientId) AND attrName = 'Exchange Environment Type' AND modified = 0)
								WHERE appType = @CV_APPTYPE_EXCHANGE_ONEPASS AND isOffice365V2Client = 0
		SET @o_xmlString = (SELECT (SELECT
								instanceType AS "@instanceType",
								backupSetType AS "@backupsetType",
								appType as "@appType",
								ISNULL(isDisabledClient, 0) AS "@isDisabledClient",
								ISNULL(isOffice365V2Client , 0) AS "@isOffice365V2Client",
								environmentType AS '@environmentType',
								(SELECT (SELECT
									clientId as "@clientId",
									clientName as "@clientName",
									clientGUID as "@clientGUID",
									displayName as "@displayName",
									backupSetId as "@backupsetId",
									backupSetName as "@backupsetName",
									instanceId as "@instanceId",
									instanceName as "@instanceName",
									subclientId as "@subclientId",
									subclientGUID as "@subclientGUID",
									subclientName as "@subclientName"
									FOR XML PATH ('subclientEntity'), TYPE)
								)
							FROM #tempOffice365ClientInfo
							FOR XML PATH ('office365ClientInfo'), TYPE)
							FOR XML PATH ('App_Office365ClientInfoResp'))
	END TRY
	BEGIN CATCH
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
	ERROR_EXIT:
		IF @errorCode <> 0
		BEGIN
			SET @o_xmlString =
			(SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
                                AS '@errorMessage' FOR XML PATH('App_Office365ClientInfoResp'))
		END
	IF OBJECT_ID('tempdb.dbo.#tempOffice365ClientInfo') IS NOT NULL
		DROP TABLE #tempOffice365ClientInfo
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetOffice365ClientInfo')
	delete from GxQscripts where name = 'AppGetOffice365ClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOffice365ClientInfo')
	delete from GXDBVersions where aliasname = 'AppGetOffice365ClientInfo'
GO

insert into GXDBVersions values(2, 'AppGetOffice365ClientInfo',  '00000000000000000000', 'AppGetOffice365ClientInfo', '00000000000000000000')
GO

