

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetObjectStoreDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetObjectStoreDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetObjectStoreDetails <<<'
	drop procedure AppGetObjectStoreDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetObjectStoreDetails')
	delete from GxQscripts where name = 'AppGetObjectStoreDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetObjectStoreDetails')
	delete from GXDBVersions where aliasname = 'AppGetObjectStoreDetails'
GO
print '... Creating Procedure: AppGetObjectStoreDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetObjectStoreDetails
  @inXMl XML
AS
BEGIN
  DECLARE @outputXML XML 
  DECLARE @iSubclientId INTEGER
  DECLARE @clientId INTEGER
  DECLARE @vmName nvarchar(max)
  DECLARE @vmGuid nvarchar(max)
  DECLARE @vmInstanceType nvarchar(max)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SELECT @iSubclientId = N.value('@subclientId','INTEGER') FROM @inXMl.nodes('App_GetObjectStoreDetailsReq') AS T(N)
    SELECT @clientId = clientId FROM APP_Application WITH(NOLOCK) WHERE id = @iSubclientId
	SELECT @vmName = attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND modified = 0 AND attrName  ='Virtual Machine Name'
	SELECT @vmGuid = attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND modified = 0 AND attrName  ='Virtual Machine Instance UUID'
	SELECT  @vmInstanceType = IP.attrval  from APP_InstanceProp IP WITH(NOLOCK) INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON IP.componentNameId = CP.attrVal
			WHERE  CP.modified = 0 AND IP.modified = 0 AND IP.attrName = 'Virtual Server Instance Type'
			AND CP.attrName ='Virtual Machine Instance ID'
    SET @outputXML  =
    (
		SELECT
		ISNULL(IDA.caseSensitivity, 0) AS '@isCaseSensitive',
		CASE
WHEN(IDA.type = 134 AND (INST.attrVal = 5 OR INST.attrVal = 6 OR INST.attrVal = 20)) THEN '/' -- azure blob, amazon s3, Google
WHEN (IDA.type = 78 OR (IDA.type = 134 AND (INST.attrVal = 7 OR INST.attrVal = 35))) THEN '\' -- For SharePoint the dirDelim stored in App_iDAType is '\\MB', set it to '\' -- OneDrive 's delimiter is '\'
			ELSE ISNULL(IDA.dirDelim, '\')
			END AS '@delimiter',
		CASE ISNULL(CP1.attrVal, 0)
			WHEN 0
				THEN  ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'EdgeDriveBulkDeleteAlertThreshold'), '500')
			ELSE '0'
		END AS '@bulkDeletedhreshold',
		@vmName AS 'vmDetails/@vmName',
		@vmGuid AS 'vmDetails/@vmGuid',
		@vmInstanceType AS 'vmDetails/@vmInstanceType'
		FROM APP_Application APP WITH(NOLOCK)
		INNER JOIN APP_iDAType IDA WITH(NOLOCK) ON APP.appTypeId = IDA.type
		INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = APP.clientId
		LEFT OUTER JOIN APP_ClientProp CP1 WITH(NOLOCK) ON CP1.componentNameId = C.id AND CP1.attrName = 'System Drive Type'
		LEFT OUTER JOIN APP_InstanceProp INST WITH(NOLOCK) ON INST.attrName = 'Cloud Apps Instance Type' AND INST.componentNameId = APP.instance
		WHERE APP.id = @iSubclientId
		FOR XML PATH ('App_GetObjectStoreDetailsResp'), TYPE
    )
    SELECT @outputXML
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetObjectStoreDetails')
	delete from GxQscripts where name = 'AppGetObjectStoreDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetObjectStoreDetails')
	delete from GXDBVersions where aliasname = 'AppGetObjectStoreDetails'
GO

insert into GXDBVersions values(2, 'AppGetObjectStoreDetails',  '00000000000000000000', 'AppGetObjectStoreDetails', '00000000000000000000')
GO

