

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetOAuthAppForURL.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------
--	SP Name :	AppGetOAuthAppForURL
--	Purpose	:	for a particular redirect URL, get the list of OAuth
--				applications which have the redirect URI as part of their
--				redirect URI list.
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetOAuthAppForURL <<<'

IF EXISTS (select * from sysobjects where name='AppGetOAuthAppForURL')
	drop procedure AppGetOAuthAppForURL
IF EXISTS (select * from GxQscripts where name='AppGetOAuthAppForURL')
	delete from GxQscripts where name = 'AppGetOAuthAppForURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOAuthAppForURL')
	delete from GXDBVersions where aliasname = 'AppGetOAuthAppForURL'
GO
print '... Creating Procedure: AppGetOAuthAppForURL'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetOAuthAppForURL
  @i_hostURL nvarchar(MAX),
  @i_appType integer,
  @out_xml XML	OUT
AS
SET NOCOUNT ON
declare @errorCode 		integer
declare @warningCode 	integer
declare @errorXml		xml
declare @appXml			xml
declare @hostURL 		nvarchar(255)
declare @errorMessage 	nvarchar(255)
declare @appType		integer
set @hostURL 	= isnull(@i_hostURL , '')
set @appType	= isnull(@i_appType , 0)
set @errorCode  	= 0
set @errorMessage 	= ''
if(@hostURL = '' or @appType = 0)
begin
	set @errorCode	 = 1
end
else
begin
	if exists(select 1 from CC_Oauthapplication	where assocWebconsole is not null and appType = @appType)
	begin
	if exists(select 1 from CC_Oauthapplication	where assocWebconsole is not null and appType = @appType)
		begin
			declare @appList table
			(
				id			integer,
				appId		nvarchar(max),
				providerId	integer
			)
			--Get all Application that have the given host URL listed in their 'Redirect URL' list and are Enabled.
			insert into @appList
			select 	distinct	id,
								appID,
								umdsProviderId
			from CC_Oauthapplication
			where 	exists(SELECT 1 from assocWebconsole.nodes('/webconsoleList/webconsole') as T1(Loc)
							where Loc.value('@name','nvarchar(max)') like '%'+@hostURL+'%')
			and 	appType = @appType and (flags & 1) > 0
			--Now pick up the first App in this list for every distinct provider ID
			set @appXml = (select 	appId			as '@appId',
									providerId		as '@providerId'
							from	@appList
							where 	id in (SELECT MIN(id) FROM @appList group by providerId)
							for XML path('oauthApplications')
						 )
			end
			else
			begin
				set @errorCode	 = 1
				set @errorMessage = 'No Applications found for given webconsole URL'
			end
	end
	else
	begin
		set @errorCode	 = 1
	end
end
SET @errorXml = (SELECT @errorCode 	 AS '@errorCode',
						@errorMessage AS '@errorString'
					FOR xml PATH('error'))
SET @out_xml = ( SELECT  ISNULL(@errorXml,'') ,
						 ISNULL(@appXml ,'')
                 FOR xml path('') , ROOT('App_CCGetApplicationInfoResp')
               )
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetOAuthAppForURL')
	delete from GxQscripts where name = 'AppGetOAuthAppForURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetOAuthAppForURL')
	delete from GXDBVersions where aliasname = 'AppGetOAuthAppForURL'
GO

insert into GXDBVersions values(2, 'AppGetOAuthAppForURL',  '00000000000000000000', 'AppGetOAuthAppForURL', '00000000000000000000')
GO

