

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetNotesMailboxHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNotesMailboxHistory.sp,v $ $Id: AppGetNotesMailboxHistory.sp,v 1.5.200.2 2018/03/22 01:51:51 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppGetNotesMailboxHistory"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetNotesMailboxHistory <<<'

IF EXISTS (select * from sysobjects where name='AppGetNotesMailboxHistory')
	drop procedure AppGetNotesMailboxHistory
IF EXISTS (select * from GxQscripts where name='AppGetNotesMailboxHistory')
	delete from GxQscripts where name = 'AppGetNotesMailboxHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNotesMailboxHistory')
	delete from GXDBVersions where aliasname = 'AppGetNotesMailboxHistory'
GO
print '... Creating Procedure: AppGetNotesMailboxHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetNotesMailboxHistory
  @_mailboxName nvarchar(1024),
  @_backupSetId integer,
  @_fromTime integer,
  @_endTime integer,
  @_instanceName nvarchar(1024),
  @_clientName nvarchar(1024)	
AS
  DECLARE @o_mailboxId integer
  DECLARE @o_bsetId integer
  DECLARE @o_fromTime integer
  DECLARE @o_endTime integer
  DECLARE @o_mailbox nvarchar(1024)
  DECLARE @o_mailboxReplicaId nvarchar(1024)
declare     @prefix						nvarchar(12)
declare     @seper						nchar(1)
declare		@seper1						nchar(1)
Declare @l_mailBoxPath   nvarchar(512)
Declare @l_replicaId		   nvarchar(512)
Declare @l_canonicalName 		nvarchar(1024)
Declare @start      int
Declare @index      int
Declare @currentMailboxId int
Declare @subClientId int
Declare @nowTime int
Set @nowTime = dbo.GetUnixTime (GetUTCdate())
SET NOCOUNT ON
set  @seper = char(0x15)
set  @seper1 = CHAR(0x12)
   IF object_id('tempdb.dbo.#mailBoxHistory') is not null DROP TABLE #mailBoxHistory
   create table  #mailBoxHistory
   (
      mailBoxId		int	NOT null,
      backupSetId	int NOT null,
      subClientId   int NOT null,
      fromTime		integer,
      endTime		integer,
      propType		integer,
      canonicalName  nvarchar(1024),
      replicaId	nvarchar(1024),
      mailbox	nvarchar(1024),
    )
--------------------------------------------------------
--  PARSE THE MAILBOX NAME TO GIVE US SEARCH CRITERIA --
--------------------------------------------------------
-- check whether replicaId is passed as part of mailbox
set @l_replicaId  = ''
set @start = 0
set @index = (select charindex(@seper, @_mailboxName, @start))
--SELECT debug='debug', @index
if(@index <> 0)
BEGIN
	set @l_mailBoxPath = subString(@_mailboxName, @start, @index-@start)
	set @start = @index+1
	set @l_replicaId  = ISNULL(subString(@_mailboxName, @start, LEN(@_mailboxName)-@start+1), '')
END
ELSE
	set @l_mailBoxPath = @_mailboxName
--SELECT debug='debug', @l_mailBoxPath, @l_replicaId
------------------------------------------------------
-- IF WE DIDN'T GET A GUID, NO REASON TO GO FURTHER --
------------------------------------------------------
IF @l_replicaId = '' AND @l_mailBoxPath = ''
BEGIN
	INSERT #mailBoxHistory VALUES ( 0,0,0,0,0,0, 'No GUID or SMTP For MailBox:', @_mailboxName, '', @l_replicaId,'')
		GOTO RETURN_RESULTS
END
--select debug='debug', * from #mailBoxHistory
--------------------------
-- Find all the 'Parts' --
--------------------------
IF @l_replicaId <> ''
BEGIN
	INSERT INTO #mailBoxHistory
SELECT DISTINCT componentId, 0, 0, 0, 0, 1401, '', stringVal,''				--'CV_COMPONENT_LOTUS_NOTES_REPLICA_ID'
	FROM    APP_ComponentProp
	WHERE
componentType = 	9				-- 'CV_COMPONENT_TYPE_LN_DOC'
AND (PropertyTypeId = 1401 AND stringVal = @l_replicaId)   -- 'CV_COMPONENT_LOTUS_NOTES_REPLICA_ID'
END
--select debug='debug', * from #mailBoxHistory
-- for backward compatibility use APP_subclientProp table as we dont know after upgrade
IF @l_mailBoxPath <> ''
BEGIN
    DECLARE @instanceLike nvarchar(1024)
    DECLARE @instanceLike1 nvarchar(1024)
	IF @_instanceName IS NOT null
	BEGIN
	 SET @instanceLike = @_instanceName+@seper+'%'
	 SET @instanceLike1 = @_instanceName+@seper1+'%'
  END
	ELSE
	SET @_instanceName = ''
	IF @_clientName IS null
	SET @_clientName = ''
	--select debug='debug', @_clientName, @instanceLike, @instanceLike1
	INSERT INTO #mailBoxHistory
	SELECT  scprop.id, 0, 0, 0, 0, 1100, '', '',''
	FROM    APP_subclientProp as scprop
		JOIN APP_Application as app
		ON scprop.componentNameId = app.id
		JOIN APP_InstanceName as inst
		ON app.instance = inst.id
		JOIN app_client as client
		ON app.clientId = client.id
	WHERE	(AttrName = @l_mailBoxPath)
			AND (inst.name like @instanceLike OR inst.name like @instanceLike1 OR @_instanceName='')
			AND (client.id=app.clientId)
			AND (client.name=@_clientName OR @_clientName='')
			AND NOT EXISTS (Select * from #mailBoxHistory WHERE scprop.id = mailboxId)
END
-- select debug='debug', * from #mailBoxHistory
UPDATE #mailBoxHistory
Set fromTime = created, endTime = modified
FROM #mailBoxHistory as MBH, app_subclientProp as SCP
WHERE mailboxId = id
UPDATE #mailBoxHistory					-- THIS HELPS SIMPLIFY THE PRUNING LOGIC
set endTime = @nowTime					-- FURTHER DOWN!
WHERE endTime = 0
----------------------------------
-- PRUNE BASED ON FROM/TO TIME ---
----------------------------------
IF @_fromTime <> 0
DELETE #mailBoxHistory
WHERE
   endTime < @_fromTime
IF @_endTime <> 0
DELETE #mailBoxHistory
WHERE
	fromTime > @_endTime
----------------------------------
-- PRUNE BASED ON BACKUPSETID  ---
----------------------------------
UPDATE #mailBoxHistory
SET subClientId = ISNULL((select componentNameId from APP_subclientProp WHERE id=mailboxId),0)
UPDATE #mailBoxHistory
Set backupSetId = ISNULL((select top 1 backupset FROM APP_Application Where APP_Application.id = subClientId),0)
IF @_backupSetId <> 0
   DELETE #mailBoxHistory
      WHERE backupSetId <> @_backupSetId
DELETE FROM #mailBoxHistory WHERE subClientId=0 or backupSetId=0   -- APP_ComponentProp NOT GETTING CLEANED UP?
----------------------------------
-- !NOW! FILL IN MISSING FIELDS --
----------------------------------
UPDATE #mailBoxHistory
SET canonicalName = ISNULL((Select stringVal
                   From APP_ComponentProp
WHere componentType =  9						--'CV_COMPONENT_TYPE_LN_DOC'
AND PropertyTypeId = 1402	--'CV_COMPONENT_LOTUS_NOTES_CANONICAL_NAME'
                        AND componentId = mailboxId), '')
WHere canonicalName = ''
UPDATE #mailBoxHistory
SET replicaId = ISNULL((Select stringVal
                   From APP_ComponentProp
WHere componentType =  9						--'CV_COMPONENT_TYPE_LN_DOC'
AND PropertyTypeId = 1401 --'CV_COMPONENT_LOTUS_NOTES_REPLICA_ID'
                        AND componentId = mailboxId), '')
WHERE replicaId = ''
UPDATE #mailBoxHistory
SET mailbox = ISNULL((SELECT TOP 1 filter.fileName from APP_ScFilterFile AS filter where filter.componentNameId  in ( select componentNameId from APP_SubClientProp where id=mailBoxId) and filter.fileName like ( select ('%' + substring(attrName,2, LEN(attrName))  +   @seper1 + '%' ) from app_subClientProp where id = mailBoxId	)),'')
--SET mailbox = ISNULL((SELECT TOP 1 filter.fileName from APP_ScFilterFile AS filter where filter.componentNameId  in ( select componentNameId from APP_SubClientProp where id=mailBoxId) and filter.fileName like ( select (attrName +   @seper1 + '%' ) from app_subClientProp where id = mailBoxId	)),'')
WHERE mailbox = ''
delete from #mailBoxHistory where mailbox = ''
--If there is no entry in app_scfilterfile fallback on subclient properties
--UPDATE #mailBoxHistory
--SET mailbox = ISNULL((SELECT ( attrName + CHAR(0x12) + '0' + char(0x12) + subString(attrVal, 0, charindex(' ', attrVal, 0))) FROM app_subclientprop where id=mailBoxId ),'')
--WHERE mailbox = ''
------------------------------
-- RETURN RESULTS TO CALLER --
------------------------------
RETURN_RESULTS:
	/*select DISTINCT
	       mailBoxId,
		   backupSetId,
		   fromTime,
		   endTime,
		 (select attrName from app_subClientProp where id = mailBoxId),
		  replicaId,
		  mailbox
	FROM  #mailBoxHistory */
select DISTINCT
	       0,
		   backupSetId,
		   0,
		   0,
		  mailbox,
		   0
	FROM  #mailBoxHistory
DROP TABLE #mailBoxHistory
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetNotesMailboxHistory')
	delete from GxQscripts where name = 'AppGetNotesMailboxHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetNotesMailboxHistory')
	delete from GXDBVersions where aliasname = 'AppGetNotesMailboxHistory'
GO

insert into GXDBVersions values(2, 'AppGetNotesMailboxHistory',  '00010005020000020000', 'AppGetNotesMailboxHistory', '00010005020000020000')
GO

